/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.range.impl.imexp;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGraphicalObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGraphicalObjectData;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTDrawing;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTGraphicalObjectFrame;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTMarker;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTPicture;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTTwoCellAnchor;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCfRule;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCfvo;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCol;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTColor;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTColorScale;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCols;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDataBar;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTExternalReference;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTExternalReferences;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTIconSet;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorkbook;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorksheet;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STCfType;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STCfvoType;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STConditionalFormattingOperator;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STIconSetType;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STTimePeriod;
import org.w3c.dom.Node;
import org.zkoss.poi.POIXMLDocumentPart;
import org.zkoss.poi.ss.usermodel.AutoFilter;
import org.zkoss.poi.ss.usermodel.CellStyle;
import org.zkoss.poi.ss.usermodel.ClientAnchor;
import org.zkoss.poi.ss.usermodel.Color;
import org.zkoss.poi.ss.usermodel.ColorFilter;
import org.zkoss.poi.ss.usermodel.CustomFilter;
import org.zkoss.poi.ss.usermodel.CustomFilters;
import org.zkoss.poi.ss.usermodel.DataValidation;
import org.zkoss.poi.ss.usermodel.DataValidationConstraint;
import org.zkoss.poi.ss.usermodel.DxfCellStyle;
import org.zkoss.poi.ss.usermodel.DynamicFilter;
import org.zkoss.poi.ss.usermodel.Font;
import org.zkoss.poi.ss.usermodel.Name;
import org.zkoss.poi.ss.usermodel.Picture;
import org.zkoss.poi.ss.usermodel.Sheet;
import org.zkoss.poi.ss.usermodel.SheetProtection;
import org.zkoss.poi.ss.usermodel.TableStyle;
import org.zkoss.poi.ss.usermodel.Top10Filter;
import org.zkoss.poi.ss.usermodel.Workbook;
import org.zkoss.poi.ss.usermodel.ZssChartX;
import org.zkoss.poi.ss.usermodel.charts.CategoryAxis;
import org.zkoss.poi.ss.usermodel.charts.CategoryDataSerie;
import org.zkoss.poi.ss.usermodel.charts.ChartDataSource;
import org.zkoss.poi.ss.usermodel.charts.ChartTextSource;
import org.zkoss.poi.ss.usermodel.charts.ValueAxis;
import org.zkoss.poi.ss.usermodel.charts.XYDataSerie;
import org.zkoss.poi.ss.usermodel.charts.XYZDataSerie;
import org.zkoss.poi.ss.util.CellRangeAddress;
import org.zkoss.poi.ss.util.CellReference;
import org.zkoss.poi.xssf.model.ExternalLink;
import org.zkoss.poi.xssf.usermodel.XSSFAutoFilter;
import org.zkoss.poi.xssf.usermodel.XSSFChart;
import org.zkoss.poi.xssf.usermodel.XSSFChartX;
import org.zkoss.poi.xssf.usermodel.XSSFClientAnchor;
import org.zkoss.poi.xssf.usermodel.XSSFConditionalFormatting;
import org.zkoss.poi.xssf.usermodel.XSSFConditionalFormattingRule;
import org.zkoss.poi.xssf.usermodel.XSSFDrawing;
import org.zkoss.poi.xssf.usermodel.XSSFName;
import org.zkoss.poi.xssf.usermodel.XSSFPictureHelper;
import org.zkoss.poi.xssf.usermodel.XSSFSheet;
import org.zkoss.poi.xssf.usermodel.XSSFTable;
import org.zkoss.poi.xssf.usermodel.XSSFTableColumn;
import org.zkoss.poi.xssf.usermodel.XSSFTableStyleInfo;
import org.zkoss.poi.xssf.usermodel.XSSFWorkbook;
import org.zkoss.poi.xssf.usermodel.charts.XSSFArea3DChartData;
import org.zkoss.poi.xssf.usermodel.charts.XSSFAreaChartData;
import org.zkoss.poi.xssf.usermodel.charts.XSSFBar3DChartData;
import org.zkoss.poi.xssf.usermodel.charts.XSSFBarChartData;
import org.zkoss.poi.xssf.usermodel.charts.XSSFBubbleChartData;
import org.zkoss.poi.xssf.usermodel.charts.XSSFColumn3DChartData;
import org.zkoss.poi.xssf.usermodel.charts.XSSFColumnChartData;
import org.zkoss.poi.xssf.usermodel.charts.XSSFDoughnutChartData;
import org.zkoss.poi.xssf.usermodel.charts.XSSFLine3DChartData;
import org.zkoss.poi.xssf.usermodel.charts.XSSFLineChartData;
import org.zkoss.poi.xssf.usermodel.charts.XSSFPie3DChartData;
import org.zkoss.poi.xssf.usermodel.charts.XSSFPieChartData;
import org.zkoss.poi.xssf.usermodel.charts.XSSFScatChartData;
import org.zkoss.poi.xssf.usermodel.charts.XSSFView3D;
import org.zkoss.zss.model.CellRegion;
import org.zkoss.zss.model.SAutoFilter;
import org.zkoss.zss.model.SBook;
import org.zkoss.zss.model.SBorder;
import org.zkoss.zss.model.SCFValueObject;
import org.zkoss.zss.model.SChart;
import org.zkoss.zss.model.SChartAxis;
import org.zkoss.zss.model.SColor;
import org.zkoss.zss.model.SColorFilter;
import org.zkoss.zss.model.SColorScale;
import org.zkoss.zss.model.SColumnArray;
import org.zkoss.zss.model.SConditionalFormatting;
import org.zkoss.zss.model.SConditionalFormattingRule;
import org.zkoss.zss.model.SCustomFilters;
import org.zkoss.zss.model.SDataBar;
import org.zkoss.zss.model.SDataValidation;
import org.zkoss.zss.model.SDynamicFilter;
import org.zkoss.zss.model.SExtraStyle;
import org.zkoss.zss.model.SFill;
import org.zkoss.zss.model.SFont;
import org.zkoss.zss.model.SIconSet;
import org.zkoss.zss.model.SName;
import org.zkoss.zss.model.SSheet;
import org.zkoss.zss.model.SSheetProtection;
import org.zkoss.zss.model.STable;
import org.zkoss.zss.model.STableColumn;
import org.zkoss.zss.model.STableStyle;
import org.zkoss.zss.model.STableStyleElem;
import org.zkoss.zss.model.STop10Filter;
import org.zkoss.zss.model.SheetRegion;
import org.zkoss.zss.model.ViewAnchor;
import org.zkoss.zss.model.chart.SGeneralChartData;
import org.zkoss.zss.model.chart.SSeries;
import org.zkoss.zss.model.impl.AbstractBookAdv;
import org.zkoss.zss.model.impl.AbstractDataValidationAdv;
import org.zkoss.zss.model.impl.AbstractFontAdv;
import org.zkoss.zss.model.impl.AbstractSheetAdv;
import org.zkoss.zss.model.impl.BorderImpl;
import org.zkoss.zss.model.impl.BorderLineImpl;
import org.zkoss.zss.model.impl.CFValueObjectImpl;
import org.zkoss.zss.model.impl.ChartAxisImpl;
import org.zkoss.zss.model.impl.ColorFilterImpl;
import org.zkoss.zss.model.impl.ColorImpl;
import org.zkoss.zss.model.impl.ColorScaleImpl;
import org.zkoss.zss.model.impl.ConditionalFormattingImpl;
import org.zkoss.zss.model.impl.ConditionalFormattingRuleImpl;
import org.zkoss.zss.model.impl.CustomFilterImpl;
import org.zkoss.zss.model.impl.CustomFiltersImpl;
import org.zkoss.zss.model.impl.DataBarImpl;
import org.zkoss.zss.model.impl.DynamicFilterImpl;
import org.zkoss.zss.model.impl.ExtraFillImpl;
import org.zkoss.zss.model.impl.ExtraStyleImpl;
import org.zkoss.zss.model.impl.IconSetImpl;
import org.zkoss.zss.model.impl.TableColumnImpl;
import org.zkoss.zss.model.impl.TableImpl;
import org.zkoss.zss.model.impl.TableStyleElemImpl;
import org.zkoss.zss.model.impl.TableStyleImpl;
import org.zkoss.zss.model.impl.TableStyleInfoImpl;
import org.zkoss.zss.model.impl.Top10FilterImpl;
import org.zkoss.zss.model.util.CellStyleMatcher;
import org.zkoss.zss.range.impl.imexp.AbstractExcelImporter;
import org.zkoss.zss.range.impl.imexp.BookHelper;
import org.zkoss.zss.range.impl.imexp.ImExpUtils;
import org.zkoss.zss.range.impl.imexp.PoiEnumConversion;
import org.zkoss.zss.range.impl.imexp.UnitUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelXlsxImporter
extends AbstractExcelImporter {
    private static final long serialVersionUID = -1531963712987770117L;
    private static final Logger logger = Logger.getLogger(ExcelXlsxImporter.class.getName());

    @Override
    protected Workbook createPoiBook(InputStream is) throws IOException {
        return new XSSFWorkbook(is);
    }

    @Override
    protected void importExternalBookLinks() {
        try {
            ArrayList<String> bookNames = new ArrayList<String>();
            XSSFWorkbook xssfBook = (XSSFWorkbook)this.workbook;
            CTWorkbook ctBook = xssfBook.getCTWorkbook();
            CTExternalReferences externalReferences = ctBook.getExternalReferences();
            if (externalReferences != null) {
                List exRefs = externalReferences.getExternalReferenceList();
                for (CTExternalReference exRef : exRefs) {
                    ExternalLink link = (ExternalLink)xssfBook.getRelationById(exRef.getId());
                    bookNames.add(link.getBookName());
                }
            }
            if (bookNames.size() > 0) {
                this.book.setAttribute("$ZSS_EXTERNAL_BOOK_NAMES$", bookNames);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    @Override
    protected void importColumn(Sheet poiSheet, SSheet sheet) {
        CTWorksheet worksheet = ((XSSFSheet)poiSheet).getCTWorksheet();
        if (worksheet.sizeOfColsArray() <= 0) {
            return;
        }
        int charWidth = ((AbstractBookAdv)this.book).getCharWidth();
        int defaultWidth = UnitUtil.xssfDefaultColumnWidthToPx(((XSSFSheet)poiSheet).getXssfDefaultColumnWidth(), charWidth);
        CTCols colsArray = worksheet.getColsArray(0);
        for (int i = 0; i < colsArray.sizeOfColArray(); ++i) {
            CTCol ctCol = colsArray.getColArray(i);
            SColumnArray columnArray = sheet.setupColumnArray((int)ctCol.getMin() - 1, (int)ctCol.getMax() - 1);
            boolean hidden = ctCol.getHidden();
            int columnIndex = (int)ctCol.getMin() - 1;
            columnArray.setHidden(hidden);
            int width = ImExpUtils.getWidthAny(poiSheet, columnIndex, charWidth);
            if (!hidden && width != defaultWidth) {
                columnArray.setWidth(width);
            }
            columnArray.setCustomWidth(ctCol.getCustomWidth() || width != defaultWidth);
            CellStyle columnStyle = poiSheet.getColumnStyle(columnIndex);
            if (columnStyle == null) continue;
            columnArray.setCellStyle(this.importCellStyle(columnStyle));
        }
    }

    protected void importChart(List<ZssChartX> poiCharts, Sheet poiSheet, SSheet sheet) {
        block15: for (ZssChartX zssChart : poiCharts) {
            XSSFChart xssfChart = (XSSFChart)zssChart.getChart();
            ViewAnchor viewAnchor = this.toViewAnchor(poiSheet, xssfChart.getPreferredSize());
            SChart chart = null;
            XSSFAreaChartData categoryData = null;
            switch (xssfChart.getChartType()) {
                case Area: {
                    chart = sheet.addChart(SChart.ChartType.AREA, viewAnchor);
                    categoryData = new XSSFAreaChartData(xssfChart);
                    chart.setGrouping(PoiEnumConversion.toChartGrouping(categoryData.getGrouping()));
                    break;
                }
                case Area3D: {
                    chart = sheet.addChart(SChart.ChartType.AREA, viewAnchor);
                    categoryData = new XSSFArea3DChartData(xssfChart);
                    chart.setGrouping(PoiEnumConversion.toChartGrouping(((XSSFArea3DChartData)categoryData).getGrouping()));
                    break;
                }
                case Bar: {
                    chart = sheet.addChart(SChart.ChartType.BAR, viewAnchor);
                    categoryData = new XSSFBarChartData(xssfChart);
                    chart.setBarDirection(PoiEnumConversion.toBarDirection(((XSSFBarChartData)categoryData).getBarDirection()));
                    chart.setBarOverlap(xssfChart.getBarOverlap());
                    chart.setGrouping(PoiEnumConversion.toChartGrouping(((XSSFBarChartData)categoryData).getGrouping()));
                    break;
                }
                case Bar3D: {
                    chart = sheet.addChart(SChart.ChartType.BAR, viewAnchor);
                    categoryData = new XSSFBar3DChartData(xssfChart);
                    chart.setBarDirection(PoiEnumConversion.toBarDirection(((XSSFBar3DChartData)categoryData).getBarDirection()));
                    chart.setGrouping(PoiEnumConversion.toChartGrouping(((XSSFBar3DChartData)categoryData).getGrouping()));
                    break;
                }
                case Bubble: {
                    chart = sheet.addChart(SChart.ChartType.BUBBLE, viewAnchor);
                    XSSFBubbleChartData xyzData = new XSSFBubbleChartData(xssfChart);
                    this.importXyzSeries(xyzData.getSeries(), (SGeneralChartData)chart.getData());
                    break;
                }
                case Column: {
                    chart = sheet.addChart(SChart.ChartType.COLUMN, viewAnchor);
                    categoryData = new XSSFColumnChartData(xssfChart);
                    chart.setBarDirection(PoiEnumConversion.toBarDirection(((XSSFColumnChartData)categoryData).getBarDirection()));
                    chart.setBarOverlap(xssfChart.getBarOverlap());
                    chart.setGrouping(PoiEnumConversion.toChartGrouping(((XSSFColumnChartData)categoryData).getGrouping()));
                    break;
                }
                case Column3D: {
                    chart = sheet.addChart(SChart.ChartType.COLUMN, viewAnchor);
                    categoryData = new XSSFColumn3DChartData(xssfChart);
                    chart.setBarDirection(PoiEnumConversion.toBarDirection(((XSSFColumn3DChartData)categoryData).getBarDirection()));
                    chart.setGrouping(PoiEnumConversion.toChartGrouping(((XSSFColumn3DChartData)categoryData).getGrouping()));
                    break;
                }
                case Doughnut: {
                    chart = sheet.addChart(SChart.ChartType.DOUGHNUT, viewAnchor);
                    categoryData = new XSSFDoughnutChartData(xssfChart);
                    break;
                }
                case Line: {
                    chart = sheet.addChart(SChart.ChartType.LINE, viewAnchor);
                    categoryData = new XSSFLineChartData(xssfChart);
                    chart.setGrouping(PoiEnumConversion.toChartGrouping(((XSSFLineChartData)categoryData).getGrouping()));
                    break;
                }
                case Line3D: {
                    chart = sheet.addChart(SChart.ChartType.LINE, viewAnchor);
                    categoryData = new XSSFLine3DChartData(xssfChart);
                    chart.setGrouping(PoiEnumConversion.toChartGrouping(((XSSFLine3DChartData)categoryData).getGrouping()));
                    break;
                }
                case Pie: {
                    chart = sheet.addChart(SChart.ChartType.PIE, viewAnchor);
                    categoryData = new XSSFPieChartData(xssfChart);
                    break;
                }
                case Pie3D: {
                    chart = sheet.addChart(SChart.ChartType.PIE, viewAnchor);
                    categoryData = new XSSFPie3DChartData(xssfChart);
                    break;
                }
                case Scatter: {
                    chart = sheet.addChart(SChart.ChartType.SCATTER, viewAnchor);
                    XSSFScatChartData xyData = new XSSFScatChartData(xssfChart);
                    this.importXySeries(xyData.getSeries(), (SGeneralChartData)chart.getData());
                    break;
                }
                default: {
                    continue block15;
                }
            }
            if (xssfChart.getTitle() != null) {
                chart.setTitle(xssfChart.getTitle().getString());
            }
            chart.setThreeD(xssfChart.isSetView3D());
            if (chart.isThreeD()) {
                XSSFView3D view3d = xssfChart.getOrCreateView3D();
                chart.setRotX(view3d.getRotX());
                chart.setRotY(view3d.getRotY());
                chart.setPerspective(view3d.getPerspective());
                chart.setHPercent(view3d.getHPercent());
                chart.setDepthPercent(view3d.getDepthPercent());
                chart.setRightAngleAxes(view3d.isRightAngleAxes());
            }
            if (xssfChart.hasLegend()) {
                chart.setLegendPosition(PoiEnumConversion.toLengendPosition(xssfChart.getOrCreateLegend().getPosition()));
            }
            if (categoryData != null) {
                this.importSeries(categoryData.getSeries(), (SGeneralChartData)chart.getData());
            }
            this.importAxis(xssfChart, chart);
            chart.setPlotOnlyVisibleCells(xssfChart.isPlotOnlyVisibleCells());
        }
    }

    protected void importAxis(XSSFChart xssfChart, SChart chart) {
        List axises = xssfChart.getAxis();
        if (axises != null) {
            for (Object axis0 : axises) {
                ChartAxisImpl saxis;
                double max;
                double min;
                String format;
                ValueAxis axis;
                if (axis0 instanceof ValueAxis) {
                    axis = (ValueAxis)axis0;
                    format = axis.getNumberFormat();
                    min = axis.getMinimum();
                    max = axis.getMaximum();
                    saxis = new ChartAxisImpl(axis.getId(), SChartAxis.SChartAxisType.VALUE, min, max, format);
                    chart.addValueAxis(saxis);
                    continue;
                }
                if (!(axis0 instanceof CategoryAxis)) continue;
                axis = (CategoryAxis)axis0;
                format = null;
                min = axis.getMinimum();
                max = axis.getMaximum();
                saxis = new ChartAxisImpl(axis.getId(), SChartAxis.SChartAxisType.CATEGORY, min, max, format);
                chart.addCategoryAxis(saxis);
            }
        }
    }

    protected void importSeries(List<? extends CategoryDataSerie> seriesList, SGeneralChartData chartData) {
        CategoryDataSerie firstSeries = null;
        firstSeries = seriesList.get(0);
        if (firstSeries != null) {
            chartData.setCategoriesFormula(this.getValueFormula(firstSeries.getCategories()));
        }
        for (int i = 0; i < seriesList.size(); ++i) {
            CategoryDataSerie sourceSeries = seriesList.get(i);
            String nameExpression = this.getTitleFormula(sourceSeries.getTitle(), i);
            String xValueExpression = this.getValueFormula(sourceSeries.getValues());
            SSeries series = chartData.addSeries();
            series.setFormula(nameExpression, xValueExpression);
        }
    }

    protected void importXySeries(List<? extends XYDataSerie> seriesList, SGeneralChartData chartData) {
        for (int i = 0; i < seriesList.size(); ++i) {
            XYDataSerie sourceSeries = seriesList.get(i);
            SSeries series = chartData.addSeries();
            series.setXYFormula(this.getTitleFormula(sourceSeries.getTitle(), i), this.getValueFormula(sourceSeries.getXs()), this.getValueFormula(sourceSeries.getYs()));
        }
    }

    protected void importXyzSeries(List<? extends XYZDataSerie> seriesList, SGeneralChartData chartData) {
        for (int i = 0; i < seriesList.size(); ++i) {
            XYZDataSerie sourceSeries = seriesList.get(i);
            String nameExpression = this.getTitleFormula(sourceSeries.getTitle(), i);
            String xValueExpression = this.getValueFormula(sourceSeries.getXs());
            String yValueExpression = this.getValueFormula(sourceSeries.getYs());
            String zValueExpression = this.getValueFormula(sourceSeries.getZs());
            SSeries series = chartData.addSeries();
            series.setXYZFormula(nameExpression, xValueExpression, yValueExpression, zValueExpression);
        }
    }

    protected String getTitleFormula(ChartTextSource textSource, int seriesIndex) {
        if (textSource == null) {
            return "\"Series" + seriesIndex + "\"";
        }
        if (textSource.isReference()) {
            return textSource.getFormulaString();
        }
        return "\"" + textSource.getTextString() + "\"";
    }

    protected String getValueFormula(ChartDataSource<?> dataSource) {
        if (dataSource.isReference()) {
            return dataSource.getFormulaString();
        }
        int count = dataSource.getPointCount();
        if (count <= 0) {
            return null;
        }
        StringBuilder expression = new StringBuilder("{");
        for (int i = 0; i < count; ++i) {
            Object value = dataSource.getPointAt(i);
            if (value == null) {
                if (dataSource.isNumeric()) {
                    expression.append("0");
                } else {
                    expression.append("\"\"");
                }
            } else if (dataSource.isNumeric()) {
                expression.append(value.toString());
            } else {
                expression.append("\"").append(value).append("\"");
            }
            if (i == count - 1) continue;
            expression.append(",");
        }
        expression.append("}");
        return expression.toString();
    }

    @Override
    protected void importDrawings(Sheet poiSheet, SSheet sheet) {
        ArrayList<ZssChartX> poiCharts = new ArrayList<ZssChartX>();
        ArrayList<Picture> poiPictures = new ArrayList<Picture>();
        XSSFDrawing patriarch = null;
        for (POIXMLDocumentPart dr : ((XSSFSheet)poiSheet).getRelations()) {
            if (!(dr instanceof XSSFDrawing)) continue;
            patriarch = (XSSFDrawing)dr;
            break;
        }
        if (patriarch != null) {
            CTDrawing ctdrawing = patriarch.getCTDrawing();
            for (CTTwoCellAnchor anchor : ctdrawing.getTwoCellAnchorArray()) {
                CTPicture ctPicture;
                CTMarker from = anchor.getFrom();
                CTMarker to = anchor.getTo();
                XSSFClientAnchor clientAnchor = null;
                if (from != null && to != null) {
                    clientAnchor = new XSSFClientAnchor((int)from.getColOff(), (int)from.getRowOff(), (int)to.getColOff(), (int)to.getRowOff(), from.getCol(), from.getRow(), to.getCol(), to.getRow());
                }
                if ((ctPicture = anchor.getPic()) == null) {
                    CTGraphicalObjectFrame gfrm = anchor.getGraphicFrame();
                    if (gfrm == null) continue;
                    XSSFChartX chartX = this.createXSSFChartX(patriarch, gfrm, clientAnchor);
                    poiCharts.add((ZssChartX)chartX);
                    continue;
                }
                poiPictures.add((Picture)XSSFPictureHelper.newXSSFPicture(patriarch, clientAnchor, ctPicture));
            }
        }
        this.importChart(poiCharts, poiSheet, sheet);
        this.importPicture(poiPictures, poiSheet, sheet);
    }

    protected XSSFChartX createXSSFChartX(XSSFDrawing patriarch, CTGraphicalObjectFrame gfrm, XSSFClientAnchor xanchor) {
        String name = gfrm.getNvGraphicFramePr().getCNvPr().getName();
        CTGraphicalObject gobj = gfrm.getGraphic();
        CTGraphicalObjectData gdata = gobj.getGraphicData();
        String chartId = null;
        for (Node child = gdata.getDomNode().getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!"chart".equals(child.getLocalName())) continue;
            chartId = child.getAttributes().getNamedItemNS("http://schemas.openxmlformats.org/officeDocument/2006/relationships", "id").getNodeValue();
            break;
        }
        XSSFChartX chartX = new XSSFChartX(patriarch, xanchor, name, chartId);
        return chartX;
    }

    @Override
    protected int getAnchorWidthInPx(ClientAnchor anchor, Sheet poiSheet) {
        int charWidth = ((AbstractBookAdv)this.book).getCharWidth();
        short firstColumn = anchor.getCol1();
        int firstColumnWidth = ImExpUtils.getWidthAny(poiSheet, firstColumn, charWidth);
        int offsetInFirstColumn = UnitUtil.emuToPx(anchor.getDx1());
        int anchorWidthInFirstColumn = firstColumnWidth - offsetInFirstColumn;
        int anchorWidthInLastColumn = UnitUtil.emuToPx(anchor.getDx2());
        short lastColumn = anchor.getCol2();
        int width = firstColumn == lastColumn ? anchorWidthInLastColumn - offsetInFirstColumn : anchorWidthInFirstColumn + anchorWidthInLastColumn;
        width = Math.abs(width);
        for (int j = firstColumn + 1; j < lastColumn; ++j) {
            width += ImExpUtils.getWidthAny(poiSheet, j, charWidth);
        }
        return width;
    }

    @Override
    protected int getAnchorHeightInPx(ClientAnchor anchor, Sheet poiSheet) {
        int firstRow = anchor.getRow1();
        int offsetInFirstRow = UnitUtil.emuToPx(anchor.getDy1());
        int firstRowHeight = ImExpUtils.getHeightAny(poiSheet, firstRow);
        int anchorHeightInFirstRow = firstRowHeight - offsetInFirstRow;
        int lastRow = anchor.getRow2();
        int anchorHeightInLastRow = UnitUtil.emuToPx(anchor.getDy2());
        int height = lastRow == firstRow ? anchorHeightInLastRow - offsetInFirstRow : anchorHeightInFirstRow + anchorHeightInLastRow;
        height = Math.abs(height);
        for (int row = firstRow + 1; row < lastRow; ++row) {
            height += ImExpUtils.getHeightAny(poiSheet, row);
        }
        return height;
    }

    @Override
    protected int getXoffsetInPixel(ClientAnchor clientAnchor, Sheet poiSheet) {
        return UnitUtil.emuToPx(clientAnchor.getDx1());
    }

    @Override
    protected int getYoffsetInPixel(ClientAnchor clientAnchor, Sheet poiSheet) {
        return UnitUtil.emuToPx(clientAnchor.getDy1());
    }

    @Override
    protected void importValidation(Sheet poiSheet, SSheet sheet) {
        for (DataValidation poiValidation : poiSheet.getDataValidations()) {
            SDataValidation dataValidation = sheet.addDataValidation(null, null);
            CellRangeAddress[] cellRangeAddresses = poiValidation.getRegions().getCellRangeAddresses();
            DataValidationConstraint poiConstraint = poiValidation.getValidationConstraint();
            dataValidation.setOperatorType(PoiEnumConversion.toOperatorType(poiConstraint.getOperator()));
            dataValidation.setValidationType(PoiEnumConversion.toValidationType(poiConstraint.getValidationType()));
            ((AbstractDataValidationAdv)dataValidation).setEscapedFormulas(poiConstraint.getFormula1(), poiConstraint.getFormula2());
            dataValidation.setIgnoreBlank(poiValidation.getEmptyCellAllowed());
            dataValidation.setErrorTitle(poiValidation.getErrorBoxTitle());
            dataValidation.setErrorMessage(poiValidation.getErrorBoxText());
            dataValidation.setAlertStyle(PoiEnumConversion.toErrorStyle(poiValidation.getErrorStyle()));
            dataValidation.setInputTitle(poiValidation.getPromptBoxTitle());
            dataValidation.setInputMessage(poiValidation.getPromptBoxText());
            if (poiConstraint.getValidationType() == 3) {
                dataValidation.setInCellDropdown(poiValidation.getSuppressDropDownArrow());
            }
            dataValidation.setShowError(poiValidation.getShowErrorBox());
            dataValidation.setShowInput(poiValidation.getShowPromptBox());
            LinkedHashSet<CellRegion> regions = new LinkedHashSet<CellRegion>();
            for (CellRangeAddress cellRangeAddr : cellRangeAddresses) {
                regions.add(new CellRegion(cellRangeAddr.formatAsString()));
            }
            dataValidation.setRegions(regions);
        }
    }

    @Override
    protected boolean skipName(Name definedName) {
        boolean r = super.skipName(definedName);
        if (r) {
            return r;
        }
        return ((XSSFName)definedName).isBuiltInName();
    }

    @Override
    protected void setBookType(SBook book) {
        book.setAttribute(BOOK_TYPE_KEY, "xlsx");
    }

    @Override
    protected void importPassword(Sheet poiSheet, SSheet sheet) {
        short hashpass = ((XSSFSheet)poiSheet).getPasswordHash();
        sheet.setHashedPassword(hashpass);
        String hashValue = ((XSSFSheet)poiSheet).getHashValue();
        sheet.setHashValue(hashValue);
        String spinCount = ((XSSFSheet)poiSheet).getSpinCount();
        sheet.setSpinCount(spinCount);
        String saltValue = ((XSSFSheet)poiSheet).getSaltValue();
        sheet.setSaltValue(saltValue);
        String algName = ((XSSFSheet)poiSheet).getAlgName();
        sheet.setAlgName(algName);
    }

    @Override
    protected void importSheetProtection(Sheet poiSheet, SSheet sheet) {
        SheetProtection sp = poiSheet.getOrCreateSheetProtection();
        SSheetProtection ssp = sheet.getSheetProtection();
        ssp.setAutoFilter(sp.isAutoFilter());
        ssp.setDeleteColumns(sp.isDeleteColumns());
        ssp.setDeleteRows(sp.isDeleteRows());
        ssp.setFormatCells(sp.isFormatCells());
        ssp.setFormatColumns(sp.isFormatColumns());
        ssp.setFormatRows(sp.isFormatRows());
        ssp.setInsertColumns(sp.isInsertColumns());
        ssp.setInsertHyperlinks(sp.isInsertHyperlinks());
        ssp.setInsertRows(sp.isInsertRows());
        ssp.setPivotTables(sp.isPivotTables());
        ssp.setSort(sp.isSort());
        ssp.setObjects(sp.isObjects());
        ssp.setScenarios(sp.isScenarios());
        ssp.setSelectLockedCells(sp.isSelectLockedCells());
        ssp.setSelectUnlockedCells(sp.isSelectUnlockedCells());
    }

    @Override
    protected void importSheetDefaultColumnWidth(Sheet poiSheet, SSheet sheet) {
        int charWidth = ((AbstractBookAdv)this.book).getCharWidth();
        int defaultWidth = UnitUtil.xssfDefaultColumnWidthToPx(((XSSFSheet)poiSheet).getXssfDefaultColumnWidth(), charWidth);
        sheet.setDefaultColumnWidth(defaultWidth);
    }

    @Override
    protected void importTables(Sheet poiSheet, SSheet sheet) {
        XSSFSheet srcSheet = (XSSFSheet)poiSheet;
        for (XSSFTable poiTable : srcSheet.getTables()) {
            CellReference cr1 = poiTable.getStartCellReference();
            CellReference cr2 = poiTable.getEndCellReference();
            CellRegion region0 = new CellRegion(cr1.getRow(), cr1.getCol(), cr2.getRow(), cr2.getCol());
            SheetRegion region = new SheetRegion(sheet, region0);
            XSSFTableStyleInfo poiInfo = new XSSFTableStyleInfo(poiTable.getTableStyleInfo());
            TableStyleInfoImpl info = new TableStyleInfoImpl(poiInfo.getName(), poiInfo.isShowColumnStripes(), poiInfo.isShowRowStripes(), poiInfo.isShowFirstColumn(), poiInfo.isShowLastColumn());
            TableImpl table = new TableImpl((AbstractBookAdv)this.book, poiTable.getName(), poiTable.getDisplayName(), region, poiTable.getHeaderRowCount(), poiTable.getTotalsRowCount(), info);
            for (XSSFTableColumn poiTbCol : poiTable.getTableColumns()) {
                TableColumnImpl tbCol = new TableColumnImpl(poiTbCol.getName());
                tbCol.setTotalsRowFunction(STableColumn.STotalsRowFunction.values()[poiTbCol.getTotalsRowFunction().ordinal()]);
                if (tbCol.getTotalsRowFunction() == STableColumn.STotalsRowFunction.none) {
                    tbCol.setTotalsRowLabel(poiTbCol.getTotalsRowLabel());
                } else if (tbCol.getTotalsRowFunction() == STableColumn.STotalsRowFunction.custom) {
                    tbCol.setTotalsRowFormula(poiTbCol.getTotalsRowFormula());
                }
                table.addColumn(tbCol);
            }
            XSSFAutoFilter poiFilter = poiTable.getAutoFilter();
            table.enableAutoFilter(poiFilter != null);
            sheet.addTable(table);
            if (poiFilter != null) {
                int numberOfColumn = region.getColumnCount();
                SAutoFilter zssFilter = table.getAutoFilter();
                this.importAutoFilterColumns((AutoFilter)poiFilter, zssFilter, numberOfColumn);
            }
            this.importTableName(table);
            ((AbstractBookAdv)this.book).addTable(table);
        }
    }

    protected void importTableName(STable table) {
        SName namedRange = ((AbstractBookAdv)this.book).createTableName(table);
        SheetRegion rgn = table.getDataRegion();
        namedRange.setRefersToFormula(rgn.getReferenceString());
    }

    @Override
    protected void importExtraStyles() {
        ((AbstractBookAdv)this.book).clearExtraStyles();
        for (DxfCellStyle poiStyle : this.workbook.getDxfCellStyles()) {
            this.book.addExtraStyle(this.importExtraStyle(poiStyle));
        }
    }

    protected SExtraStyle importExtraStyle(DxfCellStyle poiCellStyle) {
        String dataFormat = poiCellStyle.getRawDataFormatString();
        SFill.FillPattern pattern = PoiEnumConversion.toFillPattern(poiCellStyle.getRawFillPattern());
        Color fgColor = poiCellStyle.getRawFillForegroundColor();
        Color bgColor = poiCellStyle.getRawFillBackgroundColor();
        SColor fgSColor = fgColor == null ? null : this.book.createColor(BookHelper.colorToForegroundHTML(this.workbook, fgColor));
        SColor bgSColor = bgColor == null ? null : this.book.createColor(BookHelper.colorToBackgroundHTML(this.workbook, bgColor));
        ExtraFillImpl fill = new ExtraFillImpl(pattern, fgSColor, bgSColor);
        SBorder border = this.importBorder(poiCellStyle);
        SFont font = this.importFont((CellStyle)poiCellStyle);
        return new ExtraStyleImpl(font, fill, border, dataFormat);
    }

    protected SBorder importBorder(DxfCellStyle poiCellStyle) {
        BorderLineImpl vertical;
        BorderLineImpl diagonal;
        BorderLineImpl bottom;
        BorderLineImpl right;
        BorderLineImpl top;
        BorderLineImpl left;
        if (!poiCellStyle.isOverrideBorder()) {
            return null;
        }
        SBorder.BorderType typel = PoiEnumConversion.toBorderType(poiCellStyle.getRawBorderLeft());
        SBorder.BorderType typet = PoiEnumConversion.toBorderType(poiCellStyle.getRawBorderTop());
        SBorder.BorderType typer = PoiEnumConversion.toBorderType(poiCellStyle.getRawBorderRight());
        SBorder.BorderType typeb = PoiEnumConversion.toBorderType(poiCellStyle.getRawBorderBottom());
        SBorder.BorderType typed = PoiEnumConversion.toBorderType(poiCellStyle.getRawBorderDiagonal());
        SBorder.BorderType typev = PoiEnumConversion.toBorderType(poiCellStyle.getRawBorderVertical());
        SBorder.BorderType typeh = PoiEnumConversion.toBorderType(poiCellStyle.getRawBorderHorizontal());
        Color clrl = poiCellStyle.getRawBorderLeftColor();
        Color clrt = poiCellStyle.getRawBorderTopColor();
        Color clrr = poiCellStyle.getRawBorderRightColor();
        Color clrb = poiCellStyle.getRawBorderBottomColor();
        Color clrd = poiCellStyle.getRawBorderDiagonalColor();
        Color clrv = poiCellStyle.getRawBorderVerticalColor();
        Color clrh = poiCellStyle.getRawBorderHorizontalColor();
        BorderLineImpl borderLineImpl = typel == null ? null : (left = new BorderLineImpl(typel, clrl == null ? null : this.book.createColor(BookHelper.colorToBorderHTML(this.workbook, clrl))));
        BorderLineImpl borderLineImpl2 = typet == null ? null : (top = new BorderLineImpl(typet, clrt == null ? null : this.book.createColor(BookHelper.colorToBorderHTML(this.workbook, clrt))));
        BorderLineImpl borderLineImpl3 = typer == null ? null : (right = new BorderLineImpl(typer, clrr == null ? null : this.book.createColor(BookHelper.colorToBorderHTML(this.workbook, clrr))));
        BorderLineImpl borderLineImpl4 = typeb == null ? null : (bottom = new BorderLineImpl(typeb, clrb == null ? null : this.book.createColor(BookHelper.colorToBorderHTML(this.workbook, clrb))));
        BorderLineImpl borderLineImpl5 = typed == null ? null : (diagonal = new BorderLineImpl(typed, clrd == null ? null : this.book.createColor(BookHelper.colorToBorderHTML(this.workbook, clrd))));
        BorderLineImpl borderLineImpl6 = typev == null ? null : (vertical = new BorderLineImpl(typev, clrv == null ? null : this.book.createColor(BookHelper.colorToBorderHTML(this.workbook, clrv))));
        BorderLineImpl horizontal = typeh == null ? null : new BorderLineImpl(typeh, clrh == null ? null : this.book.createColor(BookHelper.colorToBorderHTML(this.workbook, clrh)));
        return new BorderImpl(left, top, right, bottom, diagonal, vertical, horizontal);
    }

    protected SFont createDxfZssFont(Font poiFont) {
        AbstractFontAdv font = (AbstractFontAdv)this.book.createFont(false);
        if (poiFont.isOverrideName()) {
            font.setName(poiFont.getFontName());
        }
        if (poiFont.isOverrideBold()) {
            font.setBoldweight(PoiEnumConversion.toBoldweight(poiFont.getBoldweight()));
        }
        if (poiFont.isOverrideItalic()) {
            font.setItalic(poiFont.getItalic());
        }
        if (poiFont.isOverrideStrikeout()) {
            font.setStrikeout(poiFont.getStrikeout());
        }
        if (poiFont.isOverrideUnderline()) {
            font.setUnderline(PoiEnumConversion.toUnderline(poiFont.getUnderline()));
        }
        if (poiFont.isOverrideHeightPoints()) {
            font.setHeightPoints(poiFont.getFontHeightInPoints());
        }
        if (poiFont.isOverrideTypeOffset()) {
            font.setTypeOffset(PoiEnumConversion.toTypeOffset(poiFont.getTypeOffset()));
        }
        if (poiFont.isOverrideColor()) {
            font.setColor(this.book.createColor(BookHelper.getFontHTMLColor(this.workbook, poiFont)));
        }
        font.setOverrideBold(poiFont.isOverrideBold());
        font.setOverrideColor(poiFont.isOverrideColor());
        font.setOverrideHeightPoints(poiFont.isOverrideHeightPoints());
        font.setOverrideItalic(poiFont.isOverrideItalic());
        font.setOverrideName(poiFont.isOverrideName());
        font.setOverrideStrikeout(poiFont.isOverrideStrikeout());
        font.setOverrideTypeOffset(poiFont.isOverrideTypeOffset());
        font.setOverrideUnderline(poiFont.isOverrideUnderline());
        return font;
    }

    @Override
    protected SFont importFont(CellStyle poiCellStyle) {
        if (poiCellStyle instanceof DxfCellStyle) {
            DxfCellStyle poiDxfCellStyle = (DxfCellStyle)poiCellStyle;
            Font poiFont = poiDxfCellStyle.getFont();
            return poiFont != null ? this.createDxfZssFont(poiFont) : null;
        }
        return super.importFont(poiCellStyle);
    }

    @Override
    protected void importConditionalFormatting(SSheet sheet, Sheet poiSheet) {
        XSSFSheet xssfSheet = (XSSFSheet)poiSheet;
        List cfms = xssfSheet.getConditionalFormattings();
        if (cfms == null) {
            return;
        }
        for (XSSFConditionalFormatting cf : cfms) {
            ConditionalFormattingImpl scf = this.prepareConditionalFormattingImpl(sheet, cf);
            ((AbstractSheetAdv)sheet).addConditionalFormatting(scf);
        }
    }

    protected ConditionalFormattingImpl prepareConditionalFormattingImpl(SSheet sheet, XSSFConditionalFormatting cf) {
        ConditionalFormattingImpl cfi = new ConditionalFormattingImpl(sheet);
        for (CellRangeAddress addr : cf.getFormattingRanges()) {
            int r1 = addr.getFirstRow();
            int c1 = addr.getFirstColumn();
            int r2 = addr.getLastRow();
            int c2 = addr.getLastColumn();
            cfi.addRegion(new CellRegion(r1, c1, r2, c2));
        }
        int len = cf.getNumberOfRules();
        for (int j = 0; j < len; ++j) {
            XSSFConditionalFormattingRule rule = cf.getRule(j);
            cfi.addRule(this.prepareConditonalFormattingRuleImpl(cfi, rule));
        }
        return cfi;
    }

    protected ConditionalFormattingRuleImpl prepareConditonalFormattingRuleImpl(SConditionalFormatting cfi, XSSFConditionalFormattingRule poiRule) {
        ConditionalFormattingRuleImpl cfri = new ConditionalFormattingRuleImpl(cfi);
        CTCfRule ctRule = poiRule.getCTCfRule();
        cfri.setPriority(ctRule.getPriority());
        cfri.setType(this.toConditionalFormattingRuleType(ctRule.getType()));
        if (ctRule.isSetStopIfTrue()) {
            cfri.setStopIfTrue(ctRule.getStopIfTrue());
        }
        if (ctRule.isSetDxfId()) {
            cfri.setExtraStyle(this.book.getExtraStyleAt((int)ctRule.getDxfId()));
        }
        switch (cfri.getType()) {
            case ABOVE_AVERAGE: {
                if (ctRule.isSetAboveAverage()) {
                    cfri.setAboveAverage(ctRule.getAboveAverage());
                }
                if (ctRule.isSetEqualAverage()) {
                    cfri.setEqualAverage(ctRule.getEqualAverage());
                }
                if (!ctRule.isSetStdDev()) break;
                cfri.setStandardDeviation(ctRule.getStdDev());
                break;
            }
            case CELL_IS: {
                if (ctRule.isSetOperator()) {
                    cfri.setOperator(this.toCFRuleOperator(ctRule.getOperator()));
                }
                this.prepareFormulas(cfri, ctRule);
                break;
            }
            case COLOR_SCALE: {
                cfri.setColorScale(this.prepareColorScale(ctRule));
                break;
            }
            case CONTAINS_BLANKS: 
            case NOT_CONTAINS_BLANKS: {
                this.prepareFormulas(cfri, ctRule);
                break;
            }
            case CONTAINS_ERRORS: 
            case NOT_CONTAINS_ERRORS: {
                this.prepareFormulas(cfri, ctRule);
                break;
            }
            case CONTAINS_TEXT: 
            case NOT_CONTAINS_TEXT: {
                cfri.setText(ctRule.getText());
                cfri.setOperator(this.toCFRuleOperator(ctRule.getOperator()));
                this.prepareFormulas(cfri, ctRule);
                break;
            }
            case DATA_BAR: {
                cfri.setDataBar(this.prepareDataBar(ctRule));
                break;
            }
            case BEGINS_WITH: 
            case ENDS_WITH: {
                cfri.setText(ctRule.getText());
                cfri.setOperator(this.toCFRuleOperator(ctRule.getOperator()));
                this.prepareFormulas(cfri, ctRule);
                break;
            }
            case EXPRESSION: {
                this.prepareFormulas(cfri, ctRule);
                break;
            }
            case ICON_SET: {
                cfri.setIconSet(this.prepareIconSet(ctRule));
                break;
            }
            case TIME_PERIOD: {
                cfri.setTimePeriod(this.toTimePeriod(ctRule.getTimePeriod()));
                this.prepareFormulas(cfri, ctRule);
                break;
            }
            case TOP_10: {
                if (ctRule.isSetRank()) {
                    cfri.setRank(ctRule.getRank());
                }
                if (ctRule.isSetPercent()) {
                    cfri.setPercent(ctRule.getPercent());
                }
                if (!ctRule.isSetBottom()) break;
                cfri.setBottom(ctRule.getBottom());
                break;
            }
        }
        return cfri;
    }

    protected SIconSet prepareIconSet(CTCfRule ctRule) {
        IconSetImpl iconSet = new IconSetImpl();
        CTIconSet ctIconSet = ctRule.getIconSet();
        for (CTCfvo ctvo : ctIconSet.getCfvoList()) {
            iconSet.addValueObject(this.prepareValueObject(ctvo));
        }
        iconSet.setType(this.toIconSetType(ctIconSet.getIconSet()));
        if (ctIconSet.isSetPercent()) {
            iconSet.setPercent(ctIconSet.getPercent());
        }
        if (ctIconSet.isSetReverse()) {
            iconSet.setReverse(ctIconSet.getReverse());
        }
        if (ctIconSet.isSetShowValue()) {
            iconSet.setShowValue(ctIconSet.getShowValue());
        }
        return iconSet;
    }

    protected SColorScale prepareColorScale(CTCfRule ctRule) {
        ColorScaleImpl colorScale = new ColorScaleImpl();
        CTColorScale ctColorScale = ctRule.getColorScale();
        for (CTCfvo ctvo : ctColorScale.getCfvoList()) {
            colorScale.addValueObject(this.prepareValueObject(ctvo));
        }
        for (CTColor ctColor : ctColorScale.getColorList()) {
            byte[] rgb = ctColor.getRgb();
            ColorImpl color = new ColorImpl(rgb);
            colorScale.addColor(color);
        }
        return colorScale;
    }

    protected SDataBar prepareDataBar(CTCfRule ctRule) {
        DataBarImpl dataBar = new DataBarImpl();
        CTDataBar ctDataBar = ctRule.getDataBar();
        for (CTCfvo ctvo : ctDataBar.getCfvoList()) {
            dataBar.addValueObject(this.prepareValueObject(ctvo));
        }
        byte[] rgb = ctDataBar.getColor().getRgb();
        ColorImpl color = new ColorImpl(rgb);
        dataBar.setColor(color);
        if (ctDataBar.isSetMaxLength()) {
            dataBar.setMaxLength((int)ctDataBar.getMaxLength());
        }
        if (ctDataBar.isSetMinLength()) {
            dataBar.setMinLength((int)ctDataBar.getMinLength());
        }
        if (ctDataBar.isSetShowValue()) {
            dataBar.setShowValue(ctDataBar.getShowValue());
        }
        return dataBar;
    }

    protected void prepareFormulas(ConditionalFormattingRuleImpl cfri, CTCfRule ctRule) {
        Iterator it = ctRule.getFormulaList().iterator();
        if (!it.hasNext()) {
            return;
        }
        cfri.setFormula1((String)it.next());
        if (!it.hasNext()) {
            return;
        }
        cfri.setFormula2((String)it.next());
        if (!it.hasNext()) {
            return;
        }
        cfri.setFormula3((String)it.next());
    }

    protected SCFValueObject prepareValueObject(CTCfvo ctvo) {
        CFValueObjectImpl vo = new CFValueObjectImpl();
        if (ctvo.isSetGte()) {
            vo.setGreaterOrEqual(ctvo.getGte());
        }
        vo.setType(this.toValueObjectType(ctvo.getType()));
        if (ctvo.isSetVal()) {
            vo.setValue(ctvo.getVal());
        }
        return vo;
    }

    protected SConditionalFormattingRule.RuleTimePeriod toTimePeriod(STTimePeriod.Enum ctPeriod) {
        return SConditionalFormattingRule.RuleTimePeriod.values()[ctPeriod.intValue() - 1];
    }

    protected SConditionalFormattingRule.RuleOperator toCFRuleOperator(STConditionalFormattingOperator.Enum ctType) {
        return SConditionalFormattingRule.RuleOperator.values()[ctType.intValue() - 1];
    }

    protected SIconSet.IconSetType toIconSetType(STIconSetType.Enum ctType) {
        return SIconSet.IconSetType.values()[ctType.intValue() - 1];
    }

    protected SCFValueObject.CFValueObjectType toValueObjectType(STCfvoType.Enum ctType) {
        return SCFValueObject.CFValueObjectType.values()[ctType.intValue() - 1];
    }

    protected SConditionalFormattingRule.RuleType toConditionalFormattingRuleType(STCfType.Enum cfType) {
        return SConditionalFormattingRule.RuleType.values()[cfType.intValue() - 1];
    }

    protected STCfType.Enum toConditionalFormatingRuleType(SConditionalFormattingRule.RuleType stype) {
        return STCfType.Enum.forInt((int)stype.value);
    }

    @Override
    protected void importTableStyles() {
        ((AbstractBookAdv)this.book).clearTableStyles();
        for (TableStyle poiStyle : this.workbook.getTableStyles()) {
            this.book.addTableStyle(this.importTableStyle(poiStyle));
        }
        this.book.setDefaultPivotStyleName(this.workbook.getDefaultPivotStyle());
        this.book.setDefaultTableStyleName(this.workbook.getDefaultTableStyle());
    }

    protected STableStyleElem importTableStyleElem(TableStyle poiTableStyle, String name) {
        DxfCellStyle dxfStyle = poiTableStyle.getDxfCellStyle(name);
        if (dxfStyle == null) {
            return null;
        }
        SExtraStyle extraStyle = this.book.getExtraStyleAt(dxfStyle.getIndex());
        return new TableStyleElemImpl(extraStyle.getFont(), extraStyle.getFill(), extraStyle.getBorder());
    }

    protected STableStyle importTableStyle(TableStyle poiTableStyle) {
        String name = poiTableStyle.getName();
        STableStyleElem wholeTable = this.importTableStyleElem(poiTableStyle, "wholeTable");
        STableStyleElem colStripe1 = this.importTableStyleElem(poiTableStyle, "firstColumnStripe");
        STableStyleElem colStripe2 = this.importTableStyleElem(poiTableStyle, "SecondColumnStripe");
        STableStyleElem rowStripe1 = this.importTableStyleElem(poiTableStyle, "firstRowStripe");
        STableStyleElem rowStripe2 = this.importTableStyleElem(poiTableStyle, "SecondRowStripe");
        STableStyleElem lastCol = this.importTableStyleElem(poiTableStyle, "lastColumn");
        STableStyleElem firstCol = this.importTableStyleElem(poiTableStyle, "firstColumn");
        STableStyleElem headerRow = this.importTableStyleElem(poiTableStyle, "headerRow");
        STableStyleElem totalRow = this.importTableStyleElem(poiTableStyle, "totalRow");
        STableStyleElem firstHeaderCell = this.importTableStyleElem(poiTableStyle, "firstHeaderCell");
        STableStyleElem lastHeaderCell = this.importTableStyleElem(poiTableStyle, "lastHeaderCell");
        STableStyleElem firstTotalCell = this.importTableStyleElem(poiTableStyle, "firstTotalCell");
        STableStyleElem lastTotalCell = this.importTableStyleElem(poiTableStyle, "lastTotalCell");
        return new TableStyleImpl(name, wholeTable, colStripe1, 1, colStripe2, 1, rowStripe1, 1, rowStripe2, 1, lastCol, firstCol, headerRow, totalRow, firstHeaderCell, lastHeaderCell, firstTotalCell, lastTotalCell);
    }

    @Override
    protected SColorFilter importColorFilter(ColorFilter colorFilter) {
        if (colorFilter == null) {
            return null;
        }
        SExtraStyle src = this.importExtraStyle(colorFilter.getDxfCellStyle());
        CellStyleMatcher matcher = new CellStyleMatcher(src);
        SExtraStyle style = this.book.searchExtraStyle(matcher);
        if (style == null) {
            this.book.addExtraStyle(src);
            style = src;
        }
        return new ColorFilterImpl(style, colorFilter.isByFontColor());
    }

    @Override
    protected SCustomFilters importCustomFilters(CustomFilters poiCustomFilters) {
        if (poiCustomFilters == null) {
            return null;
        }
        boolean and = poiCustomFilters.isAnd();
        CustomFilter poiFilter1 = poiCustomFilters.getCustomFilter1();
        CustomFilter poiFilter2 = poiCustomFilters.getCustomFilter2();
        CustomFilterImpl filter1 = new CustomFilterImpl(poiFilter1.getValue(), this.toZSSOperator(poiFilter1.getOperator()));
        CustomFilterImpl filter2 = poiFilter2 == null ? null : new CustomFilterImpl(poiFilter2.getValue(), this.toZSSOperator(poiFilter2.getOperator()));
        return new CustomFiltersImpl(filter1, filter2, and);
    }

    private SAutoFilter.FilterOp toZSSOperator(CustomFilter.Operator op) {
        return SAutoFilter.FilterOp.valueOf(op.name());
    }

    @Override
    protected SDynamicFilter importDynamicFilter(DynamicFilter poiDynamicFilter) {
        if (poiDynamicFilter == null) {
            return null;
        }
        Double maxval = poiDynamicFilter.getMaxValue();
        Double val = poiDynamicFilter.getValue();
        String type = poiDynamicFilter.getType();
        return new DynamicFilterImpl(maxval, val, type);
    }

    @Override
    protected STop10Filter importTop10Filter(Top10Filter poiTop10Filter) {
        if (poiTop10Filter == null) {
            return null;
        }
        return new Top10FilterImpl(poiTop10Filter.isTop(), poiTop10Filter.getValue(), poiTop10Filter.isPercent(), poiTop10Filter.getFilterValue());
    }
}

