/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.range.impl;

import java.io.Serializable;
import org.zkoss.poi.ss.usermodel.ZssContext;
import org.zkoss.zss.model.SCell;
import org.zkoss.zss.model.SSheet;
import org.zkoss.zss.model.sys.EngineFactory;
import org.zkoss.zss.model.sys.format.FormatContext;
import org.zkoss.zss.model.sys.format.FormatEngine;
import org.zkoss.zss.model.sys.formula.FormulaEngine;
import org.zkoss.zss.range.SRange;

public class RangeHelperBase
implements Serializable {
    private static final long serialVersionUID = 1611119134706736160L;
    protected final SRange range;
    protected final SSheet sheet;
    private FormatEngine _formatEngine;
    private FormulaEngine _formulaEngine;

    public RangeHelperBase(SRange range) {
        this.range = range;
        this.sheet = range.getSheet();
    }

    public static boolean isBlank(SCell cell) {
        return cell == null || cell.isNull() || cell.getType() == SCell.CellType.BLANK;
    }

    protected FormatEngine getFormatEngine() {
        if (this._formatEngine == null) {
            this._formatEngine = EngineFactory.getInstance().createFormatEngine();
        }
        return this._formatEngine;
    }

    public String getFormattedText(SCell cell) {
        return this.getFormatEngine().format(cell, new FormatContext(ZssContext.getCurrent().getLocale())).getText();
    }

    protected FormulaEngine getFormulaEngine() {
        if (this._formulaEngine == null) {
            this._formulaEngine = EngineFactory.getInstance().createFormulaEngine();
        }
        return this._formulaEngine;
    }

    public int getRow() {
        return this.range.getRow();
    }

    public int getColumn() {
        return this.range.getColumn();
    }

    public int getLastRow() {
        return this.range.getLastRow();
    }

    public int getLastColumn() {
        return this.range.getLastColumn();
    }

    public boolean isWholeRow() {
        return this.range.isWholeRow();
    }

    public boolean isWholeSheet() {
        return this.range.isWholeSheet();
    }

    public boolean isWholeColumn() {
        return this.range.isWholeColumn();
    }
}

