/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.range.impl;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.zkoss.zss.model.CellRegion;
import org.zkoss.zss.model.InvalidModelOpException;
import org.zkoss.zss.model.SCell;
import org.zkoss.zss.model.SCellStyle;
import org.zkoss.zss.model.SChart;
import org.zkoss.zss.model.SColumn;
import org.zkoss.zss.model.SColumnArray;
import org.zkoss.zss.model.SRow;
import org.zkoss.zss.model.SSheet;
import org.zkoss.zss.model.SSheetViewInfo;
import org.zkoss.zss.model.STable;
import org.zkoss.zss.model.STableColumn;
import org.zkoss.zss.model.ViewAnchor;
import org.zkoss.zss.model.impl.AbstractBookAdv;
import org.zkoss.zss.model.impl.AbstractCellAdv;
import org.zkoss.zss.model.impl.AbstractColumnArrayAdv;
import org.zkoss.zss.model.impl.AbstractRowAdv;
import org.zkoss.zss.model.impl.AbstractSheetAdv;
import org.zkoss.zss.model.impl.AbstractTableAdv;
import org.zkoss.zss.range.SRange;
import org.zkoss.zss.range.impl.ClearCellHelper;
import org.zkoss.zss.range.impl.NotifyChangeHelper;
import org.zkoss.zss.range.impl.RangeHelperBase;
import org.zkoss.zss.range.impl.RangeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InsertDeleteHelper
extends RangeHelperBase {
    public InsertDeleteHelper(SRange range) {
        super(range);
    }

    private String getDeletedTables(SRange range, Set<String> toDelete, Set<String> overlapped) {
        int row1 = range.getRow();
        int row2 = range.getLastRow();
        int col1 = range.getColumn();
        int col2 = range.getLastColumn();
        SSheet sheet = range.getSheet();
        for (STable tb : sheet.getTables()) {
            CellRegion rgn = tb.getAllRegion().getRegion();
            int tr1 = rgn.getRow();
            int tc1 = rgn.getColumn();
            int tr2 = rgn.getLastRow();
            int tc2 = rgn.getLastColumn();
            if (tr2 < row1 || tr1 > row2 || tc2 < col1 || tc1 > col2) continue;
            if (row1 <= tr1 && tr2 <= row2 && col1 <= tc1 && tc2 <= col2) {
                if (!(this.isWholeColumn() || this.isWholeRow() || toDelete.isEmpty())) {
                    return "The operation can only be applied on one table.";
                }
                toDelete.add(tb.getName().toUpperCase());
                continue;
            }
            if (!overlapped.isEmpty() || !toDelete.isEmpty()) {
                return "The operation can only be applied on one table.";
            }
            if (range.isWholeRow() || range.isWholeColumn() || tr1 <= row1 && row2 <= tr2 && tc1 <= col1 && col2 <= tc2) {
                overlapped.add(tb.getName().toUpperCase());
                continue;
            }
            return "The operation can only be applied on one table.";
        }
        return null;
    }

    private void collectAndCheckShiftTables(int row1, int col1, int row2, int col2, Set<String> toShift, boolean horizontal) {
        if (horizontal) {
            for (STable tb : this.sheet.getTables()) {
                CellRegion rgn = tb.getAllRegion().getRegion();
                int tr1 = rgn.getRow();
                int tc1 = rgn.getColumn();
                int tr2 = rgn.getLastRow();
                if (tc1 <= col2 || tr2 < row1 || tr1 > row2) continue;
                if (row1 > tr1 || tr2 > row2) {
                    throw new InvalidModelOpException("The operation is attempting to shift cells in table '" + tb.getAllRegion().getRegion().getReferenceString() + "' on your worksheet.");
                }
                toShift.add(tb.getName().toUpperCase());
            }
        } else {
            for (STable tb : this.sheet.getTables()) {
                CellRegion rgn = tb.getAllRegion().getRegion();
                int tr1 = rgn.getRow();
                int tc1 = rgn.getColumn();
                int tc2 = rgn.getLastColumn();
                if (tr1 <= row2 || tc2 < col1 || tc1 > col2) continue;
                if (col1 > tc1 || tc2 > col2) {
                    throw new InvalidModelOpException("The operation is attempting to shift cells in table '" + tb.getAllRegion().getRegion().getReferenceString() + "' on your worksheet.");
                }
                toShift.add(tb.getName().toUpperCase());
            }
        }
    }

    private STable deleteTable(SRange.DeleteShift shift, Set<String> toShift) {
        HashSet<String> toDelete = new HashSet<String>();
        HashSet<String> overlapped = new HashSet<String>(2);
        String message = this.getDeletedTables(this.range, toDelete, overlapped);
        if (message != null) {
            throw new InvalidModelOpException(message);
        }
        AbstractBookAdv book = (AbstractBookAdv)this.sheet.getBook();
        STable overlap = overlapped.isEmpty() ? null : book.getTable((String)overlapped.iterator().next());
        int row1 = this.getRow();
        int row2 = this.getLastRow();
        int col1 = this.getColumn();
        int col2 = this.getLastColumn();
        if (overlap != null) {
            CellRegion orgn = overlap.getAllRegion().getRegion();
            int r1 = orgn.getRow();
            int r2 = orgn.getLastRow();
            if (shift == SRange.DeleteShift.UP) {
                if (overlap.getHeaderRowCount() > 0 && row1 <= r1 && r1 <= row2 && r2 > row2 || orgn.getRowCount() - overlap.getHeaderRowCount() - overlap.getTotalsRowCount() == 1) {
                    throw new InvalidModelOpException("Can only applies Delete > Shift Cells Left");
                }
                int c01 = Math.min(orgn.getColumn(), col1);
                int c02 = Math.max(orgn.getLastColumn(), col2);
                this.collectAndCheckShiftTables(row1, c01, row2, c02, toShift, false);
            } else {
                int r01 = Math.min(r1, row1);
                int r02 = Math.max(orgn.getLastRow(), row2);
                this.collectAndCheckShiftTables(r01, col1, r02, col2, toShift, true);
            }
        } else {
            this.collectAndCheckShiftTables(row1, col1, row2, col2, toShift, shift == SRange.DeleteShift.LEFT);
        }
        InsertDeleteHelper.deleteTablesByNames(this.sheet, toDelete);
        return overlap;
    }

    public static Set<String> collectContainedTables(SSheet sheet, int row1, int col1, int row2, int col2) {
        HashSet<String> toDelete = new HashSet<String>();
        for (STable tb : sheet.getTables()) {
            CellRegion rgn = tb.getAllRegion().getRegion();
            int tr1 = rgn.getRow();
            int tc1 = rgn.getColumn();
            int tr2 = rgn.getLastRow();
            int tc2 = rgn.getLastColumn();
            if (row1 > tr1 || tr2 > row2 || col1 > tc1 || tc2 > col2) continue;
            toDelete.add(tb.getName().toUpperCase());
        }
        return toDelete;
    }

    public static void deleteTablesByNames(SSheet sheet, Set<String> toDelete) {
        AbstractBookAdv book = (AbstractBookAdv)sheet.getBook();
        if (!toDelete.isEmpty()) {
            for (String tbName : toDelete) {
                book.removeTable(tbName);
            }
            ((AbstractSheetAdv)sheet).removeTables(toDelete);
        }
    }

    private void deleteTable0(STable tb) {
        AbstractBookAdv book = (AbstractBookAdv)this.sheet.getBook();
        String tbName = tb.getName();
        book.removeTable(tbName);
        ((AbstractSheetAdv)this.sheet).removeTable(tbName);
    }

    private boolean deleteRows(STable tb) {
        if (tb == null) {
            return false;
        }
        CellRegion rgn = tb.getAllRegion().getRegion();
        if (rgn.getRow() == this.getRow() && rgn.getLastRow() == this.getLastRow()) {
            this.deleteTable0(tb);
            return false;
        }
        ((AbstractTableAdv)tb).deleteRows(this.getRow(), this.getLastRow());
        return true;
    }

    private void deleteCols(STable tb) {
        if (tb == null) {
            return;
        }
        CellRegion rgn = tb.getAllRegion().getRegion();
        if (rgn.getColumn() == this.getColumn() && rgn.getLastColumn() == this.getLastColumn()) {
            this.deleteTable0(tb);
        } else {
            ((AbstractTableAdv)tb).deleteCols(this.getColumn(), this.getLastColumn());
        }
    }

    private void shiftTables(AbstractBookAdv book, Set<String> toShift, int offset, boolean horizontal) {
        if (!toShift.isEmpty()) {
            HashSet<String> toDelete = new HashSet<String>();
            if (horizontal) {
                for (String tbName : toShift) {
                    if (((AbstractTableAdv)book.getTable(tbName)).shiftCols(offset)) continue;
                    toDelete.add(tbName);
                }
            } else {
                for (String tbName : toShift) {
                    if (((AbstractTableAdv)book.getTable(tbName)).shiftRows(offset)) continue;
                    toDelete.add(tbName);
                }
            }
            if (!toDelete.isEmpty()) {
                for (String tbName : toDelete) {
                    book.removeTable(tbName);
                }
                ((AbstractSheetAdv)this.sheet).removeTables(toDelete);
            }
        }
    }

    public void delete(SRange.DeleteShift shift) {
        CellRegion rgn0;
        CellRegion rgn;
        AbstractBookAdv book = (AbstractBookAdv)this.sheet.getBook();
        int row1 = this.getRow();
        int row2 = this.getLastRow();
        int col1 = this.getColumn();
        int col2 = this.getLastColumn();
        HashSet<String> toShift = new HashSet<String>();
        STable overlap = null;
        if (this.isWholeRow()) {
            if (this.checkInCornerFreezePanel()) {
                throw new InvalidModelOpException("Doesn't support deleting rows/columns operation when current range covers the corner frozen panes");
            }
            if (this.checkCrossTopFreezePanel()) {
                throw new InvalidModelOpException("Doesn't support deleting rows when current range cross the freeze panes line");
            }
            overlap = this.deleteTable(SRange.DeleteShift.UP, toShift);
            if (overlap != null) {
                rgn = overlap.getAllRegion().getRegion();
                if (this.deleteRows(overlap) && (rgn0 = overlap.getAllRegion().getRegion()).getLastRow() - rgn0.getRow() + row2 - row1 + 1 > rgn.getLastRow() - rgn.getRow()) {
                    new ClearCellHelper(new RangeImpl(this.sheet, row1, col1, row1, col2)).clearCellContent();
                    ++row1;
                }
            }
            if (row2 >= row1) {
                this.shiftTables(book, toShift, -row2 + row1 - 1, false);
                this.shrinkChartHeight(row1, row2);
                this.sheet.deleteRow(row1, row2);
            }
        } else if (this.isWholeColumn()) {
            if (this.checkInCornerFreezePanel()) {
                throw new InvalidModelOpException("Doesn't support deleting rows/columns operation when current range covers the corner frozen panes");
            }
            if (this.checkCrossLeftFreezePanel()) {
                throw new InvalidModelOpException("Doesn't support deleting columns when current range cross the freeze panes line");
            }
            overlap = this.deleteTable(SRange.DeleteShift.LEFT, toShift);
            this.deleteCols(overlap);
            this.shiftTables(book, toShift, -col2 + col1 - 1, true);
            this.shrinkChartWidth();
            this.sheet.deleteColumn(col1, col2);
        } else if (shift != SRange.DeleteShift.DEFAULT) {
            overlap = this.deleteTable(shift, toShift);
            if (overlap != null) {
                rgn = overlap.getAllRegion().getRegion();
                if (shift == SRange.DeleteShift.LEFT) {
                    this.deleteCols(overlap);
                    this.shiftTables(book, toShift, -col2 + col1 - 1, true);
                    this.sheet.deleteCell(rgn.getRow(), col1, rgn.getLastRow(), col2, true);
                } else {
                    if (this.deleteRows(overlap) && (rgn0 = overlap.getAllRegion().getRegion()).getLastRow() - rgn0.getRow() + row2 - row1 + 1 > rgn.getLastRow() - rgn.getRow()) {
                        new ClearCellHelper(new RangeImpl(this.sheet, row1, rgn.getColumn(), row1, rgn.getLastColumn())).clearCellContent();
                        ++row1;
                    }
                    if (row2 >= row1) {
                        this.shiftTables(book, toShift, -row2 + row1 - 1, false);
                        this.sheet.deleteCell(row1, rgn.getColumn(), row2, rgn.getLastColumn(), false);
                    }
                }
            } else {
                if (shift == SRange.DeleteShift.LEFT) {
                    this.shiftTables(book, toShift, -col2 + col1 - 1, true);
                } else {
                    this.shiftTables(book, toShift, -row2 + row1 - 1, false);
                }
                this.sheet.deleteCell(row1, col1, row2, col2, shift == SRange.DeleteShift.LEFT);
            }
        }
        if (overlap != null) {
            ((AbstractTableAdv)overlap).refreshFilter();
        }
        if (!toShift.isEmpty()) {
            for (String tbName : toShift) {
                AbstractTableAdv tb = (AbstractTableAdv)book.getTable(tbName);
                if (tb == null) continue;
                tb.refreshFilter();
            }
        }
    }

    private String getInsertedTables(SRange range, Set<String> overlapped, boolean horizontal) {
        int row1 = range.getRow();
        int row2 = range.getLastRow();
        int col1 = range.getColumn();
        int col2 = range.getLastColumn();
        SSheet sheet = range.getSheet();
        boolean isWholeRow = this.isWholeRow();
        boolean isWholeColumn = this.isWholeColumn();
        HashSet<String> toShift = new HashSet<String>();
        for (STable tb : sheet.getTables()) {
            CellRegion rgn = tb.getAllRegion().getRegion();
            int tr1 = rgn.getRow();
            int tc1 = rgn.getColumn();
            int tr2 = rgn.getLastRow();
            int tc2 = rgn.getLastColumn();
            if (tr2 < row1 || tr1 > row2 || tc2 < col1 || tc1 > col2) continue;
            if (isWholeRow && row1 <= tr1) {
                toShift.add(tb.getName().toUpperCase());
                continue;
            }
            if (isWholeColumn && col1 <= tc1) {
                toShift.add(tb.getName().toUpperCase());
                continue;
            }
            if (!(horizontal || col1 > tc1 || tc2 > col2 || row1 >= tr1 && (row1 != tr1 || col1 >= tc1 && tc2 >= col2))) {
                toShift.add(tb.getName().toUpperCase());
                continue;
            }
            if (horizontal && row1 <= tr1 && tr2 <= row2 && (col1 < tc1 || col1 == tc1 && (row1 < tr1 || tr2 < row2))) {
                toShift.add(tb.getName().toUpperCase());
                continue;
            }
            if (!overlapped.isEmpty() || !toShift.isEmpty()) {
                return "The operation can only be applied on one table.";
            }
            if (range.isWholeRow() || range.isWholeColumn() || tr1 <= row1 && row2 <= tr2 && tc1 <= col1 && col2 <= tc2) {
                overlapped.add(tb.getName().toUpperCase());
                continue;
            }
            return "The operation can only be applied on one table.";
        }
        return null;
    }

    private STable insertTable(SRange.InsertShift shift, Set<String> toShift) {
        HashSet<String> overlapped = new HashSet<String>(2);
        String message = this.getInsertedTables(this.range, overlapped, shift == SRange.InsertShift.RIGHT);
        if (message != null) {
            throw new InvalidModelOpException(message);
        }
        AbstractBookAdv book = (AbstractBookAdv)this.sheet.getBook();
        STable overlap = overlapped.isEmpty() ? null : book.getTable((String)overlapped.iterator().next());
        int row1 = this.getRow();
        int row2 = this.getLastRow();
        int col1 = this.getColumn();
        int col2 = this.getLastColumn();
        if (overlap != null) {
            CellRegion orgn = overlap.getAllRegion().getRegion();
            int r1 = orgn.getRow();
            int r2 = orgn.getLastRow();
            if (shift == SRange.InsertShift.DOWN) {
                if (overlap.getHeaderRowCount() > 0 && row1 <= r1 && r1 <= row2 && r2 > row2) {
                    throw new InvalidModelOpException("Can only applies Insert > Shift Cells Right");
                }
                int c01 = Math.min(orgn.getColumn(), col1);
                int c02 = Math.max(orgn.getLastColumn(), col2);
                this.collectAndCheckShiftTables(row1, c01, row1, c02, toShift, false);
            } else {
                int r01 = Math.min(r1, row1);
                int r02 = Math.max(orgn.getLastRow(), row2);
                this.collectAndCheckShiftTables(r01, col1, r02, col1, toShift, true);
            }
        } else if (shift == SRange.InsertShift.DOWN) {
            this.collectAndCheckShiftTables(row1, col1, row1 - 1, col2, toShift, false);
        } else {
            this.collectAndCheckShiftTables(row1, col1, row2, col1 - 1, toShift, true);
        }
        return overlap;
    }

    private void insertTableRows(STable tb) {
        if (tb == null) {
            return;
        }
        ((AbstractTableAdv)tb).insertRows(this.getRow(), this.getLastRow());
    }

    private void insertTableCols(STable tb, boolean insertLeft) {
        if (tb == null) {
            return;
        }
        ((AbstractTableAdv)tb).insertCols(this.getColumn(), this.getLastColumn(), insertLeft);
    }

    private void fillHeaderRow(STable tb, int col1, int col2) {
        if (tb == null || tb.getHeaderRowCount() == 0) {
            return;
        }
        CellRegion rgn = tb.getAllRegion().getRegion();
        int r1 = rgn.getRow();
        for (int j = col1; j <= col2; ++j) {
            STableColumn tbCol = tb.getColumnAt(j);
            String name = tbCol.getName();
            SCell cell = this.sheet.getCell(r1, j);
            cell.setStringValue(name);
        }
    }

    public void insert(SRange.InsertShift shift, SRange.InsertCopyOrigin copyOrigin) {
        AbstractBookAdv book = (AbstractBookAdv)this.sheet.getBook();
        int row1 = this.getRow();
        int row2 = this.getLastRow();
        int col1 = this.getColumn();
        int col2 = this.getLastColumn();
        HashSet<String> toShift = new HashSet<String>();
        STable overlap = null;
        if (this.isWholeRow()) {
            if (this.checkInCornerFreezePanel()) {
                throw new InvalidModelOpException("Doesn't support inserting rows/columns when current range covers the corner frozen panes");
            }
            if (this.checkCrossTopFreezePanel()) {
                throw new InvalidModelOpException("Doesn't support inserting rows when current range cross the freeze panes line");
            }
            overlap = this.insertTable(SRange.InsertShift.DOWN, toShift);
            this.insertTableRows(overlap);
            this.shiftTables(book, toShift, row2 - row1 + 1, false);
            if (overlap != null) {
                copyOrigin = SRange.InsertCopyOrigin.FORMAT_LEFT_ABOVE;
            }
            this.sheet.insertRow(row1, row2);
            if (copyOrigin == SRange.InsertCopyOrigin.FORMAT_LEFT_ABOVE) {
                if (row1 - 1 >= 0) {
                    this.copyRowStyle(row1 - 1, row1, row2);
                }
            } else if (copyOrigin == SRange.InsertCopyOrigin.FORMAT_RIGHT_BELOW && this.getLastRow() + 1 <= this.sheet.getBook().getMaxRowIndex()) {
                this.copyRowStyle(row2 + 1, row1, row2);
            }
            this.extendChartHeight();
        } else if (this.isWholeColumn()) {
            if (this.checkInCornerFreezePanel()) {
                throw new InvalidModelOpException("Doesn't support inserting rows/columns when current range covers the corner frozen panes");
            }
            if (this.checkCrossLeftFreezePanel()) {
                throw new InvalidModelOpException("Doesn't support inserting columns when current range cross the freeze panes line");
            }
            overlap = this.insertTable(SRange.InsertShift.RIGHT, toShift);
            this.insertTableCols(overlap, copyOrigin == SRange.InsertCopyOrigin.FORMAT_LEFT_ABOVE);
            this.shiftTables(book, toShift, col2 - col1 + 1, true);
            if (overlap != null) {
                copyOrigin = SRange.InsertCopyOrigin.FORMAT_LEFT_ABOVE;
            }
            this.sheet.insertColumn(col1, col2);
            this.fillHeaderRow(overlap, col1, col2);
            if (copyOrigin == SRange.InsertCopyOrigin.FORMAT_LEFT_ABOVE) {
                if (col1 - 1 >= 0) {
                    this.copyColumnStyle(col1 - 1, col1, col2);
                }
            } else if (copyOrigin == SRange.InsertCopyOrigin.FORMAT_RIGHT_BELOW && col2 + 1 <= this.sheet.getBook().getMaxColumnIndex()) {
                this.copyColumnStyle(col2 + 1, col1, col2);
            }
            this.extendChartWidth();
        } else if (shift != SRange.InsertShift.DEFAULT) {
            overlap = this.insertTable(shift, toShift);
            if (overlap != null) {
                CellRegion rgn = overlap.getAllRegion().getRegion();
                if (shift == SRange.InsertShift.RIGHT) {
                    boolean isLastColumn = col1 == rgn.getLastColumn();
                    this.insertTableCols(overlap, copyOrigin == SRange.InsertCopyOrigin.FORMAT_LEFT_ABOVE);
                    this.shiftTables(book, toShift, col2 - col1 + 1, true);
                    if (col1 == col2 && isLastColumn && copyOrigin == SRange.InsertCopyOrigin.FORMAT_RIGHT_BELOW) {
                        ++col1;
                        ++col2;
                    }
                    row1 = rgn.getRow();
                    row2 = rgn.getLastRow();
                } else {
                    boolean isLastDataRow = row1 == rgn.getLastRow() - overlap.getTotalsRowCount();
                    this.insertTableRows(overlap);
                    this.shiftTables(book, toShift, row2 - row1 + 1, false);
                    if (row1 == row2 && isLastDataRow && copyOrigin == SRange.InsertCopyOrigin.FORMAT_RIGHT_BELOW) {
                        ++row1;
                        ++row2;
                    }
                    col1 = rgn.getColumn();
                    col2 = rgn.getLastColumn();
                }
                copyOrigin = SRange.InsertCopyOrigin.FORMAT_LEFT_ABOVE;
            } else if (shift == SRange.InsertShift.RIGHT) {
                this.shiftTables(book, toShift, col2 - col1 + 1, true);
            } else {
                this.shiftTables(book, toShift, row2 - row1 + 1, false);
            }
            this.sheet.insertCell(row1, col1, row2, col2, shift == SRange.InsertShift.RIGHT);
            if (shift == SRange.InsertShift.RIGHT) {
                this.fillHeaderRow(overlap, col1, col2);
            }
            if (shift == SRange.InsertShift.RIGHT) {
                if (copyOrigin == SRange.InsertCopyOrigin.FORMAT_LEFT_ABOVE) {
                    if (col1 - 1 >= 0) {
                        this.copyCellStyleFromColumn(col1 - 1);
                    }
                } else if (copyOrigin == SRange.InsertCopyOrigin.FORMAT_RIGHT_BELOW && col2 + 1 <= this.sheet.getBook().getMaxColumnIndex()) {
                    this.copyCellStyleFromColumn(col2 + 1);
                }
            } else if (copyOrigin == SRange.InsertCopyOrigin.FORMAT_LEFT_ABOVE) {
                if (row1 - 1 >= 0) {
                    this.copyCellStyleFromRow(row1 - 1);
                }
            } else if (copyOrigin == SRange.InsertCopyOrigin.FORMAT_RIGHT_BELOW && row2 + 1 <= this.sheet.getBook().getMaxRowIndex()) {
                this.copyCellStyleFromRow(row2 + 1);
            }
        }
        if (overlap != null) {
            ((AbstractTableAdv)overlap).refreshFilter();
        }
        if (!toShift.isEmpty()) {
            for (String tbName : toShift) {
                AbstractTableAdv tb = (AbstractTableAdv)book.getTable(tbName);
                if (tb == null) continue;
                tb.refreshFilter();
            }
        }
    }

    private void copyRowStyle(int srcRowIdx, int rowIdx, int lastRowIdx) {
        SRow srcRow = this.sheet.getRow(srcRowIdx);
        if (!srcRow.isNull()) {
            for (int r = rowIdx; r <= lastRowIdx; ++r) {
                SRow row = this.sheet.getRow(r);
                SCellStyle style = ((AbstractRowAdv)srcRow).getCellStyle(true);
                if (style != null) {
                    row.setCellStyle(style);
                }
                if (!srcRow.isCustomHeight()) continue;
                row.setHeight(srcRow.getHeight());
                row.setCustomHeight(true);
            }
        }
        Iterator<SCell> cellsInRow = this.sheet.getCellIterator(srcRowIdx);
        while (cellsInRow.hasNext()) {
            SCell srcCell = cellsInRow.next();
            SCellStyle cellStyle = ((AbstractCellAdv)srcCell).getCellStyle(true);
            if (cellStyle == null) continue;
            for (int r = rowIdx; r <= lastRowIdx; ++r) {
                this.sheet.getCell(r, srcCell.getColumnIndex()).setCellStyle(cellStyle);
            }
        }
    }

    private void copyColumnStyle(int srcColumnIdx, int columnIdx, int lastColumnIdx) {
        SColumnArray srcColumnArray = this.sheet.getColumnArray(srcColumnIdx);
        if (srcColumnArray != null) {
            for (int c = columnIdx; c <= lastColumnIdx; ++c) {
                SColumn row = this.sheet.getColumn(c);
                SCellStyle style = ((AbstractColumnArrayAdv)srcColumnArray).getCellStyle(true);
                if (style != null) {
                    row.setCellStyle(style);
                }
                if (!srcColumnArray.isCustomWidth()) continue;
                row.setWidth(srcColumnArray.getWidth());
                row.setCustomWidth(true);
            }
        }
        Iterator<SRow> srcRows = this.sheet.getRowIterator();
        while (srcRows.hasNext()) {
            SCellStyle cellStyle;
            int r = srcRows.next().getIndex();
            SCell srcCell = this.sheet.getCell(r, srcColumnIdx);
            if (srcCell.isNull() || (cellStyle = ((AbstractCellAdv)srcCell).getCellStyle(true)) == null) continue;
            for (int c = columnIdx; c <= lastColumnIdx; ++c) {
                this.sheet.getCell(r, c).setCellStyle(cellStyle);
            }
        }
    }

    private void copyCellStyleFromRow(int rowIndex) {
        Iterator<SCell> cellsInRow = this.sheet.getCellIterator(rowIndex);
        while (cellsInRow.hasNext()) {
            SCell srcCell = cellsInRow.next();
            int c = srcCell.getColumnIndex();
            if (c < this.getColumn()) continue;
            if (c > this.getLastColumn()) break;
            SCellStyle cellStyle = ((AbstractCellAdv)srcCell).getCellStyle(true);
            if (cellStyle == null) continue;
            for (int r = this.getRow(); r <= this.getLastRow(); ++r) {
                this.sheet.getCell(r, c).setCellStyle(cellStyle);
            }
        }
    }

    private void copyCellStyleFromColumn(int srcColumnIdx) {
        Iterator<SRow> srcRows = this.sheet.getRowIterator();
        while (srcRows.hasNext()) {
            SCellStyle cellStyle;
            int r = srcRows.next().getIndex();
            if (r < this.getRow()) continue;
            if (r > this.getLastRow()) break;
            SCell srcCell = this.sheet.getCell(r, srcColumnIdx);
            if (srcCell.isNull() || (cellStyle = ((AbstractCellAdv)srcCell).getCellStyle(true)) == null) continue;
            for (int c = this.getColumn(); c <= this.getLastColumn(); ++c) {
                this.sheet.getCell(r, c).setCellStyle(cellStyle);
            }
        }
    }

    private void shrinkChartWidth() {
        for (SChart chart : this.sheet.getCharts()) {
            int c;
            ViewAnchor anchor = chart.getAnchor();
            int col = anchor.getColumnIndex();
            ViewAnchor rightBottomAnchor = anchor.getRightBottomAnchor(this.sheet);
            int lastCol = rightBottomAnchor.getColumnIndex();
            if ((col > this.getColumn() || this.getColumn() > lastCol) && (col > this.getLastColumn() || this.getLastColumn() > lastCol)) continue;
            int shrunkWidth = 0;
            int n = c = this.getColumn() > col ? this.getColumn() : col;
            while (c <= this.getLastColumn() && c <= lastCol) {
                shrunkWidth = c != lastCol ? (shrunkWidth += this.sheet.getColumn(c).getWidth()) : (shrunkWidth += rightBottomAnchor.getXOffset());
                ++c;
            }
            if (anchor.getWidth() <= shrunkWidth) continue;
            anchor.setWidth(anchor.getWidth() - shrunkWidth);
            new NotifyChangeHelper().notifySheetChartUpdate(this.sheet, chart.getId());
        }
    }

    private void shrinkChartHeight(int row1, int row2) {
        for (SChart chart : this.sheet.getCharts()) {
            int r;
            ViewAnchor anchor = chart.getAnchor();
            int row = anchor.getRowIndex();
            ViewAnchor rightBottomAnchor = anchor.getRightBottomAnchor(this.sheet);
            int lastRow = rightBottomAnchor.getRowIndex();
            if ((row > row1 || row1 > lastRow) && (row > row2 || row2 > lastRow)) continue;
            int shrunkHeight = 0;
            int n = r = row1 > row ? row1 : row;
            while (r <= row2 && r <= lastRow) {
                shrunkHeight = r != lastRow ? (shrunkHeight += this.sheet.getRow(r).getHeight()) : (shrunkHeight += rightBottomAnchor.getYOffset());
                ++r;
            }
            if (anchor.getHeight() <= shrunkHeight) continue;
            anchor.setHeight(anchor.getHeight() - shrunkHeight);
            new NotifyChangeHelper().notifySheetChartUpdate(this.sheet, chart.getId());
        }
    }

    private void extendChartWidth() {
        int size = 0;
        for (int r = this.getColumn(); r <= this.getLastColumn(); ++r) {
            size += this.sheet.getColumn(r).getWidth();
        }
        for (SChart chart : this.sheet.getCharts()) {
            ViewAnchor anchor = chart.getAnchor();
            int col = anchor.getColumnIndex();
            int lastCol = anchor.getRightBottomAnchor(this.sheet).getColumnIndex();
            if (col > this.getColumn() || this.getColumn() > lastCol) continue;
            anchor.setWidth(anchor.getWidth() + size);
            new NotifyChangeHelper().notifySheetChartUpdate(this.sheet, chart.getId());
        }
    }

    private void extendChartHeight() {
        int size = 0;
        for (int r = this.getRow(); r <= this.getLastRow(); ++r) {
            size += this.sheet.getRow(r).getHeight();
        }
        for (SChart chart : this.sheet.getCharts()) {
            ViewAnchor anchor = chart.getAnchor();
            int row = anchor.getRowIndex();
            int lastRow = anchor.getRightBottomAnchor(this.sheet).getRowIndex();
            if (row > this.getRow() || this.getRow() > lastRow) continue;
            anchor.setHeight(anchor.getHeight() + size);
            new NotifyChangeHelper().notifySheetChartUpdate(this.sheet, chart.getId());
        }
    }

    private boolean checkInCornerFreezePanel() {
        SSheetViewInfo viewInfo = this.sheet.getViewInfo();
        int fzr = viewInfo.getNumOfRowFreeze();
        int fzc = viewInfo.getNumOfColumnFreeze();
        return fzr > 0 && fzc > 0 && this.getRow() < fzr && this.getColumn() < fzc;
    }

    private boolean checkCrossTopFreezePanel() {
        SSheetViewInfo viewInfo = this.sheet.getViewInfo();
        int fzr = viewInfo.getNumOfRowFreeze();
        return fzr > 0 && this.getRow() < fzr && this.getLastRow() >= fzr;
    }

    private boolean checkCrossLeftFreezePanel() {
        SSheetViewInfo viewInfo = this.sheet.getViewInfo();
        int fzc = viewInfo.getNumOfColumnFreeze();
        return fzc > 0 && this.getColumn() < fzc && this.getLastColumn() >= fzc;
    }
}

