/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.range.impl;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.zkoss.poi.ss.usermodel.DateUtil;
import org.zkoss.zss.model.SCell;
import org.zkoss.zss.model.impl.RuleInfo;
import org.zkoss.zss.model.sys.formula.EvaluationResult;
import org.zkoss.zss.range.impl.Matchable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionMatch
implements Matchable<SCell>,
Serializable {
    private static final long serialVersionUID = -1931445210569317355L;
    private final RuleInfo ruleInfo;

    public ExpressionMatch(RuleInfo ruleInfo) {
        this.ruleInfo = ruleInfo;
    }

    @Override
    public boolean match(SCell cell) {
        EvaluationResult result = this.ruleInfo.evalFormula(cell);
        if (result.getType() == EvaluationResult.ResultType.SUCCESS) {
            Object val = result.getValue();
            return this.matchVal(val);
        }
        return false;
    }

    private boolean matchVal(Object val) {
        if (val instanceof Double) {
            return (Double)val != 0.0;
        }
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        if (val instanceof Date) {
            return DateUtil.getExcelDate((Date)((Date)val)) != 0.0;
        }
        if (val instanceof List && !((List)val).isEmpty()) {
            return this.matchVal(((List)val).get(0));
        }
        return false;
    }
}

