/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.range.impl;

import java.util.List;
import org.zkoss.zss.model.CellRegion;
import org.zkoss.zss.model.InvalidModelOpException;
import org.zkoss.zss.model.SCell;
import org.zkoss.zss.model.SRow;
import org.zkoss.zss.model.SSheet;
import org.zkoss.zss.model.STable;
import org.zkoss.zss.range.SRange;
import org.zkoss.zss.range.impl.RangeHelperBase;

public class DataRegionHelper
extends RangeHelperBase {
    public DataRegionHelper(SRange range) {
        super(range);
    }

    public CellRegion findCustomSortRegion() {
        CellRegion currentArea = new CellRegion(this.getRow(), this.getColumn(), this.getLastRow(), this.getLastColumn());
        if (DataRegionHelper.isOneCell(this.sheet, currentArea)) {
            FilterRegionHelper frHelper = new FilterRegionHelper();
            CellRegion cra = frHelper.findCurrentRegion(this.sheet, this.getRow(), this.getColumn());
            if (cra == null) {
                throw new InvalidModelOpException("This cannot be applied to the selected range");
            }
            return cra;
        }
        return currentArea;
    }

    public CellRegion findAutoFilterDataRegion() {
        CellRegion currentArea = new CellRegion(this.getRow(), this.getColumn(), this.getLastRow(), this.getLastColumn());
        FilterRegionHelper frHelper = new FilterRegionHelper();
        if (this.isWholeRow()) {
            CellRegion cra = frHelper.getRowCurrentRegion(this.sheet, this.getRow(), this.getLastRow());
            return cra;
        }
        if (DataRegionHelper.isOneCell(this.sheet, currentArea)) {
            CellRegion cra = frHelper.findCurrentRegion(this.sheet, this.getRow(), this.getColumn());
            return cra;
        }
        CellRegion largeRange = this.getLargestRange(this.sheet);
        if (largeRange == null) {
            return null;
        }
        int left = largeRange.getColumn();
        int top = largeRange.getRow();
        int right = largeRange.getLastColumn();
        int bottom = largeRange.getLastRow();
        if (left < this.getColumn()) {
            left = this.getColumn();
        }
        if (right > this.getLastColumn()) {
            right = this.getLastColumn();
        }
        if (top < this.getRow()) {
            top = this.getRow();
        }
        if (bottom > this.getLastRow()) {
            bottom = this.getLastRow();
        }
        if (top > bottom || left > right) {
            return null;
        }
        return new CellRegion(top, left, bottom, right);
    }

    public static boolean isOneCell(SSheet sheet, CellRegion rng) {
        if (rng.isSingle()) {
            return true;
        }
        int l = rng.getColumn();
        int t = rng.getRow();
        int r = rng.getLastColumn();
        int b = rng.getLastRow();
        int s = sheet.getNumOfMergedRegion();
        for (int i = 0; i < s; ++i) {
            CellRegion ref = sheet.getMergedRegion(i);
            int top = ref.getRow();
            int bottom = ref.getLastRow();
            int left = ref.getColumn();
            int right = ref.getLastColumn();
            if (l != left || t != top || r != right || b != bottom) continue;
            return true;
        }
        return false;
    }

    static int[] getNullRowMinMax(SSheet sheet, int row, int minc, int maxc) {
        int[] nArray;
        CellRegion region = new CellRegion(row, minc, row, maxc);
        List<CellRegion> overlaps = sheet.getOverlapsMergedRegions(region, true);
        int maxr = -1;
        int minr = row;
        for (CellRegion rng : overlaps) {
            int l;
            int t = rng.getRow();
            SCell cell = sheet.getCell(t, l = rng.getColumn());
            if (DataRegionHelper.isBlank(cell)) continue;
            int b = rng.getLastRow();
            int r = rng.getLastColumn();
            if (minc > l) {
                minc = l;
            }
            if (minr > t) {
                minr = t;
            }
            if (maxc < r) {
                maxc = r;
            }
            if (maxr >= b) continue;
            maxr = b;
        }
        if (maxr < 0) {
            nArray = null;
        } else {
            int[] nArray2 = new int[4];
            nArray2[0] = minc;
            nArray2[1] = minr;
            nArray2[2] = maxc;
            nArray = nArray2;
            nArray2[3] = maxr;
        }
        return nArray;
    }

    private static boolean isEmptyRow(SSheet sheet, SRow rowobj) {
        return rowobj.isNull() || sheet.getStartCellIndex(rowobj.getIndex()) < 0;
    }

    private CellRegion getLargestRange(SSheet sheet) {
        int t = Math.max(0, sheet.getStartRowIndex());
        int b = sheet.getEndRowIndex();
        if (b < 0) {
            return null;
        }
        int minr = -1;
        block0: for (int r = t; r <= b && minr < 0; ++r) {
            int ll;
            SRow rowobj = sheet.getRow(r);
            if (rowobj.isNull() || (ll = sheet.getStartCellIndex(r)) < 0) continue;
            int rr = sheet.getEndCellIndex(r);
            for (int c = ll; c <= rr; ++c) {
                SCell cell = sheet.getCell(r, c);
                if (DataRegionHelper.isBlank(cell)) continue;
                minr = r;
                continue block0;
            }
        }
        int maxr = -1;
        int sl = sheet.getStartColumnIndex();
        int sr = sheet.getEndColumnIndex();
        block2: for (int r = b; r >= minr && maxr < 0; --r) {
            SRow rowobj = sheet.getRow(r);
            if (!rowobj.isNull()) {
                int ll = sheet.getStartCellIndex(r);
                if (ll < 0) continue;
                int rr = sheet.getEndCellIndex(r);
                for (int c = ll; c <= rr; ++c) {
                    SCell cell = sheet.getCell(r, c);
                    if (DataRegionHelper.isBlank(cell)) continue;
                    maxr = r;
                    continue block2;
                }
                continue;
            }
            int[] ltrb = DataRegionHelper.getNullRowMinMax(sheet, r, sl, sr);
            if (ltrb == null) continue;
            maxr = ltrb[3];
        }
        int minc = Integer.MAX_VALUE;
        block4: for (int r = minr; r <= maxr; ++r) {
            int ll;
            SRow rowobj = sheet.getRow(r);
            if (rowobj.isNull() || (ll = sheet.getStartCellIndex(r)) < 0) continue;
            int rr = sheet.getEndCellIndex(r);
            for (int c = ll; c < minc && c <= rr; ++c) {
                SCell cell = sheet.getCell(r, c);
                if (DataRegionHelper.isBlank(cell)) continue;
                minc = c;
                continue block4;
            }
        }
        int maxc = -1;
        block6: for (int r = minr; r <= maxr; ++r) {
            int rr;
            int ll;
            SRow rowobj = sheet.getRow(r);
            if (rowobj.isNull() || (ll = sheet.getStartCellIndex(r)) < 0) continue;
            for (int c = rr = sheet.getEndCellIndex(r); c > maxc && c >= ll; --c) {
                SCell cell = sheet.getCell(r, c);
                if (DataRegionHelper.isBlank(cell)) continue;
                CellRegion merged = sheet.getMergedRegion(r, c);
                maxc = merged == null ? c : merged.getLastColumn();
                continue block6;
            }
        }
        if (minr < 0 || maxc < 0) {
            return null;
        }
        return new CellRegion(minr, minc, maxr, maxc);
    }

    public static class FilterRegionHelper {
        int llm;
        int tlm;
        int rlm;
        int blm;

        CellRegion findCurrentRegion(SSheet sheet, int row, int col) {
            int b;
            int t;
            int r;
            int l;
            CellRegion rgn;
            this.llm = 0;
            this.rlm = Integer.MAX_VALUE;
            this.tlm = 0;
            this.blm = Integer.MAX_VALUE;
            for (STable tb : sheet.getTables()) {
                rgn = tb.getAllRegion().getRegion();
                l = rgn.getColumn();
                r = rgn.getLastColumn();
                t = rgn.getRow();
                b = rgn.getLastRow();
                if (l > col || col > r) continue;
                if (row < t && this.blm >= t) {
                    this.blm = t - 1;
                }
                if (row <= b || this.tlm > b) continue;
                this.tlm = b + 1;
            }
            for (STable tb : sheet.getTables()) {
                rgn = tb.getAllRegion().getRegion();
                l = rgn.getColumn();
                r = rgn.getLastColumn();
                t = rgn.getRow();
                b = rgn.getLastRow();
                if (t > this.blm || b < this.tlm) continue;
                if (col < l && this.rlm >= l) {
                    this.rlm = l - 1;
                }
                if (col <= r || this.llm > r) continue;
                this.llm = r + 1;
            }
            int[] ltrb = this.getNonBlankCell(sheet, row, col);
            if (ltrb == null && row > 0) {
                ltrb = this.getNonBlankCell(sheet, row - 1, col);
            }
            if (ltrb == null) {
                ltrb = this.getNonBlankCell(sheet, row + 1, col);
            }
            return ltrb == null ? null : this.findCurrentRegion0(sheet, row, ltrb);
        }

        private int[] getNonBlankCell(SSheet sheet, int row, int col) {
            if (this.tlm > row || this.blm < row || this.llm > col || this.rlm < col) {
                return null;
            }
            SRow rowObj = sheet.getRow(row);
            return !DataRegionHelper.isEmptyRow(sheet, rowObj) ? this.getNonBlankCell0(sheet, row, col) : null;
        }

        private int[] getNonBlankCell0(SSheet sheet, int row, int col) {
            int[] ltrb = this.getCellMinMax(sheet, row, col);
            if (ltrb == null && col > 0) {
                ltrb = this.getCellMinMax(sheet, row, col - 1);
            }
            if (ltrb == null) {
                ltrb = this.getCellMinMax(sheet, row, col + 1);
            }
            return ltrb;
        }

        private CellRegion findCurrentRegion0(SSheet sheet, int row, int[] ltrb) {
            int minNonBlankColumn = ltrb[0];
            int maxNonBlankColumn = ltrb[2];
            int minNonBlankRow = ltrb[1];
            int maxNonBlankRow = ltrb[3];
            SRow rowobj = sheet.getRow(row);
            int[] leftTopRightBottom = this.getRowMinMax(sheet, rowobj, minNonBlankColumn, maxNonBlankColumn);
            if (leftTopRightBottom != null) {
                minNonBlankColumn = leftTopRightBottom[0];
                minNonBlankRow = leftTopRightBottom[1];
                maxNonBlankColumn = leftTopRightBottom[2];
                maxNonBlankRow = leftTopRightBottom[3];
            }
            int rowUp = row > 0 ? row - 1 : row;
            int rowDown = row + 1;
            boolean stopFindingUp = rowUp == row;
            boolean stopFindingDown = false;
            do {
                int[] downRowLeftTopRightBottom;
                if (!stopFindingUp) {
                    int[] upperRowLeftTopRightBottom;
                    SRow rowu = sheet.getRow(rowUp);
                    int[] nArray = upperRowLeftTopRightBottom = rowu.isNull() || sheet.getStartCellIndex(rowUp) < 0 ? DataRegionHelper.getNullRowMinMax(sheet, rowUp, minNonBlankColumn, maxNonBlankColumn) : this.getRowMinMax(sheet, rowu, minNonBlankColumn, maxNonBlankColumn);
                    if (upperRowLeftTopRightBottom != null) {
                        if (minNonBlankColumn != upperRowLeftTopRightBottom[0] || maxNonBlankColumn != upperRowLeftTopRightBottom[2]) {
                            stopFindingDown = false;
                            minNonBlankColumn = upperRowLeftTopRightBottom[0];
                            maxNonBlankColumn = upperRowLeftTopRightBottom[2];
                        }
                        if (minNonBlankRow > upperRowLeftTopRightBottom[1]) {
                            minNonBlankRow = upperRowLeftTopRightBottom[1];
                        }
                        if (maxNonBlankRow < upperRowLeftTopRightBottom[3]) {
                            maxNonBlankRow = upperRowLeftTopRightBottom[3];
                        }
                        if (rowUp > 0) {
                            --rowUp;
                        } else {
                            stopFindingUp = true;
                        }
                    } else {
                        stopFindingUp = true;
                    }
                }
                if (stopFindingDown) continue;
                SRow rowd = sheet.getRow(rowDown);
                int[] nArray = downRowLeftTopRightBottom = rowd.isNull() || sheet.getStartCellIndex(rowDown) < 0 ? DataRegionHelper.getNullRowMinMax(sheet, rowDown, minNonBlankColumn, maxNonBlankColumn) : this.getRowMinMax(sheet, rowd, minNonBlankColumn, maxNonBlankColumn);
                if (downRowLeftTopRightBottom != null) {
                    if (minNonBlankColumn != downRowLeftTopRightBottom[0] || maxNonBlankColumn != downRowLeftTopRightBottom[2]) {
                        stopFindingUp = false;
                        minNonBlankColumn = downRowLeftTopRightBottom[0];
                        maxNonBlankColumn = downRowLeftTopRightBottom[2];
                    }
                    if (maxNonBlankRow < downRowLeftTopRightBottom[3]) {
                        maxNonBlankRow = downRowLeftTopRightBottom[3];
                    }
                    ++rowDown;
                    continue;
                }
                stopFindingDown = true;
            } while (!stopFindingUp || !stopFindingDown);
            return new CellRegion(minNonBlankRow, minNonBlankColumn, maxNonBlankRow, maxNonBlankColumn);
        }

        private int[] getRowMinMax(SSheet sheet, SRow rowobj, int minc, int maxc) {
            int[] nArray;
            int b;
            int[] rng;
            int c;
            int t;
            int row;
            if (DataRegionHelper.isEmptyRow(sheet, rowobj)) {
                return null;
            }
            int minr = row = rowobj.getIndex();
            int maxr = row;
            boolean allblank = true;
            int[] minrng = this.getCellMinMax(sheet, row, minc);
            if (minrng != null) {
                int l = minrng[0];
                t = minrng[1];
                int b2 = minrng[3];
                if (minr > t) {
                    minr = t;
                }
                if (maxr < b2) {
                    maxr = b2;
                }
                minc = l;
                allblank = false;
            }
            if (maxc > (minrng != null ? minrng[2] : minc)) {
                int[] maxrng = this.getCellMinMax(sheet, row, maxc);
                if (maxrng != null) {
                    t = maxrng[1];
                    int r = maxrng[2];
                    int b3 = maxrng[3];
                    if (minr > t) {
                        minr = t;
                    }
                    if (maxr < b3) {
                        maxr = b3;
                    }
                    maxc = r;
                    allblank = false;
                }
            } else if (minrng != null) {
                maxc = minrng[2];
            }
            int lc = sheet.getStartCellIndex(row);
            int rc = sheet.getEndCellIndex(row);
            int left = minc > 0 ? minc - 1 : 0;
            int right = maxc + 1;
            for (c = left; c >= lc && (rng = this.getCellMinMax(sheet, row, c)) != null; --c) {
                int l = rng[0];
                int t2 = rng[1];
                b = rng[3];
                minc = c = l;
                if (minr > t2) {
                    minr = t2;
                }
                if (maxr < b) {
                    maxr = b;
                }
                allblank = false;
            }
            for (c = right; c <= rc && (rng = this.getCellMinMax(sheet, row, c)) != null; ++c) {
                int t3 = rng[1];
                int r = rng[2];
                b = rng[3];
                maxc = c = r;
                if (minr > t3) {
                    minr = t3;
                }
                if (maxr < b) {
                    maxr = b;
                }
                allblank = false;
            }
            if (allblank) {
                boolean bl = allblank = !(minc <= lc && lc <= maxc || minc <= rc && rc <= maxc);
            }
            if (allblank) {
                nArray = null;
            } else {
                int[] nArray2 = new int[4];
                nArray2[0] = minc;
                nArray2[1] = minr;
                nArray2[2] = maxc;
                nArray = nArray2;
                nArray2[3] = maxr;
            }
            return nArray;
        }

        private int[] getCellMinMax(SSheet sheet, int row, int col) {
            int[] nArray;
            if (this.tlm > row || this.blm < row || this.llm > col || this.rlm < col) {
                return null;
            }
            CellRegion rng = sheet.getMergedRegion(row, col);
            if (rng == null) {
                rng = new CellRegion(row, col, row, col);
            }
            int t = rng.getRow();
            int l = rng.getColumn();
            int b = rng.getLastRow();
            int r = rng.getLastColumn();
            SCell cell = sheet.getCell(t, l);
            if (RangeHelperBase.isBlank(cell)) {
                nArray = null;
            } else {
                int[] nArray2 = new int[4];
                nArray2[0] = l;
                nArray2[1] = t;
                nArray2[2] = r;
                nArray = nArray2;
                nArray2[3] = b;
            }
            return nArray;
        }

        private CellRegion getRowCurrentRegion(SSheet sheet, int topRow, int btmRow) {
            int minc = 0;
            int maxc = 0;
            int minr = topRow;
            int maxr = btmRow;
            int lastCellIdx = sheet.getEndCellIndex(topRow);
            for (int c = minc; c <= lastCellIdx; ++c) {
                int[] cellMinMax;
                boolean foundMax = false;
                for (int r = minr + 1; r <= sheet.getEndRowIndex() && ((cellMinMax = this.getCellMinMax(sheet, r, c)) != null || r < btmRow); ++r) {
                    if (cellMinMax == null) continue;
                    foundMax = true;
                    maxr = Math.max(maxr, cellMinMax[3]);
                }
                if (!foundMax) continue;
                maxc = c;
            }
            return new CellRegion(minr, minc, maxr, maxc);
        }
    }
}

