/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.range.impl;

import java.io.Serializable;
import org.zkoss.poi.ss.usermodel.ZssContext;
import org.zkoss.zss.model.SCell;
import org.zkoss.zss.model.SConditionalFormattingRule;
import org.zkoss.zss.model.impl.RuleInfo;
import org.zkoss.zss.model.sys.EngineFactory;
import org.zkoss.zss.model.sys.format.FormatContext;
import org.zkoss.zss.model.sys.format.FormatEngine;
import org.zkoss.zss.range.impl.BeginsWith;
import org.zkoss.zss.range.impl.ContainsText;
import org.zkoss.zss.range.impl.EndsWith;
import org.zkoss.zss.range.impl.Equals;
import org.zkoss.zss.range.impl.GreaterThan2;
import org.zkoss.zss.range.impl.GreaterThanOrEqual2;
import org.zkoss.zss.range.impl.LessThan2;
import org.zkoss.zss.range.impl.LessThanOrEqual2;
import org.zkoss.zss.range.impl.Matchable;
import org.zkoss.zss.range.impl.NotContainsText;
import org.zkoss.zss.range.impl.NotEquals;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CellMatch2
implements Matchable<SCell>,
Serializable {
    private static final long serialVersionUID = 4775550316177451879L;
    private MatchOne f1;
    private MatchOne f2;
    private boolean isAnd;

    public CellMatch2(SConditionalFormattingRule.RuleOperator op1, String text1) {
        this.f1 = new MatchOne(op1, text1);
        this.f2 = null;
        this.isAnd = false;
    }

    public CellMatch2(SConditionalFormattingRule.RuleOperator op1, RuleInfo rule1, SConditionalFormattingRule.RuleOperator op2, RuleInfo rule2, boolean isAnd) {
        this.f1 = new MatchOne(op1, rule1);
        this.f2 = op2 == null ? null : new MatchOne(op2, rule2);
        this.isAnd = isAnd;
    }

    @Override
    public boolean match(SCell cell) {
        boolean matchf1 = this.f1.match(cell);
        if (this.isAnd && !matchf1) {
            return false;
        }
        if (!this.isAnd && matchf1) {
            return true;
        }
        if (this.f2 != null) {
            return this.f2.match(cell);
        }
        return matchf1;
    }

    static class MatchOne
    implements Serializable {
        private static final long serialVersionUID = -7474902362367302742L;
        private Matchable<SCell> _matchable;
        private SConditionalFormattingRule.RuleOperator op;
        private FormatEngine _formatEngine;

        MatchOne(SConditionalFormattingRule.RuleOperator op, String text) {
            this.op = op;
            this._prepareMatch(null, text);
        }

        MatchOne(SConditionalFormattingRule.RuleOperator op, RuleInfo ruleInfo) {
            this.op = op;
            this._prepareMatch(ruleInfo, null);
        }

        public String _getFormattedText(SCell cell) {
            return this.getFormatEngine().format(cell, new FormatContext(ZssContext.getCurrent().getLocale())).getText();
        }

        protected FormatEngine getFormatEngine() {
            if (this._formatEngine == null) {
                this._formatEngine = EngineFactory.getInstance().createFormatEngine();
            }
            return this._formatEngine;
        }

        public boolean match(SCell cell) {
            if (this._matchable != null) {
                return this._matchable.match(cell);
            }
            return false;
        }

        private void _prepareMatch(RuleInfo ruleInfo, String value) {
            switch (this.op) {
                case BEGINS_WITH: {
                    this._matchable = ruleInfo == null ? new BeginsWith(value.toString()) : new BeginsWith(ruleInfo);
                    break;
                }
                case ENDS_WITH: {
                    this._matchable = ruleInfo == null ? new EndsWith(value.toString()) : new EndsWith(ruleInfo);
                    break;
                }
                case NOT_CONTAINS: {
                    this._matchable = ruleInfo == null ? new NotContainsText(value.toString()) : new NotContainsText(ruleInfo);
                    break;
                }
                case CONTAINS_TEXT: {
                    this._matchable = ruleInfo == null ? new ContainsText(value.toString()) : new ContainsText(ruleInfo);
                    break;
                }
                case NOT_EQUAL: {
                    this._matchable = ruleInfo == null ? new NotEquals(value.toString()) : new NotEquals(ruleInfo);
                    break;
                }
                case EQUAL: {
                    this._matchable = ruleInfo == null ? new Equals(value.toString()) : new Equals(ruleInfo);
                    break;
                }
                case LESS_THAN_OR_EQUAL: {
                    this._matchable = ruleInfo == null ? new LessThanOrEqual2(value.toString()) : new LessThanOrEqual2(ruleInfo);
                    break;
                }
                case GREATER_THAN: {
                    this._matchable = ruleInfo == null ? new GreaterThan2(value.toString()) : new GreaterThan2(ruleInfo);
                    break;
                }
                case GREATER_THAN_OR_EQUAL: {
                    this._matchable = ruleInfo == null ? new GreaterThanOrEqual2(value.toString()) : new GreaterThanOrEqual2(ruleInfo);
                    break;
                }
                case LESS_THAN: {
                    this._matchable = ruleInfo == null ? new LessThan2(value.toString()) : new LessThan2(ruleInfo);
                }
            }
        }
    }
}

