/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.range.impl;

import java.io.Serializable;
import java.util.Date;
import org.zkoss.poi.ss.usermodel.DateUtil;
import org.zkoss.zss.model.SCell;
import org.zkoss.zss.model.SRichText;
import org.zkoss.zss.model.impl.RuleInfo;
import org.zkoss.zss.model.sys.formula.EvaluationResult;
import org.zkoss.zss.range.impl.CellValueHelper;
import org.zkoss.zss.range.impl.Matchable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseMatch2
implements Matchable<SCell>,
Serializable {
    private static final long serialVersionUID = -2673045590406268437L;
    private final Object base;
    private final RuleInfo ruleInfo;

    public BaseMatch2(Object b) {
        this.base = b;
        this.ruleInfo = null;
    }

    public BaseMatch2(RuleInfo ruleInfo) {
        this.base = null;
        this.ruleInfo = ruleInfo;
    }

    @Override
    public boolean match(SCell cell) {
        if (this.base != null) {
            if (this.base instanceof String) {
                return this.matchString0(cell, (String)this.base);
            }
            if (this.base instanceof Number) {
                return this.matchDouble0(cell, (Double)this.base);
            }
        } else {
            EvaluationResult result = this.ruleInfo.evalFormula(cell);
            if (result.getType() == EvaluationResult.ResultType.SUCCESS) {
                Object val = result.getValue();
                if (val instanceof Double) {
                    return this.matchDouble0(cell, (Double)val);
                }
                if (val instanceof Date) {
                    return this.matchDouble0(cell, DateUtil.getExcelDate((Date)((Date)val)));
                }
                if (val instanceof String) {
                    return this.matchString0(cell, (String)val);
                }
            }
        }
        return false;
    }

    private boolean matchString0(SCell cell, String b) {
        Object value = CellValueHelper.inst.getValue(cell);
        if (value == null) {
            value = "";
        }
        if (value instanceof String) {
            String formattedText = CellValueHelper.inst.getFormattedText(cell);
            return this.matchString(formattedText, b);
        }
        if (value instanceof SRichText) {
            String text = ((SRichText)value).getText();
            return this.matchString(text, b);
        }
        return false;
    }

    private boolean matchDouble0(SCell cell, Double b) {
        Object value = CellValueHelper.inst.getValue(cell);
        if (value instanceof Double) {
            return this.matchDouble((Double)value, b);
        }
        return false;
    }

    protected abstract boolean matchString(String var1, String var2);

    protected abstract boolean matchDouble(Double var1, Double var2);
}

