/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.model.sys;

import org.zkoss.lang.Library;
import org.zkoss.util.logging.Log;
import org.zkoss.zss.model.impl.sys.CalendarUtilImpl;
import org.zkoss.zss.model.impl.sys.DependencyTableImpl;
import org.zkoss.zss.model.impl.sys.FormatEngineImpl;
import org.zkoss.zss.model.impl.sys.InputEngineImpl;
import org.zkoss.zss.model.impl.sys.formula.FormulaEngineImpl;
import org.zkoss.zss.model.sys.CalendarUtil;
import org.zkoss.zss.model.sys.dependency.DependencyTable;
import org.zkoss.zss.model.sys.format.FormatEngine;
import org.zkoss.zss.model.sys.formula.FormulaEngine;
import org.zkoss.zss.model.sys.input.InputEngine;

public class EngineFactory {
    private static final Log _logger = Log.lookup((String)EngineFactory.class.getName());
    private static EngineFactory _instance;
    private static CalendarUtil _calendarUtil;
    static InputEngine _inputEngine;
    static Class<?> inputEngineClazz;
    static Class<?> formulaEngineClazz;
    static Class<?> dependencyTableClazz;
    static FormatEngine _formatEngine;
    static Class<?> formatEngineClazz;

    private EngineFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EngineFactory getInstance() {
        if (_instance != null) return _instance;
        Class<EngineFactory> clazz = EngineFactory.class;
        synchronized (EngineFactory.class) {
            if (_instance != null) return _instance;
            _instance = new EngineFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _instance;
        }
    }

    public InputEngine createInputEngine() {
        if (_inputEngine == null) {
            try {
                if (inputEngineClazz != null) {
                    _inputEngine = (InputEngine)inputEngineClazz.newInstance();
                    return _inputEngine;
                }
            }
            catch (Exception e) {
                _logger.error(e.getMessage(), (Throwable)e);
                inputEngineClazz = null;
            }
            _inputEngine = new InputEngineImpl();
        }
        return _inputEngine;
    }

    public FormulaEngine createFormulaEngine() {
        try {
            if (formulaEngineClazz != null) {
                return (FormulaEngine)formulaEngineClazz.newInstance();
            }
        }
        catch (Exception e) {
            _logger.error(e.getMessage(), (Throwable)e);
            formulaEngineClazz = null;
        }
        return new FormulaEngineImpl();
    }

    public DependencyTable createDependencyTable() {
        try {
            if (dependencyTableClazz != null) {
                return (DependencyTable)dependencyTableClazz.newInstance();
            }
        }
        catch (Exception e) {
            _logger.error(e.getMessage(), (Throwable)e);
            dependencyTableClazz = null;
        }
        return new DependencyTableImpl();
    }

    public FormatEngine createFormatEngine() {
        if (_formatEngine == null) {
            try {
                if (formatEngineClazz != null) {
                    _formatEngine = (FormatEngine)formatEngineClazz.newInstance();
                    return _formatEngine;
                }
            }
            catch (Exception e) {
                _logger.error(e.getMessage(), (Throwable)e);
                formatEngineClazz = null;
            }
            _formatEngine = new FormatEngineImpl();
        }
        return _formatEngine;
    }

    public CalendarUtil getCalendarUtil() {
        return _calendarUtil;
    }

    static {
        _calendarUtil = new CalendarUtilImpl();
        String clz = Library.getProperty((String)"org.zkoss.zss.model.InputEngine.class");
        if (clz != null) {
            try {
                inputEngineClazz = Class.forName(clz);
            }
            catch (Exception e) {
                _logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if ((clz = Library.getProperty((String)"org.zkoss.zss.model.FormulaEngine.class")) != null) {
            try {
                formulaEngineClazz = Class.forName(clz);
            }
            catch (Exception e) {
                _logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if ((clz = Library.getProperty((String)"org.zkoss.zss.model.DependencyTable.class")) != null) {
            try {
                dependencyTableClazz = Class.forName(clz);
            }
            catch (Exception e) {
                _logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if ((clz = Library.getProperty((String)"org.zkoss.zss.model.FormatEngine.class")) != null) {
            try {
                formatEngineClazz = Class.forName(clz);
            }
            catch (Exception e) {
                _logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

