/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.model.impl.sys.formula;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.zkoss.poi.ss.SpreadsheetVersion;
import org.zkoss.poi.ss.formula.EvaluationName;
import org.zkoss.poi.ss.formula.EvaluationWorkbook;
import org.zkoss.poi.ss.formula.FormulaParser;
import org.zkoss.poi.ss.formula.FormulaParsingWorkbook;
import org.zkoss.poi.ss.formula.FormulaRenderingWorkbook;
import org.zkoss.poi.ss.formula.ptg.NamePtg;
import org.zkoss.poi.ss.formula.ptg.NameXPtg;
import org.zkoss.poi.ss.formula.ptg.Ptg;
import org.zkoss.poi.ss.formula.ptg.TablePtg;
import org.zkoss.util.logging.Log;
import org.zkoss.zss.model.SBook;
import org.zkoss.zss.model.SSheet;
import org.zkoss.zss.model.STable;
import org.zkoss.zss.model.STableColumn;
import org.zkoss.zss.model.SheetRegion;
import org.zkoss.zss.model.impl.AbstractBookAdv;
import org.zkoss.zss.model.impl.AbstractSheetAdv;

public class ParsingBook
implements FormulaParsingWorkbook,
FormulaRenderingWorkbook,
Serializable {
    private static final long serialVersionUID = 6254892443337634145L;
    private static final Log logger = Log.lookup((String)ParsingBook.class.getName());
    private SBook book;
    private SheetIndexes _indexes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParsingBook(SBook book) {
        this.book = book;
        SBook sBook = book;
        synchronized (sBook) {
            this._indexes = (SheetIndexes)book.getAttribute("$ZSS_SHEET_INDEXES$");
            if (this._indexes == null) {
                this._indexes = new SheetIndexes();
                book.setAttribute("$ZSS_SHEET_INDEXES$", this._indexes);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameName(int sheetIndex, String oldName, String newName) {
        String sidx = String.valueOf(sheetIndex);
        String oldkey = this.toKey(sidx, oldName);
        SheetIndexes sheetIndexes = this._indexes;
        synchronized (sheetIndexes) {
            Integer index = (Integer)this._indexes.name2index.remove(oldkey);
            if (index != null) {
                String key = this.toKey(sidx, newName);
                this._indexes.name2index.put(key, index);
                this._indexes.index2name.set(index, new Object[]{sheetIndex, newName});
            }
        }
    }

    public EvaluationName getName(String name, int sheetIndex) {
        return this.getOrCreateName(name, sheetIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NameXPtg getNameXPtg(String name) {
        String key = this.toKey("", name);
        SheetIndexes sheetIndexes = this._indexes;
        synchronized (sheetIndexes) {
            Integer index = (Integer)this._indexes.name2index.get(key);
            if (index == null) {
                index = this._indexes.index2name.size();
                this._indexes.index2name.add(new Object[]{-1, name});
                this._indexes.name2index.put(key, index);
            }
            return new NameXPtg(0, index.intValue());
        }
    }

    public int getExternalSheetIndex(String sheetName) {
        return this.getExternalSheetIndex(null, sheetName);
    }

    private String[] splitSheetName(String sheetName) {
        String[] stringArray;
        String lastName;
        int p = sheetName.indexOf(58);
        String name = p < 0 ? sheetName : sheetName.substring(0, p);
        String string = lastName = p < 0 ? sheetName : sheetName.substring(p + 1);
        if (name.equalsIgnoreCase(lastName)) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = name;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = name;
            stringArray = stringArray3;
            stringArray3[1] = lastName;
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getExternalSheetIndex(String workbookName, String sheetName) {
        String name;
        String lastName;
        String[] names = this.splitSheetName(sheetName);
        if (names.length == 1) {
            name = lastName = names[0];
            sheetName = lastName;
        } else {
            name = names[0];
            lastName = names[1];
        }
        String key = this.toKey(workbookName, sheetName);
        SheetIndexes sheetIndexes = this._indexes;
        synchronized (sheetIndexes) {
            Integer index = (Integer)this._indexes.sheetName2index.get(key);
            if (index == null) {
                index = this._indexes.index2sheet.size();
                this._indexes.index2sheet.add(new EvaluationWorkbook.ExternalSheet(workbookName, name, lastName));
                this._indexes.sheetName2index.put(key, index);
            }
            return index;
        }
    }

    public int findExternalSheetIndex(String sheetName) {
        return this.findExternalSheetIndex(null, sheetName);
    }

    private String normalizeSheetName(String sheetName) {
        String[] names = this.splitSheetName(sheetName);
        return names.length == 1 ? names[0] : sheetName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findExternalSheetIndex(String workbookName, String sheetName) {
        sheetName = this.normalizeSheetName(sheetName);
        SheetIndexes sheetIndexes = this._indexes;
        synchronized (sheetIndexes) {
            Integer index = (Integer)this._indexes.sheetName2index.get(this.toKey(workbookName, sheetName));
            return index != null ? index : -1;
        }
    }

    private String toKey(String ... strings) {
        return Arrays.toString(strings);
    }

    public SpreadsheetVersion getSpreadsheetVersion() {
        return SpreadsheetVersion.EXCEL2007;
    }

    public String getBookNameFromExternalLinkIndex(String externalLinkIndex) {
        try {
            int index = Integer.parseInt(externalLinkIndex) - 1;
            List names = (List)this.book.getAttribute("$ZSS_EXTERNAL_BOOK_NAMES$");
            if (names != null) {
                return names.get(index).toString();
            }
        }
        catch (NumberFormatException index) {
        }
        catch (IndexOutOfBoundsException e) {
            logger.warning(e.getMessage(), (Throwable)e);
        }
        return externalLinkIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EvaluationName getOrCreateName(String name, int sheetIndex) {
        String key = this.toKey(String.valueOf(sheetIndex), name);
        SheetIndexes sheetIndexes = this._indexes;
        synchronized (sheetIndexes) {
            Integer index = (Integer)this._indexes.name2index.get(key);
            if (index == null) {
                index = this._indexes.index2name.size();
                this._indexes.index2name.add(new Object[]{sheetIndex, name});
                this._indexes.name2index.put(key, index);
            }
            SimpleName n = new SimpleName(name, index, sheetIndex);
            return n;
        }
    }

    public String getNameText(NamePtg namePtg) {
        return (String)this.getNameInfo(namePtg)[1];
    }

    public String getFullNameText(NamePtg namePtg) {
        Object[] info = this.getNameInfo(namePtg);
        String nameName = (String)info[1];
        int sheetIndex = (Integer)info[0];
        return sheetIndex < 0 ? nameName : this.book.getSheet(sheetIndex).getSheetName() + '!' + nameName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getNameInfo(NamePtg namePtg) {
        SheetIndexes sheetIndexes = this._indexes;
        synchronized (sheetIndexes) {
            return (Object[])this._indexes.index2name.get(namePtg.getIndex());
        }
    }

    public String resolveNameXText(NameXPtg nameXPtg) {
        return (String)this.resolveNameXInfo(nameXPtg)[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] resolveNameXInfo(NameXPtg nameXPtg) {
        SheetIndexes sheetIndexes = this._indexes;
        synchronized (sheetIndexes) {
            return (Object[])this._indexes.index2name.get(nameXPtg.getNameIndex());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EvaluationWorkbook.ExternalSheet getAnyExternalSheet(int externSheetIndex) {
        SheetIndexes sheetIndexes = this._indexes;
        synchronized (sheetIndexes) {
            return (EvaluationWorkbook.ExternalSheet)this._indexes.index2sheet.get(externSheetIndex);
        }
    }

    public EvaluationWorkbook.ExternalSheet getExternalSheet(int externSheetIndex) {
        EvaluationWorkbook.ExternalSheet externalSheet = this.getAnyExternalSheet(externSheetIndex);
        return externalSheet.getWorkbookName() != null ? externalSheet : null;
    }

    public String getSheetNameByExternSheet(int externSheetIndex) {
        String lastName;
        EvaluationWorkbook.ExternalSheet sheet = this.getAnyExternalSheet(externSheetIndex);
        String name = sheet.getSheetName();
        return name.equals(lastName = sheet.getLastSheetName()) ? name : name + ":" + lastName;
    }

    public String getExternalLinkIndexFromBookName(String bookname) {
        return bookname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameSheet(String bookName, String oldName, String newName) {
        if (this.book.getBookName().equals(bookName)) {
            bookName = null;
        }
        SheetIndexes sheetIndexes = this._indexes;
        synchronized (sheetIndexes) {
            Map sheetName2index = this._indexes.sheetName2index;
            List index2sheet = this._indexes.index2sheet;
            ArrayList<EvaluationWorkbook.ExternalSheet> temp = new ArrayList<EvaluationWorkbook.ExternalSheet>(index2sheet.size());
            for (EvaluationWorkbook.ExternalSheet extSheet : index2sheet) {
                if (bookName == null && extSheet.getWorkbookName() == null || bookName != null && bookName.equals(extSheet.getWorkbookName())) {
                    String sheet1 = oldName.equals(extSheet.getSheetName()) ? newName : extSheet.getSheetName();
                    String sheet2 = oldName.equals(extSheet.getLastSheetName()) ? newName : extSheet.getLastSheetName();
                    temp.add(new EvaluationWorkbook.ExternalSheet(extSheet.getWorkbookName(), sheet1, sheet2));
                    continue;
                }
                temp.add(extSheet);
            }
            this._indexes.index2sheet = temp;
            sheetName2index.clear();
            int len = temp.size();
            for (int i = 0; i < len; ++i) {
                EvaluationWorkbook.ExternalSheet esheet = (EvaluationWorkbook.ExternalSheet)temp.get(i);
                String book = esheet.getWorkbookName();
                String sheet1 = esheet.getSheetName();
                String sheet2 = esheet.getLastSheetName();
                String key = this.toKey(book, !sheet1.equalsIgnoreCase(sheet2) ? sheet1 + ":" + sheet2 : sheet1);
                sheetName2index.put(key, i);
            }
        }
    }

    public boolean isAllowedDeferredNamePtg() {
        return true;
    }

    public EvaluationName getName(String name, String sheetName) {
        int sheetIndex = this.book.getSheetIndex(sheetName);
        return this.getName(name, sheetIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reorderSheet(String bookName, int oldIndex, int newIndex) {
        if (this.book.getBookName().equals(bookName)) {
            bookName = null;
        }
        SheetIndexes sheetIndexes = this._indexes;
        synchronized (sheetIndexes) {
            String sheet2;
            String sheet1;
            int offset = oldIndex < newIndex ? -1 : 1;
            int low = oldIndex < newIndex ? oldIndex : newIndex;
            int high = oldIndex < newIndex ? newIndex : oldIndex;
            Map sheetName2index = this._indexes.sheetName2index;
            List index2sheet = this._indexes.index2sheet;
            ArrayList<EvaluationWorkbook.ExternalSheet> temp = new ArrayList<EvaluationWorkbook.ExternalSheet>(index2sheet.size());
            for (EvaluationWorkbook.ExternalSheet extSheet : index2sheet) {
                if (bookName == null && extSheet.getWorkbookName() == null || bookName != null && bookName.equals(extSheet.getWorkbookName())) {
                    int low0 = this.book.getSheetIndex(extSheet.getSheetName());
                    int high0 = this.book.getSheetIndex(extSheet.getLastSheetName());
                    if (high0 < 0) {
                        high0 = low0;
                    }
                    if (high0 < low || low0 > high) {
                        temp.add(extSheet);
                        continue;
                    }
                    sheet1 = extSheet.getSheetName();
                    sheet2 = extSheet.getLastSheetName();
                    if (low0 == oldIndex && low0 != high0 && newIndex >= high0) {
                        sheet1 = this.book.getSheet(low0 - offset).getSheetName();
                    }
                    if (high0 == oldIndex && low0 != high0 && newIndex <= low0) {
                        sheet2 = this.book.getSheet(high0 - offset).getSheetName();
                    }
                    temp.add(new EvaluationWorkbook.ExternalSheet(extSheet.getWorkbookName(), sheet1, sheet2));
                    continue;
                }
                temp.add(extSheet);
            }
            this._indexes.index2sheet = temp;
            sheetName2index.clear();
            int len = temp.size();
            for (int i = 0; i < len; ++i) {
                EvaluationWorkbook.ExternalSheet esheet = (EvaluationWorkbook.ExternalSheet)temp.get(i);
                String book = esheet.getWorkbookName();
                sheet1 = esheet.getSheetName();
                sheet2 = esheet.getLastSheetName();
                String key = this.toKey(book, !sheet1.equalsIgnoreCase(sheet2) ? sheet1 + ":" + sheet2 : sheet1);
                sheetName2index.put(key, i);
            }
        }
    }

    private String getColumnName(STable table, String colName) {
        for (STableColumn tbCol : table.getColumns()) {
            String tbColName = tbCol.getName();
            if (!tbColName.equalsIgnoreCase(colName)) continue;
            return tbColName;
        }
        return null;
    }

    public TablePtg createTablePtg(String tableName, Object[] specifiers, int sheetIndex, int rowIdx, int colIdx) {
        String[] stringArray;
        TablePtg.Item[] itemArray;
        SheetRegion rgn3;
        if (specifiers.length > 3) {
            throw new IllegalArgumentException("at most total 3 table specifiers");
        }
        String tableName0 = tableName;
        String tableName1 = null;
        String sheetName = this.getSheetNameByExternSheet(sheetIndex);
        SSheet sheetx = this.book.getSheetByName(sheetName);
        STable tablex = ((AbstractSheetAdv)sheetx).getTableByRowCol(rowIdx, colIdx);
        if (tableName0 == null) {
            tableName0 = tablex == null ? null : tablex.getName();
        } else {
            String string = tableName1 = tablex == null ? null : tablex.getName();
        }
        if (tableName0 == null) {
            throw new IllegalArgumentException(tableName == null ? "Expect a legal Table" : "Expect a legal Table: '" + tableName + "'");
        }
        TablePtg.Item item1 = null;
        TablePtg.Item item2 = null;
        String column1 = null;
        String column2 = null;
        for (Object obj : specifiers) {
            if (obj instanceof String) {
                if (column1 == null) {
                    column1 = ParsingBook.normalize((String)obj);
                    continue;
                }
                if (column2 == null) {
                    column2 = ParsingBook.normalize((String)obj);
                    continue;
                }
                throw new IllegalArgumentException("at most 2 column specifiers");
            }
            if (obj instanceof TablePtg.Item) {
                if (item1 == null) {
                    item1 = (TablePtg.Item)obj;
                    continue;
                }
                if (item2 == null) {
                    item2 = (TablePtg.Item)obj;
                    continue;
                }
                throw new IllegalArgumentException("at most 2 item specifiers: " + specifiers);
            }
            throw new IllegalArgumentException("legal specifier(" + obj + ")");
        }
        if (item2 != null) {
            if (item2.ordinal() < item1.ordinal()) {
                TablePtg.Item tmp = item1;
                item1 = item2;
                item2 = tmp;
            }
            switch (item1) {
                case ALL: {
                    item2 = null;
                    break;
                }
                case HEADERS: {
                    if (item2 != TablePtg.Item.HEADERS && item2 != TablePtg.Item.TOTALS && item2 != TablePtg.Item.THIS_ROW) break;
                    item2 = null;
                    break;
                }
                case DATA: {
                    if (item2 != TablePtg.Item.THIS_ROW && item2 != TablePtg.Item.DATA) break;
                    item1 = item2;
                    item2 = null;
                    break;
                }
                case TOTALS: {
                    if (item2 != TablePtg.Item.TOTALS && item2 != TablePtg.Item.THIS_ROW) break;
                    item2 = null;
                    break;
                }
                case THIS_ROW: {
                    if (item2 != TablePtg.Item.THIS_ROW) break;
                    item2 = null;
                }
            }
        }
        STable table = ((AbstractBookAdv)this.book).getTable(tableName0);
        if (column1 != null) {
            String column01 = this.getColumnName(table, column1);
            if (column01 == null) {
                throw new IllegalArgumentException("expect a legal Table Column: '" + column1 + "'");
            }
            column1 = column01;
        }
        if (column2 != null) {
            String column02 = this.getColumnName(table, column2);
            if (column02 == null) {
                throw new IllegalArgumentException("expect a legal Table Column: '" + column2 + "'");
            }
            column2 = column02;
        }
        SheetRegion rgn1 = table.getItemRegion(item1 != null ? item1 : TablePtg.Item.DATA, rowIdx);
        SSheet sheet = rgn1.getSheet();
        int l = rgn1.getColumn();
        int r = rgn1.getLastColumn();
        int t = rgn1.getRow();
        int b = rgn1.getLastRow();
        SheetRegion rgn2 = table.getItemRegion(item2, rowIdx);
        if (rgn2 != null) {
            int l2 = rgn2.getColumn();
            int r2 = rgn2.getLastColumn();
            int t2 = rgn2.getRow();
            int b2 = rgn2.getLastRow();
            if (l2 < l) {
                l = l2;
            }
            if (r2 > r) {
                r = r2;
            }
            if (t2 < t) {
                t = t2;
            }
            if (b2 > b) {
                b = b2;
            }
        }
        if ((rgn3 = table.getColumnsRegion(column1, column2)) != null) {
            int l3 = rgn3.getColumn();
            int r3 = rgn3.getLastColumn();
            if (l3 > l) {
                l = l3;
            }
            if (r3 < r) {
                r = r3;
            }
        }
        int extIdx = this.getExternalSheetIndex(sheet.getSheetName());
        if (item1 == null) {
            itemArray = new TablePtg.Item[]{};
        } else if (item2 == null) {
            TablePtg.Item[] itemArray2 = new TablePtg.Item[1];
            itemArray = itemArray2;
            itemArray2[0] = item1;
        } else {
            TablePtg.Item[] itemArray3 = new TablePtg.Item[2];
            itemArray3[0] = item1;
            itemArray = itemArray3;
            itemArray3[1] = item2;
        }
        if (column1 == null) {
            stringArray = new String[]{};
        } else if (column2 == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = column1;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = column1;
            stringArray = stringArray3;
            stringArray3[1] = column2;
        }
        return new TablePtg(extIdx, t, b, l, r, tableName0, itemArray, stringArray, tableName == null || tableName.equalsIgnoreCase(tableName1));
    }

    private static String normalize(String col) {
        int preSingle = -2;
        StringBuilder sb = new StringBuilder();
        int len = col.length();
        for (int j = 0; j < len; ++j) {
            char ch = col.charAt(j);
            if (ch == '\'') {
                if (preSingle == j - 1) {
                    sb.append(ch);
                    preSingle = -2;
                    continue;
                }
                preSingle = j;
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public String getTableName(String name) {
        STable table = ((AbstractBookAdv)this.book).getTable(name);
        return table == null ? null : table.getName();
    }

    private static class SheetIndexes
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private List<Object[]> index2name = new ArrayList<Object[]>();
        private Map<String, Integer> name2index = new HashMap<String, Integer>();
        private List<EvaluationWorkbook.ExternalSheet> index2sheet = new ArrayList<EvaluationWorkbook.ExternalSheet>();
        private Map<String, Integer> sheetName2index = new HashMap<String, Integer>();

        private SheetIndexes() {
        }
    }

    private class SimpleName
    implements EvaluationName {
        private final String name;
        private final int nameIndex;
        private int sheetIndex;

        public SimpleName(String name, int nameIndex, int sheetIndex) {
            this.name = name;
            this.nameIndex = nameIndex;
            this.sheetIndex = sheetIndex;
        }

        public Ptg[] getNameDefinition() {
            return FormulaParser.parse((String)this.name, (FormulaParsingWorkbook)ParsingBook.this, (int)4, (int)this.sheetIndex);
        }

        public String getNameText() {
            return this.name;
        }

        public boolean hasFormula() {
            return false;
        }

        public boolean isFunctionName() {
            return false;
        }

        public boolean isRange() {
            return true;
        }

        public NamePtg createPtg() {
            return new NamePtg(this.nameIndex);
        }
    }
}

