/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.model.impl.sys.formula;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.zkoss.poi.ss.formula.CollaboratingWorkbooksEnvironment;
import org.zkoss.poi.ss.formula.DependencyTracker;
import org.zkoss.poi.ss.formula.EvaluationCell;
import org.zkoss.poi.ss.formula.EvaluationSheet;
import org.zkoss.poi.ss.formula.EvaluationWorkbook;
import org.zkoss.poi.ss.formula.ExternSheetReferenceToken;
import org.zkoss.poi.ss.formula.FormulaParseException;
import org.zkoss.poi.ss.formula.FormulaParser;
import org.zkoss.poi.ss.formula.FormulaParsingWorkbook;
import org.zkoss.poi.ss.formula.FormulaRenderer;
import org.zkoss.poi.ss.formula.FormulaRenderingWorkbook;
import org.zkoss.poi.ss.formula.IStabilityClassifier;
import org.zkoss.poi.ss.formula.PtgShifter;
import org.zkoss.poi.ss.formula.WorkbookEvaluator;
import org.zkoss.poi.ss.formula.eval.AreaEval;
import org.zkoss.poi.ss.formula.eval.BlankEval;
import org.zkoss.poi.ss.formula.eval.BoolEval;
import org.zkoss.poi.ss.formula.eval.ErrorEval;
import org.zkoss.poi.ss.formula.eval.EvaluationException;
import org.zkoss.poi.ss.formula.eval.NotImplementedException;
import org.zkoss.poi.ss.formula.eval.NumberEval;
import org.zkoss.poi.ss.formula.eval.RefEval;
import org.zkoss.poi.ss.formula.eval.StringEval;
import org.zkoss.poi.ss.formula.eval.ValueEval;
import org.zkoss.poi.ss.formula.eval.ValuesEval;
import org.zkoss.poi.ss.formula.ptg.AbstractFunctionPtg;
import org.zkoss.poi.ss.formula.ptg.Area3DPtg;
import org.zkoss.poi.ss.formula.ptg.AreaPtg;
import org.zkoss.poi.ss.formula.ptg.AreaPtgBase;
import org.zkoss.poi.ss.formula.ptg.FuncPtg;
import org.zkoss.poi.ss.formula.ptg.NamePtg;
import org.zkoss.poi.ss.formula.ptg.NameXPtg;
import org.zkoss.poi.ss.formula.ptg.Parenthesis2Ptg;
import org.zkoss.poi.ss.formula.ptg.ParenthesisPtg;
import org.zkoss.poi.ss.formula.ptg.Ptg;
import org.zkoss.poi.ss.formula.ptg.Ref3DPtg;
import org.zkoss.poi.ss.formula.ptg.RefPtg;
import org.zkoss.poi.ss.formula.ptg.RefPtgBase;
import org.zkoss.poi.ss.formula.ptg.TablePtg;
import org.zkoss.poi.ss.formula.udf.UDFFinder;
import org.zkoss.poi.xssf.model.IndexedUDFFinder;
import org.zkoss.util.logging.Log;
import org.zkoss.xel.FunctionMapper;
import org.zkoss.xel.VariableResolver;
import org.zkoss.xel.XelContext;
import org.zkoss.xel.util.SimpleXelContext;
import org.zkoss.zss.model.ErrorValue;
import org.zkoss.zss.model.SBook;
import org.zkoss.zss.model.SCell;
import org.zkoss.zss.model.SSheet;
import org.zkoss.zss.model.STable;
import org.zkoss.zss.model.SheetRegion;
import org.zkoss.zss.model.impl.AbstractBookAdv;
import org.zkoss.zss.model.impl.AbstractBookSeriesAdv;
import org.zkoss.zss.model.impl.AbstractCellAdv;
import org.zkoss.zss.model.impl.ColumnPrecedentRefImpl;
import org.zkoss.zss.model.impl.ColumnRefImpl;
import org.zkoss.zss.model.impl.IndirectRefImpl;
import org.zkoss.zss.model.impl.NameRefImpl;
import org.zkoss.zss.model.impl.NonSerializableHolder;
import org.zkoss.zss.model.impl.RefImpl;
import org.zkoss.zss.model.impl.TablePrecedentRefImpl;
import org.zkoss.zss.model.impl.sys.DependencyTableAdv;
import org.zkoss.zss.model.impl.sys.formula.EvalBook;
import org.zkoss.zss.model.impl.sys.formula.EvalSheet;
import org.zkoss.zss.model.impl.sys.formula.JoinFunctionMapper;
import org.zkoss.zss.model.impl.sys.formula.JoinVariableResolver;
import org.zkoss.zss.model.impl.sys.formula.ParsingBook;
import org.zkoss.zss.model.sys.dependency.ColumnRef;
import org.zkoss.zss.model.sys.dependency.DependencyTable;
import org.zkoss.zss.model.sys.dependency.Ref;
import org.zkoss.zss.model.sys.formula.EvaluationResult;
import org.zkoss.zss.model.sys.formula.FormulaClearContext;
import org.zkoss.zss.model.sys.formula.FormulaEngine;
import org.zkoss.zss.model.sys.formula.FormulaEvaluationContext;
import org.zkoss.zss.model.sys.formula.FormulaExpression;
import org.zkoss.zss.model.sys.formula.FormulaParseContext;
import org.zkoss.zss.model.sys.formula.FunctionResolver;
import org.zkoss.zss.model.sys.formula.FunctionResolverFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormulaEngineImpl
implements FormulaEngine,
Serializable {
    private static final long serialVersionUID = -2283899323000274392L;
    public static final String KEY_EVALUATORS = "$ZSS_EVALUATORS$";
    private static final Log _logger = Log.lookup((String)FormulaEngineImpl.class.getName());
    private Map<EvaluationWorkbook, XelContext> _xelContexts = new HashMap<EvaluationWorkbook, XelContext>();
    protected static final IStabilityClassifier noCacheClassifier = new IStabilityClassifier(){

        public boolean isCellFinal(int sheetIndex, int rowIndex, int columnIndex) {
            return true;
        }
    };
    private static Pattern _areaPattern = Pattern.compile("\\([.[^\\(\\)]]*\\)");
    private static Pattern _searchPattern = Pattern.compile("\\s*((?:(?:'[^!\\(]+'!)|(?:[^'!,\\(]+!))?(?:[$\\w]+:)?[$\\w]+)");

    private static boolean isMultipleAreaFormula(String formula) {
        return formula.split(",").length > 1 && _areaPattern.matcher(formula).matches();
    }

    private String[] unwrapeAreaFormula(String formula) {
        ArrayList<String> areaStrings = new ArrayList<String>();
        Matcher m = _searchPattern.matcher(formula);
        while (m.find()) {
            areaStrings.add(m.group(1));
        }
        return areaStrings.toArray(new String[0]);
    }

    private FormulaExpression parseMultipleAreaFormula(String formula, FormulaParseContext context) {
        if (!FormulaEngineImpl.isMultipleAreaFormula(formula)) {
            return null;
        }
        FormulaExpression[] result = this.parse0(this.unwrapeAreaFormula(formula), context, true);
        ArrayList<Object> tokens = new ArrayList<Object>(result.length + 2);
        LinkedList<Ref> areaRefs = new LinkedList<Ref>();
        for (FormulaExpression expr : result) {
            if (expr.hasError()) {
                return new FormulaExpressionImpl(formula, null, null, true, expr.getErrorMessage(), true);
            }
            for (Ref ref : expr.getAreaRefs()) {
                areaRefs.add(ref);
            }
            Ptg[] ptgs = expr.getPtgs();
            for (int k = 0; k < ptgs.length; ++k) {
                tokens.add(ptgs[k]);
            }
        }
        tokens.add(new Parenthesis2Ptg(tokens.size()));
        Ptg[] ptgArray = tokens.toArray(new Ptg[tokens.size()]);
        String renderedFormula = this.renderFormula(new ParsingBook(context.getBook()), formula, ptgArray, true);
        return new FormulaExpressionImpl(renderedFormula, ptgArray, areaRefs.toArray(new Ref[areaRefs.size()]), false, null, true);
    }

    @Override
    public FormulaExpression parse(String formula, FormulaParseContext context) {
        FormulaExpression expr = this.parseMultipleAreaFormula(formula = formula.trim(), context);
        if (expr != null) {
            return expr;
        }
        expr = this.parse0(new String[]{formula}, context, false)[0];
        if (expr.hasError()) {
            return expr;
        }
        Ptg[] ptgArray = expr.getPtgs();
        Ref[] refArray = expr.getAreaRefs();
        String renderedFormula = this.renderFormula(new ParsingBook(context.getBook()), expr.getFormulaString(), ptgArray, true);
        return new FormulaExpressionImpl(renderedFormula, ptgArray, refArray, false, null, expr.isMultipleAreaFormula());
    }

    private FormulaExpression[] parse0(String[] formulas, FormulaParseContext context, boolean multipleArea) {
        LinkedList<FormulaExpressionImpl> result = new LinkedList<FormulaExpressionImpl>();
        Ref dependant = context.getDependent();
        LinkedList<Ref> precedents = dependant != null ? new LinkedList<Ref>() : null;
        try {
            SBook book = context.getBook();
            ParsingBook parsingBook = new ParsingBook(book);
            int sheetIndex = parsingBook.getExternalSheetIndex(null, context.getSheet().getSheetName());
            AbstractBookSeriesAdv series = (AbstractBookSeriesAdv)book.getBookSeries();
            DependencyTableAdv dt = (DependencyTableAdv)series.getDependencyTable();
            boolean error = false;
            for (String formula : formulas) {
                try {
                    Ref[] refArray;
                    Ref singleRef;
                    Ptg[] tokens = this.parse(formula, parsingBook, sheetIndex, context);
                    if (dependant != null) {
                        int len = tokens.length;
                        for (int j = 0; j < len; ++j) {
                            String columnName1;
                            Ptg ptg = tokens[j];
                            Ref precedent = this.toDependRef(context, parsingBook, ptg, j);
                            if (precedent == null) continue;
                            precedents.add(precedent);
                            if (!(precedent instanceof ColumnRef)) continue;
                            ColumnRef colRef = (ColumnRef)precedent;
                            String bookName = colRef.getBookName();
                            String tableName = colRef.getTableName();
                            TablePrecedentRefImpl tbPrecedent = new TablePrecedentRefImpl(bookName, tableName);
                            precedents.add(tbPrecedent);
                            if (!colRef.isWithHeaders() || (columnName1 = colRef.getColumnName1()) == null) continue;
                            ColumnPrecedentRefImpl colPrecedent1 = new ColumnPrecedentRefImpl(bookName, tableName, columnName1);
                            precedents.add(colPrecedent1);
                            STable table = ((AbstractBookAdv)book).getTable(tableName);
                            int rowHd = table.getHeadersRegion().getRow();
                            int col1 = colRef.getColumn();
                            String sheetName = table.getAllRegion().getSheet().getSheetName();
                            RefImpl cellRef1 = new RefImpl(bookName, sheetName, rowHd, col1);
                            precedents.add(cellRef1);
                            String columnName2 = colRef.getColumnName2();
                            if (columnName2 == null) continue;
                            ColumnPrecedentRefImpl colPrecedent2 = new ColumnPrecedentRefImpl(bookName, tableName, columnName2);
                            precedents.add(colPrecedent2);
                            int col2 = colRef.getLastColumn();
                            RefImpl cellRef2 = new RefImpl(bookName, sheetName, rowHd, col2);
                            precedents.add(cellRef2);
                        }
                    }
                    String renderedFormula = this.renderFormula(parsingBook, formula, tokens, true);
                    Ref ref = singleRef = tokens.length == 1 ? this.toDependRef(context, parsingBook, tokens[0], 0) : null;
                    if (singleRef == null) {
                        refArray = null;
                    } else if (singleRef.getType() == Ref.RefType.AREA || singleRef.getType() == Ref.RefType.CELL) {
                        Ref[] refArray2 = new Ref[1];
                        refArray = refArray2;
                        refArray2[0] = singleRef;
                    } else {
                        refArray = null;
                    }
                    Ref[] refs = refArray;
                    result.add(new FormulaExpressionImpl(renderedFormula, tokens, refs, false, null, multipleArea));
                }
                catch (FormulaParseException e) {
                    _logger.info(e.getMessage() + " when parsing " + formula + " at " + this.getReference(context));
                    if (_logger.infoable()) {
                        e.printStackTrace();
                    }
                    result.add(new FormulaExpressionImpl(formula, null, null, true, e.getMessage(), multipleArea));
                    error = true;
                }
                catch (Exception e) {
                    _logger.error(e.getMessage() + " when parsing " + formula + " at " + this.getReference(context), (Throwable)e);
                    if (_logger.errorable()) {
                        e.printStackTrace();
                    }
                    result.add(new FormulaExpressionImpl(formula, null, null, true, e.getMessage(), multipleArea));
                    error = true;
                }
            }
            if (!error && dependant != null) {
                for (Ref precedent : precedents) {
                    dt.add(dependant, precedent);
                }
            }
        }
        catch (Exception e) {
            _logger.error(e.getMessage() + " when parsing " + Arrays.asList(formulas) + " at " + this.getReference(context), (Throwable)e);
            result.clear();
            result.add(new FormulaExpressionImpl(Arrays.asList(formulas).toString(), null, null, true, e.getMessage(), multipleArea));
        }
        return result.toArray(new FormulaExpression[result.size()]);
    }

    private String getReference(FormulaParseContext context) {
        return "[" + context.getBook().getBookName() + "]" + context.getSheet().getSheetName() + "!" + context.getCell();
    }

    protected Ptg[] parse(String formula, FormulaParsingWorkbook book, int sheetIndex, FormulaParseContext context) {
        return FormulaParser.parse((String)formula, (FormulaParsingWorkbook)book, (int)0, (int)sheetIndex);
    }

    protected String renderFormula(ParsingBook parsingBook, String formula, Ptg[] tokens, boolean always) {
        return always ? FormulaRenderer.toFormulaString((FormulaRenderingWorkbook)parsingBook, (Ptg[])tokens) : FormulaRenderer.toFormulaEditText((FormulaRenderingWorkbook)parsingBook, (Ptg[])tokens, (String)formula);
    }

    protected Ref toDependRef(FormulaParseContext ctx, ParsingBook parsingBook, Ptg ptg, int ptgIndex) {
        try {
            SSheet sheet = ctx.getSheet();
            if (ptg instanceof NamePtg) {
                NamePtg namePtg = (NamePtg)ptg;
                String bookName = sheet.getBook().getBookName();
                String name = parsingBook.getNameText(namePtg);
                return new NameRefImpl(bookName, null, name);
            }
            if (!(ptg instanceof NameXPtg) && !(ptg instanceof FuncPtg)) {
                if (ptg instanceof TablePtg) {
                    TablePtg tbPtg = (TablePtg)ptg;
                    SBook book = sheet.getBook();
                    String tbName = tbPtg.getTableName();
                    STable tb = ((AbstractBookAdv)book).getTable(tbName);
                    String columnName1 = tbPtg.getColumn1();
                    String columnName2 = tbPtg.getColumn2();
                    TablePtg.Item item1 = tbPtg.getItem1();
                    TablePtg.Item item2 = tbPtg.getItem2();
                    SSheet srcSheet = tb.getAllRegion().getSheet();
                    String sheetName = srcSheet.getSheetName();
                    String bookName = book.getBookName();
                    return new ColumnRefImpl(bookName, sheetName, tbName, item1, item2, columnName1, columnName2, tb.getHeaderRowCount() > 0, tbPtg.getFirstRow(), tbPtg.getFirstColumn(), tbPtg.getLastRow(), tbPtg.getLastColumn());
                }
                if (ptg instanceof Ref3DPtg) {
                    Ref3DPtg rptg = (Ref3DPtg)ptg;
                    EvaluationWorkbook.ExternalSheet es = parsingBook.getAnyExternalSheet(rptg.getExternSheetIndex());
                    String bookName = es.getWorkbookName() != null ? es.getWorkbookName() : sheet.getBook().getBookName();
                    String sheetName = es.getSheetName();
                    String lastSheetName = es.getLastSheetName().equals(sheetName) ? null : es.getLastSheetName();
                    return new RefImpl(bookName, sheetName, lastSheetName, rptg.getRow(), rptg.getColumn());
                }
                if (ptg instanceof Area3DPtg) {
                    Area3DPtg aptg = (Area3DPtg)ptg;
                    EvaluationWorkbook.ExternalSheet es = parsingBook.getAnyExternalSheet(aptg.getExternSheetIndex());
                    String bookName = es.getWorkbookName() != null ? es.getWorkbookName() : sheet.getBook().getBookName();
                    String sheetName = es.getSheetName();
                    String lastSheetName = es.getLastSheetName().equals(sheetName) ? null : es.getLastSheetName();
                    return new RefImpl(bookName, sheetName, lastSheetName, aptg.getFirstRow(), aptg.getFirstColumn(), aptg.getLastRow(), aptg.getLastColumn());
                }
                if (ptg instanceof RefPtg) {
                    RefPtg rptg = (RefPtg)ptg;
                    String bookName = sheet.getBook().getBookName();
                    String sheetName = sheet.getSheetName();
                    return new RefImpl(bookName, sheetName, rptg.getRow(), rptg.getColumn());
                }
                if (ptg instanceof AreaPtg) {
                    AreaPtg aptg = (AreaPtg)ptg;
                    String sheetName = sheet.getSheetName();
                    String bookName = sheet.getBook().getBookName();
                    return new RefImpl(bookName, sheetName, aptg.getFirstRow(), aptg.getFirstColumn(), aptg.getLastRow(), aptg.getLastColumn());
                }
                if (ptg instanceof AbstractFunctionPtg && ((AbstractFunctionPtg)ptg).getFunctionIndex() == 148) {
                    String sheetName = sheet.getSheetName();
                    String bookName = sheet.getBook().getBookName();
                    return new IndirectRefImpl(bookName, sheetName, ptgIndex);
                }
            }
        }
        catch (Exception e) {
            _logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EvaluationResult evaluate(FormulaExpression expr, FormulaEvaluationContext context) {
        if (expr.hasError()) {
            return new EvaluationResultImpl(EvaluationResult.ResultType.ERROR, ErrorValue.valueOf((byte)127), (ValueEval)ErrorEval.FORMULA_INVALID);
        }
        Ref dependant = context.getDependent();
        EvaluationResult result = null;
        try {
            SBook book = context.getBook();
            AbstractBookSeriesAdv bookSeries = (AbstractBookSeriesAdv)book.getBookSeries();
            DependencyTableAdv table = (DependencyTableAdv)bookSeries.getDependencyTable();
            Map<String, EvalContext> evalCtxMap = this.getEvalCtxMap(bookSeries);
            EvalContext ctx = evalCtxMap.get(book.getBookName());
            if (ctx == null) {
                throw new IllegalStateException("The book isn't in the book series.");
            }
            EvalBook evalBook = ctx.getBook();
            WorkbookEvaluator evaluator = ctx.getEvaluator();
            Object oldXelCtx = this.getXelContext();
            XelContext xelCtx = this.getXelContextForResolving(context, evalBook, evaluator);
            this.setXelContext(xelCtx);
            try {
                result = this.evaluateFormula(expr, context, evalBook, evaluator);
            }
            finally {
                this.setXelContext(oldXelCtx);
            }
            if (dependant != null) {
                table.setEvaluated(dependant);
            }
        }
        catch (NotImplementedException e) {
            _logger.info(e.getMessage() + " when eval " + expr.getFormulaString());
            result = new EvaluationResultImpl(EvaluationResult.ResultType.ERROR, new ErrorValue(29, e.getMessage()), (ValueEval)ErrorEval.NAME_INVALID);
        }
        catch (EvaluationException e) {
            _logger.warning(e.getMessage() + " when eval " + expr.getFormulaString());
            ErrorEval error = e.getErrorEval();
            result = new EvaluationResultImpl(EvaluationResult.ResultType.ERROR, error == null ? new ErrorValue(127, e.getMessage()) : error, (ValueEval)(error == null ? ErrorEval.FORMULA_INVALID : error));
        }
        catch (FormulaParseException e) {
            _logger.error(e.getMessage() + " when eval " + expr.getFormulaString());
            result = new EvaluationResultImpl(EvaluationResult.ResultType.ERROR, new ErrorValue(127, e.getMessage()), (ValueEval)ErrorEval.FORMULA_INVALID);
        }
        catch (Exception e) {
            _logger.error(e.getMessage() + " when eval " + expr.getFormulaString(), (Throwable)e);
            result = new EvaluationResultImpl(EvaluationResult.ResultType.ERROR, new ErrorValue(127, e.getMessage()), (ValueEval)ErrorEval.FORMULA_INVALID);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, EvalContext> getEvalCtxMap(AbstractBookSeriesAdv bookSeries) {
        Map<String, EvalContext> evalCtxMap = this.getEvalCtxMap0(bookSeries);
        if (evalCtxMap == null) {
            AbstractBookSeriesAdv abstractBookSeriesAdv = bookSeries;
            synchronized (abstractBookSeriesAdv) {
                evalCtxMap = this.getEvalCtxMap0(bookSeries);
                if (evalCtxMap == null) {
                    evalCtxMap = new LinkedHashMap<String, EvalContext>();
                    ArrayList<String> bookNames = new ArrayList<String>();
                    ArrayList<WorkbookEvaluator> evaluators = new ArrayList<WorkbookEvaluator>();
                    for (SBook nb : bookSeries.getBooks()) {
                        String bookName = nb.getBookName();
                        EvalBook evalBook = new EvalBook(nb);
                        WorkbookEvaluator we = new WorkbookEvaluator((EvaluationWorkbook)evalBook, noCacheClassifier, null, new WorkbookEvaluator.CacheManager(){

                            public void onUpdateCacheResult(EvaluationCell srcCell, ValueEval result) {
                                EvalSheet evalSheet = (EvalSheet)srcCell.getSheet();
                                SSheet sheet = evalSheet.getNSheet();
                                int row = srcCell.getRowIndex();
                                int col = srcCell.getColumnIndex();
                                SCell cell = sheet.getCell(row, col);
                                ((AbstractCellAdv)cell).setFormulaResultValue(result);
                            }
                        });
                        bookNames.add(bookName);
                        evaluators.add(we);
                        evalCtxMap.put(bookName, new EvalContext(evalBook, we));
                        FunctionResolver resolver = FunctionResolverFactory.createFunctionResolver();
                        UDFFinder zkUDFF = resolver.getUDFFinder();
                        if (zkUDFF == null) continue;
                        IndexedUDFFinder bookUDFF = (IndexedUDFFinder)evalBook.getUDFFinder();
                        bookUDFF.insert(0, zkUDFF);
                    }
                    CollaboratingWorkbooksEnvironment.setup((String[])bookNames.toArray(new String[0]), (WorkbookEvaluator[])evaluators.toArray(new WorkbookEvaluator[0]));
                    NonSerializableHolder<Map<String, EvalContext>> holder = new NonSerializableHolder<Map<String, EvalContext>>(evalCtxMap);
                    bookSeries.setAttribute(KEY_EVALUATORS, holder);
                }
            }
        }
        return evalCtxMap;
    }

    private Map<String, EvalContext> getEvalCtxMap0(AbstractBookSeriesAdv bookSeries) {
        NonSerializableHolder holder = (NonSerializableHolder)bookSeries.getAttribute(KEY_EVALUATORS);
        return holder == null ? null : (Map)holder.getObject();
    }

    protected EvaluationResult evaluateFormula(FormulaExpression expr, FormulaEvaluationContext context, EvalBook evalBook, WorkbookEvaluator evaluator) throws FormulaParseException, Exception {
        SBook book = context.getBook();
        int currentSheetIndex = book.getSheetIndex(context.getSheet());
        SCell cell = context.getCell();
        ValueEval value = null;
        boolean multipleArea = FormulaEngineImpl.isMultipleAreaFormula(expr.getFormulaString());
        if (cell == null || cell.isNull() || context.isExternalFormula()) {
            if (multipleArea) {
                String[] formulas = this.unwrapeAreaFormula(expr.getFormulaString());
                ArrayList<ValueEval> evals = new ArrayList<ValueEval>(formulas.length);
                for (String f : formulas) {
                    value = evaluator.evaluate(currentSheetIndex, f, true, (Object)context.getDependent());
                    evals.add(value);
                }
                value = new ValuesEval(evals.toArray(new ValueEval[evals.size()]));
            } else {
                int columnIndex = cell == null ? 0 : cell.getColumnIndex();
                int rowIndex = cell == null ? 0 : cell.getRowIndex();
                value = this.evaluateFormulaExpression(evaluator, currentSheetIndex, rowIndex, columnIndex, expr, true, context.getDependent(), context.getOffset());
            }
        } else {
            if (multipleArea) {
                return new EvaluationResultImpl(EvaluationResult.ResultType.ERROR, ErrorValue.valueOf((byte)15), (ValueEval)ErrorEval.VALUE_INVALID);
            }
            EvaluationCell evalCell = evalBook.getSheet(currentSheetIndex).getCell(cell.getRowIndex(), cell.getColumnIndex());
            value = evaluator.evaluate(evalCell, (Object)context.getDependent(), context.getOffset());
        }
        return FormulaEngineImpl.convertToEvaluationResult(value);
    }

    public static EvaluationResult convertToEvaluationResult(ValueEval value) throws EvaluationException {
        if (value instanceof ErrorEval) {
            int code = ((ErrorEval)value).getErrorCode();
            return new EvaluationResultImpl(EvaluationResult.ResultType.ERROR, ErrorValue.valueOf((byte)code), value);
        }
        try {
            ResultValueEval resultEval = FormulaEngineImpl.getResolvedValue(value);
            return new EvaluationResultImpl(EvaluationResult.ResultType.SUCCESS, resultEval.value, resultEval.valueEval);
        }
        catch (EvaluationException x) {
            if (x.getErrorEval() != null) {
                return new EvaluationResultImpl(EvaluationResult.ResultType.ERROR, ErrorValue.valueOf((byte)x.getErrorEval().getErrorCode()), (ValueEval)x.getErrorEval());
            }
            throw x;
        }
    }

    protected static ResultValueEval getResolvedValue(ValueEval value) throws EvaluationException {
        if (value instanceof StringEval) {
            return new ResultValueEval(((StringEval)value).getStringValue(), value);
        }
        if (value instanceof NumberEval) {
            return new ResultValueEval(((NumberEval)value).getNumberValue(), value);
        }
        if (value instanceof BlankEval) {
            return new ResultValueEval("", value);
        }
        if (value instanceof BoolEval) {
            return new ResultValueEval(((BoolEval)value).getBooleanValue(), value);
        }
        if (value instanceof ValuesEval) {
            ValueEval[] values = ((ValuesEval)value).getValueEvals();
            Object[] array = new Object[values.length];
            for (int i = 0; i < values.length; ++i) {
                try {
                    array[i] = FormulaEngineImpl.getResolvedValue((ValueEval)values[i]).value;
                    continue;
                }
                catch (EvaluationException ex) {
                    array[i] = ErrorValue.valueOf((byte)ex.getErrorEval().getErrorCode());
                }
            }
            return new ResultValueEval(array, value);
        }
        if (value instanceof AreaEval) {
            ArrayList<Object> list = new ArrayList<Object>();
            AreaEval area = (AreaEval)value;
            for (int r = 0; r < area.getHeight(); ++r) {
                for (int c = 0; c < area.getWidth(); ++c) {
                    ValueEval v = area.getValue(r, c);
                    list.add(FormulaEngineImpl.getResolvedValue((ValueEval)v).value);
                }
            }
            return new ResultValueEval(list, value);
        }
        if (value instanceof RefEval) {
            ValueEval ve = ((RefEval)value).getInnerValueEval();
            Object v = FormulaEngineImpl.getResolvedValue((ValueEval)ve).value;
            return new ResultValueEval(v, value);
        }
        if (value instanceof ErrorEval) {
            throw new EvaluationException((ErrorEval)value);
        }
        throw new EvaluationException(null, "no matched type: " + value);
    }

    protected Object getXelContext() {
        return null;
    }

    protected void setXelContext(Object ctx) {
    }

    private XelContext getXelContextForResolving(FormulaEvaluationContext context, EvaluationWorkbook evalBook, WorkbookEvaluator evaluator) {
        XelContext xelContext = this._xelContexts.get(evalBook);
        if (xelContext == null) {
            FunctionMapper zssFuncMapper;
            FunctionResolver resolver = FunctionResolverFactory.createFunctionResolver();
            DependencyTracker tracker = resolver.getDependencyTracker();
            if (tracker != null) {
                evaluator.setDependencyTracker(tracker);
            }
            JoinFunctionMapper functionMapper = new JoinFunctionMapper(null);
            FunctionMapper extraFunctionMapper = context.getFunctionMapper();
            if (extraFunctionMapper != null) {
                functionMapper.addFunctionMapper(extraFunctionMapper);
            }
            if ((zssFuncMapper = resolver.getFunctionMapper()) != null) {
                functionMapper.addFunctionMapper(zssFuncMapper);
            }
            JoinVariableResolver variableResolver = new JoinVariableResolver();
            VariableResolver extraVariableResolver = context.getVariableResolver();
            if (extraVariableResolver != null) {
                variableResolver.addVariableResolver(extraVariableResolver);
            }
            xelContext = new SimpleXelContext((VariableResolver)variableResolver, (FunctionMapper)functionMapper);
            xelContext.setAttribute("zkoss.zss.CellType", Object.class);
            this._xelContexts.put(evalBook, xelContext);
        }
        return xelContext;
    }

    @Override
    public void clearCache(FormulaClearContext context) {
        try {
            Map map;
            SBook book = context.getBook();
            SSheet sheet = context.getSheet();
            SCell cell = context.getCell();
            AbstractBookSeriesAdv bookSeries = (AbstractBookSeriesAdv)book.getBookSeries();
            NonSerializableHolder holder = (NonSerializableHolder)bookSeries.getAttribute(KEY_EVALUATORS);
            Map map2 = map = holder == null ? null : (Map)holder.getObject();
            if (map == null) {
                return;
            }
            if (cell != null && !cell.isNull()) {
                EvalContext ctx = (EvalContext)map.get(book.getBookName());
                if (ctx == null) {
                    _logger.warning("clear a non-existed book? >> " + book.getBookName());
                    return;
                }
                String sheetName = sheet.getSheetName();
                EvalBook evalBook = ctx.getBook();
                EvaluationSheet evalSheet = evalBook.getSheet(evalBook.getSheetIndex(sheetName));
                EvaluationCell evalCell = evalSheet.getCell(cell.getRowIndex(), cell.getColumnIndex());
                WorkbookEvaluator evaluator = ctx.getEvaluator();
                evaluator.notifyUpdateCell(evalCell);
            } else {
                bookSeries.setAttribute(KEY_EVALUATORS, null);
                map.clear();
            }
        }
        catch (Exception e) {
            _logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private FormulaExpression adjustMultipleArea(String formula, FormulaParseContext context, FormulaAdjuster adjuster) {
        if (!FormulaEngineImpl.isMultipleAreaFormula(formula)) {
            return null;
        }
        String[] fs = this.unwrapeAreaFormula(formula);
        ArrayList<Object> tokens = new ArrayList<Object>(fs.length + 2);
        LinkedList<Ref> areaRefs = new LinkedList<Ref>();
        for (int i = 0; i < fs.length; ++i) {
            FormulaExpression expr = this.adjust(fs[i], context, adjuster);
            if (expr.hasError()) {
                return new FormulaExpressionImpl(formula, null, null, true, expr.getErrorMessage(), true);
            }
            if (expr.isAreaRefs()) {
                for (Ref ref : expr.getAreaRefs()) {
                    areaRefs.add(ref);
                }
            }
            Ptg[] ptgs = expr.getPtgs();
            for (int k = 0; k < ptgs.length; ++k) {
                tokens.add(ptgs[k]);
            }
        }
        tokens.add(new Parenthesis2Ptg(tokens.size()));
        return new FormulaExpressionImpl(formula, tokens.toArray(new Ptg[tokens.size()]), areaRefs.size() == 0 ? null : areaRefs.toArray(new Ref[areaRefs.size()]));
    }

    private FormulaExpression adjust(String formula, FormulaParseContext context, FormulaAdjuster adjuster) {
        FormulaExpressionImpl expr = null;
        try {
            Ref[] refArray;
            Ref singleRef;
            ParsingBook parsingBook = new ParsingBook(context.getBook());
            String sheetName = context.getSheet().getSheetName();
            int sheetIndex = parsingBook.getExternalSheetIndex(null, sheetName);
            Ptg[] tokens = this.parse(formula, parsingBook, sheetIndex, context);
            boolean modified = adjuster.process(sheetIndex, tokens, parsingBook, context);
            String renderedFormula = modified ? this.renderFormula(parsingBook, formula, tokens, true) : formula;
            Ref ref = singleRef = tokens.length == 1 ? this.toDependRef(context, parsingBook, tokens[0], 0) : null;
            if (singleRef == null) {
                refArray = null;
            } else if (singleRef.getType() == Ref.RefType.AREA || singleRef.getType() == Ref.RefType.CELL) {
                Ref[] refArray2 = new Ref[1];
                refArray = refArray2;
                refArray2[0] = singleRef;
            } else {
                refArray = null;
            }
            Ref[] refs = refArray;
            expr = new FormulaExpressionImpl(renderedFormula, tokens, refs);
        }
        catch (FormulaParseException e) {
            _logger.info(e.getMessage());
            expr = new FormulaExpressionImpl(formula, null, null, true, e.getMessage(), false);
        }
        return expr;
    }

    @Override
    public FormulaExpression move(String formula, SheetRegion region, int rowOffset, int columnOffset, FormulaParseContext context) {
        FormulaAdjuster shiftAdjuster;
        FormulaExpression result = this.adjustMultipleArea(formula = formula.trim(), context, shiftAdjuster = this.getMoveAdjuster(region, rowOffset, columnOffset));
        if (result != null) {
            return result;
        }
        return this.adjust(formula, context, shiftAdjuster);
    }

    protected FormulaAdjuster getMoveAdjuster(final SheetRegion region, final int rowOffset, final int columnOffset) {
        return new FormulaAdjuster(){

            public boolean process(int sheetIndex, Ptg[] tokens, ParsingBook parsingBook, FormulaParseContext context) {
                String bookName = context.getBook().getBookName();
                String regionBookName = region.getSheet().getBook().getBookName();
                String regionSheetName = region.getSheet().getSheetName();
                int regionSheetIndex = bookName.equals(regionBookName) ? parsingBook.findExternalSheetIndex(regionSheetName) : parsingBook.findExternalSheetIndex(regionBookName, regionSheetName);
                PtgShifter shifter = new PtgShifter(regionSheetIndex, region.getRow(), region.getLastRow(), rowOffset, region.getColumn(), region.getLastColumn(), columnOffset, parsingBook.getSpreadsheetVersion());
                return shifter.adjustFormula(tokens, sheetIndex);
            }
        };
    }

    @Override
    public FormulaExpression shrink(String formula, SheetRegion srcRegion, boolean horizontal, FormulaParseContext context) {
        SheetRegion neighbor;
        SSheet sheet = srcRegion.getSheet();
        int rowOffset = 0;
        int colOffset = 0;
        if (horizontal) {
            colOffset = -srcRegion.getColumnCount();
            int col = srcRegion.getLastColumn() + 1;
            int lastCol = sheet.getBook().getMaxColumnIndex();
            int row = srcRegion.getRow();
            int lastRow = srcRegion.getLastRow();
            neighbor = new SheetRegion(sheet, row, col, lastRow, lastCol);
        } else {
            rowOffset = -srcRegion.getRowCount();
            int row = srcRegion.getLastRow() + 1;
            int lastRow = sheet.getBook().getMaxRowIndex();
            int col = srcRegion.getColumn();
            int lastCol = srcRegion.getLastColumn();
            neighbor = new SheetRegion(sheet, row, col, lastRow, lastCol);
        }
        return this.move(formula, neighbor, rowOffset, colOffset, context);
    }

    @Override
    public FormulaExpression extend(String formula, SheetRegion srcRegion, boolean horizontal, FormulaParseContext context) {
        SheetRegion neighbor;
        SSheet sheet = srcRegion.getSheet();
        int rowOffset = 0;
        int colOffset = 0;
        if (horizontal) {
            colOffset = srcRegion.getColumnCount();
            int col = srcRegion.getColumn();
            int lastCol = sheet.getBook().getMaxColumnIndex();
            int row = srcRegion.getRow();
            int lastRow = srcRegion.getLastRow();
            neighbor = new SheetRegion(sheet, row, col, lastRow, lastCol);
        } else {
            rowOffset = srcRegion.getRowCount();
            int row = srcRegion.getRow();
            int lastRow = sheet.getBook().getMaxRowIndex();
            int col = srcRegion.getColumn();
            int lastCol = srcRegion.getLastColumn();
            neighbor = new SheetRegion(sheet, row, col, lastRow, lastCol);
        }
        return this.move(formula, neighbor, rowOffset, colOffset, context);
    }

    @Override
    public FormulaExpression shift(String formula, int rowOffset, int columnOffset, FormulaParseContext context) {
        FormulaAdjuster shiftAdjuster;
        FormulaExpression result = this.adjustMultipleArea(formula = formula.trim(), context, shiftAdjuster = this.getShiftAdjuster(rowOffset, columnOffset));
        if (result != null) {
            return result;
        }
        return this.adjust(formula, context, shiftAdjuster);
    }

    protected FormulaAdjuster getShiftAdjuster(final int rowOffset, final int columnOffset) {
        return new FormulaAdjuster(){

            public boolean process(int sheetIndex, Ptg[] tokens, ParsingBook parsingBook, FormulaParseContext context) {
                if (rowOffset != 0 || columnOffset != 0) {
                    SBook book = context.getBook();
                    for (int i = 0; i < tokens.length; ++i) {
                        Ptg ptg = tokens[i];
                        if (ptg instanceof RefPtgBase) {
                            RefPtgBase rptg = (RefPtgBase)ptg;
                            int r = rptg.getRow() + (rptg.isRowRelative() ? rowOffset : 0);
                            int c = rptg.getColumn() + (rptg.isColRelative() ? columnOffset : 0);
                            if (FormulaEngineImpl.this.isValidRowIndex(book, r) && FormulaEngineImpl.this.isValidColumnIndex(book, c)) {
                                rptg.setRow(r);
                                rptg.setColumn(c);
                                continue;
                            }
                            tokens[i] = PtgShifter.createDeletedRef((Ptg)rptg);
                            continue;
                        }
                        if (!(ptg instanceof AreaPtgBase)) continue;
                        AreaPtgBase aptg = (AreaPtgBase)ptg;
                        int r0 = aptg.getFirstRow() + (aptg.isFirstRowRelative() ? rowOffset : 0);
                        int r1 = aptg.getLastRow() + (aptg.isLastRowRelative() ? rowOffset : 0);
                        int c0 = aptg.getFirstColumn() + (aptg.isFirstColRelative() ? columnOffset : 0);
                        int c1 = aptg.getLastColumn() + (aptg.isLastColRelative() ? columnOffset : 0);
                        if (FormulaEngineImpl.this.isValidRowIndex(book, r0) && FormulaEngineImpl.this.isValidRowIndex(book, r1) && FormulaEngineImpl.this.isValidColumnIndex(book, c0) && FormulaEngineImpl.this.isValidColumnIndex(book, c1)) {
                            aptg.setFirstRow(Math.min(r0, r1));
                            aptg.setLastRow(Math.max(r0, r1));
                            aptg.setFirstColumn(Math.min(c0, c1));
                            aptg.setLastColumn(Math.max(c0, c1));
                            continue;
                        }
                        tokens[i] = PtgShifter.createDeletedRef((Ptg)aptg);
                    }
                    return true;
                }
                return false;
            }
        };
    }

    private boolean isValidRowIndex(SBook book, int rowIndex) {
        return 0 <= rowIndex && rowIndex <= book.getMaxRowIndex();
    }

    private boolean isValidColumnIndex(SBook book, int columnIndex) {
        return 0 <= columnIndex && columnIndex <= book.getMaxColumnIndex();
    }

    @Override
    public FormulaExpression transpose(String formula, int rowOrigin, int columnOrigin, FormulaParseContext context) {
        FormulaAdjuster shiftAdjuster;
        FormulaExpression result = this.adjustMultipleArea(formula = formula.trim(), context, shiftAdjuster = this.getTransposeAdjuster(rowOrigin, columnOrigin));
        if (result != null) {
            return result;
        }
        return this.adjust(formula, context, shiftAdjuster);
    }

    protected FormulaAdjuster getTransposeAdjuster(final int rowOrigin, final int columnOrigin) {
        return new FormulaAdjuster(){

            public boolean process(int sheetIndex, Ptg[] tokens, ParsingBook parsingBook, FormulaParseContext context) {
                SBook book = context.getBook();
                for (int i = 0; i < tokens.length; ++i) {
                    AreaPtgBase aptg;
                    Ptg ptg = tokens[i];
                    if (ptg instanceof RefPtgBase) {
                        RefPtgBase rptg = (RefPtgBase)ptg;
                        if (!rptg.isRowRelative() || !rptg.isColRelative()) continue;
                        int r = rptg.getColumn() - columnOrigin + rowOrigin;
                        int c = rptg.getRow() - rowOrigin + columnOrigin;
                        if (FormulaEngineImpl.this.isValidRowIndex(book, r) && FormulaEngineImpl.this.isValidColumnIndex(book, c)) {
                            rptg.setRow(r);
                            rptg.setColumn(c);
                            continue;
                        }
                        tokens[i] = PtgShifter.createDeletedRef((Ptg)rptg);
                        continue;
                    }
                    if (!(ptg instanceof AreaPtgBase) || (!(aptg = (AreaPtgBase)ptg).isFirstRowRelative() || !aptg.isFirstColRelative()) && (!aptg.isLastRowRelative() || !aptg.isLastColRelative())) continue;
                    int r0 = aptg.getFirstColumn() - columnOrigin + rowOrigin;
                    int c0 = aptg.getFirstRow() - rowOrigin + columnOrigin;
                    int r1 = aptg.getLastColumn() - columnOrigin + rowOrigin;
                    int c1 = aptg.getLastRow() - rowOrigin + columnOrigin;
                    boolean temp = aptg.isFirstRowRelative();
                    aptg.setFirstRowRelative(aptg.isFirstColRelative());
                    aptg.setFirstColRelative(temp);
                    temp = aptg.isLastRowRelative();
                    aptg.setLastRowRelative(aptg.isLastColRelative());
                    aptg.setLastColRelative(temp);
                    if (FormulaEngineImpl.this.isValidRowIndex(book, r0) && FormulaEngineImpl.this.isValidRowIndex(book, r1) && FormulaEngineImpl.this.isValidColumnIndex(book, c0) && FormulaEngineImpl.this.isValidColumnIndex(book, c1)) {
                        aptg.setFirstRow(Math.min(r0, r1));
                        aptg.setLastRow(Math.max(r0, r1));
                        aptg.setFirstColumn(Math.min(c0, c1));
                        aptg.setLastColumn(Math.max(c0, c1));
                        continue;
                    }
                    tokens[i] = PtgShifter.createDeletedRef((Ptg)aptg);
                }
                return true;
            }
        };
    }

    @Override
    public FormulaExpression renameSheet(String formula, SBook targetBook, String oldSheetName, String newSheetName, FormulaParseContext context) {
        FormulaAdjuster shiftAdjuster;
        FormulaExpression result = this.adjustMultipleArea(formula = formula.trim(), context, shiftAdjuster = this.getRenameSheetAdjuster(targetBook, oldSheetName, newSheetName));
        if (result != null) {
            return result;
        }
        return this.adjust(formula, context, shiftAdjuster);
    }

    protected FormulaAdjuster getRenameSheetAdjuster(final SBook targetBook, final String oldSheetName, final String newSheetName) {
        return new FormulaAdjuster(){

            public boolean process(int formulaSheetIndex, Ptg[] tokens, ParsingBook parsingBook, FormulaParseContext context) {
                if (newSheetName != null) {
                    parsingBook.renameSheet(targetBook.getBookName(), oldSheetName, newSheetName);
                } else {
                    String bookName = targetBook == context.getBook() ? null : targetBook.getBookName();
                    for (int i = 0; i < tokens.length; ++i) {
                        Ptg ptg = tokens[i];
                        if (!(ptg instanceof ExternSheetReferenceToken)) continue;
                        ExternSheetReferenceToken t = (ExternSheetReferenceToken)ptg;
                        EvaluationWorkbook.ExternalSheet es = parsingBook.getAnyExternalSheet(t.getExternSheetIndex());
                        if ((bookName != null || es.getWorkbookName() != null) && (bookName == null || !bookName.equals(es.getWorkbookName())) || !oldSheetName.equals(es.getSheetName()) && !oldSheetName.equals(es.getLastSheetName())) continue;
                        tokens[i] = PtgShifter.createDeletedRef3d((String)bookName, (Ptg)ptg);
                    }
                }
                return true;
            }
        };
    }

    @Override
    public FormulaExpression renameName(String formula, SBook targetBook, String oldName, String newName, FormulaParseContext context) {
        return this.renameName(formula, targetBook, -1, oldName, newName, context);
    }

    @Override
    public FormulaExpression renameName(String formula, SBook targetBook, int sheetIndex, String oldName, String newName, FormulaParseContext context) {
        FormulaAdjuster shiftAdjuster;
        FormulaExpression result = this.adjustMultipleArea(formula = formula.trim(), context, shiftAdjuster = this.getRenameNameAdjuster(sheetIndex, oldName, newName));
        if (result != null) {
            return result;
        }
        return this.adjust(formula, context, shiftAdjuster);
    }

    protected FormulaAdjuster getRenameNameAdjuster(final int sheetIndex, final String oldName, final String newName) {
        return new FormulaAdjuster(){

            public boolean process(int contextSheetIndex, Ptg[] tokens, ParsingBook parsingBook, FormulaParseContext context) {
                parsingBook.renameName(sheetIndex, oldName, newName);
                return true;
            }
        };
    }

    @Override
    public FormulaExpression movePtgs(FormulaExpression fe, SheetRegion region, int rowOffset, int columnOffset, FormulaParseContext context) {
        return this.move(fe.getFormulaString(), region, rowOffset, columnOffset, context);
    }

    @Override
    public FormulaExpression shrinkPtgs(FormulaExpression fe, SheetRegion srcRegion, boolean horizontal, FormulaParseContext context) {
        return this.shrink(fe.getFormulaString(), srcRegion, horizontal, context);
    }

    @Override
    public FormulaExpression extendPtgs(FormulaExpression fe, SheetRegion srcRegion, boolean horizontal, FormulaParseContext context) {
        return this.extend(fe.getFormulaString(), srcRegion, horizontal, context);
    }

    @Override
    public FormulaExpression shiftPtgs(FormulaExpression fe, int rowOffset, int columnOffset, FormulaParseContext context) {
        return this.shift(fe.getFormulaString(), rowOffset, columnOffset, context);
    }

    @Override
    public FormulaExpression transposePtgs(FormulaExpression fe, int rowOrigin, int columnOrigin, FormulaParseContext context) {
        return this.transpose(fe.getFormulaString(), rowOrigin, columnOrigin, context);
    }

    @Override
    public FormulaExpression renameSheetPtgs(FormulaExpression fe, SBook targetBook, String oldSheetName, String newSheetName, FormulaParseContext context) {
        return this.renameSheet(fe.getFormulaString(), targetBook, oldSheetName, newSheetName, context);
    }

    @Override
    public FormulaExpression renameNamePtgs(FormulaExpression fe, SBook targetBook, int sheetIndex, String oldName, String newName, FormulaParseContext context) {
        return this.renameName(fe.getFormulaString(), targetBook, sheetIndex, oldName, newName, context);
    }

    @Override
    public void updateDependencyTable(FormulaExpression fexpr, FormulaParseContext context) {
        Ref dependent = context.getDependent();
        if (dependent == null) {
            return;
        }
        if (fexpr.hasError()) {
            return;
        }
        SBook book = context.getBook();
        AbstractBookSeriesAdv series = (AbstractBookSeriesAdv)book.getBookSeries();
        DependencyTable dt = series.getDependencyTable();
        ParsingBook parsingBook = new ParsingBook(book);
        Ptg[] ptgs = fexpr.getPtgs();
        int len = ptgs.length;
        for (int j = 0; j < len; ++j) {
            String colName1;
            Ptg ptg = ptgs[j];
            Ref precedent = this.toDependRef(context, parsingBook, ptg, j);
            if (precedent == null) continue;
            dt.add(dependent, precedent);
            if (!(precedent instanceof ColumnRef)) continue;
            ColumnRef colRef = (ColumnRef)precedent;
            String bookName = colRef.getBookName();
            String tableName = colRef.getTableName();
            TablePrecedentRefImpl tbPrecedent = new TablePrecedentRefImpl(bookName, tableName);
            dt.add(dependent, tbPrecedent);
            if (!colRef.isWithHeaders() || (colName1 = colRef.getColumnName1()) == null) continue;
            ColumnPrecedentRefImpl colPrecedent1 = new ColumnPrecedentRefImpl(bookName, tableName, colName1);
            dt.add(dependent, colPrecedent1);
            STable table = ((AbstractBookAdv)book).getTable(tableName);
            int rowHd = table.getHeadersRegion().getRow();
            int col1 = colRef.getColumn();
            String sheetName = table.getAllRegion().getSheet().getSheetName();
            RefImpl cellRef1 = new RefImpl(bookName, sheetName, rowHd, col1);
            dt.add(dependent, cellRef1);
            String colName2 = colRef.getColumnName2();
            if (colName2 == null) continue;
            ColumnPrecedentRefImpl colPrecedent2 = new ColumnPrecedentRefImpl(bookName, tableName, colName2);
            dt.add(dependent, colPrecedent2);
            int col2 = colRef.getLastColumn();
            RefImpl cellRef2 = new RefImpl(bookName, sheetName, rowHd, col2);
            dt.add(dependent, cellRef2);
        }
    }

    @Deprecated
    protected ValueEval evaluateFormulaExpression(WorkbookEvaluator evaluator, int sheetIndex, FormulaExpression expr, boolean ignoreDereference, Ref dependent) {
        return evaluator.evaluate(sheetIndex, expr.getFormulaString(), ignoreDereference, (Object)dependent);
    }

    @Deprecated
    protected ValueEval evaluateFormulaExpression(WorkbookEvaluator evaluator, int sheetIndex, FormulaExpression expr, boolean ignoreDereference, Ref dependent, int[] offset) {
        return evaluator.evaluate(sheetIndex, expr.getFormulaString(), ignoreDereference, (Object)dependent, offset);
    }

    protected ValueEval evaluateFormulaExpression(WorkbookEvaluator evaluator, int sheetIndex, int rowIndex, int columnIndex, FormulaExpression expr, boolean ignoreDereference, Ref dependent, int[] offset) {
        return evaluator.evaluate(sheetIndex, rowIndex, columnIndex, expr.getFormulaString(), ignoreDereference, (Object)dependent, offset);
    }

    private FormulaExpression adjustMultipleAreaPtgs(Ptg[] ptgs0, String formula, FormulaParseContext context, FormulaAdjuster adjuster) {
        if (!FormulaEngineImpl.isMultipleAreaFormula(formula)) {
            return null;
        }
        String[] fs = this.unwrapeAreaFormula(formula);
        Ptg ptg0 = ptgs0[ptgs0.length - 1];
        if (!(ptg0 instanceof ParenthesisPtg)) {
            return null;
        }
        Ptg[][] ps = FormulaRenderer.unwrapPtgArrays((Ptg[])ptgs0);
        ArrayList<Object> tokens = new ArrayList<Object>(ps.length + 2);
        ArrayList<Ref> areaRefs = new ArrayList<Ref>();
        for (int i = 0; i < ps.length - 1; ++i) {
            FormulaExpression expr = this.adjustPtgs(ps[i], fs[i], context, adjuster);
            if (expr.hasError()) {
                return new FormulaExpressionImpl(formula, null, null, true, expr.getErrorMessage(), true);
            }
            if (expr.isAreaRefs()) {
                for (Ref ref : expr.getAreaRefs()) {
                    areaRefs.add(ref);
                }
            }
            Ptg[] ptgs = expr.getPtgs();
            for (int k = 0; k < ptgs.length; ++k) {
                tokens.add(ptgs[k]);
            }
        }
        tokens.add(new Parenthesis2Ptg(tokens.size()));
        return new FormulaExpressionImpl(formula, tokens.toArray(new Ptg[tokens.size()]), areaRefs.size() == 0 ? null : areaRefs.toArray(new Ref[areaRefs.size()]));
    }

    private FormulaExpression adjustPtgs(Ptg[] tokens, String formula, FormulaParseContext context, FormulaAdjuster adjuster) {
        FormulaExpressionImpl expr = null;
        try {
            Ref[] refArray;
            Ref singleRef;
            ParsingBook parsingBook = new ParsingBook(context.getBook());
            String sheetName = context.getSheet().getSheetName();
            int sheetIndex = parsingBook.getExternalSheetIndex(null, sheetName);
            boolean modified = adjuster.process(sheetIndex, tokens, parsingBook, context);
            String renderedFormula = modified ? this.renderFormula(parsingBook, formula, tokens, true) : formula;
            Ref ref = singleRef = tokens.length == 1 ? this.toDependRef(context, parsingBook, tokens[0], 0) : null;
            if (singleRef == null) {
                refArray = null;
            } else if (singleRef.getType() == Ref.RefType.AREA || singleRef.getType() == Ref.RefType.CELL) {
                Ref[] refArray2 = new Ref[1];
                refArray = refArray2;
                refArray2[0] = singleRef;
            } else {
                refArray = null;
            }
            Ref[] refs = refArray;
            expr = new FormulaExpressionImpl(renderedFormula, tokens, refs);
        }
        catch (FormulaParseException e) {
            _logger.info(e.getMessage());
            expr = new FormulaExpressionImpl(formula, null, null, true, e.getMessage(), false);
        }
        return expr;
    }

    @Override
    public FormulaExpression reorderSheetPtgs(FormulaExpression fexpr, SBook targetBook, int oldIndex, int newIndex, FormulaParseContext context) {
        String formula = fexpr.getFormulaString().trim();
        FormulaAdjuster shiftAdjuster = this.getReorderSheetAdjuster(targetBook, oldIndex, newIndex);
        FormulaExpression result = this.adjustMultipleAreaPtgs(fexpr.getPtgs(), formula, context, shiftAdjuster);
        if (result != null) {
            return result;
        }
        return this.adjustPtgs(fexpr.getPtgs(), formula, context, shiftAdjuster);
    }

    protected FormulaAdjuster getReorderSheetAdjuster(SBook targetBook, int oldIndex, int newIndex) {
        return new FormulaAdjuster(){

            public boolean process(int formulaSheetIndex, Ptg[] tokens, ParsingBook parsingBook, FormulaParseContext context) {
                return true;
            }
        };
    }

    @Override
    public FormulaExpression renameTableNameTablePtgs(FormulaExpression fexpr, SBook book, String oldName, String newName, FormulaParseContext context) {
        return fexpr;
    }

    @Override
    public FormulaExpression renameColumnNameTablePtgs(FormulaExpression fexpr, STable table, String oldName, String newName, FormulaParseContext context) {
        return fexpr;
    }

    private static class ResultValueEval {
        final Object value;
        final ValueEval valueEval;

        ResultValueEval(Object value, ValueEval valueEval) {
            this.value = value;
            this.valueEval = valueEval;
        }
    }

    protected static interface FormulaAdjuster {
        public boolean process(int var1, Ptg[] var2, ParsingBook var3, FormulaParseContext var4);
    }

    protected static class EvalContext {
        private EvalBook book;
        private WorkbookEvaluator evaluator;

        public EvalContext(EvalBook book, WorkbookEvaluator evaluator) {
            this.book = book;
            this.evaluator = evaluator;
        }

        public EvalBook getBook() {
            return this.book;
        }

        public WorkbookEvaluator getEvaluator() {
            return this.evaluator;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.book == null ? 0 : this.book.hashCode());
            result = 31 * result + (this.evaluator == null ? 0 : this.evaluator.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EvalContext other = (EvalContext)obj;
            if (this.book == null ? other.book != null : !this.book.equals(other.book)) {
                return false;
            }
            return !(this.evaluator == null ? other.evaluator != null : !this.evaluator.equals(other.evaluator));
        }
    }

    protected static class EvaluationResultImpl
    implements EvaluationResult {
        private EvaluationResult.ResultType type;
        private Object value;
        private ValueEval valueEval;

        public EvaluationResultImpl(EvaluationResult.ResultType type, Object value, ValueEval valueEval) {
            this.type = type;
            this.value = value;
            this.valueEval = valueEval;
        }

        public EvaluationResult.ResultType getType() {
            return this.type;
        }

        public Object getValue() {
            return this.value;
        }

        public ValueEval getValueEval() {
            return this.valueEval;
        }
    }

    protected static class FormulaExpressionImpl
    implements FormulaExpression,
    Serializable {
        private static final long serialVersionUID = -8532826169759927711L;
        private String formula;
        private Ref[] refs;
        private boolean error;
        private String errorMessage;
        private Ptg[] ptgs;
        private boolean multipleArea;

        public FormulaExpressionImpl(String formula, Ptg[] ptgs, Ref[] refs) {
            this(formula, ptgs, refs, false, null, false);
        }

        public FormulaExpressionImpl(String formula, Ptg[] ptgs, Ref[] refs, boolean error, String errorMessage, boolean multipleArea) {
            this.formula = formula;
            if (refs != null) {
                for (Ref ref : refs) {
                    if (ref.getType() == Ref.RefType.AREA || ref.getType() == Ref.RefType.CELL) continue;
                    this.error = true;
                    this.errorMessage = errorMessage == null ? "wrong area reference" : errorMessage;
                    return;
                }
            }
            this.ptgs = ptgs;
            this.refs = refs;
            this.error = error;
            this.errorMessage = errorMessage;
            this.multipleArea = multipleArea;
        }

        public boolean hasError() {
            return this.error;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public String getFormulaString() {
            return this.formula;
        }

        public boolean isAreaRefs() {
            return this.refs != null && this.refs.length > 0;
        }

        public Ref[] getAreaRefs() {
            return this.refs;
        }

        public Ptg[] getPtgs() {
            return this.ptgs;
        }

        public boolean isMultipleAreaFormula() {
            return this.multipleArea;
        }
    }
}

