/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.model.impl;

import java.util.HashMap;
import java.util.Map;
import org.zkoss.zss.model.SCell;
import org.zkoss.zss.model.SSheet;
import org.zkoss.zss.model.impl.ConditionalFormattingRuleImpl;
import org.zkoss.zss.model.sys.EngineFactory;
import org.zkoss.zss.model.sys.formula.EvaluationResult;
import org.zkoss.zss.model.sys.formula.FormulaEngine;
import org.zkoss.zss.model.sys.formula.FormulaEvaluationContext;
import org.zkoss.zss.model.sys.formula.FormulaExpression;

public class RuleInfo {
    private SSheet _sheet;
    private ConditionalFormattingRuleImpl _rule;
    private int row0;
    private int col0;
    private FormulaExpression _formulaExpr;
    private Map<String, EvaluationResult> _cacheMap;

    RuleInfo(SSheet sheet, ConditionalFormattingRuleImpl rule, FormulaExpression formulaExpr, int row0, int col0) {
        this._sheet = sheet;
        this._rule = rule;
        this._formulaExpr = formulaExpr;
        this.row0 = row0;
        this.col0 = col0;
        this._cacheMap = new HashMap<String, EvaluationResult>();
        if (formulaExpr != null) {
            rule.addDependency(formulaExpr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EvaluationResult evalFormula(SCell cell) {
        RuleInfo ruleInfo = this;
        synchronized (ruleInfo) {
            int row = cell == null ? this.row0 : cell.getRowIndex();
            int col = cell == null ? this.col0 : cell.getColumnIndex();
            String key = "" + row + "_" + col;
            EvaluationResult cache = this._cacheMap.get(key);
            if (cache != null) {
                return cache;
            }
            int rowOffset = row - this.row0;
            int colOffset = col - this.col0;
            FormulaEngine fe = EngineFactory.getInstance().createFormulaEngine();
            if (this._formulaExpr != null) {
                EvaluationResult result = fe.evaluate(this._formulaExpr, new FormulaEvaluationContext(this._sheet, cell, null, new int[]{rowOffset, colOffset}, true));
                this._cacheMap.put(key, result);
                return result;
            }
            return null;
        }
    }

    public void clearCacheMap() {
        this._cacheMap = new HashMap<String, EvaluationResult>();
    }
}

