/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.model.impl;

import java.io.Serializable;
import org.zkoss.zss.model.CellRegion;
import org.zkoss.zss.model.SFooter;
import org.zkoss.zss.model.SHeader;
import org.zkoss.zss.model.SPrintSetup;
import org.zkoss.zss.model.impl.HeaderFooterImpl;

public class PrintSetupImpl
implements SPrintSetup,
Serializable {
    private static final long serialVersionUID = 1L;
    private boolean _printGridlines = false;
    private double _headerMargin;
    private double _footerMargin;
    private double _leftMargin;
    private double _rightMargin;
    private double _topMargin;
    private double _bottomMargin;
    private boolean _landscape = false;
    private int _scale = 100;
    private SPrintSetup.PaperSize _paperSize = SPrintSetup.PaperSize.A4;
    private SHeader _header;
    private SHeader _evenHeader;
    private SHeader _firstHeader;
    private SFooter _footer;
    private SFooter _evenFooter;
    private SFooter _firstFooter;
    private boolean _diffOddEven;
    private boolean _diffFirst;
    private boolean _scaleWithDoc;
    private boolean _alignWithMargins;
    private boolean _hCenter;
    private boolean _vCenter;
    private int _pageStart;
    private int _fitWidth;
    private int _fitHeight;
    private String _printArea;
    private int _rowsTitle1 = -1;
    private int _rowsTitle2 = -1;
    private int _columnsTitle1 = -1;
    private int _columnsTitle2 = -1;
    private boolean _printHeadings;
    private int _errorMode;
    private int _commentMode;
    private boolean _leftToRight;

    public boolean isPrintGridlines() {
        return this._printGridlines;
    }

    public void setPrintGridlines(boolean enable) {
        this._printGridlines = enable;
    }

    public double getHeaderMargin() {
        return this._headerMargin;
    }

    public void setHeaderMargin(double headerMargin) {
        this._headerMargin = headerMargin;
    }

    public double getFooterMargin() {
        return this._footerMargin;
    }

    public void setFooterMargin(double footerMargin) {
        this._footerMargin = footerMargin;
    }

    public double getLeftMargin() {
        return this._leftMargin;
    }

    public void setLeftMargin(double leftMargin) {
        this._leftMargin = leftMargin;
    }

    public double getRightMargin() {
        return this._rightMargin;
    }

    public void setRightMargin(double rightMargin) {
        this._rightMargin = rightMargin;
    }

    public double getTopMargin() {
        return this._topMargin;
    }

    public void setTopMargin(double topMargin) {
        this._topMargin = topMargin;
    }

    public double getBottomMargin() {
        return this._bottomMargin;
    }

    public void setBottomMargin(double bottomMargin) {
        this._bottomMargin = bottomMargin;
    }

    public void setPaperSize(SPrintSetup.PaperSize size) {
        this._paperSize = size;
    }

    public SPrintSetup.PaperSize getPaperSize() {
        return this._paperSize;
    }

    public void setLandscape(boolean landscape) {
        this._landscape = landscape;
    }

    public boolean isLandscape() {
        return this._landscape;
    }

    public void setScale(int scale) {
        if (scale < 10 || scale > 400) {
            scale = 100;
        }
        this._scale = scale;
    }

    public int getScale() {
        return this._scale;
    }

    public void copyFrom(PrintSetupImpl src) {
        this._printGridlines = src._printGridlines;
        this._headerMargin = src._headerMargin;
        this._footerMargin = src._footerMargin;
        this._leftMargin = src._leftMargin;
        this._rightMargin = src._rightMargin;
        this._topMargin = src._topMargin;
        this._bottomMargin = src._bottomMargin;
        this._landscape = src._landscape;
        this.setScale(src._scale);
        this._paperSize = src._paperSize;
        HeaderFooterImpl srcHF = (HeaderFooterImpl)src._header;
        if (srcHF != null) {
            this._header = srcHF.cloneHeaderFooterImpl();
        }
        if ((srcHF = (HeaderFooterImpl)src._evenHeader) != null) {
            this._evenHeader = srcHF.cloneHeaderFooterImpl();
        }
        if ((srcHF = (HeaderFooterImpl)src._firstHeader) != null) {
            this._firstHeader = srcHF.cloneHeaderFooterImpl();
        }
        if ((srcHF = (HeaderFooterImpl)src._footer) != null) {
            this._footer = srcHF.cloneHeaderFooterImpl();
        }
        if ((srcHF = (HeaderFooterImpl)src._evenFooter) != null) {
            this._evenFooter = ((HeaderFooterImpl)src._evenFooter).cloneHeaderFooterImpl();
        }
        if ((srcHF = (HeaderFooterImpl)src._firstFooter) != null) {
            this._firstFooter = ((HeaderFooterImpl)src._firstFooter).cloneHeaderFooterImpl();
        }
        this._diffOddEven = src._diffOddEven;
        this._diffFirst = src._diffFirst;
        this._scaleWithDoc = src._scaleWithDoc;
        this._alignWithMargins = src._alignWithMargins;
        this._hCenter = src._hCenter;
        this._vCenter = src._vCenter;
        this._pageStart = src._pageStart;
        this._fitWidth = src._fitWidth;
        this._fitHeight = src._fitHeight;
        this._printArea = src._printArea;
        this._rowsTitle1 = src._rowsTitle1;
        this._rowsTitle2 = src._rowsTitle2;
        this._columnsTitle1 = src._columnsTitle1;
        this._columnsTitle2 = src._columnsTitle2;
        this._printHeadings = src._printHeadings;
        this._errorMode = src._errorMode;
        this._commentMode = src._commentMode;
        this._leftToRight = src._leftToRight;
    }

    public void setHeader(SHeader header) {
        this._header = header;
    }

    public SHeader getHeader() {
        return this._header;
    }

    public void setEvenHeader(SHeader header) {
        this._evenHeader = header;
    }

    public SHeader getEvenHeader() {
        return this._evenHeader;
    }

    public void setFirstHeader(SHeader header) {
        this._firstHeader = header;
    }

    public SHeader getFirstHeader() {
        return this._firstHeader;
    }

    public void setFooter(SFooter footer) {
        this._footer = footer;
    }

    public SFooter getFooter() {
        return this._footer;
    }

    public void setEvenFooter(SFooter footer) {
        this._evenFooter = footer;
    }

    public SFooter getEvenFooter() {
        return this._evenFooter;
    }

    public void setFirstFooter(SFooter footer) {
        this._firstFooter = footer;
    }

    public SFooter getFirstFooter() {
        return this._firstFooter;
    }

    public void setScaleWithDoc(boolean flag) {
        this._scaleWithDoc = flag;
    }

    public boolean isScaleWithDoc() {
        return this._scaleWithDoc;
    }

    public void setAlignWithMargins(boolean flag) {
        this._alignWithMargins = flag;
    }

    public boolean isAlignWithMargins() {
        return this._alignWithMargins;
    }

    public void setHCenter(boolean center) {
        this._hCenter = center;
    }

    public boolean isHCenter() {
        return this._hCenter;
    }

    public void setVCenter(boolean center) {
        this._vCenter = center;
    }

    public boolean isVCenter() {
        return this._vCenter;
    }

    public void setPageStart(int start) {
        this._pageStart = start;
    }

    public int getPageStart() {
        return this._pageStart;
    }

    public void setFitWidth(int numPages) {
        this._fitWidth = numPages;
    }

    public int getFitWidth() {
        return this._fitWidth;
    }

    public void setFitHeight(int numPages) {
        this._fitHeight = numPages;
    }

    public int getFitHeight() {
        return this._fitHeight;
    }

    public void setPrintArea(String formula) {
        this._printArea = formula;
    }

    public String getPrintArea() {
        return this._printArea;
    }

    public void setRepeatingRowsTitle(int firstRow, int lastRow) {
        this._rowsTitle1 = firstRow;
        this._rowsTitle2 = lastRow;
    }

    public CellRegion getRepeatingRowsTitle() {
        return this._rowsTitle1 >= 0 && this._rowsTitle2 >= this._rowsTitle1 ? new CellRegion(this._rowsTitle1, 0, this._rowsTitle2, 0) : null;
    }

    public void setRepeatingColumnsTitle(int firstCol, int lastCol) {
        this._columnsTitle1 = firstCol;
        this._columnsTitle2 = lastCol;
    }

    public CellRegion getRepeatingColumnsTitle() {
        return this._columnsTitle1 >= 0 && this._columnsTitle2 >= this._columnsTitle1 ? new CellRegion(0, this._columnsTitle1, 0, this._columnsTitle2) : null;
    }

    public void setPrintHeadings(boolean flag) {
        this._printHeadings = flag;
    }

    public boolean isPrintHeadings() {
        return this._printHeadings;
    }

    public void setCommentsMode(int mode) {
        this._commentMode = mode;
    }

    public int getCommentsMode() {
        return this._commentMode;
    }

    public void setErrorPrintMode(int mode) {
        this._errorMode = mode;
    }

    public int getErrorPrintMode() {
        return this._errorMode;
    }

    public void setLeftToRight(boolean flag) {
        this._leftToRight = flag;
    }

    public boolean isLeftToRight() {
        return this._leftToRight;
    }

    public void setDifferentOddEvenPage(boolean flag) {
        this._diffOddEven = flag;
    }

    public boolean isDifferentOddEvenPage() {
        return this._diffOddEven;
    }

    public void setDifferentFirstPage(boolean flag) {
        this._diffFirst = flag;
    }

    public boolean isDifferentFirstPage() {
        return this._diffFirst;
    }
}

