/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.model.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.zkoss.zss.model.CellRegion;
import org.zkoss.zss.model.SAutoFilter;
import org.zkoss.zss.model.SBook;
import org.zkoss.zss.model.SBookSeries;
import org.zkoss.zss.model.SCFValueObject;
import org.zkoss.zss.model.SCell;
import org.zkoss.zss.model.SChart;
import org.zkoss.zss.model.SConditionalFormatting;
import org.zkoss.zss.model.SConditionalFormattingRule;
import org.zkoss.zss.model.SDataValidation;
import org.zkoss.zss.model.SName;
import org.zkoss.zss.model.SSheet;
import org.zkoss.zss.model.STable;
import org.zkoss.zss.model.SheetRegion;
import org.zkoss.zss.model.chart.SChartData;
import org.zkoss.zss.model.chart.SGeneralChartData;
import org.zkoss.zss.model.chart.SSeries;
import org.zkoss.zss.model.impl.AbstractAutoFilterAdv;
import org.zkoss.zss.model.impl.AbstractBookSeriesAdv;
import org.zkoss.zss.model.impl.AbstractCellAdv;
import org.zkoss.zss.model.impl.AbstractDataValidationAdv;
import org.zkoss.zss.model.impl.AbstractNameAdv;
import org.zkoss.zss.model.impl.AbstractSeriesAdv;
import org.zkoss.zss.model.impl.AbstractSheetAdv;
import org.zkoss.zss.model.impl.AutoFilterImpl;
import org.zkoss.zss.model.impl.CFValueObjectImpl;
import org.zkoss.zss.model.impl.ConditionalFormattingImpl;
import org.zkoss.zss.model.impl.ConditionalFormattingRuleImpl;
import org.zkoss.zss.model.impl.ModelUpdateUtil;
import org.zkoss.zss.model.impl.SheetImpl;
import org.zkoss.zss.model.impl.chart.AbstractGeneralChartDataAdv;
import org.zkoss.zss.model.sys.EngineFactory;
import org.zkoss.zss.model.sys.dependency.ConditionalRef;
import org.zkoss.zss.model.sys.dependency.DependencyTable;
import org.zkoss.zss.model.sys.dependency.NameRef;
import org.zkoss.zss.model.sys.dependency.ObjectRef;
import org.zkoss.zss.model.sys.dependency.Ref;
import org.zkoss.zss.model.sys.formula.FormulaEngine;
import org.zkoss.zss.model.sys.formula.FormulaExpression;
import org.zkoss.zss.model.sys.formula.FormulaParseContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FormulaTunerHelper
implements Serializable {
    private static final long serialVersionUID = 1102626197326199285L;
    private final SBookSeries _bookSeries;
    private FormulaEngine engine;

    public FormulaTunerHelper(SBookSeries bookSeries) {
        this._bookSeries = bookSeries;
    }

    public void move(SheetRegion sheetRegion, Set<Ref> dependents, int rowOffset, int columnOffset) {
        LinkedHashMap<String, Ref> chartDependents = new LinkedHashMap<String, Ref>();
        LinkedHashMap<String, Ref> validationDependents = new LinkedHashMap<String, Ref>();
        LinkedHashSet<Ref> cellDependents = new LinkedHashSet<Ref>();
        LinkedHashMap<String, Ref> nameDependents = new LinkedHashMap<String, Ref>();
        LinkedHashSet<Ref> filterDependents = new LinkedHashSet<Ref>();
        LinkedHashMap<Integer, Ref> conditionalDependents = new LinkedHashMap<Integer, Ref>();
        this.splitDependents(dependents, cellDependents, chartDependents, validationDependents, nameDependents, filterDependents, conditionalDependents);
        for (Ref dependent : cellDependents) {
            this.moveCellRef(sheetRegion, dependent, rowOffset, columnOffset);
        }
        for (Ref dependent : chartDependents.values()) {
            this.moveChartRef(sheetRegion, (ObjectRef)dependent, rowOffset, columnOffset);
        }
        for (Ref dependent : validationDependents.values()) {
            this.moveDataValidationRef(sheetRegion, (ObjectRef)dependent, rowOffset, columnOffset);
        }
        for (Ref dependent : nameDependents.values()) {
            this.moveNameRef(sheetRegion, (NameRef)dependent, rowOffset, columnOffset);
        }
        for (Ref dependent : filterDependents) {
            this.moveFilterRef(sheetRegion, (ObjectRef)dependent, rowOffset, columnOffset);
        }
        for (Ref dependent : conditionalDependents.values()) {
            this.moveConditionalRef(sheetRegion, (ConditionalRef)dependent, rowOffset, columnOffset);
        }
    }

    private void moveChartRef(SheetRegion sheetRegion, ObjectRef dependent, int rowOffset, int columnOffset) {
        FormulaExpression exprAfter;
        SBook book = this._bookSeries.getBook(dependent.getBookName());
        if (book == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(dependent.getSheetName());
        if (sheet == null) {
            return;
        }
        SChart chart = sheet.getChart(dependent.getObjectIdPath()[0]);
        if (chart == null) {
            return;
        }
        SChartData d = chart.getData();
        if (!(d instanceof SGeneralChartData)) {
            return;
        }
        FormulaEngine engine = this.getFormulaEngine();
        SGeneralChartData data = (SGeneralChartData)d;
        FormulaExpression catExpr = ((AbstractGeneralChartDataAdv)((Object)data)).getCategoriesFormulaExpression();
        if (catExpr != null) {
            exprAfter = engine.movePtgs(catExpr, sheetRegion, rowOffset, columnOffset, new FormulaParseContext(sheet, null));
            if (!exprAfter.hasError() && !catExpr.getFormulaString().equals(exprAfter.getFormulaString())) {
                ((AbstractGeneralChartDataAdv)((Object)data)).setCategoriesFormula(exprAfter);
            } else {
                data.clearFormulaResultCache();
            }
        }
        for (int i = 0; i < data.getNumOfSeries(); ++i) {
            SSeries series = data.getSeries(i);
            FormulaExpression nameExpr = ((AbstractSeriesAdv)series).getNameFormulaExpression();
            FormulaExpression xvalExpr = ((AbstractSeriesAdv)series).getXValuesFormulaExpression();
            FormulaExpression yvalExpr = ((AbstractSeriesAdv)series).getYValuesFormulaExpression();
            FormulaExpression zvalExpr = ((AbstractSeriesAdv)series).getZValuesFormulaExpression();
            boolean dirty = false;
            if (nameExpr != null && !(exprAfter = engine.movePtgs(nameExpr, sheetRegion, rowOffset, columnOffset, new FormulaParseContext(sheet, null))).hasError()) {
                dirty |= !nameExpr.getFormulaString().equals(exprAfter.getFormulaString());
                nameExpr = exprAfter;
            }
            if (xvalExpr != null && !(exprAfter = engine.movePtgs(xvalExpr, sheetRegion, rowOffset, columnOffset, new FormulaParseContext(sheet, null))).hasError()) {
                dirty |= !xvalExpr.getFormulaString().equals(exprAfter.getFormulaString());
                xvalExpr = exprAfter;
            }
            if (yvalExpr != null && !(exprAfter = engine.movePtgs(yvalExpr, sheetRegion, rowOffset, columnOffset, new FormulaParseContext(sheet, null))).hasError()) {
                dirty |= !yvalExpr.getFormulaString().equals(exprAfter.getFormulaString());
                yvalExpr = exprAfter;
            }
            if (zvalExpr != null && !(exprAfter = engine.movePtgs(zvalExpr, sheetRegion, rowOffset, columnOffset, new FormulaParseContext(sheet, null))).hasError()) {
                dirty |= !zvalExpr.getFormulaString().equals(exprAfter.getFormulaString());
                zvalExpr = exprAfter;
            }
            if (dirty) {
                ((AbstractSeriesAdv)series).setXYZFormula(nameExpr, xvalExpr, yvalExpr, zvalExpr);
                continue;
            }
            series.clearFormulaResultCache();
        }
        ModelUpdateUtil.addRefUpdate(dependent);
    }

    private void moveFilterRef(SheetRegion sheetRegion, ObjectRef dependent, int rowOffset, int columnOffset) {
        FormulaParseContext context;
        CellRegion region;
        String area;
        FormulaExpression fexpr;
        SBook book = this._bookSeries.getBook(dependent.getBookName());
        if (book == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(dependent.getSheetName());
        if (sheet == null) {
            return;
        }
        SAutoFilter filter = sheet.getAutoFilter();
        if (filter == null) {
            return;
        }
        FormulaEngine engine = this.getFormulaEngine();
        FormulaExpression expr2 = engine.movePtgs(fexpr = engine.parse(area = (region = filter.getRegion()).getReferenceString(), context = new FormulaParseContext(sheet, null)), sheetRegion, rowOffset, columnOffset, context);
        if (!expr2.hasError() && !area.equals(expr2.getFormulaString())) {
            sheet.deleteAutoFilter();
            if (!"#REF!".equals(expr2.getFormulaString())) {
                CellRegion region2 = new CellRegion(expr2.getFormulaString());
                sheet.createAutoFilter(region2);
            }
        }
        ModelUpdateUtil.addRefUpdate(dependent);
    }

    private void moveDataValidationRef(SheetRegion sheetRegion, ObjectRef dependent, int rowOffset, int columnOffset) {
        FormulaExpression exprf2;
        FormulaExpression exprf1;
        SBook book = this._bookSeries.getBook(dependent.getBookName());
        if (book == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(dependent.getSheetName());
        if (sheet == null) {
            return;
        }
        SDataValidation validation = sheet.getDataValidation(dependent.getObjectIdPath()[0]);
        if (validation == null) {
            return;
        }
        FormulaEngine engine = this.getFormulaEngine();
        FormulaExpression f1 = ((AbstractDataValidationAdv)validation).getFormulaExpression1();
        FormulaExpression f2 = ((AbstractDataValidationAdv)validation).getFormulaExpression2();
        boolean changed = false;
        if (f1 != null && !(exprf1 = engine.movePtgs(f1, sheetRegion, rowOffset, columnOffset, new FormulaParseContext(sheet, null))).hasError() && !f1.getFormulaString().equals(exprf1.getFormulaString())) {
            f1 = exprf1;
            changed = true;
        }
        if (f2 != null && !(exprf2 = engine.movePtgs(f2, sheetRegion, rowOffset, columnOffset, new FormulaParseContext(sheet, null))).hasError() && !f2.getFormulaString().equals(exprf2.getFormulaString())) {
            f2 = exprf2;
            changed = true;
        }
        if (changed) {
            ((AbstractDataValidationAdv)validation).setFormulas(f1, f2);
        } else {
            validation.clearFormulaResultCache();
        }
        ArrayList<CellRegion> regions = new ArrayList<CellRegion>(validation.getRegions());
        for (CellRegion region : regions) {
            FormulaParseContext context;
            String sqref = region.getReferenceString();
            FormulaExpression fexpr = engine.parse(sqref, context = new FormulaParseContext(sheet, null));
            FormulaExpression expr2 = engine.movePtgs(fexpr, sheetRegion, rowOffset, columnOffset, context);
            if (expr2.hasError() || sqref.equals(expr2.getFormulaString())) continue;
            if ("#REF!".equals(expr2.getFormulaString())) {
                ((AbstractDataValidationAdv)validation).removeRegion(region);
                if (validation.getRegions() != null) continue;
                sheet.deleteDataValidation(validation);
                continue;
            }
            ((AbstractDataValidationAdv)validation).removeRegion(region);
            region = new CellRegion(expr2.getFormulaString());
            ((AbstractDataValidationAdv)validation).addRegion(region);
        }
        ModelUpdateUtil.addRefUpdate(dependent);
    }

    private void moveConditionalRef(SheetRegion sheetRegion, ConditionalRef dependent, int rowOffset, int columnOffset) {
        SBook book = this._bookSeries.getBook(dependent.getBookName());
        if (book == null) {
            return;
        }
        AbstractSheetAdv sheet = (AbstractSheetAdv)book.getSheetByName(dependent.getSheetName());
        if (sheet == null) {
            return;
        }
        ConditionalFormattingImpl cfmt = (ConditionalFormattingImpl)((Object)((SheetImpl)sheet).getDataValidation(dependent.getConditionalId()));
        if (cfmt == null) {
            return;
        }
        FormulaEngine engine = this.getFormulaEngine();
        for (SConditionalFormattingRule rule0 : cfmt.getRules()) {
            FormulaExpression exprf;
            FormulaExpression f;
            CFValueObjectImpl cvo;
            FormulaExpression exprf3;
            FormulaExpression exprf2;
            FormulaExpression exprf1;
            ConditionalFormattingRuleImpl rule = (ConditionalFormattingRuleImpl)rule0;
            FormulaExpression f1 = rule.getFormulaExpression1();
            FormulaExpression f2 = rule.getFormulaExpression2();
            FormulaExpression f3 = rule.getFormulaExpression3();
            boolean changed = false;
            if (f1 != null && !(exprf1 = engine.movePtgs(f1, sheetRegion, rowOffset, columnOffset, new FormulaParseContext(sheet, null))).hasError() && !f1.getFormulaString().equals(exprf1.getFormulaString())) {
                f1 = exprf1;
                changed = true;
            }
            if (f2 != null && !(exprf2 = engine.movePtgs(f2, sheetRegion, rowOffset, columnOffset, new FormulaParseContext(sheet, null))).hasError() && !f2.getFormulaString().equals(exprf2.getFormulaString())) {
                f2 = exprf2;
                changed = true;
            }
            if (f3 != null && !(exprf3 = engine.movePtgs(f3, sheetRegion, rowOffset, columnOffset, new FormulaParseContext(sheet, null))).hasError() && !f3.getFormulaString().equals(exprf3.getFormulaString())) {
                f3 = exprf3;
                changed = true;
            }
            if (changed) {
                rule.setFormulas(f1, f2, f3);
            } else {
                cfmt.clearFormulaResultCache();
            }
            changed = false;
            if (rule.getColorScale() != null) {
                for (SCFValueObject cvo0 : rule.getColorScale().getCFValueObjects()) {
                    cvo = (CFValueObjectImpl)cvo0;
                    f = cvo.getFormulaExpression();
                    if (f == null || (exprf = engine.movePtgs(f, sheetRegion, rowOffset, columnOffset, new FormulaParseContext(sheet, null))).hasError() || f.getFormulaString().equals(exprf.getFormulaString())) continue;
                    cvo.setFormulaExpression(exprf);
                    changed = true;
                }
            }
            if (rule.getDataBar() != null) {
                for (SCFValueObject cvo0 : rule.getDataBar().getCFValueObjects()) {
                    cvo = (CFValueObjectImpl)cvo0;
                    f = cvo.getFormulaExpression();
                    if (f == null || (exprf = engine.movePtgs(f, sheetRegion, rowOffset, columnOffset, new FormulaParseContext(sheet, null))).hasError() || f.getFormulaString().equals(exprf.getFormulaString())) continue;
                    cvo.setFormulaExpression(exprf);
                    changed = true;
                }
            }
            if (rule.getIconSet() != null) {
                for (SCFValueObject cvo0 : rule.getIconSet().getCFValueObjects()) {
                    cvo = (CFValueObjectImpl)cvo0;
                    f = cvo.getFormulaExpression();
                    if (f == null || (exprf = engine.movePtgs(f, sheetRegion, rowOffset, columnOffset, new FormulaParseContext(sheet, null))).hasError() || f.getFormulaString().equals(exprf.getFormulaString())) continue;
                    cvo.setFormulaExpression(exprf);
                    changed = true;
                }
            }
            if (!changed) continue;
            rule.clearFormulaResultCache();
        }
        ArrayList<CellRegion> regions = new ArrayList<CellRegion>(cfmt.getRegions());
        for (CellRegion region : regions) {
            FormulaParseContext context;
            String sqref = region.getReferenceString();
            FormulaExpression fexpr = engine.parse(sqref, context = new FormulaParseContext(sheet, null));
            FormulaExpression expr2 = engine.movePtgs(fexpr, sheetRegion, rowOffset, columnOffset, context);
            if (expr2.hasError() || sqref.equals(expr2.getFormulaString())) continue;
            if ("#REF!".equals(expr2.getFormulaString())) {
                cfmt.removeRegion(region);
                if (cfmt.getRegions() != null) continue;
                sheet.deleteConditionalFormatting(cfmt);
                continue;
            }
            cfmt.removeRegion(region);
            region = new CellRegion(expr2.getFormulaString());
            cfmt.addRegion(region);
        }
        ModelUpdateUtil.addRefUpdate(dependent);
    }

    private void moveCellRef(SheetRegion sheetRegion, Ref dependent, int rowOffset, int columnOffset) {
        SBook book = this._bookSeries.getBook(dependent.getBookName());
        if (book == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(dependent.getSheetName());
        if (sheet == null) {
            return;
        }
        SCell cell = sheet.getCell(dependent.getRow(), dependent.getColumn());
        if (cell.getType() != SCell.CellType.FORMULA) {
            return;
        }
        FormulaExpression expr = (FormulaExpression)((AbstractCellAdv)cell).getValue(false);
        FormulaEngine engine = this.getFormulaEngine();
        FormulaExpression exprAfter = engine.movePtgs(expr, sheetRegion, rowOffset, columnOffset, new FormulaParseContext(cell, null));
        if (!expr.getFormulaString().equals(exprAfter.getFormulaString())) {
            cell.setValue(exprAfter);
        } else {
            cell.clearFormulaResultCache();
            ModelUpdateUtil.addRefUpdate(dependent);
        }
    }

    private void moveNameRef(SheetRegion sheetRegion, NameRef dependent, int rowOffset, int columnOffset) {
        SBook book = this._bookSeries.getBook(dependent.getBookName());
        if (book == null) {
            return;
        }
        SName name = book.getNameByName(dependent.getNameName(), dependent.getSheetName());
        if (name == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(name.getRefersToSheetName());
        if (sheet == null) {
            return;
        }
        FormulaExpression expr = ((AbstractNameAdv)name).getRefersToFormulaExpression();
        FormulaEngine engine = this.getFormulaEngine();
        FormulaExpression exprAfter = engine.movePtgs(expr, sheetRegion, rowOffset, columnOffset, new FormulaParseContext(sheet, null));
        if (!expr.getFormulaString().equals(exprAfter.getFormulaString())) {
            ((AbstractNameAdv)name).setRefersToFormula(exprAfter);
        } else {
            this.clearFormulaCache(dependent);
            ModelUpdateUtil.addRefUpdate(dependent);
        }
    }

    private FormulaEngine getFormulaEngine() {
        if (this.engine == null) {
            this.engine = EngineFactory.getInstance().createFormulaEngine();
        }
        return this.engine;
    }

    public void extend(SheetRegion sheetRegion, Set<Ref> dependents, boolean horizontal) {
        LinkedHashMap<String, Ref> chartDependents = new LinkedHashMap<String, Ref>();
        LinkedHashMap<String, Ref> validationDependents = new LinkedHashMap<String, Ref>();
        LinkedHashSet<Ref> cellDependents = new LinkedHashSet<Ref>();
        LinkedHashMap<String, Ref> nameDependents = new LinkedHashMap<String, Ref>();
        LinkedHashSet<Ref> filterDependents = new LinkedHashSet<Ref>();
        LinkedHashMap<Integer, Ref> conditionalDependents = new LinkedHashMap<Integer, Ref>();
        this.splitDependents(dependents, cellDependents, chartDependents, validationDependents, nameDependents, filterDependents, conditionalDependents);
        for (Ref dependent : cellDependents) {
            this.extendCellRef(sheetRegion, dependent, horizontal);
        }
        for (Ref dependent : chartDependents.values()) {
            this.extendChartRef(sheetRegion, (ObjectRef)dependent, horizontal);
        }
        for (Ref dependent : validationDependents.values()) {
            this.extendDataValidationRef(sheetRegion, (ObjectRef)dependent, horizontal);
        }
        for (Ref dependent : nameDependents.values()) {
            this.extendNameRef(sheetRegion, (NameRef)dependent, horizontal);
        }
        for (Ref dependent : filterDependents) {
            this.extendFilterRef(sheetRegion, (ObjectRef)dependent, horizontal);
        }
        for (Ref dependent : conditionalDependents.values()) {
            this.extendConditionalRef(sheetRegion, (ConditionalRef)dependent, horizontal);
        }
    }

    private void extendChartRef(SheetRegion sheetRegion, ObjectRef dependent, boolean horizontal) {
        SBook book = this._bookSeries.getBook(dependent.getBookName());
        if (book == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(dependent.getSheetName());
        if (sheet == null) {
            return;
        }
        SChart chart = sheet.getChart(dependent.getObjectIdPath()[0]);
        if (chart == null) {
            return;
        }
        SChartData d = chart.getData();
        if (!(d instanceof SGeneralChartData)) {
            return;
        }
        SGeneralChartData data = (SGeneralChartData)d;
        FormulaEngine engine = this.getFormulaEngine();
        for (int i = 0; i < data.getNumOfSeries(); ++i) {
            FormulaExpression expr2;
            SSeries series = data.getSeries(i);
            if (series == null) continue;
            boolean changed = false;
            series.clearFormulaResultCache();
            FormulaExpression nf = ((AbstractSeriesAdv)series).getNameFormulaExpression();
            FormulaExpression xf = ((AbstractSeriesAdv)series).getXValuesFormulaExpression();
            FormulaExpression yf = ((AbstractSeriesAdv)series).getYValuesFormulaExpression();
            FormulaExpression zf = ((AbstractSeriesAdv)series).getZValuesFormulaExpression();
            if (nf != null && !(expr2 = engine.extendPtgs(nf, sheetRegion, horizontal, new FormulaParseContext(sheet, null))).hasError() && !nf.getFormulaString().equals(expr2.getFormulaString())) {
                nf = expr2;
                changed = true;
            }
            if (xf != null && !(expr2 = engine.extendPtgs(xf, sheetRegion, horizontal, new FormulaParseContext(sheet, null))).hasError() && !xf.getFormulaString().equals(expr2.getFormulaString())) {
                xf = expr2;
                changed = true;
            }
            if (yf != null && !(expr2 = engine.extendPtgs(yf, sheetRegion, horizontal, new FormulaParseContext(sheet, null))).hasError() && !yf.getFormulaString().equals(expr2.getFormulaString())) {
                yf = expr2;
                changed = true;
            }
            if (zf != null && !(expr2 = engine.extendPtgs(zf, sheetRegion, horizontal, new FormulaParseContext(sheet, null))).hasError() && !zf.getFormulaString().equals(expr2.getFormulaString())) {
                zf = expr2;
                changed = true;
            }
            if (changed) {
                ((AbstractSeriesAdv)series).setXYZFormula(nf, xf, yf, zf);
                continue;
            }
            series.clearFormulaResultCache();
        }
        FormulaExpression expr = ((AbstractGeneralChartDataAdv)((Object)data)).getCategoriesFormulaExpression();
        if (expr != null) {
            FormulaExpression exprAfter = engine.extendPtgs(expr, sheetRegion, horizontal, new FormulaParseContext(sheet, null));
            if (!exprAfter.hasError() && !expr.getFormulaString().equals(exprAfter.getFormulaString())) {
                ((AbstractGeneralChartDataAdv)((Object)data)).setCategoriesFormula(exprAfter);
            } else {
                data.clearFormulaResultCache();
            }
        }
        ModelUpdateUtil.addRefUpdate(dependent);
    }

    private void extendDataValidationRef(SheetRegion sheetRegion, ObjectRef dependent, boolean horizontal) {
        FormulaExpression exprf2;
        FormulaExpression exprf1;
        SBook book = this._bookSeries.getBook(dependent.getBookName());
        if (book == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(dependent.getSheetName());
        if (sheet == null) {
            return;
        }
        SDataValidation validation = sheet.getDataValidation(dependent.getObjectIdPath()[0]);
        if (validation == null) {
            return;
        }
        FormulaEngine engine = this.getFormulaEngine();
        FormulaExpression f1 = ((AbstractDataValidationAdv)validation).getFormulaExpression1();
        FormulaExpression f2 = ((AbstractDataValidationAdv)validation).getFormulaExpression2();
        boolean changed = false;
        if (f1 != null && !(exprf1 = engine.extendPtgs(f1, sheetRegion, horizontal, new FormulaParseContext(sheet, null))).hasError() && !f1.getFormulaString().equals(exprf1.getFormulaString())) {
            f1 = exprf1;
            changed = true;
        }
        if (f2 != null && !(exprf2 = engine.extendPtgs(f2, sheetRegion, horizontal, new FormulaParseContext(sheet, null))).hasError() && !f2.getFormulaString().equals(exprf2.getFormulaString())) {
            f2 = exprf2;
            changed = true;
        }
        if (changed) {
            ((AbstractDataValidationAdv)validation).setFormulas(f1, f2);
        } else {
            validation.clearFormulaResultCache();
        }
        FormulaParseContext context = new FormulaParseContext(sheet, null);
        ArrayList<CellRegion> regions = new ArrayList<CellRegion>(validation.getRegions());
        for (CellRegion region : regions) {
            String sqref = region.getReferenceString();
            FormulaExpression fexpr = engine.parse(sqref, context);
            FormulaExpression expr2 = engine.extendPtgs(fexpr, sheetRegion, horizontal, context);
            if (expr2.hasError() || sqref.equals(expr2.getFormulaString())) continue;
            if ("#REF!".equals(expr2.getFormulaString())) {
                ((AbstractDataValidationAdv)validation).removeRegion(region);
                if (validation.getRegions() != null) continue;
                sheet.deleteDataValidation(validation);
                continue;
            }
            ((AbstractDataValidationAdv)validation).removeRegion(region);
            CellRegion region0 = new CellRegion(expr2.getFormulaString());
            ((AbstractDataValidationAdv)validation).addRegion(region0);
        }
        ModelUpdateUtil.addRefUpdate(dependent);
    }

    private void extendConditionalRef(SheetRegion sheetRegion, ConditionalRef dependent, boolean horizontal) {
        SBook book = this._bookSeries.getBook(dependent.getBookName());
        if (book == null) {
            return;
        }
        AbstractSheetAdv sheet = (AbstractSheetAdv)book.getSheetByName(dependent.getSheetName());
        if (sheet == null) {
            return;
        }
        SConditionalFormatting cfmt = sheet.getConditionalFormatting(dependent.getConditionalId());
        if (cfmt == null) {
            return;
        }
        FormulaEngine engine = this.getFormulaEngine();
        for (SConditionalFormattingRule rule0 : cfmt.getRules()) {
            FormulaExpression exprf;
            FormulaExpression f;
            CFValueObjectImpl cvo;
            SCFValueObject cvo0;
            Iterator<SCFValueObject> exprf3;
            FormulaExpression exprf2;
            FormulaExpression exprf1;
            ConditionalFormattingRuleImpl rule = (ConditionalFormattingRuleImpl)rule0;
            FormulaExpression f1 = rule.getFormulaExpression1();
            FormulaExpression f2 = rule.getFormulaExpression2();
            Object f3 = rule.getFormulaExpression3();
            boolean changed = false;
            if (f1 != null && !(exprf1 = engine.extendPtgs(f1, sheetRegion, horizontal, new FormulaParseContext(sheet, null))).hasError() && !f1.getFormulaString().equals(exprf1.getFormulaString())) {
                f1 = exprf1;
                changed = true;
            }
            if (f2 != null && !(exprf2 = engine.extendPtgs(f2, sheetRegion, horizontal, new FormulaParseContext(sheet, null))).hasError() && !f2.getFormulaString().equals(exprf2.getFormulaString())) {
                f2 = exprf2;
                changed = true;
            }
            if (f3 != null && !(exprf3 = engine.extendPtgs((FormulaExpression)f3, sheetRegion, horizontal, new FormulaParseContext(sheet, null))).hasError() && !f3.getFormulaString().equals(exprf3.getFormulaString())) {
                f3 = exprf3;
                changed = true;
            }
            if (changed) {
                rule.setFormulas(f1, f2, (FormulaExpression)f3);
            } else {
                rule.clearFormulaResultCache();
            }
            changed = false;
            if (rule.getColorScale() != null) {
                exprf3 = rule.getColorScale().getCFValueObjects().iterator();
                while (exprf3.hasNext()) {
                    cvo0 = exprf3.next();
                    cvo = (CFValueObjectImpl)cvo0;
                    f = cvo.getFormulaExpression();
                    if (f == null || (exprf = engine.extendPtgs(f, sheetRegion, horizontal, new FormulaParseContext(sheet, null))).hasError() || f.getFormulaString().equals(exprf.getFormulaString())) continue;
                    cvo.setFormulaExpression(exprf);
                    changed = true;
                }
            }
            if (rule.getDataBar() != null) {
                exprf3 = rule.getDataBar().getCFValueObjects().iterator();
                while (exprf3.hasNext()) {
                    cvo0 = exprf3.next();
                    cvo = (CFValueObjectImpl)cvo0;
                    f = cvo.getFormulaExpression();
                    if (f == null || (exprf = engine.extendPtgs(f, sheetRegion, horizontal, new FormulaParseContext(sheet, null))).hasError() || f.getFormulaString().equals(exprf.getFormulaString())) continue;
                    cvo.setFormulaExpression(exprf);
                    changed = true;
                }
            }
            if (rule.getIconSet() != null) {
                exprf3 = rule.getIconSet().getCFValueObjects().iterator();
                while (exprf3.hasNext()) {
                    cvo0 = exprf3.next();
                    cvo = (CFValueObjectImpl)cvo0;
                    f = cvo.getFormulaExpression();
                    if (f == null || (exprf = engine.extendPtgs(f, sheetRegion, horizontal, new FormulaParseContext(sheet, null))).hasError() || f.getFormulaString().equals(exprf.getFormulaString())) continue;
                    cvo.setFormulaExpression(exprf);
                    changed = true;
                }
            }
            if (!changed) continue;
            rule.clearFormulaResultCache();
        }
        FormulaParseContext context = new FormulaParseContext(sheet, null);
        ArrayList<CellRegion> regions = new ArrayList<CellRegion>(cfmt.getRegions());
        for (CellRegion region : regions) {
            String sqref = region.getReferenceString();
            FormulaExpression fexpr = engine.parse(sqref, context);
            FormulaExpression expr2 = engine.extendPtgs(fexpr, sheetRegion, horizontal, context);
            if (expr2.hasError() || sqref.equals(expr2.getFormulaString())) continue;
            if ("#REF!".equals(expr2.getFormulaString())) {
                cfmt.removeRegion(region);
                if (cfmt.getRegions() != null) continue;
                sheet.deleteConditionalFormatting(cfmt);
                continue;
            }
            cfmt.removeRegion(region);
            CellRegion region0 = new CellRegion(expr2.getFormulaString());
            cfmt.addRegion(region0);
        }
        ModelUpdateUtil.addRefUpdate(dependent);
    }

    private void extendFilterRef(SheetRegion sheetRegion, ObjectRef dependent, boolean horizontal) {
        FormulaParseContext context;
        CellRegion region;
        String area;
        FormulaExpression fexpr;
        SBook book = this._bookSeries.getBook(dependent.getBookName());
        if (book == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(dependent.getSheetName());
        if (sheet == null) {
            return;
        }
        SAutoFilter filter = sheet.getAutoFilter();
        if (filter == null) {
            return;
        }
        FormulaEngine engine = this.getFormulaEngine();
        FormulaExpression expr2 = engine.extendPtgs(fexpr = engine.parse(area = (region = filter.getRegion()).getReferenceString(), context = new FormulaParseContext(sheet, null)), sheetRegion, horizontal, context);
        if (!expr2.hasError() && !area.equals(expr2.getFormulaString())) {
            Collection<SAutoFilter.NFilterColumn> fcols = horizontal ? filter.getFilterColumns() : null;
            sheet.deleteAutoFilter();
            if (!"#REF!".equals(expr2.getFormulaString())) {
                CellRegion region2 = new CellRegion(expr2.getFormulaString());
                AutoFilterImpl nfilter = (AutoFilterImpl)sheet.createAutoFilter(region2);
                if (fcols != null) {
                    int start = sheetRegion.getColumn() - region.getColumn();
                    int offset = start > 0 ? sheetRegion.getColumnCount() : 0;
                    for (SAutoFilter.NFilterColumn fcol : fcols) {
                        int index0 = fcol.getIndex() + (fcol.getIndex() >= start ? offset : 0);
                        ((AbstractAutoFilterAdv.FilterColumnImpl)fcol).setIndex(index0);
                        nfilter.putFilterColumn(fcol.getIndex(), fcol);
                    }
                }
            }
        }
        ModelUpdateUtil.addRefUpdate(dependent);
    }

    private void extendCellRef(SheetRegion sheetRegion, Ref dependent, boolean horizontal) {
        SBook book = this._bookSeries.getBook(dependent.getBookName());
        if (book == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(dependent.getSheetName());
        if (sheet == null) {
            return;
        }
        SCell cell = sheet.getCell(dependent.getRow(), dependent.getColumn());
        if (cell.getType() != SCell.CellType.FORMULA) {
            return;
        }
        FormulaExpression fexpr = (FormulaExpression)((AbstractCellAdv)cell).getValue(false);
        FormulaEngine engine = this.getFormulaEngine();
        FormulaExpression exprAfter = engine.extendPtgs(fexpr, sheetRegion, horizontal, new FormulaParseContext(sheet, null));
        if (!fexpr.getFormulaString().equals(exprAfter.getFormulaString())) {
            cell.setValue(exprAfter);
        } else {
            cell.clearFormulaResultCache();
            ModelUpdateUtil.addRefUpdate(dependent);
        }
    }

    private void extendNameRef(SheetRegion sheetRegion, NameRef dependent, boolean horizontal) {
        SBook book = this._bookSeries.getBook(dependent.getBookName());
        if (book == null) {
            return;
        }
        SName name = book.getNameByName(dependent.getNameName(), dependent.getSheetName());
        if (name == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(name.getRefersToSheetName());
        if (sheet == null) {
            return;
        }
        FormulaExpression expr = ((AbstractNameAdv)name).getRefersToFormulaExpression();
        FormulaEngine engine = this.getFormulaEngine();
        FormulaExpression exprAfter = engine.extendPtgs(expr, sheetRegion, horizontal, new FormulaParseContext(sheet, null));
        if (!expr.getFormulaString().equals(exprAfter.getFormulaString())) {
            ((AbstractNameAdv)name).setRefersToFormula(exprAfter);
        } else {
            this.clearFormulaCache(dependent);
            ModelUpdateUtil.addRefUpdate(dependent);
        }
    }

    public void shrink(SheetRegion sheetRegion, Set<Ref> dependents, boolean horizontal) {
        LinkedHashMap<String, Ref> chartDependents = new LinkedHashMap<String, Ref>();
        LinkedHashMap<String, Ref> validationDependents = new LinkedHashMap<String, Ref>();
        LinkedHashSet<Ref> cellDependents = new LinkedHashSet<Ref>();
        LinkedHashMap<String, Ref> nameDependents = new LinkedHashMap<String, Ref>();
        LinkedHashSet<Ref> filterDependents = new LinkedHashSet<Ref>();
        LinkedHashMap<Integer, Ref> conditionalDependents = new LinkedHashMap<Integer, Ref>();
        this.splitDependents(dependents, cellDependents, chartDependents, validationDependents, nameDependents, filterDependents, conditionalDependents);
        for (Ref dependent : cellDependents) {
            this.shrinkCellRef(sheetRegion, dependent, horizontal);
        }
        for (Ref dependent : chartDependents.values()) {
            this.shrinkChartRef(sheetRegion, (ObjectRef)dependent, horizontal);
        }
        for (Ref dependent : validationDependents.values()) {
            this.shrinkDataValidationRef(sheetRegion, (ObjectRef)dependent, horizontal);
        }
        for (Ref dependent : nameDependents.values()) {
            this.shrinkNameRef(sheetRegion, (NameRef)dependent, horizontal);
        }
        for (Ref dependent : filterDependents) {
            this.shrinkFilterRef(sheetRegion, (ObjectRef)dependent, horizontal);
        }
        for (Ref dependent : conditionalDependents.values()) {
            this.shrinkConditionalRef(sheetRegion, (ConditionalRef)dependent, horizontal);
        }
    }

    private void shrinkChartRef(SheetRegion sheetRegion, ObjectRef dependent, boolean horizontal) {
        SBook book = this._bookSeries.getBook(dependent.getBookName());
        if (book == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(dependent.getSheetName());
        if (sheet == null) {
            return;
        }
        SChart chart = sheet.getChart(dependent.getObjectIdPath()[0]);
        if (chart == null) {
            return;
        }
        SChartData d = chart.getData();
        if (!(d instanceof SGeneralChartData)) {
            return;
        }
        SGeneralChartData data = (SGeneralChartData)d;
        FormulaEngine engine = this.getFormulaEngine();
        for (int i = 0; i < data.getNumOfSeries(); ++i) {
            FormulaExpression expr2;
            SSeries series = data.getSeries(i);
            if (series == null) continue;
            boolean changed = false;
            series.clearFormulaResultCache();
            FormulaExpression nf = ((AbstractSeriesAdv)series).getNameFormulaExpression();
            FormulaExpression xf = ((AbstractSeriesAdv)series).getXValuesFormulaExpression();
            FormulaExpression yf = ((AbstractSeriesAdv)series).getYValuesFormulaExpression();
            FormulaExpression zf = ((AbstractSeriesAdv)series).getZValuesFormulaExpression();
            if (nf != null && !(expr2 = engine.shrinkPtgs(nf, sheetRegion, horizontal, new FormulaParseContext(sheet, null))).hasError() && !nf.getFormulaString().equals(expr2.getFormulaString())) {
                nf = expr2;
                changed = true;
            }
            if (xf != null && !(expr2 = engine.shrinkPtgs(xf, sheetRegion, horizontal, new FormulaParseContext(sheet, null))).hasError() && !xf.getFormulaString().equals(expr2.getFormulaString())) {
                xf = expr2;
                changed = true;
            }
            if (yf != null && !(expr2 = engine.shrinkPtgs(yf, sheetRegion, horizontal, new FormulaParseContext(sheet, null))).hasError() && !yf.getFormulaString().equals(expr2.getFormulaString())) {
                yf = expr2;
                changed = true;
            }
            if (zf != null && !(expr2 = engine.shrinkPtgs(zf, sheetRegion, horizontal, new FormulaParseContext(sheet, null))).hasError() && !zf.getFormulaString().equals(expr2.getFormulaString())) {
                zf = expr2;
                changed = true;
            }
            if (changed) {
                ((AbstractSeriesAdv)series).setXYZFormula(nf, xf, yf, zf);
                continue;
            }
            series.clearFormulaResultCache();
        }
        FormulaExpression expr = ((AbstractGeneralChartDataAdv)((Object)data)).getCategoriesFormulaExpression();
        if (expr != null) {
            FormulaExpression exprAfter = engine.shrinkPtgs(expr, sheetRegion, horizontal, new FormulaParseContext(sheet, null));
            if (!exprAfter.hasError() && !expr.getFormulaString().equals(exprAfter.getFormulaString())) {
                ((AbstractGeneralChartDataAdv)((Object)data)).setCategoriesFormula(exprAfter);
            } else {
                data.clearFormulaResultCache();
            }
        }
        ModelUpdateUtil.addRefUpdate(dependent);
    }

    private void shrinkDataValidationRef(SheetRegion sheetRegion, ObjectRef dependent, boolean horizontal) {
        FormulaExpression exprf2;
        FormulaExpression exprf1;
        SBook book = this._bookSeries.getBook(dependent.getBookName());
        if (book == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(dependent.getSheetName());
        if (sheet == null) {
            return;
        }
        SDataValidation validation = sheet.getDataValidation(dependent.getObjectIdPath()[0]);
        if (validation == null) {
            return;
        }
        FormulaEngine engine = this.getFormulaEngine();
        FormulaExpression f1 = ((AbstractDataValidationAdv)validation).getFormulaExpression1();
        FormulaExpression f2 = ((AbstractDataValidationAdv)validation).getFormulaExpression2();
        boolean changed = false;
        if (f1 != null && !(exprf1 = engine.shrinkPtgs(f1, sheetRegion, horizontal, new FormulaParseContext(sheet, null))).hasError() && !f1.getFormulaString().equals(exprf1.getFormulaString())) {
            f1 = exprf1;
            changed = true;
        }
        if (f2 != null && !(exprf2 = engine.shrinkPtgs(f2, sheetRegion, horizontal, new FormulaParseContext(sheet, null))).hasError() && !f2.getFormulaString().equals(exprf2.getFormulaString())) {
            f2 = exprf2;
            changed = true;
        }
        if (changed) {
            ((AbstractDataValidationAdv)validation).setFormulas(f1, f2);
        } else {
            validation.clearFormulaResultCache();
        }
        ArrayList<CellRegion> regions = new ArrayList<CellRegion>(validation.getRegions());
        for (CellRegion region : regions) {
            FormulaParseContext context;
            String sqref = region.getReferenceString();
            FormulaExpression fexpr = engine.parse(sqref, context = new FormulaParseContext(sheet, null));
            FormulaExpression expr2 = engine.shrinkPtgs(fexpr, sheetRegion, horizontal, new FormulaParseContext(sheet, null));
            if (expr2.hasError() || sqref.equals(expr2.getFormulaString())) continue;
            if ("#REF!".equals(expr2.getFormulaString())) {
                ((AbstractDataValidationAdv)validation).removeRegion(region);
                if (validation.getRegions() != null) continue;
                sheet.deleteDataValidation(validation);
                continue;
            }
            ((AbstractDataValidationAdv)validation).removeRegion(region);
            region = new CellRegion(expr2.getFormulaString());
            ((AbstractDataValidationAdv)validation).addRegion(region);
        }
        ModelUpdateUtil.addRefUpdate(dependent);
    }

    private void shrinkConditionalRef(SheetRegion sheetRegion, ConditionalRef dependent, boolean horizontal) {
        SBook book = this._bookSeries.getBook(dependent.getBookName());
        if (book == null) {
            return;
        }
        AbstractSheetAdv sheet = (AbstractSheetAdv)book.getSheetByName(dependent.getSheetName());
        if (sheet == null) {
            return;
        }
        ConditionalFormattingImpl cfmt = (ConditionalFormattingImpl)sheet.getConditionalFormatting(dependent.getConditionalId());
        if (cfmt == null) {
            return;
        }
        FormulaEngine engine = this.getFormulaEngine();
        for (SConditionalFormattingRule rule0 : cfmt.getRules()) {
            FormulaExpression exprf;
            FormulaExpression f;
            CFValueObjectImpl cvo;
            FormulaExpression exprf3;
            FormulaExpression exprf2;
            FormulaExpression exprf1;
            ConditionalFormattingRuleImpl rule = (ConditionalFormattingRuleImpl)rule0;
            FormulaExpression f1 = rule.getFormulaExpression1();
            FormulaExpression f2 = rule.getFormulaExpression2();
            FormulaExpression f3 = rule.getFormulaExpression3();
            boolean changed = false;
            if (f1 != null && !(exprf1 = engine.shrinkPtgs(f1, sheetRegion, horizontal, new FormulaParseContext(sheet, null))).hasError() && !f1.getFormulaString().equals(exprf1.getFormulaString())) {
                f1 = exprf1;
                changed = true;
            }
            if (f2 != null && !(exprf2 = engine.shrinkPtgs(f2, sheetRegion, horizontal, new FormulaParseContext(sheet, null))).hasError() && !f2.getFormulaString().equals(exprf2.getFormulaString())) {
                f2 = exprf2;
                changed = true;
            }
            if (f3 != null && !(exprf3 = engine.shrinkPtgs(f3, sheetRegion, horizontal, new FormulaParseContext(sheet, null))).hasError() && !f3.getFormulaString().equals(exprf3.getFormulaString())) {
                f3 = exprf3;
                changed = true;
            }
            if (changed) {
                rule.setFormulas(f1, f2, f3);
            } else {
                rule.clearFormulaResultCache();
            }
            changed = false;
            if (rule.getColorScale() != null) {
                for (SCFValueObject cvo0 : rule.getColorScale().getCFValueObjects()) {
                    cvo = (CFValueObjectImpl)cvo0;
                    f = cvo.getFormulaExpression();
                    if (f == null || (exprf = engine.shrinkPtgs(f, sheetRegion, horizontal, new FormulaParseContext(sheet, null))).hasError() || f.getFormulaString().equals(exprf.getFormulaString())) continue;
                    cvo.setFormulaExpression(exprf);
                    changed = true;
                }
            }
            if (rule.getDataBar() != null) {
                for (SCFValueObject cvo0 : rule.getDataBar().getCFValueObjects()) {
                    cvo = (CFValueObjectImpl)cvo0;
                    f = cvo.getFormulaExpression();
                    if (f == null || (exprf = engine.shrinkPtgs(f, sheetRegion, horizontal, new FormulaParseContext(sheet, null))).hasError() || f.getFormulaString().equals(exprf.getFormulaString())) continue;
                    cvo.setFormulaExpression(exprf);
                    changed = true;
                }
            }
            if (rule.getIconSet() != null) {
                for (SCFValueObject cvo0 : rule.getIconSet().getCFValueObjects()) {
                    cvo = (CFValueObjectImpl)cvo0;
                    f = cvo.getFormulaExpression();
                    if (f == null || (exprf = engine.shrinkPtgs(f, sheetRegion, horizontal, new FormulaParseContext(sheet, null))).hasError() || f.getFormulaString().equals(exprf.getFormulaString())) continue;
                    cvo.setFormulaExpression(exprf);
                    changed = true;
                }
            }
            if (!changed) continue;
            rule.clearFormulaResultCache();
        }
        ArrayList<CellRegion> regions = new ArrayList<CellRegion>(cfmt.getRegions());
        for (CellRegion region : regions) {
            FormulaParseContext context;
            String sqref = region.getReferenceString();
            FormulaExpression fexpr = engine.parse(sqref, context = new FormulaParseContext(sheet, null));
            FormulaExpression expr2 = engine.shrinkPtgs(fexpr, sheetRegion, horizontal, new FormulaParseContext(sheet, null));
            if (expr2.hasError() || sqref.equals(expr2.getFormulaString())) continue;
            if ("#REF!".equals(expr2.getFormulaString())) {
                cfmt.removeRegion(region);
                if (cfmt.getRegions() != null) continue;
                sheet.deleteConditionalFormatting(cfmt);
                continue;
            }
            cfmt.removeRegion(region);
            region = new CellRegion(expr2.getFormulaString());
            cfmt.addRegion(region);
        }
        ModelUpdateUtil.addRefUpdate(dependent);
    }

    private void shrinkFilterRef(SheetRegion sheetRegion, ObjectRef dependent, boolean horizontal) {
        FormulaParseContext context;
        CellRegion region;
        String area;
        FormulaExpression fexpr;
        SBook book = this._bookSeries.getBook(dependent.getBookName());
        if (book == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(dependent.getSheetName());
        if (sheet == null) {
            return;
        }
        SAutoFilter filter = sheet.getAutoFilter();
        if (filter == null) {
            return;
        }
        FormulaEngine engine = this.getFormulaEngine();
        FormulaExpression expr2 = engine.shrinkPtgs(fexpr = engine.parse(area = (region = filter.getRegion()).getReferenceString(), context = new FormulaParseContext(sheet, null)), sheetRegion, horizontal, context);
        if (!expr2.hasError() && !area.equals(expr2.getFormulaString())) {
            Collection<SAutoFilter.NFilterColumn> fcols = horizontal ? filter.getFilterColumns() : null;
            sheet.deleteAutoFilter();
            if (!"#REF!".equals(expr2.getFormulaString())) {
                CellRegion region2 = new CellRegion(expr2.getFormulaString());
                AutoFilterImpl nfilter = (AutoFilterImpl)sheet.createAutoFilter(region2);
                if (fcols != null) {
                    int start = sheetRegion.getColumn() - region.getColumn();
                    int end = sheetRegion.getLastColumn() - region.getColumn();
                    int offset = end >= 0 ? Math.min(sheetRegion.getColumnCount(), end + 1) : 0;
                    for (SAutoFilter.NFilterColumn fcol : fcols) {
                        int fcolj = fcol.getIndex();
                        if (start <= fcolj && fcolj <= end) continue;
                        int index0 = fcol.getIndex() - (fcolj < start ? 0 : offset);
                        ((AbstractAutoFilterAdv.FilterColumnImpl)fcol).setIndex(index0);
                        nfilter.putFilterColumn(fcol.getIndex(), fcol);
                    }
                }
            }
        }
        ModelUpdateUtil.addRefUpdate(dependent);
    }

    private void shrinkCellRef(SheetRegion sheetRegion, Ref dependent, boolean horizontal) {
        SBook book = this._bookSeries.getBook(dependent.getBookName());
        if (book == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(dependent.getSheetName());
        if (sheet == null) {
            return;
        }
        SCell cell = sheet.getCell(dependent.getRow(), dependent.getColumn());
        if (cell.getType() != SCell.CellType.FORMULA) {
            return;
        }
        FormulaExpression fexpr = (FormulaExpression)((AbstractCellAdv)cell).getValue(false);
        FormulaEngine engine = this.getFormulaEngine();
        FormulaExpression exprAfter = engine.shrinkPtgs(fexpr, sheetRegion, horizontal, new FormulaParseContext(sheet, null));
        if (!fexpr.getFormulaString().equals(exprAfter.getFormulaString())) {
            cell.setValue(exprAfter);
        } else {
            cell.clearFormulaResultCache();
            ModelUpdateUtil.addRefUpdate(dependent);
        }
    }

    private void shrinkNameRef(SheetRegion sheetRegion, NameRef dependent, boolean horizontal) {
        SBook book = this._bookSeries.getBook(dependent.getBookName());
        if (book == null) {
            return;
        }
        SName name = book.getNameByName(dependent.getNameName(), dependent.getSheetName());
        if (name == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(name.getRefersToSheetName());
        if (sheet == null) {
            return;
        }
        FormulaExpression expr = ((AbstractNameAdv)name).getRefersToFormulaExpression();
        FormulaEngine engine = this.getFormulaEngine();
        FormulaExpression exprAfter = engine.shrinkPtgs(expr, sheetRegion, horizontal, new FormulaParseContext(sheet, null));
        if (!expr.getFormulaString().equals(exprAfter.getFormulaString())) {
            ((AbstractNameAdv)name).setRefersToFormula(exprAfter);
        } else {
            this.clearFormulaCache(dependent);
            ModelUpdateUtil.addRefUpdate(dependent);
        }
    }

    public void renameSheet(SBook book, String oldName, String newName, Set<Ref> dependents) {
        LinkedHashMap<String, Ref> chartDependents = new LinkedHashMap<String, Ref>();
        LinkedHashMap<String, Ref> validationDependents = new LinkedHashMap<String, Ref>();
        LinkedHashSet<Ref> cellDependents = new LinkedHashSet<Ref>();
        LinkedHashMap<String, Ref> nameDependents = new LinkedHashMap<String, Ref>();
        LinkedHashSet<Ref> filterDependents = new LinkedHashSet<Ref>();
        LinkedHashMap<Integer, Ref> conditionalDependents = new LinkedHashMap<Integer, Ref>();
        this.splitDependents(dependents, cellDependents, chartDependents, validationDependents, nameDependents, filterDependents, conditionalDependents);
        for (Ref dependent : cellDependents) {
            this.renameSheetCellRef(book, oldName, newName, dependent);
        }
        for (Ref dependent : chartDependents.values()) {
            this.renameSheetChartRef(book, oldName, newName, (ObjectRef)dependent);
        }
        for (Ref dependent : validationDependents.values()) {
            this.renameSheetDataValidationRef(book, oldName, newName, (ObjectRef)dependent);
        }
        for (Ref dependent : nameDependents.values()) {
            this.renameSheetNameRef(book, oldName, newName, (NameRef)dependent);
        }
        for (Ref dependent : filterDependents) {
            this.renameSheetFilterRef(book, oldName, newName, (ObjectRef)dependent);
        }
        for (Ref dependent : conditionalDependents.values()) {
            this.renameSheetConditionalRef(book, oldName, newName, (ConditionalRef)dependent);
        }
    }

    private void renameSheetChartRef(SBook bookOfSheet, String oldName, String newName, ObjectRef dependent) {
        FormulaExpression exprAfter;
        SBook book = this._bookSeries.getBook(dependent.getBookName());
        if (book == null) {
            return;
        }
        String sheetName = null;
        SSheet sheet = book.getSheetByName(dependent.getSheetName());
        if (sheet == null) {
            if (oldName.equals(dependent.getSheetName())) {
                sheet = book.getSheetByName(newName);
                sheetName = oldName;
            }
        } else {
            sheetName = sheet.getSheetName();
        }
        if (sheet == null) {
            return;
        }
        SChart chart = sheet.getChart(dependent.getObjectIdPath()[0]);
        if (chart == null) {
            return;
        }
        SChartData d = chart.getData();
        if (!(d instanceof SGeneralChartData)) {
            return;
        }
        FormulaEngine engine = this.getFormulaEngine();
        SGeneralChartData data = (SGeneralChartData)d;
        FormulaExpression catExpr = ((AbstractGeneralChartDataAdv)((Object)data)).getCategoriesFormulaExpression();
        if (catExpr != null && !(exprAfter = engine.renameSheetPtgs(catExpr, bookOfSheet, oldName, newName, new FormulaParseContext(sheet, sheetName, null))).hasError()) {
            ((AbstractGeneralChartDataAdv)((Object)data)).setCategoriesFormula(exprAfter);
        }
        for (int i = 0; i < data.getNumOfSeries(); ++i) {
            SSeries series = data.getSeries(i);
            FormulaExpression nameExpr = ((AbstractSeriesAdv)series).getNameFormulaExpression();
            FormulaExpression xvalExpr = ((AbstractSeriesAdv)series).getXValuesFormulaExpression();
            FormulaExpression yvalExpr = ((AbstractSeriesAdv)series).getYValuesFormulaExpression();
            FormulaExpression zvalExpr = ((AbstractSeriesAdv)series).getZValuesFormulaExpression();
            if (nameExpr != null && !(exprAfter = engine.renameSheetPtgs(nameExpr, bookOfSheet, oldName, newName, new FormulaParseContext(sheet, sheetName, null))).hasError()) {
                nameExpr = exprAfter;
            }
            if (xvalExpr != null && !(exprAfter = engine.renameSheetPtgs(xvalExpr, bookOfSheet, oldName, newName, new FormulaParseContext(sheet, sheetName, null))).hasError()) {
                xvalExpr = exprAfter;
            }
            if (yvalExpr != null && !(exprAfter = engine.renameSheetPtgs(yvalExpr, bookOfSheet, oldName, newName, new FormulaParseContext(sheet, sheetName, null))).hasError()) {
                yvalExpr = exprAfter;
            }
            if (zvalExpr != null && !(exprAfter = engine.renameSheetPtgs(zvalExpr, bookOfSheet, oldName, newName, new FormulaParseContext(sheet, sheetName, null))).hasError()) {
                zvalExpr = exprAfter;
            }
            ((AbstractSeriesAdv)series).setXYZFormula(nameExpr, xvalExpr, yvalExpr, zvalExpr);
        }
        ModelUpdateUtil.addRefUpdate(dependent);
    }

    private void renameSheetDataValidationRef(SBook bookOfSheet, String oldName, String newName, ObjectRef dependent) {
        FormulaExpression exprf2;
        FormulaExpression exprf1;
        SBook book = this._bookSeries.getBook(dependent.getBookName());
        if (book == null) {
            return;
        }
        String sheetName = null;
        SSheet sheet = book.getSheetByName(dependent.getSheetName());
        if (sheet == null) {
            if (oldName.equals(dependent.getSheetName())) {
                sheet = book.getSheetByName(newName);
                sheetName = oldName;
            }
        } else {
            sheetName = sheet.getSheetName();
        }
        if (sheet == null) {
            return;
        }
        SDataValidation validation = sheet.getDataValidation(dependent.getObjectIdPath()[0]);
        if (validation == null) {
            return;
        }
        FormulaEngine engine = this.getFormulaEngine();
        FormulaExpression f1 = ((AbstractDataValidationAdv)validation).getFormulaExpression1();
        FormulaExpression f2 = ((AbstractDataValidationAdv)validation).getFormulaExpression2();
        boolean changed = false;
        if (f1 != null && !(exprf1 = engine.renameSheetPtgs(f1, bookOfSheet, oldName, newName, new FormulaParseContext(sheet, sheetName, null))).hasError() && !f1.getFormulaString().equals(exprf1.getFormulaString())) {
            f1 = exprf1;
            changed = true;
        }
        if (f2 != null && !(exprf2 = engine.renameSheetPtgs(f2, bookOfSheet, oldName, newName, new FormulaParseContext(sheet, sheetName, null))).hasError() && !f2.getFormulaString().equals(exprf2.getFormulaString())) {
            f2 = exprf2;
            changed = true;
        }
        if (changed) {
            ((AbstractDataValidationAdv)validation).setFormulas(f1, f2);
        } else {
            validation.clearFormulaResultCache();
        }
        ((AbstractDataValidationAdv)validation).renameSheet(oldName, newName);
        ModelUpdateUtil.addRefUpdate(dependent);
    }

    private void renameSheetConditionalRef(SBook bookOfSheet, String oldName, String newName, ConditionalRef dependent) {
        SBook book = this._bookSeries.getBook(dependent.getBookName());
        if (book == null) {
            return;
        }
        String sheetName = null;
        SSheet sheet = book.getSheetByName(dependent.getSheetName());
        if (sheet == null) {
            if (oldName.equals(dependent.getSheetName())) {
                sheet = book.getSheetByName(newName);
                sheetName = oldName;
            }
        } else {
            sheetName = sheet.getSheetName();
        }
        if (sheet == null) {
            return;
        }
        ConditionalFormattingImpl cfmt = (ConditionalFormattingImpl)((SheetImpl)sheet).getConditionalFormatting(dependent.getConditionalId());
        if (cfmt == null) {
            return;
        }
        FormulaEngine engine = this.getFormulaEngine();
        for (SConditionalFormattingRule rule0 : cfmt.getRules()) {
            FormulaExpression exprf;
            FormulaExpression f;
            CFValueObjectImpl cvo;
            FormulaExpression exprf3;
            FormulaExpression exprf2;
            FormulaExpression exprf1;
            ConditionalFormattingRuleImpl rule = (ConditionalFormattingRuleImpl)rule0;
            FormulaExpression f1 = rule.getFormulaExpression1();
            FormulaExpression f2 = rule.getFormulaExpression2();
            FormulaExpression f3 = rule.getFormulaExpression3();
            boolean changed = false;
            if (f1 != null && !(exprf1 = engine.renameSheetPtgs(f1, bookOfSheet, oldName, newName, new FormulaParseContext(sheet, sheetName, null))).hasError() && !f1.getFormulaString().equals(exprf1.getFormulaString())) {
                f1 = exprf1;
                changed = true;
            }
            if (f2 != null && !(exprf2 = engine.renameSheetPtgs(f2, bookOfSheet, oldName, newName, new FormulaParseContext(sheet, sheetName, null))).hasError() && !f2.getFormulaString().equals(exprf2.getFormulaString())) {
                f2 = exprf2;
                changed = true;
            }
            if (f3 != null && !(exprf3 = engine.renameSheetPtgs(f3, bookOfSheet, oldName, newName, new FormulaParseContext(sheet, sheetName, null))).hasError() && !f3.getFormulaString().equals(exprf3.getFormulaString())) {
                f3 = exprf3;
                changed = true;
            }
            if (changed) {
                rule.setFormulas(f1, f2, f3);
            } else {
                rule.clearFormulaResultCache();
            }
            changed = false;
            if (rule.getColorScale() != null) {
                for (SCFValueObject cvo0 : rule.getColorScale().getCFValueObjects()) {
                    cvo = (CFValueObjectImpl)cvo0;
                    f = cvo.getFormulaExpression();
                    if (f == null || (exprf = engine.renameSheetPtgs(f, bookOfSheet, oldName, newName, new FormulaParseContext(sheet, sheetName, null))).hasError() || f.getFormulaString().equals(exprf.getFormulaString())) continue;
                    cvo.setFormulaExpression(exprf);
                    changed = true;
                }
            }
            if (rule.getDataBar() != null) {
                for (SCFValueObject cvo0 : rule.getDataBar().getCFValueObjects()) {
                    cvo = (CFValueObjectImpl)cvo0;
                    f = cvo.getFormulaExpression();
                    if (f == null || (exprf = engine.renameSheetPtgs(f, bookOfSheet, oldName, newName, new FormulaParseContext(sheet, sheetName, null))).hasError() || f.getFormulaString().equals(exprf.getFormulaString())) continue;
                    cvo.setFormulaExpression(exprf);
                    changed = true;
                }
            }
            if (rule.getIconSet() != null) {
                for (SCFValueObject cvo0 : rule.getIconSet().getCFValueObjects()) {
                    cvo = (CFValueObjectImpl)cvo0;
                    f = cvo.getFormulaExpression();
                    if (f == null || (exprf = engine.renameSheetPtgs(f, bookOfSheet, oldName, newName, new FormulaParseContext(sheet, sheetName, null))).hasError() || f.getFormulaString().equals(exprf.getFormulaString())) continue;
                    cvo.setFormulaExpression(exprf);
                    changed = true;
                }
            }
            if (!changed) continue;
            rule.clearFormulaResultCache();
        }
        cfmt.renameSheet(oldName, newName);
        ModelUpdateUtil.addRefUpdate(dependent);
    }

    private void renameSheetFilterRef(SBook bookOfSheet, String oldName, String newName, ObjectRef dependent) {
        SBook book = this._bookSeries.getBook(dependent.getBookName());
        if (book == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(dependent.getSheetName());
        if (sheet == null && oldName.equals(dependent.getSheetName())) {
            sheet = book.getSheetByName(newName);
        }
        if (sheet == null) {
            return;
        }
        SAutoFilter filter = sheet.getAutoFilter();
        if (filter == null) {
            return;
        }
        ((AbstractAutoFilterAdv)filter).renameSheet(book, oldName, newName);
        ModelUpdateUtil.addRefUpdate(dependent);
    }

    private void renameSheetCellRef(SBook bookOfSheet, String oldName, String newName, Ref dependent) {
        SBook book = this._bookSeries.getBook(dependent.getBookName());
        if (book == null) {
            return;
        }
        String sheetName = null;
        SSheet sheet = book.getSheetByName(dependent.getSheetName());
        if (sheet == null) {
            if (oldName.equals(dependent.getSheetName())) {
                sheet = book.getSheetByName(newName);
                sheetName = oldName;
            }
        } else {
            sheetName = sheet.getSheetName();
        }
        if (sheet == null) {
            return;
        }
        SCell cell = sheet.getCell(dependent.getRow(), dependent.getColumn());
        if (cell.getType() != SCell.CellType.FORMULA) {
            return;
        }
        FormulaExpression expr = (FormulaExpression)((AbstractCellAdv)cell).getValue(false);
        FormulaEngine engine = this.getFormulaEngine();
        FormulaExpression exprAfter = engine.renameSheetPtgs(expr, bookOfSheet, oldName, newName, new FormulaParseContext(cell, sheetName, null));
        cell.setValue(exprAfter);
    }

    private void renameSheetNameRef(SBook bookOfSheet, String oldName, String newName, NameRef dependent) {
        SBook book = this._bookSeries.getBook(dependent.getBookName());
        if (book == null) {
            return;
        }
        SName name = book.getNameByName(dependent.getNameName(), dependent.getSheetName());
        if (name == null) {
            return;
        }
        String sheetName = null;
        SSheet sheet = book.getSheetByName(name.getRefersToSheetName());
        if (sheet == null) {
            if (oldName.equals(name.getRefersToSheetName())) {
                sheet = book.getSheetByName(newName);
                sheetName = oldName;
            }
        } else {
            sheetName = sheet.getSheetName();
        }
        if (sheet == null) {
            return;
        }
        FormulaExpression expr = ((AbstractNameAdv)name).getRefersToFormulaExpression();
        FormulaEngine engine = this.getFormulaEngine();
        FormulaExpression exprAfter = engine.renameSheetPtgs(expr, bookOfSheet, oldName, newName, new FormulaParseContext(sheet, sheetName, null));
        ((AbstractNameAdv)name).setRefersToFormula(exprAfter);
    }

    public void renameName(SBook book, String oldName, String newName, Set<Ref> dependents, int sheetIndex) {
        for (Ref dependent : dependents) {
            if (dependent.getType() != Ref.RefType.CELL && dependent.getType() != Ref.RefType.TABLE) continue;
            this.renameNameCellRef(book, oldName, newName, dependent, sheetIndex);
        }
    }

    private void renameNameCellRef(SBook bookOfSheet, String oldName, String newName, Ref dependent, int sheetIndex) {
        SBook book = this._bookSeries.getBook(dependent.getBookName());
        if (book == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(dependent.getSheetName());
        if (sheet == null) {
            return;
        }
        SCell cell = sheet.getCell(dependent.getRow(), dependent.getColumn());
        if (cell.getType() != SCell.CellType.FORMULA) {
            return;
        }
        FormulaExpression expr = (FormulaExpression)((AbstractCellAdv)cell).getValue(false);
        FormulaEngine engine = this.getFormulaEngine();
        FormulaExpression exprAfter = engine.renameNamePtgs(expr, bookOfSheet, sheetIndex, oldName, newName, new FormulaParseContext(cell, null));
        cell.setValue(exprAfter);
    }

    private void splitDependents(Set<Ref> dependents, Set<Ref> cellDependents, Map<String, Ref> chartDependents, Map<String, Ref> validationDependents, Map<String, Ref> nameDependents, Set<Ref> filterDependents, Map<Integer, Ref> conditionalDependents) {
        for (Ref dependent : dependents) {
            Ref.RefType type = dependent.getType();
            if (type == Ref.RefType.CELL || dependent.getType() == Ref.RefType.TABLE) {
                cellDependents.add(dependent);
                continue;
            }
            if (type == Ref.RefType.OBJECT) {
                if (((ObjectRef)dependent).getObjectType() == ObjectRef.ObjectType.CHART) {
                    chartDependents.put(((ObjectRef)dependent).getObjectIdPath()[0], dependent);
                    continue;
                }
                if (((ObjectRef)dependent).getObjectType() == ObjectRef.ObjectType.DATA_VALIDATION) {
                    validationDependents.put(((ObjectRef)dependent).getObjectIdPath()[0], dependent);
                    continue;
                }
                if (((ObjectRef)dependent).getObjectType() != ObjectRef.ObjectType.AUTO_FILTER) continue;
                filterDependents.add(dependent);
                continue;
            }
            if (type == Ref.RefType.NAME) {
                nameDependents.put(((NameRef)dependent).toString(), dependent);
                continue;
            }
            if (type != Ref.RefType.CONDITIONAL) continue;
            conditionalDependents.put(((ConditionalRef)dependent).getConditionalId(), dependent);
        }
    }

    private void clearFormulaCache(NameRef precedent) {
        HashMap<String, Ref> chartDependents = new HashMap<String, Ref>();
        HashMap<String, Ref> validationDependents = new HashMap<String, Ref>();
        HashSet<Ref> nameDependents = new HashSet<Ref>();
        AbstractBookSeriesAdv bs = (AbstractBookSeriesAdv)this._bookSeries;
        DependencyTable dt = bs.getDependencyTable();
        this.clearFormulaCache(precedent, dt, chartDependents, validationDependents, nameDependents);
        for (Ref dependent : chartDependents.values()) {
            this.clearFormulaCacheChartRef((ObjectRef)dependent);
        }
        for (Ref dependent : validationDependents.values()) {
            this.clearFormulaCacheDataValidationRef((ObjectRef)dependent);
        }
    }

    private void clearFormulaCache(NameRef precedent, DependencyTable dt, Map<String, Ref> chartDependents, Map<String, Ref> validationDependents, Set<Ref> nameDependents) {
        Set<Ref> dependents = dt.getDependents(precedent);
        for (Ref dependent : dependents) {
            Ref.RefType type = dependent.getType();
            if (type == Ref.RefType.CELL || dependent.getType() == Ref.RefType.TABLE) {
                this.clearFormulaCacheCellRef(dependent);
                continue;
            }
            if (type == Ref.RefType.OBJECT) {
                if (((ObjectRef)dependent).getObjectType() == ObjectRef.ObjectType.CHART) {
                    chartDependents.put(((ObjectRef)dependent).getObjectIdPath()[0], dependent);
                    continue;
                }
                if (((ObjectRef)dependent).getObjectType() != ObjectRef.ObjectType.DATA_VALIDATION) continue;
                validationDependents.put(((ObjectRef)dependent).getObjectIdPath()[0], dependent);
                continue;
            }
            if (type != Ref.RefType.NAME || nameDependents.contains(dependent)) continue;
            nameDependents.add(dependent);
            this.clearFormulaCache((NameRef)dependent, dt, chartDependents, validationDependents, nameDependents);
        }
    }

    private void clearFormulaCacheDataValidationRef(ObjectRef dependent) {
        SBook book = this._bookSeries.getBook(dependent.getBookName());
        if (book == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(dependent.getSheetName());
        if (sheet == null) {
            return;
        }
        SDataValidation validation = sheet.getDataValidation(dependent.getObjectIdPath()[0]);
        if (validation == null) {
            return;
        }
        validation.clearFormulaResultCache();
        ModelUpdateUtil.addRefUpdate(dependent);
    }

    private void clearFormulaCacheChartRef(ObjectRef dependent) {
        SBook book = this._bookSeries.getBook(dependent.getBookName());
        if (book == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(dependent.getSheetName());
        if (sheet == null) {
            return;
        }
        SChart chart = sheet.getChart(dependent.getObjectIdPath()[0]);
        if (chart == null) {
            return;
        }
        SChartData d = chart.getData();
        if (!(d instanceof SGeneralChartData)) {
            return;
        }
        SGeneralChartData data = (SGeneralChartData)d;
        data.clearFormulaResultCache();
        ModelUpdateUtil.addRefUpdate(dependent);
    }

    private void clearFormulaCacheCellRef(Ref dependent) {
        SBook book = this._bookSeries.getBook(dependent.getBookName());
        if (book == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(dependent.getSheetName());
        if (sheet == null) {
            return;
        }
        SCell cell = sheet.getCell(dependent.getRow(), dependent.getColumn());
        if (cell.getType() != SCell.CellType.FORMULA) {
            return;
        }
        cell.clearFormulaResultCache();
        ModelUpdateUtil.addRefUpdate(dependent);
    }

    public void reorderSheet(SBook book, int oldIndex, int newIndex, Set<Ref> dependents) {
        LinkedHashMap<String, Ref> chartDependents = new LinkedHashMap<String, Ref>();
        LinkedHashMap<String, Ref> validationDependents = new LinkedHashMap<String, Ref>();
        LinkedHashSet<Ref> cellDependents = new LinkedHashSet<Ref>();
        LinkedHashMap<String, Ref> nameDependents = new LinkedHashMap<String, Ref>();
        LinkedHashSet<Ref> filterDependents = new LinkedHashSet<Ref>();
        LinkedHashMap<Integer, Ref> conditionalDependents = new LinkedHashMap<Integer, Ref>();
        this.splitDependents(dependents, cellDependents, chartDependents, validationDependents, nameDependents, filterDependents, conditionalDependents);
        for (Ref dependent : cellDependents) {
            this.reorderSheetCellRef(book, oldIndex, newIndex, dependent);
        }
        for (Ref dependent : chartDependents.values()) {
            this.reorderSheetChartRef(book, oldIndex, newIndex, (ObjectRef)dependent);
        }
        for (Ref dependent : nameDependents.values()) {
            this.reorderSheetNameRef(book, oldIndex, newIndex, (NameRef)dependent);
        }
    }

    private void reorderSheetChartRef(SBook bookOfSheet, int oldIndex, int newIndex, ObjectRef dependent) {
        FormulaExpression exprAfter;
        SBook book = this._bookSeries.getBook(dependent.getBookName());
        if (book == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(dependent.getSheetName());
        if (sheet == null) {
            return;
        }
        String sheetName = sheet.getSheetName();
        SChart chart = sheet.getChart(dependent.getObjectIdPath()[0]);
        if (chart == null) {
            return;
        }
        SChartData d = chart.getData();
        if (!(d instanceof SGeneralChartData)) {
            return;
        }
        FormulaEngine engine = this.getFormulaEngine();
        SGeneralChartData data = (SGeneralChartData)d;
        FormulaExpression catExpr = ((AbstractGeneralChartDataAdv)((Object)data)).getCategoriesFormulaExpression();
        if (catExpr != null && !(exprAfter = engine.reorderSheetPtgs(catExpr, bookOfSheet, oldIndex, newIndex, new FormulaParseContext(sheet, sheetName, null))).hasError()) {
            ((AbstractGeneralChartDataAdv)((Object)data)).setCategoriesFormula(exprAfter);
        }
        for (int i = 0; i < data.getNumOfSeries(); ++i) {
            SSeries series = data.getSeries(i);
            FormulaExpression nameExpr = ((AbstractSeriesAdv)series).getNameFormulaExpression();
            FormulaExpression xvalExpr = ((AbstractSeriesAdv)series).getXValuesFormulaExpression();
            FormulaExpression yvalExpr = ((AbstractSeriesAdv)series).getYValuesFormulaExpression();
            FormulaExpression zvalExpr = ((AbstractSeriesAdv)series).getZValuesFormulaExpression();
            if (nameExpr != null && !(exprAfter = engine.reorderSheetPtgs(nameExpr, bookOfSheet, oldIndex, newIndex, new FormulaParseContext(sheet, sheetName, null))).hasError()) {
                nameExpr = exprAfter;
            }
            if (xvalExpr != null && !(exprAfter = engine.reorderSheetPtgs(xvalExpr, bookOfSheet, oldIndex, newIndex, new FormulaParseContext(sheet, sheetName, null))).hasError()) {
                xvalExpr = exprAfter;
            }
            if (yvalExpr != null && !(exprAfter = engine.reorderSheetPtgs(yvalExpr, bookOfSheet, oldIndex, newIndex, new FormulaParseContext(sheet, sheetName, null))).hasError()) {
                yvalExpr = exprAfter;
            }
            if (zvalExpr != null && !(exprAfter = engine.reorderSheetPtgs(zvalExpr, bookOfSheet, oldIndex, newIndex, new FormulaParseContext(sheet, sheetName, null))).hasError()) {
                zvalExpr = exprAfter;
            }
            ((AbstractSeriesAdv)series).setXYZFormula(nameExpr, xvalExpr, yvalExpr, zvalExpr);
        }
        ModelUpdateUtil.addRefUpdate(dependent);
    }

    private void reorderSheetCellRef(SBook bookOfSheet, int oldIndex, int newIndex, Ref dependent) {
        SBook book = this._bookSeries.getBook(dependent.getBookName());
        if (book == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(dependent.getSheetName());
        if (sheet == null) {
            return;
        }
        String sheetName = sheet.getSheetName();
        SCell cell = sheet.getCell(dependent.getRow(), dependent.getColumn());
        if (cell.getType() != SCell.CellType.FORMULA) {
            return;
        }
        FormulaExpression expr = (FormulaExpression)((AbstractCellAdv)cell).getValue(false);
        FormulaEngine engine = this.getFormulaEngine();
        FormulaExpression exprAfter = engine.reorderSheetPtgs(expr, bookOfSheet, oldIndex, newIndex, new FormulaParseContext(cell, sheetName, null));
        cell.setValue(exprAfter);
    }

    private void reorderSheetNameRef(SBook bookOfSheet, int oldIndex, int newIndex, NameRef dependent) {
        SBook book = this._bookSeries.getBook(dependent.getBookName());
        if (book == null) {
            return;
        }
        SName name = book.getNameByName(dependent.getNameName(), dependent.getSheetName());
        if (name == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(name.getRefersToSheetName());
        if (sheet == null) {
            return;
        }
        String sheetName = sheet.getSheetName();
        FormulaExpression expr = ((AbstractNameAdv)name).getRefersToFormulaExpression();
        FormulaEngine engine = this.getFormulaEngine();
        FormulaExpression exprAfter = engine.reorderSheetPtgs(expr, bookOfSheet, oldIndex, newIndex, new FormulaParseContext(sheet, sheetName, null));
        ((AbstractNameAdv)name).setRefersToFormula(exprAfter);
    }

    public void renameTableName(SBook book, String oldName, String newName, Set<Ref> dependents) {
        for (Ref dependent : dependents) {
            if (dependent.getType() != Ref.RefType.CELL && dependent.getType() != Ref.RefType.TABLE) continue;
            this.renameTableNameCellRef(book, oldName, newName, dependent);
        }
    }

    private void renameTableNameCellRef(SBook bookOfSheet, String oldName, String newName, Ref dependent) {
        SBook book = this._bookSeries.getBook(dependent.getBookName());
        if (book == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(dependent.getSheetName());
        if (sheet == null) {
            return;
        }
        SCell cell = sheet.getCell(dependent.getRow(), dependent.getColumn());
        if (cell.getType() != SCell.CellType.FORMULA) {
            return;
        }
        FormulaExpression expr = (FormulaExpression)((AbstractCellAdv)cell).getValue(false);
        FormulaEngine engine = this.getFormulaEngine();
        FormulaExpression exprAfter = engine.renameTableNameTablePtgs(expr, bookOfSheet, oldName, newName, new FormulaParseContext(cell, null));
        cell.setValue(exprAfter);
    }

    public void renameColumnName(STable table, String oldName, String newName, Set<Ref> dependents) {
        for (Ref dependent : dependents) {
            if (dependent.getType() != Ref.RefType.CELL && dependent.getType() != Ref.RefType.TABLE) continue;
            this.renameColumnNameCellRef(table, oldName, newName, dependent);
        }
    }

    private void renameColumnNameCellRef(STable table, String oldName, String newName, Ref dependent) {
        SBook book = this._bookSeries.getBook(dependent.getBookName());
        if (book == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(dependent.getSheetName());
        if (sheet == null) {
            return;
        }
        SCell cell = sheet.getCell(dependent.getRow(), dependent.getColumn());
        if (cell.getType() != SCell.CellType.FORMULA) {
            return;
        }
        FormulaExpression expr = (FormulaExpression)((AbstractCellAdv)cell).getValue(false);
        FormulaEngine engine = this.getFormulaEngine();
        FormulaExpression exprAfter = engine.renameColumnNameTablePtgs(expr, table, oldName, newName, new FormulaParseContext(cell, null));
        cell.setValue(exprAfter);
    }
}

