/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.model.impl;

import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Set;
import org.zkoss.zss.model.SBookSeries;
import org.zkoss.zss.model.impl.AbstractBookSeriesAdv;
import org.zkoss.zss.model.impl.FormulaCacheClearHelper;
import org.zkoss.zss.model.sys.dependency.DependencyTable;
import org.zkoss.zss.model.sys.dependency.Ref;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormulaCacheCleaner
implements Serializable {
    private static final long serialVersionUID = 1832529508263194818L;
    private static ThreadLocal<FormulaCacheCleaner> _current = new ThreadLocal();
    private final SBookSeries _bookSeries;

    public FormulaCacheCleaner(SBookSeries bookSeries) {
        this._bookSeries = bookSeries;
    }

    public static FormulaCacheCleaner setCurrent(FormulaCacheCleaner ctx) {
        FormulaCacheCleaner old = _current.get();
        _current.set(ctx);
        return old;
    }

    public static FormulaCacheCleaner getCurrent() {
        return _current.get();
    }

    public void clear(Set<Ref> dependents) {
        new FormulaCacheClearHelper(this._bookSeries).clear(dependents);
    }

    public void clearByPrecedent(Ref precedent) {
        DependencyTable table = ((AbstractBookSeriesAdv)this._bookSeries).getDependencyTable();
        LinkedHashSet<Ref> dependents = new LinkedHashSet<Ref>();
        dependents.add(precedent);
        dependents.addAll(table.getEvaluatedDependents(precedent));
        this.clear(dependents);
    }
}

