/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.model.impl;

import org.zkoss.lang.Objects;
import org.zkoss.zss.model.SBook;
import org.zkoss.zss.model.SBorder;
import org.zkoss.zss.model.SBorderLine;
import org.zkoss.zss.model.SColor;
import org.zkoss.zss.model.impl.AbstractBorderAdv;
import org.zkoss.zss.model.impl.AbstractBorderLineAdv;
import org.zkoss.zss.model.impl.BorderLineImpl;
import org.zkoss.zss.model.impl.ColorImpl;

public class BorderImpl
extends AbstractBorderAdv {
    private static final long serialVersionUID = 1L;
    private SBorderLine _leftLine;
    private SBorderLine _topLine;
    private SBorderLine _rightLine;
    private SBorderLine _bottomLine;
    private SBorderLine _diagonalLine;
    private SBorderLine _verticalLine;
    private SBorderLine _horizontalLine;

    public BorderImpl() {
    }

    public BorderImpl(SBorderLine left, SBorderLine top, SBorderLine right, SBorderLine bottom, SBorderLine diagonal, SBorderLine vertical, SBorderLine horizontal) {
        this._leftLine = left;
        this._topLine = top;
        this._rightLine = right;
        this._bottomLine = bottom;
        this._diagonalLine = diagonal;
        this._verticalLine = vertical;
        this._horizontalLine = horizontal;
    }

    public SBorder.BorderType getBorderLeft() {
        return this._leftLine == null ? SBorder.BorderType.NONE : this._leftLine.getBorderType();
    }

    public SBorder.BorderType getBorderTop() {
        return this._topLine == null ? SBorder.BorderType.NONE : this._topLine.getBorderType();
    }

    public SBorder.BorderType getBorderRight() {
        return this._rightLine == null ? SBorder.BorderType.NONE : this._rightLine.getBorderType();
    }

    public SBorder.BorderType getBorderBottom() {
        return this._bottomLine == null ? SBorder.BorderType.NONE : this._bottomLine.getBorderType();
    }

    public SBorder.BorderType getBorderVertical() {
        return this._verticalLine == null ? SBorder.BorderType.NONE : this._verticalLine.getBorderType();
    }

    public SBorder.BorderType getBorderHorizontal() {
        return this._horizontalLine == null ? SBorder.BorderType.NONE : this._horizontalLine.getBorderType();
    }

    public SBorder.BorderType getBorderDiagonal() {
        return this._diagonalLine == null ? SBorder.BorderType.NONE : this._diagonalLine.getBorderType();
    }

    public SColor getBorderTopColor() {
        return this._topLine == null ? ColorImpl.BLACK : this._topLine.getColor();
    }

    public SColor getBorderLeftColor() {
        return this._leftLine == null ? ColorImpl.BLACK : this._leftLine.getColor();
    }

    public SColor getBorderBottomColor() {
        return this._bottomLine == null ? ColorImpl.BLACK : this._bottomLine.getColor();
    }

    public SColor getBorderRightColor() {
        return this._rightLine == null ? ColorImpl.BLACK : this._rightLine.getColor();
    }

    public SColor getBorderVerticalColor() {
        return this._verticalLine == null ? ColorImpl.BLACK : this._verticalLine.getColor();
    }

    public SColor getBorderHorizontalColor() {
        return this._horizontalLine == null ? ColorImpl.BLACK : this._horizontalLine.getColor();
    }

    public SColor getBorderDiagonalColor() {
        return this._diagonalLine == null ? ColorImpl.BLACK : this._diagonalLine.getColor();
    }

    public boolean isShowDiagonalUpBorder() {
        return this._diagonalLine == null ? false : this._diagonalLine.isShowDiagonalUpBorder();
    }

    public boolean isShowDiagonalDownBorder() {
        return this._diagonalLine == null ? false : this._diagonalLine.isShowDiagonalDownBorder();
    }

    String getStyleKey() {
        return (this._leftLine == null ? "" : ((AbstractBorderLineAdv)this._leftLine).getStyleKey()) + (this._topLine == null ? "" : ((AbstractBorderLineAdv)this._topLine).getStyleKey()) + (this._rightLine == null ? "" : ((AbstractBorderLineAdv)this._rightLine).getStyleKey()) + (this._bottomLine == null ? "" : ((AbstractBorderLineAdv)this._bottomLine).getStyleKey()) + (this._diagonalLine == null ? "" : ((AbstractBorderLineAdv)this._diagonalLine).getStyleKey()) + (this._verticalLine == null ? "" : ((AbstractBorderLineAdv)this._verticalLine).getStyleKey()) + (this._horizontalLine == null ? "" : ((AbstractBorderLineAdv)this._horizontalLine).getStyleKey());
    }

    public void setBorderLeft(SBorder.BorderType type) {
        if (this._leftLine == null) {
            this._leftLine = new BorderLineImpl(type, ColorImpl.BLACK);
        }
        this._leftLine.setBorderType(type);
    }

    public void setBorderTop(SBorder.BorderType type) {
        if (this._topLine == null) {
            this._topLine = new BorderLineImpl(type, ColorImpl.BLACK);
        }
        this._topLine.setBorderType(type);
    }

    public void setBorderRight(SBorder.BorderType type) {
        if (this._rightLine == null) {
            this._rightLine = new BorderLineImpl(type, ColorImpl.BLACK);
        }
        this._rightLine.setBorderType(type);
    }

    public void setBorderBottom(SBorder.BorderType type) {
        if (this._bottomLine == null) {
            this._bottomLine = new BorderLineImpl(type, ColorImpl.BLACK);
        }
        this._bottomLine.setBorderType(type);
    }

    public void setBorderVertical(SBorder.BorderType type) {
        if (this._verticalLine == null) {
            this._verticalLine = new BorderLineImpl(type, ColorImpl.BLACK);
        }
        this._verticalLine.setBorderType(type);
    }

    public void setBorderHorizontal(SBorder.BorderType type) {
        if (this._horizontalLine == null) {
            this._horizontalLine = new BorderLineImpl(type, ColorImpl.BLACK);
        }
        this._horizontalLine.setBorderType(type);
    }

    public void setBorderDiagonal(SBorder.BorderType type) {
        if (this._diagonalLine == null) {
            this._diagonalLine = new BorderLineImpl(type, ColorImpl.BLACK);
        }
        this._diagonalLine.setBorderType(type);
    }

    public void setBorderTopColor(SColor color) {
        if (this._topLine == null) {
            this._topLine = new BorderLineImpl(SBorder.BorderType.NONE, color);
        } else {
            this._topLine.setColor(color);
        }
    }

    public void setBorderLeftColor(SColor color) {
        if (this._leftLine == null) {
            this._leftLine = new BorderLineImpl(SBorder.BorderType.NONE, color);
        } else {
            this._leftLine.setColor(color);
        }
    }

    public void setBorderBottomColor(SColor color) {
        if (this._bottomLine == null) {
            this._bottomLine = new BorderLineImpl(SBorder.BorderType.NONE, color);
        } else {
            this._bottomLine.setColor(color);
        }
    }

    public void setBorderRightColor(SColor color) {
        if (this._rightLine == null) {
            this._rightLine = new BorderLineImpl(SBorder.BorderType.NONE, color);
        } else {
            this._rightLine.setColor(color);
        }
    }

    public void setBorderVerticalColor(SColor color) {
        if (this._verticalLine == null) {
            this._verticalLine = new BorderLineImpl(SBorder.BorderType.NONE, color);
        } else {
            this._verticalLine.setColor(color);
        }
    }

    public void setBorderHorizontalColor(SColor color) {
        if (this._horizontalLine == null) {
            this._horizontalLine = new BorderLineImpl(SBorder.BorderType.NONE, color);
        } else {
            this._horizontalLine.setColor(color);
        }
    }

    public void setBorderDiagonalColor(SColor color) {
        if (this._diagonalLine == null) {
            this._diagonalLine = new BorderLineImpl(SBorder.BorderType.NONE, color);
        } else {
            this._diagonalLine.setColor(color);
        }
    }

    public void setShowDiagonalUpBorder(boolean show) {
        if (this._diagonalLine == null) {
            this._diagonalLine = new BorderLineImpl(SBorder.BorderType.NONE, ColorImpl.BLACK, show, false);
        } else {
            this._diagonalLine.setShowDiagonalUpBorder(show);
        }
    }

    public void setShowDiagonalDownBorder(boolean show) {
        if (this._diagonalLine == null) {
            this._diagonalLine = new BorderLineImpl(SBorder.BorderType.NONE, ColorImpl.BLACK, false, show);
        } else {
            this._diagonalLine.setShowDiagonalDownBorder(show);
        }
    }

    public SBorderLine getLeftLine() {
        return this._leftLine;
    }

    public SBorderLine getTopLine() {
        return this._topLine;
    }

    public SBorderLine getRightLine() {
        return this._rightLine;
    }

    public SBorderLine getBottomLine() {
        return this._bottomLine;
    }

    public SBorderLine getDiagonalLine() {
        return this._diagonalLine;
    }

    public SBorderLine getVerticalLine() {
        return this._verticalLine;
    }

    public SBorderLine getHorizontalLine() {
        return this._horizontalLine;
    }

    public int hashCode() {
        int hash = this._leftLine == null ? 0 : this._leftLine.hashCode();
        hash = hash * 31 + (this._topLine == null ? 0 : this._topLine.hashCode());
        hash = hash * 31 + (this._rightLine == null ? 0 : this._rightLine.hashCode());
        hash = hash * 31 + (this._bottomLine == null ? 0 : this._bottomLine.hashCode());
        hash = hash * 31 + (this._diagonalLine == null ? 0 : this._diagonalLine.hashCode());
        hash = hash * 31 + (this._verticalLine == null ? 0 : this._verticalLine.hashCode());
        hash = hash * 31 + (this._horizontalLine == null ? 0 : this._horizontalLine.hashCode());
        return hash;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof BorderImpl)) {
            return false;
        }
        BorderImpl o = (BorderImpl)other;
        return Objects.equals((Object)this._leftLine, (Object)o._leftLine) && Objects.equals((Object)this._topLine, (Object)o._topLine) && Objects.equals((Object)this._rightLine, (Object)o._rightLine) && Objects.equals((Object)this._bottomLine, (Object)o._bottomLine) && Objects.equals((Object)this._diagonalLine, (Object)o._diagonalLine) && Objects.equals((Object)this._verticalLine, (Object)o._verticalLine) && Objects.equals((Object)this._horizontalLine, (Object)o._horizontalLine);
    }

    SBorder cloneBorder(SBook book) {
        SBorderLine left = this._leftLine == null ? null : ((AbstractBorderLineAdv)this._leftLine).cloneBorderLine(book);
        SBorderLine top = this._topLine == null ? null : ((AbstractBorderLineAdv)this._topLine).cloneBorderLine(book);
        SBorderLine right = this._rightLine == null ? null : ((AbstractBorderLineAdv)this._rightLine).cloneBorderLine(book);
        SBorderLine bottom = this._bottomLine == null ? null : ((AbstractBorderLineAdv)this._bottomLine).cloneBorderLine(book);
        SBorderLine diagonal = this._diagonalLine == null ? null : ((AbstractBorderLineAdv)this._diagonalLine).cloneBorderLine(book);
        SBorderLine vertical = this._verticalLine == null ? null : ((AbstractBorderLineAdv)this._verticalLine).cloneBorderLine(book);
        SBorderLine horizontal = this._horizontalLine == null ? null : ((AbstractBorderLineAdv)this._horizontalLine).cloneBorderLine(book);
        return new BorderImpl(left, top, right, bottom, diagonal, vertical, horizontal);
    }
}

