/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.model.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.zkoss.zss.model.SAutoFilter;
import org.zkoss.zss.model.SBook;
import org.zkoss.zss.model.SColorFilter;
import org.zkoss.zss.model.SCustomFilters;
import org.zkoss.zss.model.SDynamicFilter;
import org.zkoss.zss.model.STop10Filter;
import org.zkoss.zss.model.impl.ColorFilterImpl;
import org.zkoss.zss.model.impl.CustomFiltersImpl;
import org.zkoss.zss.model.impl.DynamicFilterImpl;
import org.zkoss.zss.model.impl.Top10FilterImpl;

public abstract class AbstractAutoFilterAdv
implements SAutoFilter,
Serializable {
    private static final long serialVersionUID = 1L;

    public abstract void renameSheet(SBook var1, String var2, String var3);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FilterColumnImpl
    implements SAutoFilter.NFilterColumn,
    Serializable {
        private static final long serialVersionUID = 1L;
        private int _index;
        private List<String> _filters;
        private Set _criteria1;
        private Set _criteria2;
        private Boolean _showButton;
        private SAutoFilter.FilterOp _op = SAutoFilter.FilterOp.and;
        private SColorFilter _colorFilter;
        private SCustomFilters _customFilters;
        private int type;
        private SDynamicFilter _dynamicFilter;
        private STop10Filter _top10Filter;
        private int filterType;

        public FilterColumnImpl(int index) {
            this._index = index;
        }

        @Override
        public int getIndex() {
            return this._index;
        }

        @Override
        public List<String> getFilters() {
            return this._filters == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(this._filters);
        }

        @Override
        public Set getCriteria1() {
            return this._criteria1 == null ? Collections.EMPTY_SET : Collections.unmodifiableSet(this._criteria1);
        }

        @Override
        public Set getCriteria2() {
            return this._criteria2 == null ? Collections.EMPTY_SET : Collections.unmodifiableSet(this._criteria2);
        }

        @Override
        public boolean isShowButton() {
            return this._showButton == null ? true : this._showButton;
        }

        @Override
        public SAutoFilter.FilterOp getOperator() {
            return this._op;
        }

        private Set getCriteriaSet(Object criteria) {
            Set<String> set = new HashSet();
            if (criteria instanceof String[]) {
                String[] strings = (String[])criteria;
                for (int j = 0; j < strings.length; ++j) {
                    set.add(strings[j]);
                }
            } else if (criteria instanceof Set) {
                set = (Set)criteria;
            }
            return set;
        }

        @Override
        public void setProperties(SAutoFilter.FilterOp filterOp, Object criteria1, Object criteria2, Boolean showButton) {
            this._setProperties(filterOp, criteria1, criteria2, showButton, Collections.EMPTY_MAP);
        }

        @Override
        public void setProperties(SAutoFilter.FilterOp filterOp, Object criteria1, Object criteria2, Boolean showButton, Map<String, Object> extra) {
            this._setProperties(filterOp, criteria1, criteria2, showButton, extra);
        }

        private void _setProperties(SAutoFilter.FilterOp filterOp, Object criteria1, Object criteria2, Boolean showButton, Map<String, Object> extra) {
            this._colorFilter = (SColorFilter)extra.get("colorFilter");
            this._customFilters = (SCustomFilters)extra.get("customFilters");
            SDynamicFilter dynaFilter = (SDynamicFilter)extra.get("dynamicFilter");
            if (!DynamicFilterImpl.NOOP_DYNAFILTER.equals(dynaFilter)) {
                this._dynamicFilter = dynaFilter;
            }
            this._top10Filter = (STop10Filter)extra.get("top10Filter");
            this._op = filterOp;
            this._criteria1 = this.getCriteriaSet(criteria1);
            this._criteria2 = this.getCriteriaSet(criteria2);
            boolean blank1 = this._criteria1.contains("=");
            if (showButton != null) {
                this._showButton = showButton;
            }
            if (criteria1 == null) {
                this._filters = null;
                return;
            }
            switch (filterOp) {
                case values: {
                    this._filters = new LinkedList<String>();
                    for (Object obj : this._criteria1) {
                        if (!(obj instanceof String)) continue;
                        this._filters.add((String)obj);
                    }
                    if (this._filters.size() != 0) break;
                    this._filters = null;
                }
            }
        }

        FilterColumnImpl cloneFilterColumnImpl() {
            return this.cloneFilterColumnImpl(null);
        }

        FilterColumnImpl cloneFilterColumnImpl(SBook book) {
            FilterColumnImpl tgt = new FilterColumnImpl(this._index);
            if (this._filters != null) {
                tgt._filters = new LinkedList<String>();
                for (String f : this._filters) {
                    tgt._filters.add(f);
                }
            }
            if (this._criteria1 != null) {
                tgt._criteria1 = new HashSet();
                for (String c : this._criteria1) {
                    tgt._criteria1.add(c);
                }
            }
            if (this._criteria2 != null) {
                tgt._criteria2 = new HashSet();
                for (String c : this._criteria2) {
                    tgt._criteria2.add(c);
                }
            }
            tgt._showButton = this._showButton;
            tgt._op = this._op;
            if (this._colorFilter != null) {
                tgt._colorFilter = ((ColorFilterImpl)this._colorFilter).cloneColorFilter(book);
            }
            if (this._customFilters != null) {
                tgt._customFilters = ((CustomFiltersImpl)this._customFilters).cloneCustomFilters();
            }
            if (this._dynamicFilter != null) {
                tgt._dynamicFilter = ((DynamicFilterImpl)this._dynamicFilter).cloneDynamicFilter();
            }
            if (this._top10Filter != null) {
                tgt._top10Filter = ((Top10FilterImpl)this._top10Filter).cloneTop10Filter();
            }
            return tgt;
        }

        @Override
        public SColorFilter getColorFilter() {
            return this._colorFilter;
        }

        @Override
        public SCustomFilters getCustomFilters() {
            return this._customFilters;
        }

        @Override
        public SDynamicFilter getDynamicFilter() {
            return this._dynamicFilter;
        }

        @Override
        public STop10Filter getTop10Filter() {
            return this._top10Filter;
        }

        public void setFilterType(int type) {
            this.filterType = type;
        }

        public int getFilterType() {
            return this.filterType;
        }

        @Override
        public boolean isFiltered() {
            return this._filters != null && !this._filters.isEmpty() || this._colorFilter != null || this._customFilters != null || this._dynamicFilter != null || this._top10Filter != null;
        }

        public void setIndex(int index0) {
            this._index = index0;
        }
    }
}

