/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.model;

import java.io.Serializable;
import org.zkoss.poi.ss.util.AreaReference;
import org.zkoss.poi.ss.util.CellReference;
import org.zkoss.zss.model.CellRegion;
import org.zkoss.zss.model.SSheet;

public class SheetRegion
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final SSheet _sheet;
    private final CellRegion _region;

    public SheetRegion(SSheet sheet, CellRegion region) {
        this._sheet = sheet;
        this._region = region;
    }

    public SheetRegion(SSheet sheet, int row, int column) {
        this(sheet, new CellRegion(row, column));
    }

    public SheetRegion(SSheet sheet, int row, int column, int lastRow, int lastColumn) {
        this(sheet, new CellRegion(row, column, lastRow, lastColumn));
    }

    public SheetRegion(SSheet sheet, String areaReference) {
        AreaReference ref = new AreaReference(areaReference, sheet.getBook().getMaxRowIndex());
        int row = ref.getFirstCell().getRow();
        short column = ref.getFirstCell().getCol();
        int lastRow = ref.getLastCell().getRow();
        int lastColumn = ref.getLastCell().getCol();
        if (row == -1) {
            row = 0;
        }
        if (lastRow == -1) {
            lastRow = sheet.getBook().getMaxRowIndex();
        }
        if (column == -1) {
            column = 0;
        }
        if (lastColumn == -1) {
            lastColumn = sheet.getBook().getMaxColumnIndex();
        }
        this._sheet = sheet;
        this._region = new CellRegion(Math.min(row, lastRow), Math.min(column, lastColumn), Math.max(row, lastRow), Math.max(column, lastColumn));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._sheet.getSheetName()).append("!").append(this._region.toString());
        return sb.toString();
    }

    public SSheet getSheet() {
        return this._sheet;
    }

    public CellRegion getRegion() {
        return this._region;
    }

    public int getRow() {
        return this._region.row;
    }

    public int getColumn() {
        return this._region.column;
    }

    public int getLastRow() {
        return this._region.lastRow;
    }

    public int getLastColumn() {
        return this._region.lastColumn;
    }

    public int getRowCount() {
        return this._region.getRowCount();
    }

    public int getColumnCount() {
        return this._region.getColumnCount();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._region == null ? 0 : this._region.hashCode());
        result = 31 * result + (this._sheet == null ? 0 : this._sheet.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SheetRegion other = (SheetRegion)obj;
        if (this._region == null ? other._region != null : !this._region.equals(other._region)) {
            return false;
        }
        return !(this._sheet == null ? other._sheet != null : !this._sheet.equals(other._sheet));
    }

    public String getReferenceString() {
        if (this._region.isSingle()) {
            return new CellReference(this._sheet.getSheetName(), this._region.getRow(), this._region.getColumn(), false, false).formatAsString();
        }
        return new AreaReference(new CellReference(this._sheet.getSheetName(), this._region.getRow(), this._region.getColumn(), false, false), new CellReference(this._sheet.getSheetName(), this._region.getLastRow(), this._region.getLastColumn(), false, false)).formatAsString();
    }
}

