/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.zkoss.poi.ss.util.AreaReference;
import org.zkoss.poi.ss.util.CellReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CellRegion
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final int row;
    public final int column;
    public final int lastRow;
    public final int lastColumn;

    public CellRegion(int row, int column) {
        this(row, column, row, column);
    }

    public CellRegion(String areaReference) {
        AreaReference ref = new AreaReference(areaReference);
        int row = ref.getFirstCell().getRow();
        short column = ref.getFirstCell().getCol();
        int lastRow = ref.getLastCell().getRow();
        short lastColumn = ref.getLastCell().getCol();
        this.row = Math.min(row, lastRow);
        this.column = Math.min(column, lastColumn);
        this.lastRow = Math.max(row, lastRow);
        this.lastColumn = Math.max(column, lastColumn);
        this.checkLegal();
    }

    public String getReferenceString() {
        AreaReference ref = new AreaReference(new CellReference(this.row, this.column), new CellReference(this.lastRow, this.lastColumn));
        return this.isSingle() ? ref.getFirstCell().formatAsString() : ref.formatAsString();
    }

    private void checkLegal() {
        if (this.row > this.lastRow || this.column > this.lastColumn || this.row < 0 || this.lastRow < 0 || this.column < 0 || this.lastColumn < 0) {
            throw new IllegalArgumentException("the region is illegal " + this);
        }
    }

    public CellRegion(int row, int column, int lastRow, int lastColumn) {
        this.row = row;
        this.column = column;
        this.lastRow = lastRow;
        this.lastColumn = lastColumn;
        this.checkLegal();
    }

    public boolean isSingle() {
        return this.row == this.lastRow && this.column == this.lastColumn;
    }

    public boolean contains(int row, int column) {
        return row >= this.row && row <= this.lastRow && column >= this.column && column <= this.lastColumn;
    }

    public boolean contains(CellRegion region) {
        return this.contains(region.row, region.column) && this.contains(region.lastRow, region.lastColumn);
    }

    public boolean overlaps(CellRegion region) {
        return CellRegion.overlaps0(this, region) || CellRegion.overlaps0(region, this);
    }

    private static boolean overlaps0(CellRegion r1, CellRegion r2) {
        return r1.lastColumn >= r2.column && r1.lastRow >= r2.row && r1.column <= r2.lastColumn && r1.row <= r2.lastRow;
    }

    public boolean equals(int row, int column, int lastRow, int lastColumn) {
        return this.row == row && this.column == column && this.lastRow == lastRow && this.lastColumn == lastColumn;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getReferenceString()).append("[").append(this.row).append(",").append(this.column).append(",").append(this.lastRow).append(",").append(this.lastColumn).append("]");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.column;
        result = 31 * result + this.lastColumn;
        result = 31 * result + this.lastRow;
        result = 31 * result + this.row;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CellRegion other = (CellRegion)obj;
        if (this.column != other.column) {
            return false;
        }
        if (this.lastColumn != other.lastColumn) {
            return false;
        }
        if (this.lastRow != other.lastRow) {
            return false;
        }
        return this.row == other.row;
    }

    public int getRow() {
        return this.row;
    }

    public int getColumn() {
        return this.column;
    }

    public int getLastRow() {
        return this.lastRow;
    }

    public int getLastColumn() {
        return this.lastColumn;
    }

    public int getRowCount() {
        return this.lastRow - this.row + 1;
    }

    public int getColumnCount() {
        return this.lastColumn - this.column + 1;
    }

    public static String convertIndexToColumnString(int columnIdx) {
        return CellReference.convertNumToColString((int)columnIdx);
    }

    public static int convertColumnStringToIndex(String colRef) {
        return CellReference.convertColStringToIndex((String)colRef);
    }

    public List<CellRegion> diff(CellRegion target) {
        ArrayList<CellRegion> result = new ArrayList<CellRegion>();
        if (!this.overlaps(target)) {
            result.add(this);
        } else {
            CellRegion overlapRegion = new CellRegion(Math.max(this.row, target.row), Math.max(this.column, target.column), Math.min(this.lastRow, target.lastRow), Math.min(this.lastColumn, target.lastColumn));
            if (!overlapRegion.equals(this)) {
                if (overlapRegion.row - this.row > 0) {
                    result.add(new CellRegion(this.row, this.column, overlapRegion.row - 1, this.lastColumn));
                }
                if (overlapRegion.column - this.column > 0) {
                    result.add(new CellRegion(overlapRegion.row, this.column, overlapRegion.lastRow, overlapRegion.column - 1));
                }
                if (this.lastColumn - overlapRegion.lastColumn > 0) {
                    result.add(new CellRegion(overlapRegion.row, overlapRegion.lastColumn + 1, overlapRegion.lastRow, this.lastColumn));
                }
                if (this.lastRow - overlapRegion.lastRow > 0) {
                    result.add(new CellRegion(overlapRegion.lastRow + 1, this.column, this.lastRow, this.lastColumn));
                }
            }
        }
        return result;
    }

    public CellRegion getOverlap(CellRegion target) {
        int col2;
        int row2;
        int row1 = Math.max(this.row, target.row);
        if (row1 > (row2 = Math.min(this.lastRow, target.lastRow))) {
            return null;
        }
        int col1 = Math.max(this.column, target.column);
        if (col1 > (col2 = Math.min(this.lastColumn, target.lastColumn))) {
            return null;
        }
        return new CellRegion(row1, col1, row2, col2);
    }

    public int getCellCount() {
        return this.getRowCount() * this.getColumnCount();
    }

    public CellRegion cloneCellRegion() {
        return new CellRegion(this.row, this.column, this.lastRow, this.lastColumn);
    }

    public CellRegion intersect(CellRegion target) {
        int row1 = Math.max(this.row, target.row);
        int row2 = Math.min(this.lastRow, target.lastRow);
        int col1 = Math.max(this.column, target.column);
        int col2 = Math.min(this.lastColumn, target.lastColumn);
        if (row1 > row2 || col1 > col2) {
            return null;
        }
        return new CellRegion(row1, col1, row2, col2);
    }
}

