/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.range.impl.imexp;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import org.zkoss.lang.Library;
import org.zkoss.poi.POIXMLDocument;
import org.zkoss.poi.poifs.filesystem.POIFSFileSystem;
import org.zkoss.zss.model.SBook;
import org.zkoss.zss.range.impl.imexp.AbstractExcelImporter;
import org.zkoss.zss.range.impl.imexp.AbstractImporter;
import org.zkoss.zss.range.impl.imexp.ExcelXlsImporter;
import org.zkoss.zss.range.impl.imexp.ExcelXlsxImporter;

public class ExcelImportAdapter
extends AbstractImporter {
    public SBook imports(InputStream is, String bookName) throws IOException {
        if (!is.markSupported()) {
            is = new PushbackInputStream(is, 8);
        }
        AbstractExcelImporter importer = null;
        if (POIFSFileSystem.hasPOIFSHeader((InputStream)is)) {
            importer = new ExcelXlsImporter();
        } else if (POIXMLDocument.hasOOXMLHeader((InputStream)is)) {
            importer = new ExcelXlsxImporter();
        }
        if (importer != null) {
            importer.setImportCache(this.isImportCache());
            return importer.imports(is, bookName);
        }
        throw new IllegalArgumentException("The input stream to be imported is neither an OLE2 stream, nor an OOXML stream");
    }

    protected boolean isImportCache() {
        String importCache = Library.getProperty((String)"org.zkoss.zss.import.cache", (String)"false");
        return "true".equalsIgnoreCase(importCache.trim());
    }
}

