/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.range.impl.autofill;

import java.text.DateFormatSymbols;
import java.util.Locale;
import org.zkoss.util.CacheMap;
import org.zkoss.util.Pair;
import org.zkoss.zss.range.impl.autofill.CircularData;

public class ShortWeekData
extends CircularData {
    private static final CacheMap _weekData = new CacheMap(4);

    private ShortWeekData(String[] data, int type, Locale locale) {
        super(data, type, locale);
    }

    public static ShortWeekData getInstance(int type, Locale locale) {
        Pair key = new Pair((Object)locale, (Object)type);
        ShortWeekData value = (ShortWeekData)_weekData.get((Object)key);
        if (value == null) {
            DateFormatSymbols symbols = new DateFormatSymbols(locale);
            if (symbols == null) {
                symbols = new DateFormatSymbols(Locale.US);
            }
            String[] week8 = symbols.getShortWeekdays();
            String[] week7 = new String[7];
            System.arraycopy(week8, 1, week7, 0, 7);
            value = new ShortWeekData(week7, type, locale);
            _weekData.put((Object)key, (Object)value);
        }
        return value;
    }

    static {
        _weekData.setLifetime(86400000);
    }
}

