/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.range.impl;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import org.zkoss.util.logging.Log;
import org.zkoss.zss.model.SBook;
import org.zkoss.zss.model.SBookSeries;
import org.zkoss.zss.model.SSheet;
import org.zkoss.zss.model.SheetRegion;
import org.zkoss.zss.model.impl.CellAttribute;
import org.zkoss.zss.model.sys.dependency.ObjectRef;
import org.zkoss.zss.model.sys.dependency.Ref;
import org.zkoss.zss.range.impl.NotifyChangeHelper;
import org.zkoss.zss.range.impl.RefHelperBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RefNotifyContentChangeHelper
extends RefHelperBase
implements Serializable {
    private static final long serialVersionUID = -816763214525819388L;
    private static final Log _logger = Log.lookup(RefNotifyContentChangeHelper.class);
    private NotifyChangeHelper _notifyHelper = new NotifyChangeHelper();

    public RefNotifyContentChangeHelper(SBookSeries bookSeries) {
        super(bookSeries);
    }

    @Deprecated
    public void notifyContentChange(Ref notify) {
        this.notifyContentChange(notify, CellAttribute.ALL);
    }

    public void notifyContentChange(Ref notify, CellAttribute cellAttr) {
        if (notify.getType() == Ref.RefType.CELL || notify.getType() == Ref.RefType.AREA) {
            this.handleAreaRef(notify, cellAttr);
        } else if (notify.getType() == Ref.RefType.OBJECT) {
            if (((ObjectRef)notify).getObjectType() == ObjectRef.ObjectType.CHART) {
                this.handleChartRef((ObjectRef)notify);
            } else if (((ObjectRef)notify).getObjectType() == ObjectRef.ObjectType.DATA_VALIDATION) {
                this.handleDataValidationRef((ObjectRef)notify);
            } else if (((ObjectRef)notify).getObjectType() == ObjectRef.ObjectType.AUTO_FILTER) {
                this.handleAutoFilterRef((ObjectRef)notify);
            }
        }
    }

    @Deprecated
    public void notifyContentChange(Set<Ref> notifySet) {
        this.notifyContentChange(notifySet, CellAttribute.ALL);
    }

    public void notifyContentChange(Set<Ref> notifySet, CellAttribute cellAttr) {
        block6: {
            Ref notify2;
            LinkedHashMap<String, Ref> chartDependents = new LinkedHashMap<String, Ref>();
            LinkedHashMap<String, Ref> validationDependents = new LinkedHashMap<String, Ref>();
            for (Ref notify2 : notifySet) {
                if (_logger.debugable()) {
                    _logger.debug("Notify Dependent Change : " + notify2 + " with attibute " + (Object)((Object)cellAttr));
                }
                if (notify2.getType() == Ref.RefType.CELL || notify2.getType() == Ref.RefType.AREA) {
                    this.handleAreaRef(notify2, cellAttr);
                    continue;
                }
                if (notify2.getType() != Ref.RefType.OBJECT) continue;
                if (((ObjectRef)notify2).getObjectType() == ObjectRef.ObjectType.CHART) {
                    chartDependents.put(((ObjectRef)notify2).getObjectIdPath()[0], notify2);
                    continue;
                }
                if (((ObjectRef)notify2).getObjectType() == ObjectRef.ObjectType.DATA_VALIDATION) {
                    validationDependents.put(((ObjectRef)notify2).getObjectIdPath()[0], notify2);
                    continue;
                }
                if (((ObjectRef)notify2).getObjectType() != ObjectRef.ObjectType.AUTO_FILTER) continue;
                this.handleAutoFilterRef((ObjectRef)notify2);
            }
            for (Ref notify2 : chartDependents.values()) {
                this.handleChartRef((ObjectRef)notify2);
            }
            Iterator<Ref> iterator = validationDependents.values().iterator();
            if (!iterator.hasNext()) break block6;
            notify2 = iterator.next();
            this.handleDataValidationRef((ObjectRef)notify2);
        }
    }

    private void handleChartRef(ObjectRef notify) {
        SBook book = this.bookSeries.getBook(notify.getBookName());
        if (book == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(notify.getSheetName());
        if (sheet == null) {
            return;
        }
        String[] ids = notify.getObjectIdPath();
        this._notifyHelper.notifyChartChange(sheet, ids[0]);
    }

    private void handleDataValidationRef(ObjectRef notify) {
        SBook book = this.bookSeries.getBook(notify.getBookName());
        if (book == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(notify.getSheetName());
        if (sheet == null) {
            return;
        }
        String[] ids = notify.getObjectIdPath();
        this._notifyHelper.notifyDataValidationChange(sheet, ids[0]);
    }

    private void handleAutoFilterRef(ObjectRef notify) {
        SBook book = this.bookSeries.getBook(notify.getBookName());
        if (book == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(notify.getSheetName());
        if (sheet == null) {
            return;
        }
        this._notifyHelper.notifySheetAutoFilterChange(sheet, null);
    }

    private void handleAreaRef(Ref notify, CellAttribute cellAttr) {
        SBook book = this.bookSeries.getBook(notify.getBookName());
        if (book == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(notify.getSheetName());
        if (sheet == null) {
            return;
        }
        int row1 = notify.getRow();
        int row2 = notify.getLastRow();
        int col1 = notify.getColumn();
        int col2 = notify.getLastColumn();
        this._notifyHelper.notifyCellChange(new SheetRegion(sheet, row1, col1, row2, col2), cellAttr);
    }
}

