/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.range.impl;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.zkoss.poi.ss.usermodel.ZssContext;
import org.zkoss.zss.model.SAutoFilter;
import org.zkoss.zss.model.SCell;
import org.zkoss.zss.model.SCustomFilter;
import org.zkoss.zss.model.sys.EngineFactory;
import org.zkoss.zss.model.sys.format.FormatContext;
import org.zkoss.zss.model.sys.format.FormatEngine;
import org.zkoss.zss.range.impl.GreaterThan;
import org.zkoss.zss.range.impl.GreaterThanOrEqual;
import org.zkoss.zss.range.impl.LessThan;
import org.zkoss.zss.range.impl.LessThanOrEqual;
import org.zkoss.zss.range.impl.Matchable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CellMatch
implements Matchable<SCell>,
Serializable {
    private static final long serialVersionUID = 4775550316177451879L;
    private FilterMatch f1;
    private FilterMatch f2;
    private boolean isAnd;

    public CellMatch(SCustomFilter f1, SCustomFilter f2, boolean isAnd) {
        this.f1 = new FilterMatch(f1);
        this.f2 = f2 == null ? null : new FilterMatch(f2);
        this.isAnd = isAnd;
    }

    @Override
    public boolean match(SCell cell) {
        boolean matchf1 = this.f1.match(cell);
        if (this.isAnd && !matchf1) {
            return false;
        }
        if (!this.isAnd && matchf1) {
            return true;
        }
        if (this.f2 != null) {
            return this.f2.match(cell);
        }
        return matchf1;
    }

    static class FilterMatch
    implements Serializable {
        private boolean _not;
        private Pattern _pattern;
        private Matchable<?> _matchable;
        private Object value;
        private SAutoFilter.FilterOp op;
        private SCell.CellType type;
        private FormatEngine _formatEngine;

        FilterMatch(SCustomFilter filter) {
            this.op = filter.getOperator();
            switch (this.op) {
                case equal: 
                case notEqual: 
                case beginWith: 
                case notBeginWith: 
                case endWith: 
                case notEndWith: 
                case contains: 
                case notContains: {
                    this.value = filter.getValue();
                    this.type = SCell.CellType.STRING;
                    break;
                }
                default: {
                    try {
                        this.value = Double.valueOf(filter.getValue());
                        this.type = SCell.CellType.NUMBER;
                        break;
                    }
                    catch (NumberFormatException ex) {
                        this.value = filter.getValue();
                        this.type = SCell.CellType.STRING;
                    }
                }
            }
            this._prepareMatch();
        }

        public String _getFormattedText(SCell cell) {
            return this.getFormatEngine().format(cell, new FormatContext(ZssContext.getCurrent().getLocale())).getText();
        }

        protected FormatEngine getFormatEngine() {
            if (this._formatEngine == null) {
                this._formatEngine = EngineFactory.getInstance().createFormatEngine();
            }
            return this._formatEngine;
        }

        public boolean match(SCell cell) {
            boolean ret;
            SCell.CellType t;
            SCell.CellType cellType = cell == null || cell.isNull() ? SCell.CellType.BLANK : (t = cell.getType() == SCell.CellType.FORMULA ? cell.getFormulaResultType() : cell.getType());
            if (t != this.type && this.op != SAutoFilter.FilterOp.equal && this.op != SAutoFilter.FilterOp.notEqual) {
                return this._not;
            }
            boolean bl = ret = this.type == SCell.CellType.STRING ? this.matchString(cell) : this.matchDouble(cell);
            return this._not ? !ret : ret;
        }

        private boolean matchString(SCell cell) {
            String formattedText = this._getFormattedText(cell);
            if (this._pattern != null) {
                Matcher matcher = this._pattern.matcher(formattedText);
                return matcher.matches();
            }
            if (this._matchable != null) {
                return this._matchable.match(formattedText);
            }
            return false;
        }

        private boolean matchDouble(SCell cell) {
            Double val = cell.getNumberValue();
            return this._matchable.match(val);
        }

        private void _prepareMatch() {
            switch (this.op) {
                case notBeginWith: {
                    this._not = true;
                }
                case beginWith: {
                    String val = this._escape(this.value.toString());
                    val = val + ".*";
                    this._pattern = Pattern.compile(val);
                    break;
                }
                case notEndWith: {
                    this._not = true;
                }
                case endWith: {
                    String val = this._escape(this.value.toString());
                    val = ".*" + val;
                    this._pattern = Pattern.compile(val);
                    break;
                }
                case notContains: {
                    this._not = true;
                }
                case contains: {
                    String val = this._escape(this.value.toString());
                    val = ".*" + val + ".*";
                    this._pattern = Pattern.compile(val);
                    break;
                }
                case notEqual: {
                    this._not = true;
                }
                case equal: {
                    String val = this._escape(this.value.toString());
                    this._pattern = Pattern.compile(val);
                    break;
                }
                case after: 
                case greaterThan: {
                    this._matchable = this.type == SCell.CellType.STRING ? new GreaterThan<String>(this.value.toString()) : new GreaterThan<Double>((Double)this.value);
                    break;
                }
                case afterEq: 
                case greaterThanOrEqual: {
                    this._matchable = this.type == SCell.CellType.STRING ? new GreaterThanOrEqual<String>(this.value.toString()) : new GreaterThanOrEqual<Double>((Double)this.value);
                    break;
                }
                case before: 
                case lessThan: {
                    this._matchable = this.type == SCell.CellType.STRING ? new LessThan<String>(this.value.toString()) : new LessThan<Double>((Double)this.value);
                    break;
                }
                case beforeEq: 
                case lessThanOrEqual: {
                    this._matchable = this.type == SCell.CellType.STRING ? new LessThanOrEqual<String>(this.value.toString()) : new LessThanOrEqual<Double>((Double)this.value);
                }
            }
        }

        private String _escape(String src) {
            String s1 = src.replaceAll("([.+^$\\[\\]\\\\(){}|-])", "\\\\$0");
            String s2 = s1.replaceAll("\\*", ".*");
            return s2.replaceAll("\\?", ".");
        }
    }
}

