/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.range.impl;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.TimeZone;
import org.zkoss.lang.Integers;
import org.zkoss.poi.ss.usermodel.DateUtil;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zss.model.CellRegion;
import org.zkoss.zss.model.InvalidModelOpException;
import org.zkoss.zss.model.SAutoFilter;
import org.zkoss.zss.model.SBook;
import org.zkoss.zss.model.SCell;
import org.zkoss.zss.model.SCellStyle;
import org.zkoss.zss.model.SColorFilter;
import org.zkoss.zss.model.SCustomFilter;
import org.zkoss.zss.model.SCustomFilters;
import org.zkoss.zss.model.SDynamicFilter;
import org.zkoss.zss.model.SExtraStyle;
import org.zkoss.zss.model.SFill;
import org.zkoss.zss.model.SRow;
import org.zkoss.zss.model.STable;
import org.zkoss.zss.model.STop10Filter;
import org.zkoss.zss.model.impl.AbstractAutoFilterAdv;
import org.zkoss.zss.model.impl.AbstractCellAdv;
import org.zkoss.zss.model.impl.AbstractSheetAdv;
import org.zkoss.zss.model.impl.CellStyleImpl;
import org.zkoss.zss.model.impl.CellValue;
import org.zkoss.zss.model.impl.ColorFilterImpl;
import org.zkoss.zss.model.impl.CustomFilterImpl;
import org.zkoss.zss.model.impl.CustomFiltersImpl;
import org.zkoss.zss.model.impl.DynamicFilterImpl;
import org.zkoss.zss.model.impl.ExtraFillImpl;
import org.zkoss.zss.model.impl.ExtraStyleImpl;
import org.zkoss.zss.model.impl.Top10FilterImpl;
import org.zkoss.zss.model.util.CellStyleMatcher;
import org.zkoss.zss.range.SRange;
import org.zkoss.zss.range.SRanges;
import org.zkoss.zss.range.impl.CellMatch;
import org.zkoss.zss.range.impl.DataRegionHelper;
import org.zkoss.zss.range.impl.DatesMatch;
import org.zkoss.zss.range.impl.GreaterThan;
import org.zkoss.zss.range.impl.GreaterThanOrEqual;
import org.zkoss.zss.range.impl.LessThan;
import org.zkoss.zss.range.impl.LessThanOrEqual;
import org.zkoss.zss.range.impl.Matchable;
import org.zkoss.zss.range.impl.MonthMatch;
import org.zkoss.zss.range.impl.QuarterMatch;
import org.zkoss.zss.range.impl.RangeHelperBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AutoFilterHelper
extends RangeHelperBase {
    private static final long serialVersionUID = 764704415825488241L;
    private static final SCellStyle BLANK_STYLE = CellStyleImpl.BLANK_STYLE;
    private static Date MIN_DATE;

    public AutoFilterHelper(SRange range) {
        super(range);
    }

    public CellRegion findAutoFilterRegion() {
        return new DataRegionHelper(this.range).findAutoFilterDataRegion();
    }

    public SAutoFilter enableTableFilter(STable table, boolean enable) {
        SAutoFilter filter = table.getAutoFilter();
        if (filter != null && !enable) {
            CellRegion region = filter.getRegion();
            SRange toUnhide = SRanges.range(this.sheet, region.getRow(), region.getColumn(), region.getLastRow(), region.getLastColumn()).getRows();
            toUnhide.setHidden(false);
            table.deleteAutoFilter();
            filter = null;
        } else if (filter == null && enable) {
            table.enableAutoFilter(enable);
            filter = table.getAutoFilter();
        }
        return filter;
    }

    public SAutoFilter enableAutoFilter(boolean enable) {
        SAutoFilter filter = this.sheet.getAutoFilter();
        if (filter != null && !enable) {
            CellRegion region = filter.getRegion();
            SRange toUnhide = SRanges.range(this.sheet, region.getRow(), region.getColumn(), region.getLastRow(), region.getLastColumn()).getRows();
            toUnhide.setHidden(false);
            this.sheet.deleteAutoFilter();
            filter = null;
        } else if (filter == null && enable) {
            CellRegion region = this.findAutoFilterRegion();
            if (region != null) {
                filter = this.sheet.createAutoFilter(region);
            } else {
                throw new InvalidModelOpException("can't find any data in range");
            }
        }
        return filter;
    }

    @Deprecated
    public SAutoFilter enableAutoFilter(int field, SAutoFilter.FilterOp filterOp, Object criteria1, Object criteria2, Boolean showButton) {
        STable table = ((AbstractSheetAdv)this.sheet).getTableByRowCol(this.getRow(), this.getColumn());
        return this.enableAutoFilter(table, field, filterOp, criteria1, criteria2, showButton);
    }

    public SAutoFilter enableAutoFilter(STable table, int field, SAutoFilter.FilterOp filterOp, Object criteria1, Object criteria2, Boolean showButton) {
        SAutoFilter filter;
        SAutoFilter sAutoFilter = filter = table == null ? this.sheet.getAutoFilter() : table.getAutoFilter();
        if (filter == null) {
            if (table != null) {
                table.enableAutoFilter(true);
                filter = table.getAutoFilter();
            } else {
                CellRegion region = new DataRegionHelper(this.range).findAutoFilterDataRegion();
                if (region != null) {
                    filter = this.sheet.createAutoFilter(region);
                } else {
                    throw new InvalidModelOpException("can't find any data in range");
                }
            }
        }
        this.enableAutoFilter0(table, filter, field, filterOp, criteria1, criteria2, showButton);
        return filter;
    }

    private Matchable<Double> getMatchByTop10Filter(STop10Filter top10Filter) {
        boolean isTop = top10Filter.isTop();
        Double filterVal = top10Filter.getFilterValue();
        return isTop ? new GreaterThanOrEqual<Double>(filterVal) : new LessThanOrEqual<Double>(filterVal);
    }

    private Matchable<Double> getMatchByDynamicFilter(SDynamicFilter dynaFilter) {
        boolean isAbove = "aboveAverage".equals(dynaFilter.getType());
        Double avg = dynaFilter.getValue();
        return isAbove ? new GreaterThan<Double>(avg) : new LessThan<Double>(avg);
    }

    private Matchable<Date> getMatchDateByDynamicFilter(SDynamicFilter dynaFilter) {
        SAutoFilter.FilterOp op = SAutoFilter.FilterOp.valueOf(dynaFilter.getType());
        switch (op) {
            case tomorrow: 
            case today: 
            case yesterday: 
            case nextWeek: 
            case thisWeek: 
            case lastWeek: 
            case nextMonth: 
            case thisMonth: 
            case lastMonth: 
            case nextQuarter: 
            case thisQuarter: 
            case lastQuarter: 
            case nextYear: 
            case thisYear: 
            case lastYear: 
            case yearToDate: {
                Double min = dynaFilter.getValue();
                Double max = dynaFilter.getMaxValue();
                return new DatesMatch(min.intValue(), max.intValue());
            }
            case Q1: {
                return new QuarterMatch(0, 3);
            }
            case Q2: {
                return new QuarterMatch(3, 6);
            }
            case Q3: {
                return new QuarterMatch(6, 9);
            }
            case Q4: {
                return new QuarterMatch(9, 12);
            }
            case M1: {
                return new MonthMatch(0);
            }
            case M2: {
                return new MonthMatch(1);
            }
            case M3: {
                return new MonthMatch(2);
            }
            case M4: {
                return new MonthMatch(3);
            }
            case M5: {
                return new MonthMatch(4);
            }
            case M6: {
                return new MonthMatch(5);
            }
            case M7: {
                return new MonthMatch(6);
            }
            case M8: {
                return new MonthMatch(7);
            }
            case M9: {
                return new MonthMatch(8);
            }
            case M10: {
                return new MonthMatch(9);
            }
            case M11: {
                return new MonthMatch(10);
            }
            case M12: {
                return new MonthMatch(11);
            }
        }
        return null;
    }

    private Double _pickTop10(int col, int row, int row2, int value, boolean isTop, boolean isPercent) {
        if (value <= 0) {
            return null;
        }
        int count = 0;
        boolean error = false;
        ArrayList<Double> list = new ArrayList<Double>();
        for (int r = row + 1; r <= row2; ++r) {
            SCell cell = this.sheet.getCell(r, col);
            CellValue cellval = ((AbstractCellAdv)cell).getEvalCellValue(true);
            if (cellval.getType() == SCell.CellType.ERROR) {
                error = true;
                break;
            }
            if (cellval.getType() != SCell.CellType.NUMBER) continue;
            list.add(((Number)cellval.getValue()).doubleValue());
            ++count;
        }
        if (error) {
            return null;
        }
        Collections.sort(list);
        count = isPercent ? Math.min((int)Math.ceil((double)(count * value) / 100.0), count) : Math.min(count, value);
        return isTop ? (Double)list.get(list.size() - count) : (Double)list.get(count - 1);
    }

    private Double _calcAverage(int col, int row, int row2) {
        double total = 0.0;
        int count = 0;
        boolean error = false;
        for (int r = row; r <= row2; ++r) {
            SCell cell = this.sheet.getCell(r, col);
            CellValue cellval = ((AbstractCellAdv)cell).getEvalCellValue(true);
            if (cellval.getType() == SCell.CellType.ERROR) {
                error = true;
                break;
            }
            if (cellval.getType() != SCell.CellType.NUMBER) continue;
            total += ((Number)cellval.getValue()).doubleValue();
            ++count;
        }
        if (error) {
            return null;
        }
        return total / (double)count;
    }

    private LinkedHashMap<Integer, Boolean> _filterByTop10Filter(SAutoFilter filter, SAutoFilter.NFilterColumn fc, int field) {
        STop10Filter top10Filter = fc.getTop10Filter();
        Matchable<Double> match = this.getMatchByTop10Filter(top10Filter);
        return this._filterByNumber(filter, fc, field, match);
    }

    private LinkedHashMap<Integer, Boolean> _filterByDynamicFilter(SAutoFilter filter, SAutoFilter.NFilterColumn fc, int field) {
        SDynamicFilter dynaFilter = fc.getDynamicFilter();
        SAutoFilter.FilterOp op = SAutoFilter.FilterOp.valueOf(dynaFilter.getType());
        switch (op) {
            case aboveAverage: 
            case belowAverage: {
                Matchable<Double> match = this.getMatchByDynamicFilter(dynaFilter);
                return this._filterByNumber(filter, fc, field, match);
            }
        }
        Matchable<Date> matchDate = this.getMatchDateByDynamicFilter(dynaFilter);
        return this._filterByDate(filter, fc, field, matchDate);
    }

    private LinkedHashMap<Integer, Boolean> _filterByNumber(SAutoFilter filter, SAutoFilter.NFilterColumn fc, int field, Matchable<Double> match) {
        CellRegion affectedArea = filter.getRegion();
        int row1 = affectedArea.getRow();
        int col1 = affectedArea.getColumn();
        int col = col1 + field - 1;
        int row = row1 + 1;
        int row2 = affectedArea.getLastRow();
        LinkedHashMap<Integer, Boolean> affectedRows = new LinkedHashMap<Integer, Boolean>();
        for (int r = row; r <= row2; ++r) {
            SRow rowobj;
            SCell cell = this.sheet.getCell(r, col);
            CellValue cellval = ((AbstractCellAdv)cell).getEvalCellValue(true);
            Object val = cellval.getValue();
            if (val instanceof Date) {
                val = DateUtil.getExcelDate((Date)((Date)val));
            }
            if (cellval.getType() == SCell.CellType.NUMBER && match.match((Double)val)) {
                rowobj = this.sheet.getRow(r);
                if (!rowobj.isHidden() || !this.canUnhide(filter, fc, r, col1)) continue;
                affectedRows.put(r, false);
                continue;
            }
            rowobj = this.sheet.getRow(r);
            if (rowobj.isHidden()) continue;
            affectedRows.put(r, true);
        }
        return affectedRows;
    }

    private LinkedHashMap<Integer, Boolean> _filterByDate(SAutoFilter filter, SAutoFilter.NFilterColumn fc, int field, Matchable<Date> match) {
        CellRegion affectedArea = filter.getRegion();
        int row1 = affectedArea.getRow();
        int col1 = affectedArea.getColumn();
        int col = col1 + field - 1;
        int row = row1 + 1;
        int row2 = affectedArea.getLastRow();
        LinkedHashMap<Integer, Boolean> affectedRows = new LinkedHashMap<Integer, Boolean>();
        for (int r = row; r <= row2; ++r) {
            SRow rowobj;
            SCell cell = this.sheet.getCell(r, col);
            CellValue cellval = ((AbstractCellAdv)cell).getEvalCellValue(true);
            Object val = cellval.getValue();
            if (cellval.getType() == SCell.CellType.NUMBER && !(val instanceof Date)) {
                val = DateUtil.getJavaDate((double)((Double)val), (TimeZone)TimeZone.getTimeZone("UTC"));
            }
            if (cellval.getType() == SCell.CellType.NUMBER && match.match((Date)val)) {
                rowobj = this.sheet.getRow(r);
                if (!rowobj.isHidden() || !this.canUnhide(filter, fc, r, col1)) continue;
                affectedRows.put(r, false);
                continue;
            }
            rowobj = this.sheet.getRow(r);
            if (rowobj.isHidden()) continue;
            affectedRows.put(r, true);
        }
        return affectedRows;
    }

    private STop10Filter _prepareTop10Filter(Object[] criteria, CellRegion region, int field, SAutoFilter.FilterOp op) {
        int row = region.getRow();
        int row2 = region.getLastRow();
        int col = region.getColumn() + field - 1;
        boolean isTop = criteria[1] == Boolean.TRUE;
        boolean isPercent = criteria[2] == Boolean.TRUE;
        int value = (Integer)criteria[0];
        Double filterVal = this._pickTop10(col, row, row2, value, isTop, isPercent);
        return filterVal == null ? null : new Top10FilterImpl(isTop, value, isPercent, filterVal);
    }

    private SDynamicFilter _prepareDynamicFilter(CellRegion region, int field, SAutoFilter.FilterOp op) {
        int row = region.getRow();
        int row2 = region.getLastRow();
        int col = region.getColumn() + field - 1;
        Double maxVal = null;
        Double val = null;
        boolean fail = false;
        switch (op) {
            case aboveAverage: {
                val = this._calcAverage(col, row, row2);
                if (val != null) break;
                fail = true;
                break;
            }
            case belowAverage: {
                val = this._calcAverage(col, row, row2);
                if (val != null) break;
                fail = true;
                break;
            }
            case tomorrow: {
                double[] res = DateUtil.calcTomorrow();
                val = res[0];
                maxVal = res[1];
                break;
            }
            case today: {
                double[] res = DateUtil.calcToday();
                val = res[0];
                maxVal = res[1];
                break;
            }
            case yesterday: {
                double[] res = DateUtil.calcYesterday();
                val = res[0];
                maxVal = res[1];
                break;
            }
            case nextWeek: {
                double[] res = DateUtil.calcNextWeek();
                val = res[0];
                maxVal = res[1];
                break;
            }
            case thisWeek: {
                double[] res = DateUtil.calcThisWeek();
                val = res[0];
                maxVal = res[1];
                break;
            }
            case lastWeek: {
                double[] res = DateUtil.calcLastWeek();
                val = res[0];
                maxVal = res[1];
                break;
            }
            case nextMonth: {
                double[] res = DateUtil.calcNextMonth();
                val = res[0];
                maxVal = res[1];
                break;
            }
            case thisMonth: {
                double[] res = DateUtil.calcThisMonth();
                val = res[0];
                maxVal = res[1];
                break;
            }
            case lastMonth: {
                double[] res = DateUtil.calcLastMonth();
                val = res[0];
                maxVal = res[1];
                break;
            }
            case nextQuarter: {
                double[] res = DateUtil.calcNextQuarter();
                val = res[0];
                maxVal = res[1];
                break;
            }
            case thisQuarter: {
                double[] res = DateUtil.calcThisQuarter();
                val = res[0];
                maxVal = res[1];
                break;
            }
            case lastQuarter: {
                double[] res = DateUtil.calcLastQuarter();
                val = res[0];
                maxVal = res[1];
                break;
            }
            case nextYear: {
                double[] res = DateUtil.calcNextYear();
                val = res[0];
                maxVal = res[1];
                break;
            }
            case thisYear: {
                double[] res = DateUtil.calcThisYear();
                val = res[0];
                maxVal = res[1];
                break;
            }
            case lastYear: {
                double[] res = DateUtil.calcLastYear();
                val = res[0];
                maxVal = res[1];
                break;
            }
            case yearToDate: {
                double[] res = DateUtil.calcYearToDate();
                val = res[0];
                maxVal = res[1];
                break;
            }
        }
        return fail ? null : new DynamicFilterImpl(maxVal, val, op.name());
    }

    private SCustomFilters _prepareCustomFilters(String[] criteria1, String[] criteria2, boolean isAnd) {
        SAutoFilter.FilterOp op1 = SAutoFilter.FilterOp.valueOf(criteria1[0]);
        String val1 = criteria1[1];
        CustomFilterImpl f1 = new CustomFilterImpl(val1, op1);
        SAutoFilter.FilterOp op2 = criteria2 != null ? SAutoFilter.FilterOp.valueOf(criteria2[0]) : null;
        String val2 = criteria2 != null ? criteria2[1] : null;
        CustomFilterImpl f2 = op2 == null ? null : new CustomFilterImpl(val2, op2);
        return new CustomFiltersImpl(f1, f2, isAnd);
    }

    private SColorFilter _prepareColorFilter(String[] criteria, boolean byFontColor) {
        SFill.FillPattern pattern = SFill.FillPattern.valueOf(criteria[0]);
        String fg = criteria[1];
        String bg = criteria[2];
        ExtraFillImpl fill = new ExtraFillImpl(pattern, fg, bg);
        ExtraStyleImpl src = new ExtraStyleImpl(null, fill, null, null);
        CellStyleMatcher matcher = new CellStyleMatcher(src);
        SBook book = this.range.getSheet().getBook();
        SExtraStyle style = book.searchExtraStyle(matcher);
        if (style == null) {
            book.addExtraStyle(src);
            style = src;
        }
        return new ColorFilterImpl(style, byFontColor);
    }

    private Matchable<SCell> getMatchByCustomFilters(SCustomFilters filters, int filterType) {
        SCustomFilter f1 = filters.getCustomFilter1();
        SCustomFilter f2 = filters.getCustomFilter2();
        boolean isAnd = filters.isAnd();
        return new CellMatch(f1, f2, isAnd);
    }

    private LinkedHashMap<Integer, Boolean> _filterByCustomFilters(SAutoFilter filter, SAutoFilter.NFilterColumn fc, int field) {
        CellRegion affectedArea = filter.getRegion();
        int row1 = affectedArea.getRow();
        int col1 = affectedArea.getColumn();
        int col = col1 + field - 1;
        int row = row1 + 1;
        int row2 = affectedArea.getLastRow();
        SCustomFilters filters = fc.getCustomFilters();
        int filterType = ((AbstractAutoFilterAdv.FilterColumnImpl)fc).getFilterType();
        Matchable<SCell> match = this.getMatchByCustomFilters(filters, filterType);
        LinkedHashMap<Integer, Boolean> affectedRows = new LinkedHashMap<Integer, Boolean>();
        for (int r = row; r <= row2; ++r) {
            SRow rowobj;
            SCell cell = this.sheet.getCell(r, col);
            if (!match.match(cell.isNull() ? null : cell)) {
                rowobj = this.sheet.getRow(r);
                if (rowobj.isHidden()) continue;
                affectedRows.put(r, true);
                continue;
            }
            rowobj = this.sheet.getRow(r);
            if (!rowobj.isHidden() || !this.canUnhide(filter, fc, r, col1)) continue;
            affectedRows.put(r, false);
        }
        return affectedRows;
    }

    private boolean _match(SCellStyle style, SFill fill, boolean byFontColor) {
        if (byFontColor) {
            return fill.getFillColor().equals(style.getFont().getColor());
        }
        return fill.equals(style.getFill());
    }

    private LinkedHashMap<Integer, Boolean> _filterByColor(SAutoFilter filter, SAutoFilter.NFilterColumn fc, int field) {
        CellRegion affectedArea = filter.getRegion();
        int row1 = affectedArea.getRow();
        int col1 = affectedArea.getColumn();
        int col = col1 + field - 1;
        int row = row1 + 1;
        int row2 = affectedArea.getLastRow();
        SFill fill = fc.getColorFilter().getExtraStyle().getFill();
        boolean byFontColor = fc.getColorFilter().isByFontColor();
        if (!byFontColor && fill.getFillPattern() == SFill.FillPattern.SOLID) {
            fill = new ExtraFillImpl(SFill.FillPattern.SOLID, fill.getBackColor(), fill.getFillColor());
        }
        LinkedHashMap<Integer, Boolean> affectedRows = new LinkedHashMap<Integer, Boolean>();
        for (int r = row; r <= row2; ++r) {
            SRow rowobj;
            SCellStyle style;
            SCell cell = this.sheet.getCell(r, col);
            SCellStyle sCellStyle = style = cell.isNull() ? null : cell.getCellStyle();
            if (!this._match(style, fill, byFontColor)) {
                rowobj = this.sheet.getRow(r);
                if (rowobj.isHidden()) continue;
                affectedRows.put(r, true);
                continue;
            }
            rowobj = this.sheet.getRow(r);
            if (!rowobj.isHidden() || !this.canUnhide(filter, fc, r, col1)) continue;
            affectedRows.put(r, false);
        }
        return affectedRows;
    }

    LinkedHashMap<Integer, Boolean> _filterByValues(SAutoFilter filter, SAutoFilter.NFilterColumn fc, int field) {
        CellRegion affectedArea = filter.getRegion();
        int row1 = affectedArea.getRow();
        int col1 = affectedArea.getColumn();
        int col = col1 + field - 1;
        int row = row1 + 1;
        int row2 = affectedArea.getLastRow();
        Set cr1 = fc.getCriteria1();
        LinkedHashMap<Integer, Boolean> affectedRows = new LinkedHashMap<Integer, Boolean>();
        for (int r = row; r <= row2; ++r) {
            SRow rowobj;
            String val;
            SCell cell = this.sheet.getCell(r, col);
            String string = val = AutoFilterHelper.isBlank(cell) ? "=" : this.getFormattedText(cell);
            if (cr1 != null && !cr1.isEmpty() && !cr1.contains(val)) {
                rowobj = this.sheet.getRow(r);
                if (rowobj.isHidden()) continue;
                affectedRows.put(r, true);
                continue;
            }
            rowobj = this.sheet.getRow(r);
            if (!rowobj.isHidden() || !this.canUnhide(filter, fc, r, col1)) continue;
            affectedRows.put(r, false);
        }
        return affectedRows;
    }

    private void enableAutoFilter0(STable table, SAutoFilter filter, int field, SAutoFilter.FilterOp filterOp, Object criteria1, Object criteria2, Boolean showButton) {
        SAutoFilter.NFilterColumn fc = filter.getFilterColumn(field - 1, true);
        HashMap<String, Object> extra = new HashMap<String, Object>();
        SDynamicFilter dynaFilter = null;
        STop10Filter top10Filter = null;
        switch (filterOp) {
            case cellColor: 
            case fontColor: {
                extra.put("colorFilter", this._prepareColorFilter((String[])criteria1, filterOp == SAutoFilter.FilterOp.fontColor));
                criteria1 = null;
                break;
            }
            case and: 
            case or: {
                extra.put("customFilters", this._prepareCustomFilters((String[])criteria1, (String[])criteria2, filterOp == SAutoFilter.FilterOp.and));
                criteria1 = null;
                break;
            }
            case tomorrow: 
            case today: 
            case yesterday: 
            case nextWeek: 
            case thisWeek: 
            case lastWeek: 
            case nextMonth: 
            case thisMonth: 
            case lastMonth: 
            case nextQuarter: 
            case thisQuarter: 
            case lastQuarter: 
            case nextYear: 
            case thisYear: 
            case lastYear: 
            case yearToDate: 
            case Q1: 
            case Q2: 
            case Q3: 
            case Q4: 
            case M1: 
            case M2: 
            case M3: 
            case M4: 
            case M5: 
            case M6: 
            case M7: 
            case M8: 
            case M9: 
            case M10: 
            case M11: 
            case M12: 
            case aboveAverage: 
            case belowAverage: {
                dynaFilter = this._prepareDynamicFilter(filter.getRegion(), field, filterOp);
                extra.put("dynamicFilter", dynaFilter == null ? DynamicFilterImpl.NOOP_DYNAFILTER : dynaFilter);
                criteria1 = null;
                break;
            }
            case top10: {
                top10Filter = this._prepareTop10Filter((Object[])criteria1, filter.getRegion(), field, filterOp);
                extra.put("top10Filter", top10Filter == null ? Top10FilterImpl.NOOP_TOP10FILTER : top10Filter);
                criteria1 = null;
            }
        }
        fc.setProperties(filterOp, criteria1, criteria2, showButton, extra);
        LinkedHashMap<Integer, Boolean> affectedRows = null;
        switch (filterOp) {
            case cellColor: 
            case fontColor: {
                affectedRows = this._filterByColor(filter, fc, field);
                break;
            }
            case and: 
            case or: {
                affectedRows = this._filterByCustomFilters(filter, fc, field);
                break;
            }
            case tomorrow: 
            case today: 
            case yesterday: 
            case nextWeek: 
            case thisWeek: 
            case lastWeek: 
            case nextMonth: 
            case thisMonth: 
            case lastMonth: 
            case nextQuarter: 
            case thisQuarter: 
            case lastQuarter: 
            case nextYear: 
            case thisYear: 
            case lastYear: 
            case yearToDate: 
            case Q1: 
            case Q2: 
            case Q3: 
            case Q4: 
            case M1: 
            case M2: 
            case M3: 
            case M4: 
            case M5: 
            case M6: 
            case M7: 
            case M8: 
            case M9: 
            case M10: 
            case M11: 
            case M12: 
            case aboveAverage: 
            case belowAverage: {
                if (dynaFilter == null) break;
                affectedRows = this._filterByDynamicFilter(filter, fc, field);
                break;
            }
            case top10: {
                if (top10Filter == null) break;
                affectedRows = this._filterByTop10Filter(filter, fc, field);
                break;
            }
            default: {
                affectedRows = this._filterByValues(filter, fc, field);
            }
        }
        if (affectedRows != null && !affectedRows.isEmpty()) {
            String key = (table == null ? this.sheet.getId() : table.getName()) + "_ZSS_AFFECTED_ROWS";
            Executions.getCurrent().setAttribute("CONTAINS_" + key, (Object)true);
            int sz = affectedRows.size();
            int j = 0;
            for (int r : affectedRows.keySet()) {
                if (++j == sz) {
                    Executions.getCurrent().setAttribute(key, (Object)new Integer(sz));
                } else {
                    Executions.getCurrent().setAttribute(key, (Object)Integers.ZERO);
                }
                SRanges.range(this.sheet, r, 0).getRows().setHidden(affectedRows.get(r));
            }
        }
    }

    private boolean canUnhide(SAutoFilter af, SAutoFilter.NFilterColumn fc, int row, int col) {
        Collection<SAutoFilter.NFilterColumn> fltcs = af.getFilterColumns();
        for (SAutoFilter.NFilterColumn fltc : fltcs) {
            if (fc.equals(fltc) || !this.shallHide(fltc, row, col)) continue;
            return false;
        }
        return true;
    }

    private boolean shallHide(SAutoFilter.NFilterColumn fc, int row, int col) {
        SCell cell = this.sheet.getCell(row, col + fc.getIndex());
        SColorFilter colorFilter = fc.getColorFilter();
        if (colorFilter != null) {
            SCellStyle style = cell.isNull() ? BLANK_STYLE : cell.getCellStyle();
            return !this._match(style, colorFilter.getExtraStyle().getFill(), colorFilter.isByFontColor());
        }
        SCustomFilters custFilters = fc.getCustomFilters();
        int filterType = ((AbstractAutoFilterAdv.FilterColumnImpl)fc).getFilterType();
        if (custFilters != null) {
            Matchable<SCell> match = this.getMatchByCustomFilters(custFilters, filterType);
            return !match.match(cell.isNull() ? null : cell);
        }
        SDynamicFilter dynaFilter = fc.getDynamicFilter();
        if (dynaFilter != null) {
            String type = dynaFilter.getType();
            if ("aboveAverage".equals(type) || "belowAverage".equals(type)) {
                Matchable<Double> match = this.getMatchByDynamicFilter(dynaFilter);
                CellValue cv = ((AbstractCellAdv)cell).getEvalCellValue(true);
                return cv.getType() != SCell.CellType.NUMBER || !match.match((Double)cv.getValue());
            }
            Matchable<Date> match = this.getMatchDateByDynamicFilter(dynaFilter);
            CellValue cv = ((AbstractCellAdv)cell).getEvalCellValue(true);
            Object val = cv.getValue();
            if (cv.getType() == SCell.CellType.NUMBER && !(val instanceof Date)) {
                val = DateUtil.getJavaDate((double)((Double)val), (TimeZone)TimeZone.getTimeZone("UTC"));
            }
            return cv.getType() != SCell.CellType.NUMBER || !match.match((Date)val);
        }
        STop10Filter top10Filter = fc.getTop10Filter();
        if (top10Filter != null) {
            Matchable<Double> match = this.getMatchByTop10Filter(top10Filter);
            CellValue cv = ((AbstractCellAdv)cell).getEvalCellValue(true);
            return cv.getType() != SCell.CellType.NUMBER || !match.match((Double)cv.getValue());
        }
        boolean blank = AutoFilterHelper.isBlank(cell);
        String val = blank ? "=" : this.getFormattedText(cell);
        Set critera1 = fc.getCriteria1();
        return critera1 != null && !critera1.isEmpty() && !critera1.contains(val);
    }

    @Deprecated
    public void resetAutoFilter() {
        STable table = ((AbstractSheetAdv)this.sheet).getTableByRowCol(this.getRow(), this.getColumn());
        this.resetAutoFilter(table);
    }

    private void validFiltered(SAutoFilter af) {
        if (af == null) {
            return;
        }
        Collection<SAutoFilter.NFilterColumn> fcs = af.getFilterColumns();
        if (fcs == null) {
            return;
        }
        boolean hasCriteria1 = false;
        for (SAutoFilter.NFilterColumn fc : fcs) {
            Set criteria1 = fc.getCriteria1();
            if (criteria1 == null || criteria1.isEmpty()) continue;
            hasCriteria1 = true;
            break;
        }
        if (!hasCriteria1) {
            throw new InvalidModelOpException("The filter is not applied any criteria");
        }
    }

    public void resetAutoFilter(STable table) {
        SAutoFilter af;
        SAutoFilter sAutoFilter = af = table == null ? this.sheet.getAutoFilter() : table.getAutoFilter();
        if (af == null) {
            return;
        }
        CellRegion afrng = af.getRegion();
        Collection<SAutoFilter.NFilterColumn> fcs = af.getFilterColumns();
        if (fcs == null) {
            return;
        }
        this.validFiltered(af);
        for (SAutoFilter.NFilterColumn fc : fcs) {
            fc.setProperties(SAutoFilter.FilterOp.values, null, null, null);
        }
        int row1 = afrng.getRow();
        int row = row1 + 1;
        int row2 = afrng.getLastRow();
        int col1 = afrng.getColumn();
        int col2 = afrng.getLastColumn();
        for (int r = row; r <= row2; ++r) {
            SRow rowobj = this.sheet.getRow(r);
            if (!rowobj.isHidden()) continue;
            SRange rng = SRanges.range(this.sheet, r, 0, r, 0);
            rng.getRows().setHidden(false);
        }
    }

    @Deprecated
    public void applyAutoFilter() {
        STable table = ((AbstractSheetAdv)this.sheet).getTableByRowCol(this.getRow(), this.getColumn());
        this.applyAutoFilter(table);
    }

    public void applyAutoFilter(STable table) {
        SAutoFilter oldFilter;
        SAutoFilter sAutoFilter = oldFilter = table == null ? this.sheet.getAutoFilter() : table.getAutoFilter();
        if (oldFilter == null) {
            return;
        }
        this.validFiltered(oldFilter);
        CellRegion region = oldFilter.getRegion();
        int firstRow = region.getRow();
        int firstColumn = region.getColumn();
        ArrayList<Object[]> originalFilteringColumns = new ArrayList<Object[]>();
        if (oldFilter.getFilterColumns() != null) {
            for (SAutoFilter.NFilterColumn filterColumn : oldFilter.getFilterColumns()) {
                Object[] filterColumnData = new Object[]{filterColumn.getIndex() + 1, filterColumn.getCriteria1().toArray(new String[0]), filterColumn.getOperator(), filterColumn.getCriteria2(), filterColumn.isShowButton()};
                originalFilteringColumns.add(filterColumnData);
            }
        }
        SAutoFilter newFilter = null;
        if (table != null) {
            this.enableTableFilter(table, false);
            newFilter = this.enableTableFilter(table, true);
        } else {
            this.enableAutoFilter(false);
            CellRegion filteringRange = new DataRegionHelper.FilterRegionHelper().findCurrentRegion(this.sheet, firstRow, firstColumn);
            if (filteringRange == null) {
                return;
            }
            newFilter = this.sheet.createAutoFilter(filteringRange);
        }
        for (int nCol = 0; nCol < originalFilteringColumns.size(); ++nCol) {
            Object[] oldFilterColumn = (Object[])originalFilteringColumns.get(nCol);
            int field = (Integer)oldFilterColumn[0];
            Object c1 = oldFilterColumn[1];
            SAutoFilter.FilterOp op = (SAutoFilter.FilterOp)((Object)oldFilterColumn[2]);
            Object c2 = oldFilterColumn[3];
            boolean showBtn = (Boolean)oldFilterColumn[4];
            this.enableAutoFilter0(table, newFilter, field, op, c1, c2, showBtn);
        }
    }

    static {
        Calendar cal = Calendar.getInstance();
        cal.set(0, 0, 0, 0, 0, 0);
        MIN_DATE = cal.getTime();
    }
}

