/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.model.util;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.zkoss.zss.model.SBorder;
import org.zkoss.zss.model.SCellStyle;
import org.zkoss.zss.model.SFill;
import org.zkoss.zss.model.SFont;

public class CellStyleMatcher
implements Serializable {
    private static final long serialVersionUID = 7519529397643898059L;
    Map<Property, Object> _criteria = new LinkedHashMap<Property, Object>();

    public CellStyleMatcher() {
    }

    public CellStyleMatcher(SCellStyle criteria) {
        this.setAlignment(criteria.getAlignment());
        this.setVerticalAlignment(criteria.getVerticalAlignment());
        SBorder.BorderType btype = criteria.getBorderBottom();
        this.setBorderBottom(btype);
        if (btype != SBorder.BorderType.NONE) {
            this.setBorderBottomColor(criteria.getBorderBottomColor().getHtmlColor());
        }
        btype = criteria.getBorderLeft();
        this.setBorderLeft(btype);
        if (btype != SBorder.BorderType.NONE) {
            this.setBorderLeftColor(criteria.getBorderLeftColor().getHtmlColor());
        }
        btype = criteria.getBorderRight();
        this.setBorderRight(btype);
        if (btype != SBorder.BorderType.NONE) {
            this.setBorderRightColor(criteria.getBorderRightColor().getHtmlColor());
        }
        btype = criteria.getBorderTop();
        this.setBorderTop(btype);
        if (btype != SBorder.BorderType.NONE) {
            this.setBorderTopColor(criteria.getBorderTopColor().getHtmlColor());
        }
        this.setDataFormat(criteria.getDataFormat());
        this.setFillColor(criteria.getFillColor().getHtmlColor());
        this.setBackColor(criteria.getBackColor().getHtmlColor());
        this.setFillPattern(criteria.getFillPattern());
        this.setFont(criteria.getFont());
        this.setHidden(criteria.isHidden());
        this.setIndention(criteria.getIndention());
        this.setLocked(criteria.isLocked());
        this.setRotation(criteria.getRotation());
        this.setWrapText(criteria.isWrapText());
    }

    public void setDataFormat(String fmt) {
        this._criteria.put(Property.DataFormat, fmt);
    }

    public void setFontColor(String color) {
        this._criteria.put(Property.FontColor, color);
    }

    public void setFontName(String name) {
        this._criteria.put(Property.FontName, name);
    }

    public void setFontBoldweight(SFont.Boldweight boldweight) {
        this._criteria.put(Property.FontBoldweight, (Object)boldweight);
    }

    public void setFontHeightPoints(int height) {
        this._criteria.put(Property.FontHeightPoints, height);
    }

    public void setFontItalic(boolean italic) {
        this._criteria.put(Property.FontItalic, italic);
    }

    public void setFontStrikeout(boolean strikeout) {
        this._criteria.put(Property.FontStrikeout, strikeout);
    }

    public void setFontTypeOffset(SFont.TypeOffset typeOffset) {
        this._criteria.put(Property.FontTypeOffset, (Object)typeOffset);
    }

    public void setFontUnderline(SFont.Underline underline) {
        this._criteria.put(Property.FontUnderline, (Object)underline);
    }

    public void setFont(SFont font) {
        if (font != null) {
            this.setFontColor(font.getColor().getHtmlColor());
            this.setFontName(font.getName());
            this.setFontBoldweight(font.getBoldweight());
            this.setFontHeightPoints(font.getHeightPoints());
            this.setFontItalic(font.isItalic());
            this.setFontStrikeout(font.isStrikeout());
            this.setFontTypeOffset(font.getTypeOffset());
            this.setFontUnderline(font.getUnderline());
        }
    }

    public void removeFont() {
        this.removeFontColor();
        this.removeFontName();
        this.removeFontBoldweight();
        this.removeFontHeightPoints();
        this.removeFontItalic();
        this.removeFontStrikeout();
        this.removeFontTypeOffset();
        this.removeFontUnderline();
    }

    public void setHidden(boolean hidden) {
        this._criteria.put(Property.Hidden, hidden);
    }

    public void setLocked(boolean locked) {
        this._criteria.put(Property.Locked, locked);
    }

    public void setAlignment(SCellStyle.Alignment align) {
        this._criteria.put(Property.Alignment, (Object)align);
    }

    public void setWrapText(boolean wrapped) {
        this._criteria.put(Property.WrapText, wrapped);
    }

    public void setVerticalAlignment(SCellStyle.VerticalAlignment align) {
        this._criteria.put(Property.VerticalAlignment, (Object)align);
    }

    public void setRotation(int rotation) {
        this._criteria.put(Property.Rotation, rotation);
    }

    public void setIndention(int indent) {
        this._criteria.put(Property.Indention, indent);
    }

    public void setBorderRight(SBorder.BorderType border) {
        this._criteria.put(Property.BorderRight, (Object)border);
    }

    public void setBorderTop(SBorder.BorderType border) {
        this._criteria.put(Property.BorderTop, (Object)border);
    }

    public void setBorderBottom(SBorder.BorderType border) {
        this._criteria.put(Property.BorderBottom, (Object)border);
    }

    public void setBorderLeft(SBorder.BorderType border) {
        this._criteria.put(Property.BorderLeft, (Object)border);
    }

    public void setBorderLeftColor(String htmlcolor) {
        this._criteria.put(Property.BorderLeftColor, htmlcolor);
    }

    public void setBorderRightColor(String htmlcolor) {
        this._criteria.put(Property.BorderRightColor, htmlcolor);
    }

    public void setBorderTopColor(String htmlcolor) {
        this._criteria.put(Property.BorderTopColor, htmlcolor);
    }

    public void setBorderBottomColor(String htmlcolor) {
        this._criteria.put(Property.BorderBottomColor, htmlcolor);
    }

    public void setFillPattern(SFill.FillPattern fp) {
        this._criteria.put(Property.FillPattern, (Object)fp);
    }

    public void setFillColor(String htmlcolor) {
        this._criteria.put(Property.FillColor, htmlcolor);
    }

    public void setBackColor(String htmlcolor) {
        this._criteria.put(Property.BackColor, htmlcolor);
    }

    public void removeDataFormat() {
        this._criteria.remove((Object)Property.DataFormat);
    }

    public void removeFontColor() {
        this._criteria.remove((Object)Property.FontColor);
    }

    public void removeFontName() {
        this._criteria.remove((Object)Property.FontName);
    }

    public void removeFontBoldweight() {
        this._criteria.remove((Object)Property.FontBoldweight);
    }

    public void removeFontHeightPoints() {
        this._criteria.remove((Object)Property.FontHeightPoints);
    }

    public void removeFontItalic() {
        this._criteria.remove((Object)Property.FontItalic);
    }

    public void removeFontStrikeout() {
        this._criteria.remove((Object)Property.FontStrikeout);
    }

    public void removeFontTypeOffset() {
        this._criteria.remove((Object)Property.FontTypeOffset);
    }

    public void removeFontUnderline() {
        this._criteria.remove((Object)Property.FontUnderline);
    }

    public void removeHidden() {
        this._criteria.remove((Object)Property.Hidden);
    }

    public void removeLocked() {
        this._criteria.remove((Object)Property.Locked);
    }

    public void removeAlignment() {
        this._criteria.remove((Object)Property.Alignment);
    }

    public void removeWrapText() {
        this._criteria.remove((Object)Property.WrapText);
    }

    public void removeVerticalAlignment() {
        this._criteria.remove((Object)Property.VerticalAlignment);
    }

    public void removeRotation() {
        this._criteria.remove((Object)Property.Rotation);
    }

    public void removeIndention() {
        this._criteria.remove((Object)Property.Indention);
    }

    public void removeBorderRight() {
        this._criteria.remove((Object)Property.BorderRight);
    }

    public void removeBorderTop() {
        this._criteria.remove((Object)Property.BorderTop);
    }

    public void removeBorderBottom() {
        this._criteria.remove((Object)Property.BorderBottom);
    }

    public void removeBorderLeft() {
        this._criteria.remove((Object)Property.BorderLeft);
    }

    public void removeBorderLeftColor() {
        this._criteria.remove((Object)Property.BorderLeftColor);
    }

    public void removeBorderRightColor() {
        this._criteria.remove((Object)Property.BorderRightColor);
    }

    public void removeBorderTopColor() {
        this._criteria.remove((Object)Property.BorderTopColor);
    }

    public void removeBorderBottomColor() {
        this._criteria.remove((Object)Property.BorderBottomColor);
    }

    public void removeFillPattern() {
        this._criteria.remove((Object)Property.FillPattern);
    }

    public void removeFillColor() {
        this._criteria.remove((Object)Property.FillColor);
    }

    public void removeBackColor() {
        this._criteria.remove((Object)Property.BackColor);
    }

    public boolean match(SCellStyle style) {
        for (Map.Entry<Property, Object> e : this._criteria.entrySet()) {
            switch (e.getKey()) {
                case Alignment: {
                    if (this.equals(e.getValue(), (Object)style.getAlignment())) break;
                    return false;
                }
                case VerticalAlignment: {
                    if (this.equals(e.getValue(), (Object)style.getVerticalAlignment())) break;
                    return false;
                }
                case BorderBottom: {
                    if (this.equals(e.getValue(), (Object)style.getBorderBottom())) break;
                    return false;
                }
                case BorderRight: {
                    if (this.equals(e.getValue(), (Object)style.getBorderRight())) break;
                    return false;
                }
                case BorderTop: {
                    if (this.equals(e.getValue(), (Object)style.getBorderTop())) break;
                    return false;
                }
                case BorderLeft: {
                    if (this.equals(e.getValue(), (Object)style.getBorderLeft())) break;
                    return false;
                }
                case BorderBottomColor: {
                    if (this.htmlColorEuqlas(e.getValue(), style.getBorderBottomColor().getHtmlColor())) break;
                    return false;
                }
                case BorderRightColor: {
                    if (this.htmlColorEuqlas(e.getValue(), style.getBorderRightColor().getHtmlColor())) break;
                    return false;
                }
                case BorderTopColor: {
                    if (this.htmlColorEuqlas(e.getValue(), style.getBorderTopColor().getHtmlColor())) break;
                    return false;
                }
                case BorderLeftColor: {
                    if (this.htmlColorEuqlas(e.getValue(), style.getBorderLeftColor().getHtmlColor())) break;
                    return false;
                }
                case DataFormat: {
                    if (this.equals(e.getValue(), style.getDataFormat())) break;
                    return false;
                }
                case FillColor: {
                    if (this.htmlColorEuqlas(e.getValue(), style.getFillColor().getHtmlColor())) break;
                    return false;
                }
                case BackColor: {
                    if (this.htmlColorEuqlas(e.getValue(), style.getBackColor().getHtmlColor())) break;
                    return false;
                }
                case FillPattern: {
                    if (this.equals(e.getValue(), (Object)style.getFillPattern())) break;
                    return false;
                }
                case FontColor: {
                    if (this.htmlColorEuqlas(e.getValue(), style.getFont().getColor().getHtmlColor())) break;
                    return false;
                }
                case FontName: {
                    if (this.equals(e.getValue(), style.getFont().getName())) break;
                    return false;
                }
                case FontBoldweight: {
                    if (this.equals(e.getValue(), (Object)style.getFont().getBoldweight())) break;
                    return false;
                }
                case FontHeightPoints: {
                    if (this.equals(e.getValue(), style.getFont().getHeightPoints())) break;
                    return false;
                }
                case FontItalic: {
                    if (this.equals(e.getValue(), style.getFont().isItalic())) break;
                    return false;
                }
                case FontStrikeout: {
                    if (this.equals(e.getValue(), style.getFont().isStrikeout())) break;
                    return false;
                }
                case FontTypeOffset: {
                    if (this.equals(e.getValue(), (Object)style.getFont().getTypeOffset())) break;
                    return false;
                }
                case FontUnderline: {
                    if (this.equals(e.getValue(), (Object)style.getFont().getUnderline())) break;
                    return false;
                }
                case Hidden: {
                    if (this.equals(e.getValue(), style.isHidden())) break;
                    return false;
                }
                case Indention: {
                    if (this.equals(e.getValue(), style.getIndention())) break;
                    return false;
                }
                case Locked: {
                    if (this.equals(e.getValue(), style.isLocked())) break;
                    return false;
                }
                case Rotation: {
                    if (this.equals(e.getValue(), style.getRotation())) break;
                    return false;
                }
                case WrapText: {
                    if (this.equals(e.getValue(), style.isWrapText())) break;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean htmlColorEuqlas(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 instanceof String && o2 instanceof String) {
            return ((String)o1).equalsIgnoreCase((String)o2);
        }
        return false;
    }

    public boolean equals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        return o1 != null ? o1.equals(o2) : false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Property {
        Alignment,
        VerticalAlignment,
        BorderBottom,
        BorderRight,
        BorderTop,
        BorderLeft,
        BorderBottomColor,
        BorderRightColor,
        BorderTopColor,
        BorderLeftColor,
        DataFormat,
        FillColor,
        BackColor,
        FillPattern,
        FontName,
        FontColor,
        FontBoldweight,
        FontHeightPoints,
        FontItalic,
        FontStrikeout,
        FontTypeOffset,
        FontUnderline,
        Hidden,
        Indention,
        Locked,
        Rotation,
        WrapText;

    }
}

