/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.model.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.zkoss.poi.ss.formula.FormulaRenderer;
import org.zkoss.poi.ss.formula.FormulaRenderingWorkbook;
import org.zkoss.poi.ss.formula.ptg.Ptg;
import org.zkoss.zss.model.CellRegion;
import org.zkoss.zss.model.InvalidModelOpException;
import org.zkoss.zss.model.PasteOption;
import org.zkoss.zss.model.PasteSheetRegion;
import org.zkoss.zss.model.SAutoFilter;
import org.zkoss.zss.model.SBook;
import org.zkoss.zss.model.SCell;
import org.zkoss.zss.model.SCellStyle;
import org.zkoss.zss.model.SColumn;
import org.zkoss.zss.model.SConditionalFormatting;
import org.zkoss.zss.model.SDataValidation;
import org.zkoss.zss.model.SRow;
import org.zkoss.zss.model.SSheet;
import org.zkoss.zss.model.SheetRegion;
import org.zkoss.zss.model.impl.AbstractCellAdv;
import org.zkoss.zss.model.impl.AbstractDataValidationAdv;
import org.zkoss.zss.model.impl.AbstractSheetAdv;
import org.zkoss.zss.model.impl.CellBuffer;
import org.zkoss.zss.model.impl.sys.formula.ParsingBook;
import org.zkoss.zss.model.sys.EngineFactory;
import org.zkoss.zss.model.sys.formula.FormulaEngine;
import org.zkoss.zss.model.sys.formula.FormulaExpression;
import org.zkoss.zss.model.sys.formula.FormulaParseContext;
import org.zkoss.zss.model.util.Validations;
import org.zkoss.zss.range.impl.StyleUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PasteCellHelper
implements Serializable {
    private static final long serialVersionUID = 1420865992143581147L;
    private final SSheet _destSheet;
    private final SBook _book;
    private final SCellStyle _defaultStyle;
    FormulaEngine formulaEngine;
    private static Set<PasteOption.PasteType> handleStylePasteType = new HashSet<PasteOption.PasteType>();

    public PasteCellHelper(SSheet destSheet) {
        this._destSheet = destSheet;
        this._book = destSheet.getBook();
        this._defaultStyle = this._book.getDefaultCellStyle();
    }

    private CellRegion pasteRowHeights(SheetRegion src, CellRegion dest, int destRowCount) {
        boolean wrongRowMultiple;
        List<HeightInfo> heightBuffer = this.prepareRowHeight(src);
        int srcRowCount = heightBuffer.size();
        boolean bl = wrongRowMultiple = destRowCount > 1 && destRowCount % srcRowCount != 0;
        if (wrongRowMultiple) {
            throw new InvalidModelOpException("The operation can only be applied on the Paste area which is the Same size and shape of the Copy/Cut area");
        }
        int rowMultiple = destRowCount <= 1 || wrongRowMultiple ? 1 : destRowCount / srcRowCount;
        for (int j = 0; j < rowMultiple; ++j) {
            int rowMultipleOffset = j * srcRowCount;
            CellRegion destRegion = new CellRegion(dest.getRow() + rowMultipleOffset, dest.getColumn(), dest.getRow() + srcRowCount - 1 + rowMultipleOffset, dest.getColumn());
            this.pasteRowHeight(heightBuffer, destRegion);
        }
        return new CellRegion(dest.getRow(), 0, dest.getRow() + srcRowCount * rowMultiple - 1, this._destSheet.getBook().getMaxColumnIndex());
    }

    private void cutRowHeights(SheetRegion src, CellRegion dest, int srcRowCount, int destRowCount) {
        boolean wrongRowMultiple;
        boolean bl = wrongRowMultiple = destRowCount > 1 && destRowCount % srcRowCount != 0;
        if (wrongRowMultiple) {
            throw new InvalidModelOpException("The operation can only be applied on the Paste area which is the Same size and shape of the Copy/Cut area");
        }
        dest = destRowCount <= 1 || wrongRowMultiple ? new CellRegion(dest.getRow(), dest.getColumn(), dest.getRow() + srcRowCount - 1, dest.getColumn()) : dest;
        SSheet srcSheet = src.getSheet();
        int defaultHeight = srcSheet.getDefaultRowHeight();
        int destRow1 = dest.getRow();
        int destRow2 = dest.getLastRow();
        int len = src.getLastRow();
        for (int j = src.getRow(); j <= len; ++j) {
            if (destRow1 <= j && j <= destRow2) continue;
            SRow srow = srcSheet.getRow(j);
            srow.setHeight(defaultHeight);
            srow.setCustomHeight(false);
            srow.setHidden(false);
        }
    }

    private CellRegion pasteColumnWidths(SheetRegion src, CellRegion dest, int destColCount) {
        boolean wrongColMultiple;
        int[] widthBuffer = this.prepareColumnWidth(src);
        int srcColCount = widthBuffer.length;
        boolean bl = wrongColMultiple = destColCount > 1 && destColCount % srcColCount != 0;
        if (wrongColMultiple) {
            throw new InvalidModelOpException("The operation can only be applied on the Paste area which is the Same size and shape of the Copy/Cut area");
        }
        int colMultiple = destColCount <= 1 || wrongColMultiple ? 1 : destColCount / srcColCount;
        for (int j = 0; j < colMultiple; ++j) {
            int colMultipleOffset = j * srcColCount;
            CellRegion destRegion = new CellRegion(dest.getRow(), dest.getColumn() + colMultipleOffset, dest.getRow(), dest.getColumn() + srcColCount - 1 + colMultipleOffset);
            this.pasteColumnWidth(widthBuffer, destRegion);
        }
        return new CellRegion(0, dest.getColumn(), this._destSheet.getBook().getMaxRowIndex(), dest.getColumn() + srcColCount * colMultiple - 1);
    }

    private void cutColumnWidths(SheetRegion src, CellRegion dest, int srcColCount, int destColCount) {
        boolean wrongColMultiple;
        boolean bl = wrongColMultiple = destColCount > 1 && destColCount % srcColCount != 0;
        if (wrongColMultiple) {
            throw new InvalidModelOpException("The operation can only be applied on the Paste area which is the Same size and shape of the Copy/Cut area");
        }
        dest = destColCount <= 1 || wrongColMultiple ? new CellRegion(dest.getRow(), dest.getColumn(), dest.getRow(), dest.getColumn() + srcColCount - 1) : dest;
        SSheet srcSheet = src.getSheet();
        int defaultWidth = srcSheet.getDefaultColumnWidth();
        int destCol1 = dest.getColumn();
        int destCol2 = dest.getLastColumn();
        int len = src.getLastColumn();
        for (int j = src.getColumn(); j <= len; ++j) {
            if (destCol1 <= j && j <= destCol2) continue;
            SColumn scol = srcSheet.getColumn(j);
            scol.setWidth(defaultWidth);
            scol.setCustomWidth(false);
            scol.setHidden(false);
        }
    }

    public CellRegion pasteCell(SheetRegion src, CellRegion dest, PasteOption option) {
        List<CellRegion> srcOverlaps;
        boolean wholeRow;
        boolean wrongRowSize;
        boolean wrongColSize;
        boolean sameSheet;
        Validations.argNotNull(src);
        Validations.argNotNull(dest);
        AbstractSheetAdv srcSheet = (AbstractSheetAdv)src.getSheet();
        boolean bl = sameSheet = srcSheet == this._destSheet;
        if (!sameSheet && srcSheet.getBook() != this._book) {
            throw new IllegalArgumentException("the src sheet must be in the same book");
        }
        if (option == null) {
            option = new PasteOption();
        }
        int rowOffset = dest.getRow() - src.getRow();
        int columnOffset = dest.getColumn() - src.getColumn();
        int destColCount = dest.getColumnCount();
        int destRowCount = dest.getRowCount();
        boolean bl2 = wrongColSize = src instanceof PasteSheetRegion && ((PasteSheetRegion)src).isWholeColumn() && dest.getRow() != 0;
        if (wrongColSize) {
            throw new InvalidModelOpException("The operation can only be applied on the Paste area which is the Same size and shape of the Copy/Cut area");
        }
        boolean bl3 = wrongRowSize = src instanceof PasteSheetRegion && ((PasteSheetRegion)src).isWholeRow() && dest.getColumn() != 0;
        if (wrongRowSize) {
            throw new InvalidModelOpException("The operation can only be applied on the Paste area which is the Same size and shape of the Copy/Cut area");
        }
        boolean wholeColumn = src instanceof PasteSheetRegion && ((PasteSheetRegion)src).isWholeColumn() && dest.getRow() == 0;
        boolean bl4 = wholeRow = !wholeColumn && src instanceof PasteSheetRegion && ((PasteSheetRegion)src).isWholeRow() && dest.getColumn() == 0;
        if (option.getPasteType() == PasteOption.PasteType.COLUMN_WIDTHS) {
            if (option.isCut()) {
                throw new InvalidModelOpException("can't do cut when copying column width");
            }
            if (option.isTranspose()) {
                throw new InvalidModelOpException("can't do transport when copying column width");
            }
            return this.pasteColumnWidths(src, dest, destColCount);
        }
        if (option.getPasteType() == PasteOption.PasteType.ALL || option.getPasteType() == PasteOption.PasteType.ALL_EXCEPT_BORDERS) {
            if (wholeColumn) {
                this.pasteColumnWidths(src, dest, destColCount);
            } else if (wholeRow) {
                this.pasteRowHeights(src, dest, destRowCount);
            }
        }
        PasteOption.PasteType pasteType = option.getPasteType();
        boolean handleMerge = this.shouldHandleMerge(pasteType);
        CellRegion srcRegion = src.getRegion();
        if (handleMerge && (srcOverlaps = srcSheet.getOverlapsMergedRegions(srcRegion, true)).size() > 0 && !option.isCut()) {
            throw new InvalidModelOpException("Can't copy " + srcRegion.getReferenceString() + " which overlaps merge area " + ((CellRegion)srcOverlaps.iterator().next()).getReferenceString());
        }
        CellBuffer[][] srcBuffer = this.prepareCellBuffer(src, option);
        List<CellRegion> mergeBuffer = null;
        if (handleMerge) {
            mergeBuffer = this.prepareMergeRegionBuffer(src, option);
        }
        List<ValidationBuffer> srcVBuffer = this.prepareValidationBuffer(src, option);
        List<ConditionalFormattingBuffer> srcCBuffer = this.prepareConditionalFormattingBuffer(src, option);
        SheetRegion cutFrom = null;
        if (option.isCut()) {
            this.clearCell(src);
            this.clearMergeRegion(src);
            cutFrom = src;
            srcSheet.deleteDataValidationRegion(srcRegion);
            srcSheet.deleteConditionalFormattingRegion(srcRegion);
            if (wholeColumn) {
                this.cutColumnWidths(src, dest, src.getColumnCount(), destColCount);
            } else if (wholeRow) {
                this.cutRowHeights(src, dest, src.getRowCount(), destRowCount);
            }
        }
        if (srcRegion.isSingle()) {
            for (CellRegion mergedRegion : this._destSheet.getMergedRegions()) {
                if (!mergedRegion.contains(dest)) continue;
                CellRegion destRegion = new CellRegion(dest.getRow(), dest.getColumn(), dest.getRow(), dest.getColumn());
                this.pasteCells(srcBuffer, destRegion, cutFrom, option, rowOffset, columnOffset);
                if (option.isCut()) {
                    this.pasteDataValidations(srcVBuffer, src, dest, option);
                    this.pasteConditionalFormatting(srcCBuffer, src, dest, option);
                    this._destSheet.removeMergedRegion(mergedRegion, true);
                }
                return dest;
            }
        }
        int srcColCount = srcBuffer[0].length;
        int srcRowCount = srcBuffer.length;
        boolean wrongRowMultiple = destRowCount > 1 && destRowCount % srcRowCount != 0;
        boolean wrongColMultiple = destColCount > 1 && destColCount % srcColCount != 0;
        boolean wrongMultiple = wrongRowMultiple || wrongColMultiple;
        int rowMultiple = destRowCount <= 1 || wrongMultiple ? 1 : destRowCount / srcRowCount;
        int colMultiple = destColCount <= 1 || wrongMultiple ? 1 : destColCount / srcColCount;
        for (int i = 0; i < rowMultiple; ++i) {
            for (int j = 0; j < colMultiple; ++j) {
                int rowMultpleOffset = i * srcRowCount;
                int colMultipleOffset = j * srcColCount;
                CellRegion destRegion = new CellRegion(dest.getRow() + rowMultpleOffset, dest.getColumn() + colMultipleOffset, dest.getRow() + srcRowCount + -1 + rowMultpleOffset, dest.getColumn() + srcColCount - 1 + colMultipleOffset);
                this.pasteCells(srcBuffer, destRegion, cutFrom, option, rowOffset + rowMultpleOffset, columnOffset + colMultipleOffset);
                this.pasteDataValidations(srcVBuffer, src, destRegion, option);
                this.pasteConditionalFormatting(srcCBuffer, src, destRegion, option);
                if (mergeBuffer == null || mergeBuffer.size() <= 0) continue;
                this.pasteMergeRegion(mergeBuffer, rowOffset + rowMultpleOffset, columnOffset + colMultipleOffset);
            }
        }
        return new CellRegion(dest.getRow(), dest.getColumn(), dest.getRow() + srcRowCount * rowMultiple - 1, dest.getColumn() + srcColCount * colMultiple - 1);
    }

    List<ValidationBuffer> prepareValidationBuffer(SheetRegion src, PasteOption option) {
        PasteOption.PasteType type = option.getPasteType();
        if (type != PasteOption.PasteType.ALL && type != PasteOption.PasteType.ALL_EXCEPT_BORDERS && type != PasteOption.PasteType.VALIDATAION) {
            return Collections.emptyList();
        }
        boolean transpose = option.isTranspose();
        SSheet srcSheet = src.getSheet();
        CellRegion srcRegion = src.getRegion();
        ArrayList<ValidationBuffer> vbs = new ArrayList<ValidationBuffer>();
        for (SDataValidation dv : srcSheet.getDataValidations()) {
            LinkedHashSet<CellRegion> overlaps = new LinkedHashSet<CellRegion>();
            for (CellRegion rgn : dv.getRegions()) {
                CellRegion overlap = srcRegion.getOverlap(rgn);
                if (overlap == null) continue;
                overlaps.add(transpose ? new CellRegion(overlap.getColumn(), overlap.getRow(), overlap.getLastColumn(), overlap.getLastRow()) : overlap);
            }
            if (overlaps.isEmpty()) continue;
            vbs.add(new ValidationBuffer(dv, overlaps));
        }
        return vbs;
    }

    List<ConditionalFormattingBuffer> prepareConditionalFormattingBuffer(SheetRegion src, PasteOption option) {
        PasteOption.PasteType type = option.getPasteType();
        if (type != PasteOption.PasteType.ALL && type != PasteOption.PasteType.ALL_EXCEPT_BORDERS && type != PasteOption.PasteType.FORMATS && type != PasteOption.PasteType.FORMULAS_AND_NUMBER_FORMATS && type != PasteOption.PasteType.VALUES_AND_NUMBER_FORMATS) {
            return Collections.emptyList();
        }
        boolean transpose = option.isTranspose();
        SSheet srcSheet = src.getSheet();
        CellRegion srcRegion = src.getRegion();
        ArrayList<ConditionalFormattingBuffer> cbs = new ArrayList<ConditionalFormattingBuffer>();
        for (SConditionalFormatting cv : srcSheet.getConditionalFormattings()) {
            HashSet<CellRegion> overlaps = new HashSet<CellRegion>();
            for (CellRegion rgn : cv.getRegions()) {
                CellRegion overlap = srcRegion.getOverlap(rgn);
                if (overlap == null) continue;
                overlaps.add(transpose ? new CellRegion(overlap.getColumn(), overlap.getRow(), overlap.getLastColumn(), overlap.getLastRow()) : overlap);
            }
            if (overlaps.isEmpty()) continue;
            cbs.add(new ConditionalFormattingBuffer(cv, overlaps));
        }
        return cbs;
    }

    private void pasteDataValidations(List<ValidationBuffer> vbs, SheetRegion src, CellRegion dst, PasteOption option) {
        PasteOption.PasteType type = option.getPasteType();
        if (type != PasteOption.PasteType.ALL && type != PasteOption.PasteType.ALL_EXCEPT_BORDERS && type != PasteOption.PasteType.VALIDATAION) {
            return;
        }
        if (vbs.isEmpty()) {
            return;
        }
        SSheet srcSheet = src.getSheet();
        int rowOffset = dst.getRow() - src.getRegion().getRow();
        int colOffset = dst.getColumn() - src.getRegion().getColumn();
        for (ValidationBuffer vb : vbs) {
            LinkedHashSet<CellRegion> destRegions = this.convertRegions(vb.regions, rowOffset, colOffset);
            for (CellRegion rgn : destRegions) {
                this._destSheet.deleteDataValidationRegion(rgn);
            }
            SDataValidation dv = vb.validation;
            if (!srcSheet.equals(this._destSheet) || dv.getSheet() == null) {
                dv = this._destSheet.addDataValidation(null, dv);
                ((AbstractDataValidationAdv)dv).setRegions(destRegions);
                continue;
            }
            AbstractDataValidationAdv adv = (AbstractDataValidationAdv)dv;
            for (CellRegion regn : destRegions) {
                adv.addRegion(regn);
            }
        }
    }

    private void pasteConditionalFormatting(List<ConditionalFormattingBuffer> cbs, SheetRegion src, CellRegion dst, PasteOption option) {
        PasteOption.PasteType type = option.getPasteType();
        if (type != PasteOption.PasteType.ALL && type != PasteOption.PasteType.ALL_EXCEPT_BORDERS && type != PasteOption.PasteType.FORMATS && type != PasteOption.PasteType.FORMULAS_AND_NUMBER_FORMATS && type != PasteOption.PasteType.VALUES_AND_NUMBER_FORMATS) {
            return;
        }
        if (cbs.isEmpty()) {
            return;
        }
        int dstRow = dst.row;
        int dstCol = dst.column;
        AbstractSheetAdv destSheet = (AbstractSheetAdv)this._destSheet;
        destSheet.deleteConditionalFormattingRegion(dst);
        int rowOff = dstRow - src.getRow();
        int colOff = dstCol - src.getColumn();
        CellRegion srcrgn = src.getRegion();
        for (ConditionalFormattingBuffer cb : cbs) {
            SConditionalFormatting cfmt = cb.cfmt;
            destSheet.addConditionalFormatting(src.getRegion(), dst, cfmt, rowOff, colOff);
        }
    }

    private LinkedHashSet<CellRegion> convertRegions(Set<CellRegion> srcRegions, int rowOffset, int colOffset) {
        LinkedHashSet<CellRegion> dstRegions = new LinkedHashSet<CellRegion>();
        for (CellRegion rgn : srcRegions) {
            int row1 = rgn.getRow() + rowOffset;
            int col1 = rgn.getColumn() + colOffset;
            int row2 = rgn.getLastRow() + rowOffset;
            int col2 = rgn.getLastColumn() + colOffset;
            dstRegions.add(new CellRegion(row1, col1, row2, col2));
        }
        return dstRegions;
    }

    private FormulaEngine getFormulaEngine() {
        if (this.formulaEngine == null) {
            this.formulaEngine = EngineFactory.getInstance().createFormulaEngine();
        }
        return this.formulaEngine;
    }

    private boolean shouldHandleMerge(PasteOption.PasteType pasteType) {
        return pasteType == PasteOption.PasteType.ALL || pasteType == PasteOption.PasteType.ALL_EXCEPT_BORDERS || pasteType == PasteOption.PasteType.FORMATS;
    }

    private void pasteRowHeight(List<HeightInfo> heightBuffer, CellRegion dest) {
        int row = dest.getRow();
        int lastRow = dest.getLastRow();
        for (int c = row; c <= lastRow; ++c) {
            HeightInfo info = heightBuffer.get(c - row);
            SRow srow = this._destSheet.getRow(c);
            srow.setHeight(info.height);
            srow.setCustomHeight(info.custom);
        }
    }

    private List<HeightInfo> prepareRowHeight(SheetRegion src) {
        int row = src.getRow();
        int lastRow = src.getLastRow();
        ArrayList<HeightInfo> heightBuffer = new ArrayList<HeightInfo>();
        SSheet srcSheet = src.getSheet();
        for (int c = row; c <= lastRow; ++c) {
            SRow srow = srcSheet.getRow(c);
            heightBuffer.add(new HeightInfo(srow.getHeight(), srow.isCustomHeight()));
        }
        return heightBuffer;
    }

    private int[] prepareColumnWidth(SheetRegion src) {
        int column = src.getColumn();
        int lastColumn = src.getLastColumn();
        int srcColCount = src.getColumnCount();
        int[] widthBuffer = new int[srcColCount];
        SSheet srcSheet = src.getSheet();
        for (int c = column; c <= lastColumn; ++c) {
            widthBuffer[c - column] = srcSheet.getColumn(c).getWidth();
        }
        return widthBuffer;
    }

    private List<CellRegion> prepareMergeRegionBuffer(SheetRegion src, PasteOption option) {
        LinkedList<CellRegion> mergeBuffer = new LinkedList<CellRegion>();
        boolean transpose = option.isTranspose();
        for (CellRegion region : src.getSheet().getContainsMergedRegions(src.getRegion())) {
            if (transpose) {
                int rowAnchor = src.getRow();
                int columnAnchor = src.getColumn();
                int r = rowAnchor + region.getColumn() - columnAnchor;
                int c = columnAnchor + region.getRow() - rowAnchor;
                int lr = r + region.getColumnCount() - 1;
                int lc = c + region.getRowCount() - 1;
                region = new CellRegion(r, c, lr, lc);
            }
            mergeBuffer.add(region);
        }
        return mergeBuffer;
    }

    private CellBuffer[][] prepareCellBuffer(SheetRegion src, PasteOption option) {
        int row = src.getRow();
        int column = src.getColumn();
        int lastRow = src.getLastRow();
        int lastColumn = src.getLastColumn();
        boolean transpose = option.isTranspose();
        int srcRowCount = transpose ? src.getColumnCount() : src.getRowCount();
        int srcColCount = transpose ? src.getRowCount() : src.getColumnCount();
        SSheet sheet = src.getSheet();
        AbstractSheetAdv srcSheet = (AbstractSheetAdv)src.getSheet();
        ArrayList rowBuf = new ArrayList();
        SAutoFilter af = srcSheet.getAutoFilter();
        boolean isFiltered = af == null ? false : af.isFiltered();
        for (int r = row; r <= lastRow; ++r) {
            if (isFiltered && srcSheet.getRow(r).isHidden()) continue;
            ArrayList<CellBuffer> colBuf = new ArrayList<CellBuffer>();
            block11: for (int c = column; c <= lastColumn; ++c) {
                boolean handleStyle;
                if (isFiltered && srcSheet.getColumn(c).isHidden()) continue;
                SCell srcCell = srcSheet.getCell(r, c);
                PasteOption.PasteType pt = option.getPasteType();
                boolean bl = handleStyle = handleStylePasteType.contains((Object)pt) && (srcSheet.getRow(r).getCellStyle(true) != null || srcSheet.getColumn(c).getCellStyle(true) != null) || ((AbstractSheetAdv)sheet).getTableByRowCol(r, c) != null;
                if (srcCell.isNull() && !handleStyle) {
                    colBuf.add(null);
                    continue;
                }
                CellBuffer buffer = new CellBuffer();
                colBuf.add(buffer);
                buffer.setType(srcCell.getType());
                switch (pt) {
                    case ALL: 
                    case ALL_EXCEPT_BORDERS: {
                        this.prepareValue(buffer, srcCell, true);
                        buffer.setStyle(StyleUtil.prepareStyle(srcCell));
                        buffer.setHyperlink(srcCell.getHyperlink());
                        buffer.setComment(srcCell.getComment());
                        buffer.setValidation(srcSheet.getDataValidation(r, c));
                        buffer.setConditionalFormatting(srcSheet.getConditionalFormatting(r, c));
                        continue block11;
                    }
                    case COMMENTS: {
                        buffer.setComment(srcCell.getComment());
                        continue block11;
                    }
                    case FORMATS: {
                        buffer.setStyle(srcCell.getCellStyle());
                        buffer.setConditionalFormatting(srcSheet.getConditionalFormatting(r, c));
                        continue block11;
                    }
                    case FORMULAS_AND_NUMBER_FORMATS: {
                        buffer.setStyle(srcCell.getCellStyle());
                        buffer.setConditionalFormatting(srcSheet.getConditionalFormatting(r, c));
                    }
                    case FORMULAS: {
                        this.prepareValue(buffer, srcCell, true);
                        continue block11;
                    }
                    case VALIDATAION: {
                        buffer.setValidation(srcSheet.getDataValidation(r, c));
                    }
                    case VALUES_AND_NUMBER_FORMATS: {
                        buffer.setStyle(srcCell.getCellStyle());
                        buffer.setConditionalFormatting(srcSheet.getConditionalFormatting(r, c));
                    }
                    case VALUES: {
                        this.prepareValue(buffer, srcCell, false);
                        continue block11;
                    }
                }
            }
            rowBuf.add(colBuf);
        }
        if (transpose) {
            int rowLen = rowBuf.size();
            if (rowLen > 0) {
                List colBuf0 = (List)rowBuf.get(0);
                int colLen = colBuf0.size();
                CellBuffer[][] srcBuffer = new CellBuffer[colLen][rowLen];
                for (int r = 0; r < rowLen; ++r) {
                    List colBuf = (List)rowBuf.get(r);
                    for (int c = 0; c < colLen; ++c) {
                        CellBuffer buf;
                        srcBuffer[c][r] = buf = (CellBuffer)colBuf.get(c);
                    }
                }
                return srcBuffer;
            }
            return new CellBuffer[0][];
        }
        int len = rowBuf.size();
        CellBuffer[][] srcBuffer = new CellBuffer[len][];
        for (int j = 0; j < len; ++j) {
            List colBuf = (List)rowBuf.get(j);
            srcBuffer[j] = colBuf.toArray(new CellBuffer[colBuf.size()]);
        }
        return srcBuffer;
    }

    private void prepareValue(CellBuffer buffer, SCell srcCell, boolean copyFormula) {
        if (copyFormula && srcCell.getType() == SCell.CellType.FORMULA) {
            String formula = srcCell.getFormulaValue();
            ParsingBook parsingBook = new ParsingBook(srcCell.getSheet().getBook());
            Ptg[] tokens = ((AbstractCellAdv)srcCell).getFormulaExpression().getPtgs();
            String result = FormulaRenderer.toFormulaCopyText((FormulaRenderingWorkbook)parsingBook, (Ptg[])tokens, (String)formula);
            buffer.setFormula(result);
        } else {
            buffer.setValue(srcCell.getValue());
        }
    }

    private void clearMergeRegion(SheetRegion src) {
        src.getSheet().removeMergedRegion(src.getRegion(), true);
    }

    private void clearCell(SheetRegion src) {
        int row = src.getRow();
        int column = src.getColumn();
        int lastRow = src.getLastRow();
        int lastColumn = src.getLastColumn();
        SSheet srcSheet = src.getSheet();
        for (int r = row; r <= lastRow; ++r) {
            for (int c = column; c <= lastColumn; ++c) {
                SCell cell = srcSheet.getCell(r, c);
                if (cell.isNull()) continue;
                srcSheet.clearCell(new CellRegion(r, c));
            }
        }
    }

    private void pasteMergeRegion(Collection<CellRegion> mergeBuffer, int rowOffset, int columnOffset) {
        for (CellRegion merge : mergeBuffer) {
            CellRegion newMerge = new CellRegion(merge.getRow() + rowOffset, merge.getColumn() + columnOffset, merge.getLastRow() + rowOffset, merge.getLastColumn() + columnOffset);
            this._destSheet.removeMergedRegion(newMerge, true);
            this._destSheet.addMergedRegion(newMerge);
        }
    }

    private void pasteColumnWidth(int[] widthBuffer, CellRegion dest) {
        int col = dest.getColumn();
        int lastColumn = dest.getLastColumn();
        for (int c = col; c <= lastColumn; ++c) {
            this._destSheet.getColumn(c).setWidth(widthBuffer[c - col]);
        }
    }

    private void pasteCells(CellBuffer[][] srcBuffer, CellRegion destRegion, SheetRegion cutFrom, PasteOption option, int rowOffset, int columnOffset) {
        int row = destRegion.getRow();
        int col = destRegion.getColumn();
        int lastRow = destRegion.getLastRow();
        int lastColumn = destRegion.getLastColumn();
        boolean transpose = option.isTranspose();
        for (int r = row; r <= lastRow; ++r) {
            block11: for (int c = col; c <= lastColumn; ++c) {
                CellBuffer buffer = srcBuffer[r - row][c - col];
                if ((buffer == null || buffer.getType() == SCell.CellType.BLANK) && option.isSkipBlank()) continue;
                CellRegion region = this._destSheet.getMergedRegion(r, c);
                if (region != null && (region.getRow() != r || region.getColumn() != c)) {
                    this._destSheet.removeMergedRegion(region, true);
                }
                SCell destCell = this._destSheet.getCell(r, c);
                if (buffer == null) {
                    if (destCell.isNull()) continue;
                    this._destSheet.clearCell(destCell.getRowIndex(), destCell.getColumnIndex(), destCell.getRowIndex(), destCell.getColumnIndex());
                    continue;
                }
                switch (option.getPasteType()) {
                    case ALL: {
                        this.pasteValue(buffer, destCell, cutFrom, true, rowOffset, columnOffset, transpose, row, col);
                        this.pasteStyle(buffer, destCell, true);
                        buffer.applyHyperlink(destCell);
                        buffer.applyComment(destCell);
                        continue block11;
                    }
                    case ALL_EXCEPT_BORDERS: {
                        this.pasteValue(buffer, destCell, cutFrom, true, rowOffset, columnOffset, transpose, row, col);
                        this.pasteStyle(buffer, destCell, false);
                        buffer.applyHyperlink(destCell);
                        buffer.applyComment(destCell);
                        continue block11;
                    }
                    case COMMENTS: {
                        buffer.applyComment(destCell);
                        continue block11;
                    }
                    case FORMATS: {
                        this.pasteStyle(buffer, destCell, true);
                        continue block11;
                    }
                    case FORMULAS_AND_NUMBER_FORMATS: {
                        this.pasteFormat(buffer, destCell);
                    }
                    case FORMULAS: {
                        this.pasteValue(buffer, destCell, cutFrom, true, rowOffset, columnOffset, transpose, row, col);
                        continue block11;
                    }
                    case VALIDATAION: 
                    case VALUES_AND_NUMBER_FORMATS: {
                        this.pasteFormat(buffer, destCell);
                    }
                    case VALUES: {
                        this.pasteValue(buffer, destCell, cutFrom);
                        continue block11;
                    }
                }
            }
        }
    }

    private void pasteFormat(CellBuffer buffer, SCell destCell) {
        String srcFormat = buffer.getStyle().getDataFormat();
        SCellStyle destStyle = destCell.getCellStyle();
        String destFormat = destStyle.getDataFormat();
        if (!destFormat.equals(srcFormat)) {
            StyleUtil.setDataFormat(this._destSheet.getBook(), destCell, srcFormat);
        }
    }

    private void pasteStyle(CellBuffer buffer, SCell destCell, boolean pasteBorder) {
        if (destCell.getCellStyle() == this._defaultStyle && buffer.getStyle() == this._defaultStyle) {
            return;
        }
        if (pasteBorder) {
            destCell.setCellStyle(buffer.getStyle());
        } else {
            SCellStyle newStyle = this._book.createCellStyle(buffer.getStyle(), true);
            SCellStyle destStyle = destCell.getCellStyle();
            newStyle.setBorderBottom(destStyle.getBorderBottom());
            newStyle.setBorderBottomColor(destStyle.getBorderBottomColor());
            newStyle.setBorderTop(destStyle.getBorderTop());
            newStyle.setBorderTopColor(destStyle.getBorderTopColor());
            newStyle.setBorderRight(destStyle.getBorderRight());
            newStyle.setBorderRightColor(destStyle.getBorderRightColor());
            newStyle.setBorderLeft(destStyle.getBorderLeft());
            newStyle.setBorderLeftColor(destStyle.getBorderLeftColor());
            destCell.setCellStyle(newStyle);
        }
    }

    private void pasteValue(CellBuffer buffer, SCell destCell, SheetRegion cutFrom) {
        this.pasteValue(buffer, destCell, cutFrom, false, -1, -1, false, -1, -1);
    }

    public void pasteValue(CellBuffer buffer, SCell destCell, SheetRegion cutFrom, boolean pasteFormula, int rowOffset, int columnOffset, boolean transpose, int rowOrigin, int columnOrigin) {
        String formula;
        if (pasteFormula && (formula = buffer.getFormula()) != null) {
            FormulaEngine engine = this.getFormulaEngine();
            FormulaParseContext context = new FormulaParseContext(destCell, null);
            FormulaExpression fexpr = engine.parse(formula, context);
            FormulaExpression expr = cutFrom != null ? engine.movePtgs(fexpr, cutFrom, rowOffset, columnOffset, context) : engine.shiftPtgs(fexpr, rowOffset, columnOffset, context);
            if (!expr.hasError() && transpose) {
                expr = engine.transposePtgs(expr, rowOrigin, columnOrigin, context);
            }
            if (!expr.hasError()) {
                destCell.setValue(expr);
            }
            return;
        }
        destCell.setValue(buffer.getValue());
    }

    static {
        handleStylePasteType.add(PasteOption.PasteType.ALL);
        handleStylePasteType.add(PasteOption.PasteType.ALL_EXCEPT_BORDERS);
        handleStylePasteType.add(PasteOption.PasteType.FORMATS);
        handleStylePasteType.add(PasteOption.PasteType.FORMULAS);
        handleStylePasteType.add(PasteOption.PasteType.FORMULAS_AND_NUMBER_FORMATS);
        handleStylePasteType.add(PasteOption.PasteType.VALUES);
        handleStylePasteType.add(PasteOption.PasteType.VALUES_AND_NUMBER_FORMATS);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ConditionalFormattingBuffer {
        final SConditionalFormatting cfmt;
        final Set<CellRegion> regions;

        ConditionalFormattingBuffer(SConditionalFormatting cfmt, Set<CellRegion> regions) {
            this.cfmt = cfmt;
            this.regions = regions;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ValidationBuffer {
        final SDataValidation validation;
        final LinkedHashSet<CellRegion> regions;

        ValidationBuffer(SDataValidation validation, LinkedHashSet<CellRegion> regions) {
            this.validation = validation;
            this.regions = regions;
        }
    }

    private static class HeightInfo {
        int height;
        boolean custom;

        HeightInfo(int h, boolean c) {
            this.height = h;
            this.custom = c;
        }
    }
}

