/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.model.impl;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;
import org.zkoss.util.logging.Log;
import org.zkoss.zss.model.SBook;
import org.zkoss.zss.model.SBookSeries;
import org.zkoss.zss.model.SCell;
import org.zkoss.zss.model.SChart;
import org.zkoss.zss.model.SConditionalFormattingRule;
import org.zkoss.zss.model.SDataValidation;
import org.zkoss.zss.model.SRow;
import org.zkoss.zss.model.SSheet;
import org.zkoss.zss.model.impl.AbstractCellAdv;
import org.zkoss.zss.model.impl.AbstractSheetAdv;
import org.zkoss.zss.model.impl.ConditionalFormattingImpl;
import org.zkoss.zss.model.impl.ConditionalFormattingRuleImpl;
import org.zkoss.zss.model.sys.dependency.ConditionalRef;
import org.zkoss.zss.model.sys.dependency.ObjectRef;
import org.zkoss.zss.model.sys.dependency.Ref;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FormulaCacheClearHelper
implements Serializable {
    private static final long serialVersionUID = 8757672812896139208L;
    private final SBookSeries _bookSeries;
    private static final Log logger = Log.lookup((String)FormulaCacheClearHelper.class.getName());

    public FormulaCacheClearHelper(SBookSeries bookSeries) {
        this._bookSeries = bookSeries;
    }

    public void clear(Set<Ref> refs) {
        for (Ref ref : refs) {
            if (logger.debugable()) {
                logger.debug("Clear Formula Cache: " + ref);
            }
            if (ref.getType() == Ref.RefType.CELL || ref.getType() == Ref.RefType.AREA) {
                this.handleAreaRef(ref);
                continue;
            }
            if (ref.getType() == Ref.RefType.OBJECT) {
                if (((ObjectRef)ref).getObjectType() == ObjectRef.ObjectType.CHART) {
                    this.handleChartRef((ObjectRef)ref);
                    continue;
                }
                if (((ObjectRef)ref).getObjectType() != ObjectRef.ObjectType.DATA_VALIDATION) continue;
                this.handleDataValidationRef((ObjectRef)ref);
                continue;
            }
            if (ref.getType() != Ref.RefType.CONDITIONAL) continue;
            this.handleConditionalRef((ConditionalRef)ref);
        }
    }

    private void handleChartRef(ObjectRef ref) {
        SBook book = this._bookSeries.getBook(ref.getBookName());
        if (book == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(ref.getSheetName());
        if (sheet == null) {
            return;
        }
        String[] ids = ref.getObjectIdPath();
        SChart chart = sheet.getChart(ids[0]);
        if (chart != null) {
            chart.getData().clearFormulaResultCache();
        }
    }

    private void handleConditionalRef(ConditionalRef ref) {
        SBook book = this._bookSeries.getBook(ref.getBookName());
        if (book == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(ref.getSheetName());
        if (sheet == null) {
            return;
        }
        int id = ref.getConditionalId();
        ConditionalFormattingImpl cfmt = (ConditionalFormattingImpl)((AbstractSheetAdv)sheet).getConditionalFormatting(id);
        for (SConditionalFormattingRule rule0 : cfmt.getRules()) {
            ConditionalFormattingRuleImpl rule = (ConditionalFormattingRuleImpl)rule0;
            switch (rule.getType()) {
                case CELL_IS: 
                case BEGINS_WITH: 
                case ENDS_WITH: 
                case CONTAINS_TEXT: 
                case NOT_CONTAINS_TEXT: 
                case CONTAINS_BLANKS: 
                case NOT_CONTAINS_BLANKS: 
                case CONTAINS_ERRORS: 
                case NOT_CONTAINS_ERRORS: 
                case EXPRESSION: {
                    if (rule.getRuleInfo1() != null) {
                        rule.getRuleInfo1().clearCacheMap();
                        if (rule.getRuleInfo2() == null) break;
                        rule.getRuleInfo2().clearCacheMap();
                        break;
                    }
                    rule.clearFormulaResultCache();
                    break;
                }
                case ABOVE_AVERAGE: 
                case COLOR_SCALE: 
                case DATA_BAR: 
                case DUPLICATE_VALUES: 
                case ICON_SET: 
                case TIME_PERIOD: 
                case TOP_10: 
                case UNIQUE_VALUES: {
                    rule.clearFormulaResultCache();
                }
            }
        }
    }

    private void handleDataValidationRef(ObjectRef ref) {
        SBook book = this._bookSeries.getBook(ref.getBookName());
        if (book == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(ref.getSheetName());
        if (sheet == null) {
            return;
        }
        String[] ids = ref.getObjectIdPath();
        SDataValidation validation = sheet.getDataValidation(ids[0]);
        if (validation != null) {
            validation.clearFormulaResultCache();
        }
    }

    private void handleAreaRef(Ref ref) {
        boolean wholeSheet;
        SBook book = this._bookSeries.getBook(ref.getBookName());
        if (book == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(ref.getSheetName());
        if (sheet == null) {
            return;
        }
        boolean wholeRow = ref.getColumn() == 0 && ref.getLastColumn() >= book.getMaxColumnIndex();
        boolean wholeColumn = ref.getRow() == 0 && ref.getLastRow() >= book.getMaxRowIndex();
        boolean bl = wholeSheet = wholeRow && wholeColumn;
        if (wholeSheet) {
            Iterator<SRow> rows = sheet.getRowIterator();
            while (rows.hasNext()) {
                Iterator<SCell> cells = sheet.getCellIterator(rows.next().getIndex());
                while (cells.hasNext()) {
                    cells.next().clearFormulaResultCache();
                }
            }
        } else if (wholeRow) {
            for (int r = ref.getRow(); r <= ref.getLastRow(); ++r) {
                Iterator<SCell> cells = sheet.getCellIterator(r);
                while (cells.hasNext()) {
                    cells.next().clearFormulaResultCache();
                }
            }
        } else if (wholeColumn) {
            Iterator<SRow> rows = sheet.getRowIterator();
            while (rows.hasNext()) {
                int r = rows.next().getIndex();
                for (int c = ref.getColumn(); c <= ref.getLastColumn(); ++c) {
                    AbstractCellAdv cell = ((AbstractSheetAdv)sheet).getCell(r, c, false);
                    if (cell == null) continue;
                    cell.clearFormulaResultCache();
                }
            }
        } else {
            for (int r = ref.getRow(); r <= ref.getLastRow(); ++r) {
                for (int c = ref.getColumn(); c <= ref.getLastColumn(); ++c) {
                    AbstractCellAdv cell = ((AbstractSheetAdv)sheet).getCell(r, c, false);
                    if (cell == null) continue;
                    cell.clearFormulaResultCache();
                }
            }
        }
    }
}

