/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.model.impl;

import org.zkoss.zss.model.SBook;
import org.zkoss.zss.model.SBorder;
import org.zkoss.zss.model.SBorderLine;
import org.zkoss.zss.model.SCellStyle;
import org.zkoss.zss.model.SColor;
import org.zkoss.zss.model.SExtraStyle;
import org.zkoss.zss.model.SFill;
import org.zkoss.zss.model.SFont;
import org.zkoss.zss.model.impl.AbstractBorderAdv;
import org.zkoss.zss.model.impl.AbstractFillAdv;
import org.zkoss.zss.model.impl.AbstractFontAdv;
import org.zkoss.zss.model.impl.BookImpl;
import org.zkoss.zss.model.impl.CellStyleImpl;
import org.zkoss.zss.model.impl.ExtraFillImpl;
import org.zkoss.zss.model.util.Strings;
import org.zkoss.zss.model.util.Validations;

public class ExtraStyleImpl
extends CellStyleImpl
implements SExtraStyle {
    private static final long serialVersionUID = -3304797955338410853L;

    ExtraStyleImpl(ExtraStyleImpl src, BookImpl book) {
        super(src, book);
    }

    public ExtraStyleImpl(SFont font, SFill fill, SBorder border, String dataFormat) {
        super((AbstractFontAdv)font, (AbstractFillAdv)fill, (AbstractBorderAdv)border);
        if (fill != null) {
            Validations.argInstance(fill, ExtraFillImpl.class);
        }
        if (dataFormat != null && !Strings.isBlank(dataFormat)) {
            this.setDataFormat(dataFormat);
        }
    }

    public SBorder.BorderType getBorderLeft() {
        if (this._border == null) {
            return null;
        }
        SBorderLine bline = this._border.getLeftLine();
        return bline == null ? null : bline.getBorderType();
    }

    public SBorder.BorderType getBorderTop() {
        if (this._border == null) {
            return null;
        }
        SBorderLine bline = this._border.getTopLine();
        return bline == null ? null : bline.getBorderType();
    }

    public SBorder.BorderType getBorderRight() {
        if (this._border == null) {
            return null;
        }
        SBorderLine bline = this._border.getRightLine();
        return bline == null ? null : bline.getBorderType();
    }

    public SBorder.BorderType getBorderBottom() {
        if (this._border == null) {
            return null;
        }
        SBorderLine bline = this._border.getBottomLine();
        return bline == null ? null : bline.getBorderType();
    }

    public SBorder.BorderType getBorderDiagonal() {
        if (this._border == null) {
            return null;
        }
        SBorderLine bline = this._border.getDiagonalLine();
        return bline == null ? null : bline.getBorderType();
    }

    public SBorder.BorderType getBorderVertical() {
        if (this._border == null) {
            return null;
        }
        SBorderLine bline = this._border.getVerticalLine();
        return bline == null ? null : bline.getBorderType();
    }

    public SBorder.BorderType getBorderHorizontal() {
        if (this._border == null) {
            return null;
        }
        SBorderLine bline = this._border.getHorizontalLine();
        return bline == null ? null : bline.getBorderType();
    }

    public String getDataFormat() {
        return this._dataFormat;
    }

    public void setBackColor(SColor backColor) {
        Validations.argNotNull(backColor);
        if (this._fill == null) {
            this._fill = new ExtraFillImpl();
        }
        this._fill.setBackColor(backColor);
    }

    public void setFillColor(SColor fillColor) {
        Validations.argNotNull(fillColor);
        if (this._fill == null) {
            this._fill = new ExtraFillImpl();
        }
        this._fill.setFillColor(fillColor);
    }

    public void setFillPattern(SFill.FillPattern fillPattern) {
        Validations.argNotNull(new Object[]{fillPattern});
        if (this._fill == null) {
            this._fill = new ExtraFillImpl();
        }
        this._fill.setFillPattern(fillPattern);
    }

    SCellStyle createCellStyle(SBook book) {
        return new ExtraStyleImpl(this, (BookImpl)book);
    }
}

