/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.model.impl;

import java.io.Serializable;
import java.util.Date;
import java.util.Locale;
import org.zkoss.poi.ss.formula.eval.EvaluationException;
import org.zkoss.poi.ss.formula.eval.ValueEval;
import org.zkoss.poi.ss.formula.ptg.NamePtg;
import org.zkoss.poi.ss.formula.ptg.Ptg;
import org.zkoss.poi.ss.usermodel.ZssContext;
import org.zkoss.poi.util.Internal;
import org.zkoss.zss.model.CellRegion;
import org.zkoss.zss.model.ErrorValue;
import org.zkoss.zss.model.InvalidFormulaException;
import org.zkoss.zss.model.SBook;
import org.zkoss.zss.model.SBookSeries;
import org.zkoss.zss.model.SCell;
import org.zkoss.zss.model.SCellStyle;
import org.zkoss.zss.model.SColumnArray;
import org.zkoss.zss.model.SComment;
import org.zkoss.zss.model.SHyperlink;
import org.zkoss.zss.model.SName;
import org.zkoss.zss.model.SRichText;
import org.zkoss.zss.model.SSheet;
import org.zkoss.zss.model.STable;
import org.zkoss.zss.model.STableColumn;
import org.zkoss.zss.model.impl.AbstractBookAdv;
import org.zkoss.zss.model.impl.AbstractBookSeriesAdv;
import org.zkoss.zss.model.impl.AbstractCellAdv;
import org.zkoss.zss.model.impl.AbstractCellStyleAdv;
import org.zkoss.zss.model.impl.AbstractColumnArrayAdv;
import org.zkoss.zss.model.impl.AbstractCommentAdv;
import org.zkoss.zss.model.impl.AbstractHyperlinkAdv;
import org.zkoss.zss.model.impl.AbstractNameAdv;
import org.zkoss.zss.model.impl.AbstractRichTextAdv;
import org.zkoss.zss.model.impl.AbstractRowAdv;
import org.zkoss.zss.model.impl.AbstractSheetAdv;
import org.zkoss.zss.model.impl.BookImpl;
import org.zkoss.zss.model.impl.CellAttribute;
import org.zkoss.zss.model.impl.CellValue;
import org.zkoss.zss.model.impl.FormulaResultCellValue;
import org.zkoss.zss.model.impl.ModelUpdateUtil;
import org.zkoss.zss.model.impl.RefImpl;
import org.zkoss.zss.model.impl.sys.formula.FormulaEngineImpl;
import org.zkoss.zss.model.sys.EngineFactory;
import org.zkoss.zss.model.sys.dependency.DependencyTable;
import org.zkoss.zss.model.sys.dependency.Ref;
import org.zkoss.zss.model.sys.format.FormatContext;
import org.zkoss.zss.model.sys.format.FormatEngine;
import org.zkoss.zss.model.sys.format.FormatResult;
import org.zkoss.zss.model.sys.formula.EvaluationResult;
import org.zkoss.zss.model.sys.formula.FormulaClearContext;
import org.zkoss.zss.model.sys.formula.FormulaEngine;
import org.zkoss.zss.model.sys.formula.FormulaEvaluationContext;
import org.zkoss.zss.model.sys.formula.FormulaExpression;
import org.zkoss.zss.model.sys.formula.FormulaParseContext;
import org.zkoss.zss.model.util.Validations;

public class CellImpl
extends AbstractCellAdv {
    private static final long serialVersionUID = 1L;
    private AbstractRowAdv _row;
    private int _index;
    private CellValue _localValue = null;
    private AbstractCellStyleAdv _cellStyle;
    private transient FormulaResultCellValue _formulaResultValue;
    private int _height = -1;
    private int _width = -1;
    private OptFields _opts;
    private boolean _calcAutoHeight = false;

    private OptFields getOpts(boolean create) {
        if (this._opts == null && create) {
            this._opts = new OptFields();
        }
        return this._opts;
    }

    public CellImpl(AbstractRowAdv row, int index) {
        this._row = row;
        this._index = index;
    }

    public SCell.CellType getType() {
        CellValue val = this.getCellValue();
        return val == null ? SCell.CellType.BLANK : val.getType();
    }

    public boolean isNull() {
        return false;
    }

    public int getRowIndex() {
        this.checkOrphan();
        return this._row.getIndex();
    }

    public int getColumnIndex() {
        this.checkOrphan();
        return this._index;
    }

    public String getReferenceString() {
        return new CellRegion(this.getRowIndex(), this.getColumnIndex()).getReferenceString();
    }

    public void checkOrphan() {
        if (this._row == null) {
            throw new IllegalStateException("doesn't connect to parent");
        }
    }

    public SSheet getSheet() {
        this.checkOrphan();
        return this._row.getSheet();
    }

    public void destroy() {
        this.checkOrphan();
        this.clearValue0(true);
        this._row = null;
    }

    public SCellStyle getCellStyle() {
        return this.getCellStyle(false);
    }

    public SCellStyle getCellStyle(boolean local) {
        SColumnArray array;
        if (local || this._cellStyle != null) {
            return this._cellStyle;
        }
        this.checkOrphan();
        this._cellStyle = (AbstractCellStyleAdv)this._row.getCellStyle(true);
        AbstractSheetAdv sheet = (AbstractSheetAdv)this._row.getSheet();
        if (this._cellStyle == null && (array = sheet.getColumnArray(this.getColumnIndex())) != null) {
            this._cellStyle = (AbstractCellStyleAdv)((AbstractColumnArrayAdv)array).getCellStyle(true);
        }
        if (this._cellStyle == null) {
            this._cellStyle = (AbstractCellStyleAdv)sheet.getBook().getDefaultCellStyle();
        }
        return this._cellStyle;
    }

    public void setCellStyle(SCellStyle cellStyle) {
        if (cellStyle != null) {
            Validations.argInstance(cellStyle, AbstractCellStyleAdv.class);
        }
        this._cellStyle = (AbstractCellStyleAdv)cellStyle;
        this.addCellUpdate(CellAttribute.STYLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void evalFormula() {
        if (this._formulaResultValue != null) {
            return;
        }
        SBookSeries sBookSeries = this.getSheet().getBook().getBookSeries();
        synchronized (sBookSeries) {
            CellValue val;
            if (this._formulaResultValue == null && (val = this.getCellValue()) != null && val.getType() == SCell.CellType.FORMULA) {
                FormulaEngine fe = EngineFactory.getInstance().createFormulaEngine();
                EvaluationResult result = fe.evaluate((FormulaExpression)val.getValue(), new FormulaEvaluationContext(this, this.getRef()));
                if (this._formulaResultValue == null) {
                    this._formulaResultValue = new FormulaResultCellValue(result);
                }
            }
        }
    }

    public SCell.CellType getFormulaResultType() {
        this.checkType(SCell.CellType.FORMULA);
        this.evalFormula();
        return this._formulaResultValue.getCellType();
    }

    public void clearValue() {
        this.clearValue0(false);
    }

    private void clearValue0(boolean destroy) {
        this.checkOrphan();
        this.clearFormulaDependency();
        this.clearFormulaResultCache();
        this.setCellValue(null, destroy);
        OptFields opts = this.getOpts(false);
        if (opts != null) {
            // empty if block
        }
        if (BookImpl.destroyingSheet.get() != this.getSheet()) {
            this.addCellUpdate(CellAttribute.TEXT);
        }
    }

    private void addCellUpdate(CellAttribute cellAttr) {
        ModelUpdateUtil.addCellUpdate(this.getSheet(), this.getRowIndex(), this.getColumnIndex(), cellAttr);
    }

    public void setFormulaValue(String formula) {
        this.setFormulaValue(formula, Locale.US);
    }

    public void setFormulaValue(String formula, Locale locale) {
        FormulaParseContext formulaCtx;
        this.checkOrphan();
        Validations.argNotNull(formula);
        STable table = this.getTable();
        if (table != null && table.getHeaderRowCount() > 0 && table.getHeadersRegion().getRow() == this.getRowIndex()) {
            this.setCellValue(new CellValue("0"), false);
            return;
        }
        FormulaEngine fe = EngineFactory.getInstance().createFormulaEngine();
        FormulaExpression expr = fe.parse(formula, formulaCtx = new FormulaParseContext(this.getSheet().getBook(), this.getSheet(), this, this.getSheet().getSheetName(), null, locale));
        if (expr.hasError()) {
            String msg = expr.getErrorMessage();
            throw new InvalidFormulaException(msg == null ? "The formula =" + formula + " contains error" : msg);
        }
        this.setValue(expr);
    }

    private void clearValueForSet(boolean clearDependency) {
        if (clearDependency) {
            this.clearFormulaDependency();
        }
        this.clearFormulaResultCache();
        OptFields opts = this.getOpts(false);
        if (opts != null) {
            // empty if block
        }
    }

    public void clearFormulaResultCache() {
        if (this._formulaResultValue != null) {
            EngineFactory.getInstance().createFormulaEngine().clearCache(new FormulaClearContext(this));
        }
        this._formulaResultValue = null;
    }

    public boolean isFormulaParsingError() {
        if (this.getType() == SCell.CellType.FORMULA) {
            return ((FormulaExpression)this.getValue(false)).hasError();
        }
        return false;
    }

    private void clearFormulaDependency() {
        if (this.getType() == SCell.CellType.FORMULA) {
            ((AbstractBookSeriesAdv)this.getSheet().getBook().getBookSeries()).getDependencyTable().clearDependents(this.getRef());
        }
    }

    public Object getValue(boolean evaluatedVal) {
        CellValue val = this.getCellValue();
        if (evaluatedVal && val != null && val.getType() == SCell.CellType.FORMULA) {
            this.evalFormula();
            return this._formulaResultValue.getValue();
        }
        return val == null ? null : val.getValue();
    }

    private boolean isFormula(String string) {
        return string != null && string.startsWith("=") && string.length() > 1;
    }

    private CellValue getCellValue() {
        this.checkOrphan();
        return this._localValue;
    }

    private void setCellValue(CellValue value, boolean destroy) {
        STable table;
        this.checkOrphan();
        this._localValue = value != null && value.getType() == SCell.CellType.BLANK ? null : value;
        SBook book = this.getSheet().getBook();
        SBookSeries bookSeries = book.getBookSeries();
        if (!((AbstractBookAdv)book).isPostProcessing()) {
            ModelUpdateUtil.handlePrecedentUpdate(bookSeries, this.getRef());
        }
        if (!destroy && (table = this.getTable()) != null) {
            CellRegion rgn = table.getAllRegion().getRegion();
            if (table.getHeaderRowCount() > 0 && rgn.getRow() == this.getRowIndex()) {
                String newValue;
                STableColumn tbCol = table.getColumnAt(this.getColumnIndex());
                String oldName = tbCol.getName();
                String newname = null;
                if (value != null) {
                    FormatEngine formatEngine = EngineFactory.getInstance().createFormatEngine();
                    FormatResult ft = formatEngine.format(this, new FormatContext(ZssContext.getCurrent().getLocale()));
                    newname = ft.getText();
                }
                if ((newValue = ((AbstractBookAdv)book).setTableColumnName(table, oldName, newname)) != null) {
                    this._localValue = new CellValue(newValue);
                }
            } else if (table.getTotalsRowCount() > 0 && rgn.getLastRow() == this.getRowIndex()) {
                STableColumn tbCol = table.getColumnAt(this.getColumnIndex());
                this.setTableTotalsRowFunction(value, tbCol);
            }
        }
    }

    private void setTableTotalsRowFunction(CellValue value, STableColumn tbCol) {
        STableColumn.STotalsRowFunction func = STableColumn.STotalsRowFunction.none;
        if (value != null && value.getType() == SCell.CellType.FORMULA) {
            FormulaExpression fe = (FormulaExpression)value.getValue();
            String formula = fe.getFormulaString();
            func = formula.startsWith("SUBTOTAL(") && formula.charAt(12) == ',' && formula.charAt(13) == '[' && formula.endsWith("])") && tbCol.getName().equalsIgnoreCase(formula.substring(14, formula.length() - 2)) ? STableColumn.STotalsRowFunction.valueOfCode(formula.substring(9, 12)) : STableColumn.STotalsRowFunction.custom;
            if (func == STableColumn.STotalsRowFunction.custom) {
                tbCol.setTotalsRowFormula(formula);
            }
        } else if (value != null) {
            FormatEngine formatEngine = EngineFactory.getInstance().createFormatEngine();
            FormatResult ft = formatEngine.format(this, new FormatContext(ZssContext.getCurrent().getLocale()));
            String label = ft.getText();
            tbCol.setTotalsRowLabel(label);
        }
        tbCol.setTotalsRowFunction(func);
    }

    private static boolean valueEuqals(Object val1, Object val2) {
        return val1 == val2 || val1 != null && val1.equals(val2);
    }

    public void setValue(Object newVal) {
        this.setValue(newVal, false);
    }

    protected void setValue(Object newVal, boolean aString) {
        SCell.CellType newType;
        CellValue oldVal = this.getCellValue();
        if (oldVal == null && newVal == null || oldVal != null && CellImpl.valueEuqals(oldVal.getValue(), newVal)) {
            return;
        }
        if (newVal == null) {
            newType = SCell.CellType.BLANK;
        } else if (newVal instanceof String) {
            if (!aString && this.isFormula((String)newVal)) {
                this.setFormulaValue(((String)newVal).substring(1));
                return;
            }
            newType = SCell.CellType.STRING;
        } else if (newVal instanceof SRichText) {
            newType = SCell.CellType.STRING;
        } else if (newVal instanceof FormulaExpression) {
            newType = SCell.CellType.FORMULA;
        } else if (newVal instanceof Date) {
            newType = SCell.CellType.NUMBER;
            newVal = EngineFactory.getInstance().getCalendarUtil().dateToDoubleValue((Date)newVal);
        } else if (newVal instanceof Boolean) {
            newType = SCell.CellType.BOOLEAN;
        } else if (newVal instanceof Double) {
            newType = SCell.CellType.NUMBER;
        } else if (newVal instanceof Number) {
            newType = SCell.CellType.NUMBER;
            newVal = ((Number)newVal).doubleValue();
        } else if (newVal instanceof ErrorValue) {
            newType = SCell.CellType.ERROR;
        } else {
            throw new IllegalArgumentException("unsupported type " + newVal + ", supports NULL, String, Date, Number and Byte(as Error Code)");
        }
        InnerCellValue newCellVal = new InnerCellValue(newType, newVal);
        this.clearValueForSet(oldVal != null && oldVal.getType() == SCell.CellType.FORMULA);
        if (newType == SCell.CellType.FORMULA) {
            FormulaParseContext context = new FormulaParseContext(this, this.getRef());
            EngineFactory.getInstance().createFormulaEngine().updateDependencyTable((FormulaExpression)newVal, context);
        }
        this.setCellValue(newCellVal, false);
    }

    public SHyperlink getHyperlink() {
        OptFields opts = this.getOpts(false);
        return opts == null ? null : opts._hyperlink;
    }

    public void setHyperlink(SHyperlink hyperlink) {
        Validations.argInstance(hyperlink, AbstractHyperlinkAdv.class);
        this.getOpts(true)._hyperlink = (AbstractHyperlinkAdv)hyperlink;
        this.addCellUpdate(CellAttribute.TEXT);
    }

    public SComment getComment() {
        OptFields opts = this.getOpts(false);
        return opts == null ? null : opts._comment;
    }

    public void setComment(SComment comment) {
        Validations.argInstance(comment, AbstractCommentAdv.class);
        this.getOpts(true)._comment = (AbstractCommentAdv)comment;
        this.addCellUpdate(CellAttribute.COMMENT);
    }

    public void deleteComment() {
        OptFields opts = this.getOpts(false);
        if (opts == null) {
            return;
        }
        opts._comment = null;
    }

    void setIndex(int newidx) {
        if (this._index == newidx) {
            return;
        }
        SCell.CellType type = this.getType();
        String formula = null;
        DependencyTable table = null;
        if (type == SCell.CellType.FORMULA) {
            formula = this.getFormulaValue();
            Ref oldRef = this.getRef();
            table = ((AbstractBookSeriesAdv)this.getSheet().getBook().getBookSeries()).getDependencyTable();
            table.clearDependents(oldRef);
        }
        this._index = newidx;
        if (formula != null) {
            FormulaEngine fe = EngineFactory.getInstance().createFormulaEngine();
            Ref ref = this.getRef();
            fe.parse(formula, new FormulaParseContext(this, ref));
            if (this._formulaResultValue != null) {
                table.setEvaluated(ref);
            }
        }
    }

    void setRow(int oldRowIdx, AbstractRowAdv row) {
        if (oldRowIdx == row.getIndex() && this._row == row) {
            return;
        }
        SCell.CellType type = this.getType();
        String formula = null;
        DependencyTable table = null;
        if (type == SCell.CellType.FORMULA) {
            formula = this.getFormulaValue();
            SSheet sheet = this.getSheet();
            RefImpl oldRef = new RefImpl(sheet.getBook().getBookName(), sheet.getSheetName(), oldRowIdx, this.getColumnIndex());
            table = ((AbstractBookSeriesAdv)this.getSheet().getBook().getBookSeries()).getDependencyTable();
            table.clearDependents(oldRef);
        }
        this._row = row;
        if (formula != null) {
            FormulaEngine fe = EngineFactory.getInstance().createFormulaEngine();
            Ref ref = this.getRef();
            fe.parse(formula, new FormulaParseContext(this, ref));
            if (this._formulaResultValue != null) {
                table.setEvaluated(ref);
            }
        }
    }

    protected Ref getRef() {
        return new RefImpl(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Cell:" + this.getReferenceString() + "[").append(this.getRowIndex()).append(",").append(this.getColumnIndex()).append("]");
        return sb.toString();
    }

    AbstractCellAdv cloneCell(AbstractRowAdv row) {
        return this.cloneCell(row, null);
    }

    public void setFormulaResultValue(ValueEval value) {
        try {
            this._formulaResultValue = new FormulaResultCellValue(FormulaEngineImpl.convertToEvaluationResult(value));
        }
        catch (EvaluationException evaluationException) {
            // empty catch block
        }
    }

    public FormulaExpression getFormulaExpression() {
        return this._localValue != null && this._localValue.getType() == SCell.CellType.FORMULA ? (FormulaExpression)this._localValue.getValue() : null;
    }

    private STable getTable() {
        SSheet sheet = this.getSheet();
        if (!sheet.getTables().isEmpty()) {
            return ((AbstractSheetAdv)sheet).getTableByRowCol(this.getRowIndex(), this.getColumnIndex());
        }
        return null;
    }

    @Internal
    public Object getFromulaResultValue() {
        return this._formulaResultValue;
    }

    @Internal
    public void setTextHeight(int heightPx) {
        this._height = heightPx;
        this.setCalcAutoHeight(false);
    }

    @Internal
    public int getTextHeight() {
        return this._height < 0 ? this.getSheet().getDefaultRowHeight() : this._height;
    }

    @Internal
    public void setCalcAutoHeight(boolean b) {
        this._calcAutoHeight = b;
    }

    @Internal
    public boolean isCalcAutoHeight() {
        return this._calcAutoHeight;
    }

    @Internal
    public void setTextWidth(int widthPx) {
        this._width = widthPx;
    }

    @Internal
    public int getTextWidth() {
        return this._width;
    }

    AbstractCellAdv cloneCell(AbstractRowAdv row, SSheet sheet) {
        AbstractCellStyleAdv srcStyle;
        SBook book;
        CellImpl tgt = new CellImpl(row, this._index);
        SBook sBook = book = sheet == null ? null : sheet.getBook();
        if (this._localValue != null) {
            Object newVal = this._localValue.getValue();
            if (newVal instanceof SRichText) {
                newVal = ((AbstractRichTextAdv)newVal).cloneRichText(book);
            } else if (newVal instanceof FormulaExpression) {
                newVal = "=" + this.cloneFormulaString((FormulaExpression)newVal, sheet);
            }
            tgt.setValue(newVal);
        }
        tgt._cellStyle = (AbstractCellStyleAdv)((srcStyle = this._cellStyle) == null ? null : srcStyle.cloneCellStyle(book));
        if (this._opts != null) {
            OptFields opts = tgt.getOpts(true);
            if (this._opts._comment != null) {
                opts._comment = this._opts._comment.cloneComment(book);
            }
            if (this._opts._hyperlink != null) {
                opts._hyperlink = this._opts._hyperlink.clone();
            }
        }
        return tgt;
    }

    private String cloneFormulaString(FormulaExpression expr, SSheet sheet) {
        if (sheet != null) {
            SBook book = sheet.getBook();
            SSheet srcSheet = this._row.getSheet();
            SBook srcBook = srcSheet.getBook();
            if (!srcBook.equals(book)) {
                String srcSheetName = srcSheet.getSheetName();
                for (Ptg ptg : expr.getPtgs()) {
                    if (!(ptg instanceof NamePtg)) continue;
                    String nameName = ((NamePtg)ptg).getNameName();
                    SName srcName = srcBook.getNameByName(nameName, srcSheetName);
                    if (srcName == null) {
                        srcName = srcBook.getNameByName(nameName);
                    }
                    if (srcName == null) continue;
                    ((AbstractNameAdv)srcName).cloneName(sheet);
                }
            }
        }
        return expr.getFormulaString();
    }

    public CellValue getEvalCellValue(boolean evaluatedVal) {
        CellValue val = this.getCellValue();
        if (evaluatedVal && val != null && val.getType() == SCell.CellType.FORMULA) {
            this.evalFormula();
            return this._formulaResultValue;
        }
        return val == null ? new CellValue() : val;
    }

    private static class InnerCellValue
    extends CellValue {
        private static final long serialVersionUID = 1L;

        private InnerCellValue(SCell.CellType type, Object value) {
            super(type, value);
        }
    }

    private static class OptFields
    implements Serializable {
        private AbstractHyperlinkAdv _hyperlink;
        private AbstractCommentAdv _comment;

        private OptFields() {
        }
    }
}

