/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.model.impl;

import org.zkoss.zss.model.SBook;
import org.zkoss.zss.model.SBorder;
import org.zkoss.zss.model.SBorderLine;
import org.zkoss.zss.model.SColor;
import org.zkoss.zss.model.impl.AbstractBorderLineAdv;
import org.zkoss.zss.model.impl.AbstractColorAdv;
import org.zkoss.zss.model.impl.ColorImpl;

public class BorderLineImpl
extends AbstractBorderLineAdv
implements SBorderLine {
    private static final long serialVersionUID = -541335216584161785L;
    private SBorder.BorderType type;
    private SColor color;
    private boolean showUp;
    private boolean showDown;

    public BorderLineImpl(SBorder.BorderType type, String htmlColor) {
        this(type, htmlColor == null ? ColorImpl.BLACK : new ColorImpl(htmlColor), false, false);
    }

    public BorderLineImpl(SBorder.BorderType type, SColor color) {
        this(type, color, false, false);
    }

    public BorderLineImpl(SBorder.BorderType type, SColor color, boolean showUp, boolean showDown) {
        this.type = type;
        this.color = color;
        this.showUp = showUp;
        this.showDown = showDown;
    }

    public SBorder.BorderType getBorderType() {
        return this.type;
    }

    public void setBorderType(SBorder.BorderType type) {
        this.type = type;
    }

    public SColor getColor() {
        return this.color == null ? ColorImpl.BLACK : this.color;
    }

    public void setColor(SColor color) {
        this.color = color;
    }

    public boolean isShowDiagonalUpBorder() {
        return this.showUp;
    }

    public void setShowDiagonalUpBorder(boolean show) {
        this.showUp = show;
    }

    public boolean isShowDiagonalDownBorder() {
        return this.showDown;
    }

    public void setShowDiagonalDownBorder(boolean show) {
        this.showDown = show;
    }

    String getStyleKey() {
        return (this.type == null ? "" : Integer.valueOf(this.type.ordinal())) + "." + (this.color == null ? "" : this.color.getHtmlColor()) + "." + (this.showUp ? "1" : "0") + "." + (this.showDown ? "1" : "0");
    }

    SBorderLine cloneBorderLine(SBook book) {
        AbstractColorAdv srcColor = (AbstractColorAdv)this.getColor();
        SColor color = srcColor == null ? null : srcColor.cloneColor(book);
        return new BorderLineImpl(this.type, color, this.showUp, this.showDown);
    }
}

