/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.model.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.zkoss.zss.model.SBook;
import org.zkoss.zss.model.impl.AbstractBookAdv;
import org.zkoss.zss.model.impl.AbstractBookSeriesAdv;
import org.zkoss.zss.model.impl.sys.DependencyTableAdv;
import org.zkoss.zss.model.sys.EngineFactory;
import org.zkoss.zss.model.sys.dependency.DependencyTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BookSeriesImpl
extends AbstractBookSeriesAdv {
    private static final long serialVersionUID = 1L;
    private final HashMap<String, AbstractBookAdv> _books;
    private final DependencyTable _dependencyTable;
    private final ReadWriteLock _lock = new ReentrantReadWriteLock();
    private Map<String, Object> _attributes;

    public BookSeriesImpl(AbstractBookAdv ... books) {
        this._books = new LinkedHashMap<String, AbstractBookAdv>(1);
        this._dependencyTable = EngineFactory.getInstance().createDependencyTable();
        ((DependencyTableAdv)this._dependencyTable).setBookSeries(this);
        for (AbstractBookAdv book : books) {
            this._books.put(book.getBookName(), book);
            if (book.getBookSeries().isAutoFormulaCacheClean()) {
                this.setAutoFormulaCacheClean(true);
            }
            ((DependencyTableAdv)this._dependencyTable).merge((DependencyTableAdv)((AbstractBookSeriesAdv)book.getBookSeries()).getDependencyTable());
            book.setBookSeries(this);
        }
    }

    @Override
    public SBook getBook(String name) {
        return this._books.get(name);
    }

    @Override
    public DependencyTable getDependencyTable() {
        return this._dependencyTable;
    }

    @Override
    public ReadWriteLock getLock() {
        return this._lock;
    }

    @Override
    public List<SBook> getBooks() {
        return Collections.unmodifiableList(new ArrayList<AbstractBookAdv>(this._books.values()));
    }

    @Override
    public Object getAttribute(String name) {
        return this._attributes == null ? null : this._attributes.get(name);
    }

    @Override
    public Object setAttribute(String name, Object value) {
        if (this._attributes == null) {
            this._attributes = new HashMap<String, Object>();
        }
        return this._attributes.put(name, value);
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this._attributes == null ? Collections.EMPTY_MAP : Collections.unmodifiableMap(this._attributes);
    }
}

