/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ErrorValue
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final byte ERROR_NULL = 0;
    public static final byte ERROR_DIV_0 = 7;
    public static final byte INVALID_VALUE = 15;
    public static final byte ERROR_REF = 23;
    public static final byte INVALID_NAME = 29;
    public static final byte ERROR_NUM = 36;
    public static final byte ERROR_NA = 42;
    public static final byte INVALID_FORMULA = 127;
    public static final ErrorValue NULL = new ErrorValue(0, "#NULL!");
    public static final ErrorValue DIV0 = new ErrorValue(7, "#DIV/0!");
    public static final ErrorValue VALUE = new ErrorValue(15, "#VALUE!");
    public static final ErrorValue REF = new ErrorValue(23, "#REF!");
    public static final ErrorValue NAME = new ErrorValue(29, "#NAME?");
    public static final ErrorValue NUM = new ErrorValue(36, "#NUM!");
    public static final ErrorValue NA = new ErrorValue(42, "#N/A");
    public static final ErrorValue FORMULA = new ErrorValue(127, "#ERROR!");
    private static final Map<Byte, ErrorValue> ERR_MAP = new HashMap<Byte, ErrorValue>(16);
    private byte _code;
    private String _message;

    public static ErrorValue valueOf(byte code) {
        ErrorValue v = ERR_MAP.get(code);
        return v == null ? NA : v;
    }

    public ErrorValue(byte code) {
        this(code, null);
    }

    public ErrorValue(byte code, String message) {
        this._code = code;
        this._message = message;
    }

    public byte getCode() {
        return this._code;
    }

    public void setCode(byte code) {
        this._code = code;
    }

    public String getMessage() {
        return this._message;
    }

    public void setMessage(String message) {
        this._message = message;
    }

    public String getErrorString() {
        return ErrorValue.getErrorString(this._code);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("/").append(this.getErrorString());
        return sb.toString();
    }

    public static final String getErrorString(int errorCode) {
        switch (errorCode) {
            case 0: {
                return "#NULL!";
            }
            case 7: {
                return "#DIV/0!";
            }
            case 15: {
                return "#VALUE!";
            }
            case 23: {
                return "#REF!";
            }
            case 29: {
                return "#NAME?";
            }
            case 36: {
                return "#NUM!";
            }
            case 42: {
                return "#N/A";
            }
            case 127: {
                return "#ERROR!";
            }
        }
        return "#N/A";
    }

    static {
        ERR_MAP.put(ErrorValue.NULL._code, NULL);
        ERR_MAP.put(ErrorValue.DIV0._code, DIV0);
        ERR_MAP.put(ErrorValue.VALUE._code, VALUE);
        ERR_MAP.put(ErrorValue.REF._code, REF);
        ERR_MAP.put(ErrorValue.NAME._code, NAME);
        ERR_MAP.put(ErrorValue.NUM._code, NUM);
        ERR_MAP.put(ErrorValue.NA._code, NA);
        ERR_MAP.put(ErrorValue.FORMULA._code, FORMULA);
    }
}

