/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.range.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import org.zkoss.lang.Integers;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zss.model.CellRegion;
import org.zkoss.zss.model.InvalidModelOpException;
import org.zkoss.zss.model.SAutoFilter;
import org.zkoss.zss.model.SCell;
import org.zkoss.zss.model.SRow;
import org.zkoss.zss.model.STable;
import org.zkoss.zss.model.impl.AbstractSheetAdv;
import org.zkoss.zss.range.SRange;
import org.zkoss.zss.range.SRanges;
import org.zkoss.zss.range.impl.DataRegionHelper;
import org.zkoss.zss.range.impl.RangeHelperBase;

class AutoFilterHelper
extends RangeHelperBase {
    public AutoFilterHelper(SRange range) {
        super(range);
    }

    public CellRegion findAutoFilterRegion() {
        return new DataRegionHelper(this.range).findAutoFilterDataRegion();
    }

    public SAutoFilter enableTableFilter(STable table, boolean enable) {
        SAutoFilter filter = table.getAutoFilter();
        if (filter != null && !enable) {
            CellRegion region = filter.getRegion();
            SRange toUnhide = SRanges.range(this.sheet, region.getRow(), region.getColumn(), region.getLastRow(), region.getLastColumn()).getRows();
            toUnhide.setHidden(false);
            table.deleteAutoFilter();
            filter = null;
        } else if (filter == null && enable) {
            table.enableAutoFilter(enable);
            filter = table.getAutoFilter();
        }
        return filter;
    }

    public SAutoFilter enableAutoFilter(boolean enable) {
        SAutoFilter filter = this.sheet.getAutoFilter();
        if (filter != null && !enable) {
            CellRegion region = filter.getRegion();
            SRange toUnhide = SRanges.range(this.sheet, region.getRow(), region.getColumn(), region.getLastRow(), region.getLastColumn()).getRows();
            toUnhide.setHidden(false);
            this.sheet.deleteAutoFilter();
            filter = null;
        } else if (filter == null && enable) {
            CellRegion region = this.findAutoFilterRegion();
            if (region != null) {
                filter = this.sheet.createAutoFilter(region);
            } else {
                throw new InvalidModelOpException("can't find any data in range");
            }
        }
        return filter;
    }

    @Deprecated
    public SAutoFilter enableAutoFilter(int field, SAutoFilter.FilterOp filterOp, Object criteria1, Object criteria2, Boolean showButton) {
        STable table = ((AbstractSheetAdv)this.sheet).getTableByRowCol(this.getRow(), this.getColumn());
        return this.enableAutoFilter(table, field, filterOp, criteria1, criteria2, showButton);
    }

    public SAutoFilter enableAutoFilter(STable table, int field, SAutoFilter.FilterOp filterOp, Object criteria1, Object criteria2, Boolean showButton) {
        SAutoFilter filter;
        SAutoFilter sAutoFilter = filter = table == null ? this.sheet.getAutoFilter() : table.getAutoFilter();
        if (filter == null) {
            if (table != null) {
                table.enableAutoFilter(true);
                filter = table.getAutoFilter();
            } else {
                CellRegion region = new DataRegionHelper(this.range).findAutoFilterDataRegion();
                if (region != null) {
                    filter = this.sheet.createAutoFilter(region);
                } else {
                    throw new InvalidModelOpException("can't find any data in range");
                }
            }
        }
        this.enableAutoFilter0(table, filter, field, filterOp, criteria1, criteria2, showButton);
        return filter;
    }

    private void enableAutoFilter0(STable table, SAutoFilter filter, int field, SAutoFilter.FilterOp filterOp, Object criteria1, Object criteria2, Boolean showButton) {
        SAutoFilter.NFilterColumn fc = filter.getFilterColumn(field - 1, true);
        fc.setProperties(filterOp, criteria1, criteria2, showButton);
        CellRegion affectedArea = filter.getRegion();
        int row1 = affectedArea.getRow();
        int col1 = affectedArea.getColumn();
        int col = col1 + field - 1;
        int row = row1 + 1;
        int row2 = affectedArea.getLastRow();
        Set cr1 = fc.getCriteria1();
        LinkedHashMap<Integer, Boolean> affectedRows = new LinkedHashMap<Integer, Boolean>();
        for (int r = row; r <= row2; ++r) {
            SRow rowobj;
            String val;
            SCell cell = this.sheet.getCell(r, col);
            String string = val = AutoFilterHelper.isBlank(cell) ? "=" : this.getFormattedText(cell);
            if (cr1 != null && !cr1.isEmpty() && !cr1.contains(val)) {
                rowobj = this.sheet.getRow(r);
                if (rowobj.isHidden()) continue;
                affectedRows.put(r, true);
                continue;
            }
            rowobj = this.sheet.getRow(r);
            if (!rowobj.isHidden() || !this.canUnhide(filter, fc, r, col1)) continue;
            affectedRows.put(r, false);
        }
        if (!affectedRows.isEmpty()) {
            String key = (table == null ? this.sheet.getId() : table.getName()) + "_ZSS_AFFECTED_ROWS";
            Executions.getCurrent().setAttribute("CONTAINS_" + key, (Object)true);
            int sz = affectedRows.size();
            int j = 0;
            Iterator iterator = affectedRows.keySet().iterator();
            while (iterator.hasNext()) {
                int r = (Integer)iterator.next();
                if (++j == sz) {
                    Executions.getCurrent().setAttribute(key, (Object)new Integer(sz));
                } else {
                    Executions.getCurrent().setAttribute(key, (Object)Integers.ZERO);
                }
                SRanges.range(this.sheet, r, 0).getRows().setHidden((Boolean)affectedRows.get(r));
            }
        }
    }

    private boolean canUnhide(SAutoFilter af, SAutoFilter.NFilterColumn fc, int row, int col) {
        Collection<SAutoFilter.NFilterColumn> fltcs = af.getFilterColumns();
        for (SAutoFilter.NFilterColumn fltc : fltcs) {
            if (fc.equals(fltc) || !this.shallHide(fltc, row, col)) continue;
            return false;
        }
        return true;
    }

    private boolean shallHide(SAutoFilter.NFilterColumn fc, int row, int col) {
        SCell cell = this.sheet.getCell(row, col + fc.getIndex());
        boolean blank = AutoFilterHelper.isBlank(cell);
        String val = blank ? "=" : this.getFormattedText(cell);
        Set critera1 = fc.getCriteria1();
        return critera1 != null && !critera1.isEmpty() && !critera1.contains(val);
    }

    @Deprecated
    public void resetAutoFilter() {
        STable table = ((AbstractSheetAdv)this.sheet).getTableByRowCol(this.getRow(), this.getColumn());
        this.resetAutoFilter(table);
    }

    private void validFiltered(SAutoFilter af) {
        if (af == null) {
            return;
        }
        Collection<SAutoFilter.NFilterColumn> fcs = af.getFilterColumns();
        if (fcs == null) {
            return;
        }
        boolean hasCriteria1 = false;
        for (SAutoFilter.NFilterColumn fc : fcs) {
            Set criteria1 = fc.getCriteria1();
            if (criteria1 == null || criteria1.isEmpty()) continue;
            hasCriteria1 = true;
            break;
        }
        if (!hasCriteria1) {
            throw new InvalidModelOpException("The filter is not applied any criteria");
        }
    }

    public void resetAutoFilter(STable table) {
        SAutoFilter af;
        SAutoFilter sAutoFilter = af = table == null ? this.sheet.getAutoFilter() : table.getAutoFilter();
        if (af == null) {
            return;
        }
        CellRegion afrng = af.getRegion();
        Collection<SAutoFilter.NFilterColumn> fcs = af.getFilterColumns();
        if (fcs == null) {
            return;
        }
        this.validFiltered(af);
        for (SAutoFilter.NFilterColumn fc : fcs) {
            fc.setProperties(SAutoFilter.FilterOp.VALUES, null, null, null);
        }
        int row1 = afrng.getRow();
        int row = row1 + 1;
        int row2 = afrng.getLastRow();
        int col1 = afrng.getColumn();
        int col2 = afrng.getLastColumn();
        for (int r = row; r <= row2; ++r) {
            SRow rowobj = this.sheet.getRow(r);
            if (!rowobj.isHidden()) continue;
            SRange rng = SRanges.range(this.sheet, r, 0, r, 0);
            rng.getRows().setHidden(false);
        }
    }

    @Deprecated
    public void applyAutoFilter() {
        STable table = ((AbstractSheetAdv)this.sheet).getTableByRowCol(this.getRow(), this.getColumn());
        this.applyAutoFilter(table);
    }

    public void applyAutoFilter(STable table) {
        SAutoFilter oldFilter;
        SAutoFilter sAutoFilter = oldFilter = table == null ? this.sheet.getAutoFilter() : table.getAutoFilter();
        if (oldFilter == null) {
            return;
        }
        this.validFiltered(oldFilter);
        CellRegion region = oldFilter.getRegion();
        int firstRow = region.getRow();
        int firstColumn = region.getColumn();
        ArrayList<Object[]> originalFilteringColumns = new ArrayList<Object[]>();
        if (oldFilter.getFilterColumns() != null) {
            for (SAutoFilter.NFilterColumn filterColumn : oldFilter.getFilterColumns()) {
                Object[] filterColumnData = new Object[]{filterColumn.getIndex() + 1, filterColumn.getCriteria1().toArray(new String[0]), filterColumn.getOperator(), filterColumn.getCriteria2(), filterColumn.isShowButton()};
                originalFilteringColumns.add(filterColumnData);
            }
        }
        SAutoFilter newFilter = null;
        if (table != null) {
            this.enableTableFilter(table, false);
            newFilter = this.enableTableFilter(table, true);
        } else {
            this.enableAutoFilter(false);
            CellRegion filteringRange = new DataRegionHelper.FilterRegionHelper().findCurrentRegion(this.sheet, firstRow, firstColumn);
            if (filteringRange == null) {
                return;
            }
            newFilter = this.sheet.createAutoFilter(filteringRange);
        }
        for (int nCol = 0; nCol < originalFilteringColumns.size(); ++nCol) {
            Object[] oldFilterColumn = (Object[])originalFilteringColumns.get(nCol);
            int field = (Integer)oldFilterColumn[0];
            Object c1 = oldFilterColumn[1];
            SAutoFilter.FilterOp op = (SAutoFilter.FilterOp)((Object)oldFilterColumn[2]);
            Object c2 = oldFilterColumn[3];
            boolean showBtn = (Boolean)oldFilterColumn[4];
            this.enableAutoFilter0(table, newFilter, field, op, c1, c2, showBtn);
        }
    }
}

