/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.model.util;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.zkoss.util.Maps;
import org.zkoss.zss.model.SCell;
import org.zkoss.zss.model.SFont;
import org.zkoss.zss.model.SRichText;
import org.zkoss.zss.model.impl.RichTextImpl;
import org.zkoss.zss.range.SRange;

public class RichTextHelper
implements Serializable {
    private static final long serialVersionUID = 673839590374447339L;
    private static final String NEW_LINE = "\u4a3a\u0000\u9f98";
    private static final Pattern rgbPattern = Pattern.compile("rgb *\\( *([0-9]+), *([0-9]+), *([0-9]+) *\\)");
    private SRange _range;
    private Stack<SFont> _stack;
    private SRichText _txt;

    public SRichText parse(SRange range, String content) {
        this._range = range;
        this._stack = new Stack();
        this._stack.push(range.getCellStyle().getFont());
        this._txt = new RichTextImpl();
        this.parseElement(RichTextHelper.br2nl(content));
        return this._txt;
    }

    private void parseElement(Element element) {
        SFont font = this.toFont(element);
        this._stack.push(font);
        List nodes = element.childNodes();
        for (Node node : nodes) {
            if (node instanceof TextNode) {
                TextNode textNode = (TextNode)node;
                if (textNode.isBlank()) continue;
                this._txt.addSegment(textNode.text().replaceAll(NEW_LINE, "\n"), font);
                continue;
            }
            if (!(node instanceof Element)) continue;
            this.parseElement((Element)node);
        }
        this._stack.pop();
    }

    private SFont toFont(Element element) {
        SFont fontBase = this._stack.peek();
        SFont.Boldweight boldweight = fontBase.getBoldweight();
        String fontColor = fontBase.getColor().getHtmlColor();
        int fontHeight = fontBase.getHeightPoints();
        String fontName = fontBase.getName();
        boolean isItalic = fontBase.isItalic();
        boolean isStrikeout = fontBase.isStrikeout();
        SFont.TypeOffset typeOffset = fontBase.getTypeOffset();
        SFont.Underline underline = fontBase.getUnderline();
        Map style = Maps.parse(new HashMap(), (String)element.attr("style").toLowerCase(), (char)':', (char)';', (char)'\"');
        if (style.containsKey("font-weight")) {
            String weight = (String)style.get("font-weight");
            boldweight = "bold".equals(weight) || "700".equals(weight) ? SFont.Boldweight.BOLD : SFont.Boldweight.NORMAL;
        }
        if (style.containsKey("color")) {
            String color = (String)style.get("color");
            Matcher rgbMatcher = rgbPattern.matcher(color);
            if (rgbMatcher.matches()) {
                fontColor = String.format("#%02x%02x%02x", (byte)Integer.parseInt(rgbMatcher.group(1)), (byte)Integer.parseInt(rgbMatcher.group(2)), (byte)Integer.parseInt(rgbMatcher.group(3)));
            } else if (color.startsWith("#")) {
                fontColor = color;
            }
        }
        if (style.containsKey("font-family")) {
            fontName = (String)style.get("font-family");
        }
        if (style.containsKey("font-size")) {
            String size = (String)style.get("font-size");
            int ptIndex = size.lastIndexOf("pt");
            int pxIndex = size.lastIndexOf("px");
            if (ptIndex > 0) {
                fontHeight = Integer.parseInt(size.substring(0, ptIndex));
            } else if (pxIndex > 0) {
                fontHeight = Integer.parseInt(size.substring(0, pxIndex)) * 72 / 96;
            }
        }
        if (style.containsKey("font-style")) {
            String fs = (String)style.get("font-style");
            if ("italic".equals(fs)) {
                isItalic = true;
            } else if ("normal".equals(fs)) {
                isItalic = false;
            }
        }
        if (style.containsKey("text-decoration")) {
            String decoration = (String)style.get("text-decoration");
            if (decoration.contains("underline")) {
                underline = SFont.Underline.SINGLE;
            }
            if (decoration.contains("line-through")) {
                isStrikeout = true;
            }
        }
        if ("b".equals(element.nodeName()) || "strong".equals(element.nodeName())) {
            boldweight = SFont.Boldweight.BOLD;
        } else if ("i".equals(element.nodeName()) || "em".equals(element.nodeName())) {
            isItalic = true;
        } else if ("u".equals(element.nodeName())) {
            underline = SFont.Underline.SINGLE;
        } else if ("strike".equals(element.nodeName())) {
            isStrikeout = true;
        } else if ("sub".equals(element.nodeName())) {
            typeOffset = SFont.TypeOffset.SUB;
        } else if ("sup".equals(element.nodeName())) {
            typeOffset = SFont.TypeOffset.SUPER;
        }
        return this._range.getOrCreateFont(boldweight, fontColor, fontHeight, fontName, isItalic, isStrikeout, typeOffset, underline);
    }

    private static Element br2nl(String html) {
        Element body = Jsoup.parseBodyFragment((String)html).body();
        body.select("div").prepend(NEW_LINE);
        body.select("br").append(NEW_LINE);
        body.select("p").append(NEW_LINE);
        return body;
    }

    public static String getCellRichTextHtml(SCell cell) {
        boolean wrap = cell.getCellStyle().isWrapText();
        SRichText rstr = cell.getRichTextValue();
        return RichTextHelper.getCellRichTextHtml(cell, rstr, wrap);
    }

    public static SFont getRichTextRealFont(SFont font, SCell cell) {
        if (font == null) {
            font = cell.getCellStyle().getFont();
        }
        if (font == null) {
            font = cell.getSheet().getBook().getDefaultFont();
        }
        return font;
    }

    public static String getCellRichTextHtml(SCell cell, SRichText rstr, boolean wrap) {
        StringBuilder sb = new StringBuilder();
        for (SRichText.Segment seg : rstr.getSegments()) {
            sb.append(RichTextHelper.getFontTextHtml(RichTextHelper.escapeText(seg.getText(), wrap, true), RichTextHelper.getRichTextRealFont(seg.getFont(), cell)));
        }
        return sb.toString();
    }

    @Deprecated
    public static String getCellRichTextHtml(SRichText rstr, boolean wrap) {
        StringBuilder sb = new StringBuilder();
        for (SRichText.Segment seg : rstr.getSegments()) {
            sb.append(RichTextHelper.getFontTextHtml(RichTextHelper.escapeText(seg.getText(), wrap, true), seg.getFont()));
        }
        return sb.toString();
    }

    public static String escapeText(String text, boolean wrap, boolean multiline) {
        StringBuffer out = new StringBuffer();
        int tl = text.length();
        block6: for (int j = 0; j < tl; ++j) {
            char cc = text.charAt(j);
            switch (cc) {
                case '&': {
                    out.append("&amp;");
                    continue block6;
                }
                case '<': {
                    out.append("&lt;");
                    continue block6;
                }
                case '>': {
                    out.append("&gt;");
                    continue block6;
                }
                case '\n': {
                    if (!wrap || !multiline) continue block6;
                    out.append("<br/>");
                    continue block6;
                }
                default: {
                    out.append(cc);
                }
            }
        }
        return out.toString();
    }

    public static String getFontTextHtml(String text, SFont font) {
        String endTag;
        String startTag;
        StringBuilder sb = new StringBuilder();
        if (font.getTypeOffset() == SFont.TypeOffset.SUPER) {
            startTag = "<sup>";
            endTag = "</sup>";
        } else if (font.getTypeOffset() == SFont.TypeOffset.SUB) {
            startTag = "<sub>";
            endTag = "</sub>";
        } else {
            startTag = "";
            endTag = "";
        }
        sb.append("<span style=\"").append(RichTextHelper.getFontCSSStyle(font, false)).append("\">");
        sb.append(startTag).append(text).append(endTag);
        sb.append("</span>");
        return sb.toString();
    }

    public static String getFontCSSStyle(SFont font, boolean displayTypeOffset) {
        boolean isUnderline;
        String textColor;
        StringBuffer sb = new StringBuffer();
        String fontName = font.getName();
        if (fontName != null) {
            sb.append("font-family:").append(fontName).append(";");
        }
        if ((textColor = font.getColor().getHtmlColor()) != null) {
            sb.append("color:").append(textColor).append(";");
        }
        SFont.Underline fontUnderline = font.getUnderline();
        boolean strikeThrough = font.isStrikeout();
        boolean bl = isUnderline = fontUnderline == SFont.Underline.SINGLE || fontUnderline == SFont.Underline.SINGLE_ACCOUNTING;
        if (strikeThrough || isUnderline) {
            sb.append("text-decoration:");
            if (strikeThrough) {
                sb.append(" line-through");
            }
            if (isUnderline) {
                sb.append(" underline");
            }
            sb.append(";");
        }
        SFont.Boldweight weight = font.getBoldweight();
        sb.append("font-weight:").append(weight == SFont.Boldweight.BOLD ? "bold" : "normal").append(";");
        boolean italic = font.isItalic();
        if (italic) {
            sb.append("font-style:").append("italic;");
        }
        int fontSize = font.getHeightPoints();
        if (displayTypeOffset && font.getTypeOffset() != SFont.TypeOffset.NONE) {
            fontSize = (int)(0.7 * (double)fontSize + 0.5);
        }
        sb.append("font-size:").append(fontSize).append("pt;");
        if (displayTypeOffset) {
            if (font.getTypeOffset() == SFont.TypeOffset.SUPER) {
                sb.append("vertical-align:").append("super;");
            } else if (font.getTypeOffset() == SFont.TypeOffset.SUB) {
                sb.append("vertical-align:").append("sub;");
            }
        }
        return sb.toString();
    }

    public static String escapeVText(String text, boolean wrap) {
        String between = wrap ? "</div><div class=\"zsvtxt\">" : "&nbsp;";
        StringBuffer out = new StringBuffer();
        out.append("<div class=\"zsvtxt\">");
        int tl = text.length();
        block7: for (int j = 0; j < tl; ++j) {
            char cc = text.charAt(j);
            switch (cc) {
                case '&': {
                    out.append("&amp;");
                    continue block7;
                }
                case '<': {
                    out.append("&lt;");
                    continue block7;
                }
                case '>': {
                    out.append("&gt;");
                    continue block7;
                }
                case ' ': {
                    out.append("&nbsp;");
                    continue block7;
                }
                case '\n': {
                    out.append(between);
                    continue block7;
                }
                default: {
                    out.append(cc);
                }
            }
        }
        out.append("</div>");
        return out.toString();
    }

    public static String getCellVRichTextHtml(SCell cell, SRichText rstr, boolean wrap) {
        String between = wrap ? "</div><div class=\"zsvtxt\">" : "&nbsp;";
        StringBuilder sb = new StringBuilder();
        sb.append("<div class=\"zsvtxt\">");
        for (SRichText.Segment seg : rstr.getSegments()) {
            int j;
            String text = seg.getText();
            if ("\n".equals(text)) {
                sb.append(between);
                continue;
            }
            String[] texts = text.split("\n");
            SFont font = RichTextHelper.getRichTextRealFont(seg.getFont(), cell);
            int len = texts.length - 1;
            for (j = 0; j < len; ++j) {
                sb.append(RichTextHelper.getFontTextHtml(RichTextHelper.escapeText(texts[j], wrap, true), font));
                sb.append(between);
            }
            sb.append(RichTextHelper.getFontTextHtml(RichTextHelper.escapeText(texts[j], wrap, true), font));
        }
        sb.append("</div>");
        return sb.toString();
    }

    @Deprecated
    public static String getCellVRichTextHtml(SRichText rstr, boolean wrap) {
        String between = wrap ? "</div><div class=\"zsvtxt\">" : "&nbsp;";
        StringBuilder sb = new StringBuilder();
        sb.append("<div class=\"zsvtxt\">");
        for (SRichText.Segment seg : rstr.getSegments()) {
            int j;
            String text = seg.getText();
            if ("\n".equals(text)) {
                sb.append(between);
                continue;
            }
            String[] texts = text.split("\n");
            SFont font = seg.getFont();
            int len = texts.length - 1;
            for (j = 0; j < len; ++j) {
                sb.append(RichTextHelper.getFontTextHtml(RichTextHelper.escapeText(texts[j], wrap, true), font));
                sb.append(between);
            }
            sb.append(RichTextHelper.getFontTextHtml(RichTextHelper.escapeText(texts[j], wrap, true), font));
        }
        sb.append("</div>");
        return sb.toString();
    }

    public static int getRichTextHeightPoints(SCell cell, SRichText rstr) {
        int highest = 0;
        for (SRichText.Segment ss : rstr.getSegments()) {
            SFont font = RichTextHelper.getRichTextRealFont(ss.getFont(), cell);
            int p = font.getHeightPoints();
            if (p <= highest) continue;
            highest = p;
        }
        return highest;
    }
}

