/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.model.sys.formula;

import java.io.Serializable;
import org.zkoss.xel.FunctionMapper;
import org.zkoss.xel.VariableResolver;
import org.zkoss.zss.model.SBook;
import org.zkoss.zss.model.SCell;
import org.zkoss.zss.model.SSheet;
import org.zkoss.zss.model.sys.AbstractContext;
import org.zkoss.zss.model.sys.dependency.Ref;
import org.zkoss.zss.model.sys.formula.EvaluationContributor;
import org.zkoss.zss.model.sys.formula.EvaluationContributorContainer;

public class FormulaEvaluationContext
extends AbstractContext
implements Serializable {
    private static final long serialVersionUID = 2411072362379525686L;
    private final SBook _book;
    private final SSheet _sheet;
    private final SCell _cell;
    private FunctionMapper _functionMapper;
    private VariableResolver _vairableResolver;
    private final Ref _dependent;

    public FormulaEvaluationContext(SCell cell, Ref dependent) {
        this(cell.getSheet().getBook(), cell.getSheet(), cell, dependent);
    }

    public FormulaEvaluationContext(SSheet sheet, Ref dependent) {
        this(sheet.getBook(), sheet, null, dependent);
    }

    public FormulaEvaluationContext(SBook book, Ref dependent) {
        this(book, null, null, dependent);
    }

    private FormulaEvaluationContext(SBook book, SSheet sheet, SCell cell, Ref dependent) {
        EvaluationContributor contributor;
        this._book = book;
        this._sheet = sheet;
        this._cell = cell;
        this._dependent = dependent;
        EvaluationContributor evaluationContributor = contributor = book instanceof EvaluationContributorContainer ? ((EvaluationContributorContainer)((Object)book)).getEvaluationContributor() : null;
        if (contributor != null) {
            this._functionMapper = contributor.getFunctionMaper(book);
            this._vairableResolver = contributor.getVariableResolver(book);
        }
    }

    public SBook getBook() {
        return this._book;
    }

    public SSheet getSheet() {
        return this._sheet;
    }

    public SCell getCell() {
        return this._cell;
    }

    public Ref getDependent() {
        return this._dependent;
    }

    public FunctionMapper getFunctionMapper() {
        return this._functionMapper;
    }

    public VariableResolver getVariableResolver() {
        return this._vairableResolver;
    }
}

