/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.model.impl.chart;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.zkoss.zss.model.ErrorValue;
import org.zkoss.zss.model.SChart;
import org.zkoss.zss.model.chart.SGeneralChartData;
import org.zkoss.zss.model.chart.SSeries;
import org.zkoss.zss.model.impl.AbstractBookSeriesAdv;
import org.zkoss.zss.model.impl.AbstractChartAdv;
import org.zkoss.zss.model.impl.EvaluationUtil;
import org.zkoss.zss.model.impl.ObjectRefImpl;
import org.zkoss.zss.model.impl.chart.AbstractGeneralChartDataAdv;
import org.zkoss.zss.model.impl.chart.ChartUtil;
import org.zkoss.zss.model.impl.chart.SeriesImpl;
import org.zkoss.zss.model.sys.EngineFactory;
import org.zkoss.zss.model.sys.dependency.Ref;
import org.zkoss.zss.model.sys.formula.EvaluationResult;
import org.zkoss.zss.model.sys.formula.FormulaEngine;
import org.zkoss.zss.model.sys.formula.FormulaEvaluationContext;
import org.zkoss.zss.model.sys.formula.FormulaExpression;
import org.zkoss.zss.model.sys.formula.FormulaParseContext;

public class GeneralChartDataImpl
extends AbstractGeneralChartDataAdv
implements SGeneralChartData {
    private static final long serialVersionUID = 1L;
    private FormulaExpression _catFormulaExpr;
    private final List<SeriesImpl> _serieses = new LinkedList<SeriesImpl>();
    private AbstractChartAdv _chart;
    private final String _id;
    private Object _evalResult;
    private boolean _evaluated = false;
    private boolean _visibleEvaluated = false;
    private int _seriesCount = 0;
    private boolean[] _hiddenCategoriesInfo;

    public GeneralChartDataImpl(AbstractChartAdv chart, String id) {
        this._chart = chart;
        this._id = id;
    }

    public SChart getChart() {
        return this._chart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void evalFormula() {
        if (this._evaluated) {
            return;
        }
        GeneralChartDataImpl generalChartDataImpl = this;
        synchronized (generalChartDataImpl) {
            if (!this._evaluated) {
                if (this._catFormulaExpr != null) {
                    FormulaEngine fe = EngineFactory.getInstance().createFormulaEngine();
                    EvaluationResult result = fe.evaluate(this._catFormulaExpr, new FormulaEvaluationContext(this._chart.getSheet(), this.getRef()));
                    Object val = result.getValue();
                    if (result.getType() == EvaluationResult.ResultType.SUCCESS) {
                        this._evalResult = val;
                    } else if (result.getType() == EvaluationResult.ResultType.ERROR) {
                        this._evalResult = val instanceof ErrorValue ? val : ErrorValue.valueOf((byte)29);
                    }
                }
                this._evaluated = true;
            }
        }
    }

    public int getNumOfSeries() {
        return this._serieses.size();
    }

    public SSeries getSeries(int i) {
        return this._serieses.get(i);
    }

    public int getNumOfCategory() {
        this.evalFormula();
        return EvaluationUtil.sizeOf(this._evalResult);
    }

    public Object getCategory(int i) {
        this.evalFormula();
        if (i >= EvaluationUtil.sizeOf(this._evalResult)) {
            return String.valueOf(i + 1);
        }
        Object cat = EvaluationUtil.valueOf(this._evalResult, i);
        return cat == null || "".equals(cat) ? String.valueOf(i + 1) : cat;
    }

    public SSeries addSeries() {
        SeriesImpl series = new SeriesImpl(this._chart, this._chart.getId() + "-series" + this._seriesCount++);
        this._serieses.add(series);
        return series;
    }

    protected void checkOwnership(SSeries series) {
        if (!this._serieses.contains(series)) {
            throw new IllegalStateException("doesn't has ownership " + series);
        }
    }

    public void removeSeries(SSeries series) {
        this.checkOwnership(series);
        ((SeriesImpl)series).destroy();
        this._serieses.remove(series);
    }

    public void setCategoriesFormula(String expr) {
        this.checkOrphan();
        this._evaluated = false;
        this.clearFormulaDependency();
        if (expr != null && expr != "") {
            FormulaEngine fe = EngineFactory.getInstance().createFormulaEngine();
            this._catFormulaExpr = fe.parse(expr, new FormulaParseContext(this._chart.getSheet(), this.getRef()));
        } else {
            this._catFormulaExpr = null;
        }
    }

    public String getCategoriesFormula() {
        return this._catFormulaExpr == null ? null : this._catFormulaExpr.getFormulaString();
    }

    public void clearFormulaResultCache() {
        this._evalResult = null;
        this._evaluated = false;
        this._visibleEvaluated = false;
        for (SeriesImpl series : this._serieses) {
            series.clearFormulaResultCache();
        }
    }

    public boolean isFormulaParsingError() {
        return this._catFormulaExpr == null ? false : this._catFormulaExpr.hasError();
    }

    private void clearFormulaDependency() {
        if (this._catFormulaExpr != null) {
            ((AbstractBookSeriesAdv)this._chart.getSheet().getBook().getBookSeries()).getDependencyTable().clearDependents(this.getRef());
        }
    }

    private Ref getRef() {
        return new ObjectRefImpl(this._chart, new String[]{this._chart.getId(), this._id});
    }

    public void destroy() {
        this.checkOrphan();
        this.clearFormulaDependency();
        this.clearFormulaResultCache();
        for (SeriesImpl series : this._serieses) {
            series.destroy();
        }
        this._chart = null;
    }

    public void checkOrphan() {
        if (this._chart == null) {
            throw new IllegalStateException("doesn't connect to parent");
        }
    }

    public void copyFrom(GeneralChartDataImpl src) {
        String expr = this.getCategoriesFormula();
        if (expr != null) {
            this.setCategoriesFormula(expr);
        }
        for (SeriesImpl s : src._serieses) {
            this._serieses.add(s.cloneSeriesImpl(this._chart));
        }
        this._seriesCount = this._seriesCount;
    }

    public FormulaExpression getCategoriesFormulaExpression() {
        return this._catFormulaExpr;
    }

    public void setCategoriesFormula(FormulaExpression fexpr) {
        this.checkOrphan();
        this._evaluated = false;
        this.clearFormulaDependency();
        this._catFormulaExpr = fexpr;
        if (fexpr != null) {
            FormulaEngine fe = EngineFactory.getInstance().createFormulaEngine();
            fe.updateDependencyTable(fexpr, new FormulaParseContext(this._chart.getSheet(), this.getRef()));
        }
    }

    public boolean isCategoryHidden(int index) {
        this.evalVisibleInfo();
        return this._hiddenCategoriesInfo == null ? false : (this._hiddenCategoriesInfo.length < index + 1 ? false : this._hiddenCategoriesInfo[index]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evalVisibleInfo() {
        if (this._visibleEvaluated) {
            return;
        }
        GeneralChartDataImpl generalChartDataImpl = this;
        synchronized (generalChartDataImpl) {
            if (!this._visibleEvaluated) {
                HashMap<Integer, Boolean> cachedRowValues = new HashMap<Integer, Boolean>(16);
                HashMap<Integer, Boolean> cachedColumnValues = new HashMap<Integer, Boolean>(16);
                this._hiddenCategoriesInfo = new boolean[this.getNumOfCategory()];
                ChartUtil.evalVisibleInfo(this._chart, this._catFormulaExpr, this._hiddenCategoriesInfo, cachedRowValues, cachedColumnValues);
                this._visibleEvaluated = true;
            }
        }
    }
}

