/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.model.impl;

import org.zkoss.zss.model.SPicture;
import org.zkoss.zss.model.SPictureData;
import org.zkoss.zss.model.SSheet;
import org.zkoss.zss.model.ViewAnchor;
import org.zkoss.zss.model.impl.AbstractPictureAdv;
import org.zkoss.zss.model.impl.AbstractSheetAdv;

public class PictureImpl
extends AbstractPictureAdv {
    private static final long serialVersionUID = -8176040020483451498L;
    private String _id;
    private SPictureData _picData;
    private ViewAnchor _anchor;
    private AbstractSheetAdv _sheet;

    public PictureImpl(AbstractSheetAdv sheet, String id, SPicture.Format format, byte[] data, ViewAnchor anchor) {
        this._sheet = sheet;
        this._id = id;
        this._anchor = anchor;
        this._picData = this._sheet.getBook().addPictureData(format, data);
    }

    public PictureImpl(AbstractSheetAdv sheet, String id, int picDataIndex, ViewAnchor anchor) {
        this._sheet = sheet;
        this._id = id;
        this._anchor = anchor;
        SPictureData picData = sheet.getBook().getPictureData(picDataIndex);
        if (picData == null) {
            throw new IllegalStateException("Inexisting picture data index: " + picDataIndex);
        }
        this._picData = picData;
    }

    public SSheet getSheet() {
        this.checkOrphan();
        return this._sheet;
    }

    public String getId() {
        return this._id;
    }

    public SPicture.Format getFormat() {
        return this._picData.getFormat();
    }

    public ViewAnchor getAnchor() {
        return this._anchor;
    }

    public void setAnchor(ViewAnchor anchor) {
        this._anchor = anchor;
    }

    public byte[] getData() {
        return this._picData.getData();
    }

    public void destroy() {
        this.checkOrphan();
        this._sheet = null;
    }

    public void checkOrphan() {
        if (this._sheet == null) {
            throw new IllegalStateException("doesn't connect to parent");
        }
    }

    public SPictureData getPictureData() {
        return this._picData;
    }

    PictureImpl clonePictureImpl(AbstractSheetAdv sheet) {
        return new PictureImpl(sheet, this._id, this._picData.getIndex(), this._anchor.cloneViewAnchor());
    }
}

