/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.model.impl;

import java.util.Set;
import org.zkoss.zss.model.CellRegion;
import org.zkoss.zss.model.SBookSeries;
import org.zkoss.zss.model.SCell;
import org.zkoss.zss.model.SSheet;
import org.zkoss.zss.model.STable;
import org.zkoss.zss.model.impl.AbstractBookSeriesAdv;
import org.zkoss.zss.model.impl.CellAttribute;
import org.zkoss.zss.model.impl.FormulaCacheCleaner;
import org.zkoss.zss.model.impl.FormulaCacheClearHelper;
import org.zkoss.zss.model.sys.dependency.DependencyTable;
import org.zkoss.zss.model.sys.dependency.Ref;
import org.zkoss.zss.range.impl.ModelUpdateCollector;

class ModelUpdateUtil {
    ModelUpdateUtil() {
    }

    static void handlePrecedentUpdate(SBookSeries bookSeries, Ref precedent) {
        ModelUpdateUtil.handlePrecedentUpdate(bookSeries, precedent, true);
    }

    static void handlePrecedentUpdate(SBookSeries bookSeries, Ref precedent, boolean includePrecedent) {
        FormulaCacheCleaner clearer = FormulaCacheCleaner.getCurrent();
        ModelUpdateCollector collector = ModelUpdateCollector.getCurrent();
        Set<Ref> dependents = null;
        if (collector != null || clearer != null || bookSeries.isAutoFormulaCacheClean()) {
            DependencyTable table = ((AbstractBookSeriesAdv)bookSeries).getDependencyTable();
            dependents = table.getEvaluatedDependents(precedent);
        }
        if (includePrecedent) {
            ModelUpdateUtil.addRefUpdate(precedent);
        }
        if (dependents != null && dependents.size() > 0) {
            if (clearer != null) {
                clearer.clear(dependents);
            } else if (bookSeries.isAutoFormulaCacheClean()) {
                new FormulaCacheClearHelper(bookSeries).clear(dependents);
            }
            if (collector != null) {
                collector.addRefs(dependents);
            }
        }
    }

    static void addRefUpdate(Ref ref) {
        ModelUpdateCollector collector = ModelUpdateCollector.getCurrent();
        if (collector != null) {
            collector.addRef(ref);
        }
    }

    @Deprecated
    static void addCellUpdate(SSheet sheet, SCell cell) {
        ModelUpdateUtil.addCellUpdate(sheet, cell, CellAttribute.ALL);
    }

    static void addCellUpdate(SSheet sheet, SCell cell, CellAttribute cellAttr) {
        ModelUpdateUtil.addCellUpdate(sheet, cell.getRowIndex(), cell.getColumnIndex(), cellAttr);
    }

    @Deprecated
    static void addCellUpdate(SSheet sheet, int row, int column) {
        ModelUpdateUtil.addCellUpdate(sheet, row, column, CellAttribute.ALL);
    }

    static void addCellUpdate(SSheet sheet, int row, int column, CellAttribute cellAttr) {
        ModelUpdateUtil.addCellUpdate(sheet, row, column, row, column, cellAttr);
    }

    @Deprecated
    static void addCellUpdate(SSheet sheet, int row, int column, int lastRow, int lastColumn) {
        ModelUpdateUtil.addCellUpdate(sheet, row, column, lastRow, lastColumn, CellAttribute.ALL);
    }

    static void addCellUpdate(SSheet sheet, int row, int column, int lastRow, int lastColumn, CellAttribute cellAttr) {
        ModelUpdateCollector collector = ModelUpdateCollector.getCurrent();
        if (collector != null) {
            collector.addCellUpdate(sheet, row, column, lastRow, lastColumn, cellAttr);
        }
    }

    static void addMergeUpdate(SSheet sheet, CellRegion original, CellRegion changeTo) {
        ModelUpdateCollector collector = ModelUpdateCollector.getCurrent();
        if (collector != null) {
            collector.addMergeChange(sheet, original, changeTo);
        }
    }

    static void addInsertDeleteUpdate(SSheet sheet, boolean inserted, boolean isRow, int index, int lastIndex) {
        ModelUpdateCollector collector = ModelUpdateCollector.getCurrent();
        if (collector != null) {
            collector.addInsertDeleteUpdate(sheet, inserted, isRow, index, lastIndex);
        }
    }

    static void addAutoFilterUpdate(SSheet sheet, STable table) {
        ModelUpdateCollector collector = ModelUpdateCollector.getCurrent();
        if (collector != null) {
            collector.addAutoFilterUpdate(sheet, table);
        }
    }
}

