/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.model.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class IndexPool<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private TreeMap<Integer, T> _objs = new TreeMap();

    IndexPool() {
    }

    public T get(int idx) {
        return this._objs.get(idx);
    }

    public T put(int idx, T obj) {
        T old = this._objs.put(idx, obj);
        return old;
    }

    public int firstKey() {
        return this._objs.size() <= 0 ? -1 : this._objs.firstKey();
    }

    public int lastKey() {
        return this._objs.size() <= 0 ? -1 : this._objs.lastKey();
    }

    public Collection<T> clear(int start, int end) {
        NavigableMap<Integer, T> effected = this._objs.subMap(start, true, end, true);
        LinkedList remove = new LinkedList();
        Iterator iter = effected.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Object obj = entry.getValue();
            remove.add(obj);
            iter.remove();
        }
        return remove;
    }

    public void insert(int start, int size) {
        if (size <= 0) {
            return;
        }
        NavigableMap<Integer, T> effected = this._objs.descendingMap().headMap(start, true);
        for (Map.Entry entry : new ArrayList(effected.entrySet())) {
            int idx = (Integer)entry.getKey();
            int newidx = idx + size;
            Object obj = entry.getValue();
            this._objs.remove(idx);
            this.resetIndex(newidx, obj);
            this._objs.put(newidx, obj);
        }
    }

    abstract void resetIndex(int var1, T var2);

    public Collection<T> delete(int start, int size) {
        if (size <= 0) {
            return Collections.EMPTY_LIST;
        }
        NavigableMap<Integer, T> effected = this._objs.tailMap(start, true);
        LinkedList remove = new LinkedList();
        for (Map.Entry entry : new ArrayList(effected.entrySet())) {
            int idx = (Integer)entry.getKey();
            int newidx = idx - size;
            Object obj = entry.getValue();
            this._objs.remove(idx);
            if (newidx >= start) {
                this.resetIndex(newidx, obj);
                this._objs.put(newidx, obj);
                continue;
            }
            remove.add(obj);
        }
        return remove;
    }

    public Collection<T> trim(int start) {
        NavigableMap<Integer, T> effected = this._objs.tailMap(start, true);
        LinkedList remove = new LinkedList();
        for (Map.Entry entry : new ArrayList(effected.entrySet())) {
            int idx = (Integer)entry.getKey();
            this._objs.remove(idx);
            remove.add(entry.getValue());
        }
        return remove;
    }

    public Set<Integer> keySet() {
        return this._objs.keySet();
    }

    public Collection<T> values() {
        return this._objs.values();
    }

    public Collection<T> descendingValues() {
        return this._objs.descendingMap().values();
    }

    public Collection<T> subValues(int start, int end) {
        return this._objs.subMap(start, true, end, true).values();
    }

    public Collection<T> descendingSubValues(int start, int end) {
        return this._objs.subMap(start, true, end, true).descendingMap().values();
    }

    public void clear() {
        this._objs.clear();
    }
}

