/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.model.impl;

import org.zkoss.zss.model.SColor;
import org.zkoss.zss.model.SFont;
import org.zkoss.zss.model.impl.AbstractFontAdv;
import org.zkoss.zss.model.impl.ColorImpl;
import org.zkoss.zss.model.util.Validations;

public class FontImpl
extends AbstractFontAdv {
    private static final long serialVersionUID = 1L;
    public static final String FORMAT_GENERAL = "General";
    private String _fontName = "Calibri";
    private int _fontHeightPoint = 11;
    private SColor _fontColor = ColorImpl.BLACK;
    private SFont.Boldweight _fontBoldweight = SFont.Boldweight.NORMAL;
    private boolean _fontItalic = false;
    private boolean _fontStrikeout = false;
    private SFont.TypeOffset _fontTypeOffset = SFont.TypeOffset.NONE;
    private SFont.Underline _fontUnderline = SFont.Underline.NONE;
    private boolean overrideName;
    private boolean overrideColor;
    private boolean overrideBold;
    private boolean overrideItalic;
    private boolean overrideStrikeout;
    private boolean overrideUnderline;
    private boolean overrideHeightPoints;
    private boolean overrideTypeOffset;

    public FontImpl() {
    }

    public FontImpl(String fontColor, boolean bold, boolean fontItalic, boolean fontStrikeout, SFont.Underline fontUnderline) {
        this._fontColor = fontColor != null ? new ColorImpl(fontColor) : ColorImpl.BLACK;
        this._fontBoldweight = bold ? SFont.Boldweight.BOLD : SFont.Boldweight.NORMAL;
        this._fontItalic = fontItalic;
        this._fontStrikeout = fontStrikeout;
        this._fontUnderline = fontUnderline;
    }

    public String getName() {
        return this._fontName;
    }

    public void setName(String fontName) {
        this._fontName = fontName;
    }

    public SColor getColor() {
        return this._fontColor;
    }

    public void setColor(SColor fontColor) {
        Validations.argNotNull(fontColor);
        this._fontColor = fontColor;
    }

    public SFont.Boldweight getBoldweight() {
        return this._fontBoldweight;
    }

    public void setBoldweight(SFont.Boldweight fontBoldweight) {
        Validations.argNotNull(new Object[]{fontBoldweight});
        this._fontBoldweight = fontBoldweight;
    }

    public int getHeightPoints() {
        return this._fontHeightPoint < 0 ? 11 : this._fontHeightPoint;
    }

    public void setHeightPoints(int fontHeightPoint) {
        this._fontHeightPoint = fontHeightPoint;
    }

    public boolean isItalic() {
        return this._fontItalic;
    }

    public void setItalic(boolean fontItalic) {
        this._fontItalic = fontItalic;
    }

    public boolean isStrikeout() {
        return this._fontStrikeout;
    }

    public void setStrikeout(boolean fontStrikeout) {
        this._fontStrikeout = fontStrikeout;
    }

    public SFont.TypeOffset getTypeOffset() {
        return this._fontTypeOffset;
    }

    public void setTypeOffset(SFont.TypeOffset fontTypeOffset) {
        Validations.argNotNull(new Object[]{fontTypeOffset});
        this._fontTypeOffset = fontTypeOffset;
    }

    public SFont.Underline getUnderline() {
        return this._fontUnderline;
    }

    public void setUnderline(SFont.Underline fontUnderline) {
        Validations.argNotNull(new Object[]{fontUnderline});
        this._fontUnderline = fontUnderline;
    }

    public void copyFrom(SFont src) {
        if (src == this) {
            return;
        }
        Validations.argInstance(src, FontImpl.class);
        this.setName(src.getName());
        this.setColor(src.getColor());
        this.setBoldweight(src.getBoldweight());
        this.setHeightPoints(src.getHeightPoints());
        this.setItalic(src.isItalic());
        this.setStrikeout(src.isStrikeout());
        this.setTypeOffset(src.getTypeOffset());
        this.setUnderline(src.getUnderline());
    }

    String getStyleKey() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._fontName).append(".").append(this._fontColor.getHtmlColor()).append(".").append(this._fontBoldweight.ordinal()).append(".").append(this._fontHeightPoint).append(".").append(this._fontItalic ? "T" : "F").append(".").append(this._fontStrikeout ? "T" : "F").append(".").append(this._fontTypeOffset.ordinal()).append(".").append(this._fontUnderline.ordinal());
        return sb.toString();
    }

    public int hashCode() {
        return this.getStyleKey().hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof FontImpl)) {
            return false;
        }
        FontImpl o = (FontImpl)other;
        return this.getStyleKey().equals(o.getStyleKey());
    }

    public void setOverrideName(boolean overrideName) {
        this.overrideName = overrideName;
    }

    public void setOverrideColor(boolean overrideColor) {
        this.overrideColor = overrideColor;
    }

    public void setOverrideBold(boolean overrideBold) {
        this.overrideBold = overrideBold;
    }

    public void setOverrideItalic(boolean overrideItalic) {
        this.overrideItalic = overrideItalic;
    }

    public void setOverrideStrikeout(boolean overrideStrikeout) {
        this.overrideStrikeout = overrideStrikeout;
    }

    public void setOverrideUnderline(boolean overrideUnderline) {
        this.overrideUnderline = overrideUnderline;
    }

    public void setOverrideHeightPoints(boolean overrideHeightPoints) {
        this.overrideHeightPoints = overrideHeightPoints;
    }

    public void setOverrideTypeOffset(boolean overrideTypeOffset) {
        this.overrideTypeOffset = overrideTypeOffset;
    }

    public boolean isOverrideName() {
        return this.overrideName;
    }

    public boolean isOverrideColor() {
        return this.overrideColor;
    }

    public boolean isOverrideBold() {
        return this.overrideBold;
    }

    public boolean isOverrideItalic() {
        return this.overrideItalic;
    }

    public boolean isOverrideStrikeout() {
        return this.overrideStrikeout;
    }

    public boolean isOverrideUnderline() {
        return this.overrideUnderline;
    }

    public boolean isOverrideHeightPoints() {
        return this.overrideHeightPoints;
    }

    public boolean isOverrideTypeOffset() {
        return this.overrideTypeOffset;
    }
}

