/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.model.impl;

import java.lang.ref.WeakReference;
import org.zkoss.zss.model.SCellStyle;
import org.zkoss.zss.model.SColumn;
import org.zkoss.zss.model.SSheet;
import org.zkoss.zss.model.impl.AbstractColumnArrayAdv;
import org.zkoss.zss.model.impl.AbstractSheetAdv;

class ColumnProxy
implements SColumn {
    private static final long serialVersionUID = 1L;
    private final WeakReference<AbstractSheetAdv> _sheetRef;
    private final int _index;
    private AbstractColumnArrayAdv _proxy;

    public ColumnProxy(AbstractSheetAdv sheet, int index) {
        this._sheetRef = new WeakReference<AbstractSheetAdv>(sheet);
        this._index = index;
    }

    protected void loadProxy(boolean split) {
        if (split) {
            this._proxy = ((AbstractSheetAdv)this.getSheet()).getOrSplitColumnArray(this._index);
        } else if (this._proxy == null) {
            this._proxy = (AbstractColumnArrayAdv)((AbstractSheetAdv)this.getSheet()).getColumnArray(this._index);
        }
    }

    public SSheet getSheet() {
        AbstractSheetAdv sheet = (AbstractSheetAdv)this._sheetRef.get();
        if (sheet == null) {
            throw new IllegalStateException("proxy target lost, you should't keep this instance");
        }
        return sheet;
    }

    public int getIndex() {
        return this._index;
    }

    public boolean isNull() {
        this.loadProxy(false);
        return this._proxy == null;
    }

    public SCellStyle getCellStyle() {
        this.loadProxy(false);
        if (this._proxy != null) {
            return this._proxy.getCellStyle();
        }
        return this.getSheet().getBook().getDefaultCellStyle();
    }

    public SCellStyle getCellStyle(boolean local) {
        this.loadProxy(false);
        if (this._proxy != null) {
            return this._proxy.getCellStyle(local);
        }
        return local ? null : this.getSheet().getBook().getDefaultCellStyle();
    }

    public void setCellStyle(SCellStyle cellStyle) {
        this.loadProxy(true);
        this._proxy.setCellStyle(cellStyle);
    }

    public int getWidth() {
        this.loadProxy(false);
        if (this._proxy != null) {
            return this._proxy.getWidth();
        }
        return this.getSheet().getDefaultColumnWidth();
    }

    public boolean isHidden() {
        this.loadProxy(false);
        if (this._proxy != null) {
            return this._proxy.isHidden();
        }
        return false;
    }

    public void setWidth(int width) {
        this.loadProxy(true);
        this._proxy.setWidth(width);
    }

    public void setHidden(boolean hidden) {
        this.loadProxy(true);
        this._proxy.setHidden(hidden);
    }

    public boolean isCustomWidth() {
        this.loadProxy(false);
        if (this._proxy != null) {
            return this._proxy.isCustomWidth();
        }
        return false;
    }

    public void setCustomWidth(boolean custom) {
        this.loadProxy(true);
        this._proxy.setCustomWidth(custom);
    }
}

