/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.model.impl;

import java.lang.ref.WeakReference;
import java.util.Locale;
import org.zkoss.poi.ss.formula.eval.ValueEval;
import org.zkoss.zss.model.CellRegion;
import org.zkoss.zss.model.SCell;
import org.zkoss.zss.model.SCellStyle;
import org.zkoss.zss.model.SComment;
import org.zkoss.zss.model.SHyperlink;
import org.zkoss.zss.model.SSheet;
import org.zkoss.zss.model.impl.AbstractCellAdv;
import org.zkoss.zss.model.impl.AbstractColumnArrayAdv;
import org.zkoss.zss.model.impl.AbstractRowAdv;
import org.zkoss.zss.model.impl.AbstractSheetAdv;
import org.zkoss.zss.model.impl.RefImpl;
import org.zkoss.zss.model.sys.dependency.Ref;
import org.zkoss.zss.model.sys.formula.FormulaExpression;

class CellProxy
extends AbstractCellAdv {
    private static final long serialVersionUID = 1L;
    private WeakReference<AbstractSheetAdv> _sheetRef;
    private int _rowIdx;
    private int _columnIdx;
    AbstractCellAdv _proxy;

    public CellProxy(AbstractSheetAdv sheet, int row, int column) {
        this._sheetRef = new WeakReference<AbstractSheetAdv>(sheet);
        this._rowIdx = row;
        this._columnIdx = column;
    }

    public SSheet getSheet() {
        if (this._proxy != null) {
            return this._proxy.getSheet();
        }
        AbstractSheetAdv sheet = (AbstractSheetAdv)this._sheetRef.get();
        if (sheet == null) {
            throw new IllegalStateException("proxy sheet target lost, you should't keep this instance");
        }
        return sheet;
    }

    private void loadProxy() {
        if (this._proxy == null) {
            this._proxy = ((AbstractSheetAdv)this.getSheet()).getCell(this._rowIdx, this._columnIdx, false);
        }
    }

    public boolean isNull() {
        this.loadProxy();
        if (this._proxy == null) {
            return true;
        }
        return this._proxy.isNull();
    }

    public SCell.CellType getType() {
        this.loadProxy();
        if (this._proxy == null) {
            return SCell.CellType.BLANK;
        }
        return this._proxy.getType();
    }

    public int getRowIndex() {
        this.loadProxy();
        return this._proxy == null ? this._rowIdx : this._proxy.getRowIndex();
    }

    public int getColumnIndex() {
        this.loadProxy();
        return this._proxy == null ? this._columnIdx : this._proxy.getColumnIndex();
    }

    public void setFormulaValue(String formula) {
        this.loadProxy();
        if (this._proxy == null) {
            this._proxy = ((AbstractSheetAdv)this.getSheet()).getOrCreateRow(this._rowIdx).getOrCreateCell(this._columnIdx);
            this._proxy.setFormulaValue(formula);
        } else if (this._proxy != null) {
            this._proxy.setFormulaValue(formula);
        }
    }

    public void setFormulaValue(String formula, Locale locale) {
        this.loadProxy();
        if (this._proxy == null) {
            this._proxy = ((AbstractSheetAdv)this.getSheet()).getOrCreateRow(this._rowIdx).getOrCreateCell(this._columnIdx);
            this._proxy.setFormulaValue(formula, locale);
        } else if (this._proxy != null) {
            this._proxy.setFormulaValue(formula, locale);
        }
    }

    public void setValue(Object value) {
        this.loadProxy();
        if (this._proxy == null && value != null) {
            this._proxy = ((AbstractSheetAdv)this.getSheet()).getOrCreateRow(this._rowIdx).getOrCreateCell(this._columnIdx);
            this._proxy.setValue(value);
        } else if (this._proxy != null) {
            this._proxy.setValue(value);
        }
    }

    protected void setValue(Object value, boolean aString) {
        this.loadProxy();
        if (this._proxy == null && value != null) {
            this._proxy = ((AbstractSheetAdv)this.getSheet()).getOrCreateRow(this._rowIdx).getOrCreateCell(this._columnIdx);
            this._proxy.setValue(value, aString);
        } else if (this._proxy != null) {
            this._proxy.setValue(value, aString);
        }
    }

    public Object getValue() {
        this.loadProxy();
        if (this._proxy == null) {
            return null;
        }
        return this._proxy.getValue();
    }

    public String getReferenceString() {
        this.loadProxy();
        return this._proxy == null ? new CellRegion(this._rowIdx, this._columnIdx).getReferenceString() : this._proxy.getReferenceString();
    }

    public SCellStyle getCellStyle() {
        return this.getCellStyle(false);
    }

    public SCellStyle getCellStyle(boolean local) {
        AbstractColumnArrayAdv carr;
        this.loadProxy();
        if (this._proxy != null) {
            return this._proxy.getCellStyle(local);
        }
        if (local) {
            return null;
        }
        AbstractSheetAdv sheet = (AbstractSheetAdv)this.getSheet();
        AbstractRowAdv row = sheet.getRow(this._rowIdx, false);
        SCellStyle style = null;
        if (row != null) {
            style = row.getCellStyle(true);
        }
        if (style == null && (carr = (AbstractColumnArrayAdv)sheet.getColumnArray(this._columnIdx)) != null) {
            style = carr.getCellStyle(true);
        }
        if (style == null) {
            style = sheet.getBook().getDefaultCellStyle();
        }
        return style;
    }

    public void setCellStyle(SCellStyle cellStyle) {
        this.loadProxy();
        if (this._proxy == null) {
            this._proxy = ((AbstractSheetAdv)this.getSheet()).getOrCreateRow(this._rowIdx).getOrCreateCell(this._columnIdx);
        }
        this._proxy.setCellStyle(cellStyle);
    }

    public SCell.CellType getFormulaResultType() {
        this.loadProxy();
        return this._proxy == null ? null : this._proxy.getFormulaResultType();
    }

    public void clearValue() {
        this.loadProxy();
        if (this._proxy != null) {
            this._proxy.clearValue();
        }
    }

    public void clearFormulaResultCache() {
        this.loadProxy();
        if (this._proxy != null) {
            this._proxy.clearFormulaResultCache();
        }
    }

    protected void evalFormula() {
        this.loadProxy();
        if (this._proxy != null) {
            this._proxy.evalFormula();
        }
    }

    protected Object getValue(boolean eval) {
        this.loadProxy();
        return this._proxy == null ? null : this._proxy.getValue(eval);
    }

    public void destroy() {
        throw new IllegalStateException("never link proxy object and call it's release");
    }

    public void checkOrphan() {
    }

    public SHyperlink getHyperlink() {
        this.loadProxy();
        return this._proxy == null ? null : this._proxy.getHyperlink();
    }

    public void setHyperlink(SHyperlink hyperlink) {
        this.loadProxy();
        if (this._proxy == null) {
            this._proxy = ((AbstractSheetAdv)this.getSheet()).getOrCreateRow(this._rowIdx).getOrCreateCell(this._columnIdx);
        }
        this._proxy.setHyperlink(hyperlink);
    }

    public SComment getComment() {
        this.loadProxy();
        return this._proxy == null ? null : this._proxy.getComment();
    }

    public void setComment(SComment comment) {
        this.loadProxy();
        if (this._proxy == null) {
            this._proxy = ((AbstractSheetAdv)this.getSheet()).getOrCreateRow(this._rowIdx).getOrCreateCell(this._columnIdx);
        }
        this._proxy.setComment(comment);
    }

    public boolean isFormulaParsingError() {
        this.loadProxy();
        return this._proxy == null ? false : this._proxy.isFormulaParsingError();
    }

    void setIndex(int newidx) {
        throw new UnsupportedOperationException("readonly");
    }

    void setRow(int oldRowIdx, AbstractRowAdv row) {
        throw new UnsupportedOperationException("readonly");
    }

    protected Ref getRef() {
        return new RefImpl(this);
    }

    AbstractCellAdv cloneCell(AbstractRowAdv row) {
        if (this._proxy == null) {
            return new CellProxy((AbstractSheetAdv)row.getSheet(), row.getIndex(), this.getColumnIndex());
        }
        return this._proxy.cloneCell(row);
    }

    public void setFormulaResultValue(ValueEval value) {
        this.loadProxy();
        if (this._proxy != null) {
            this._proxy.setFormulaResultValue(value);
        }
    }

    public void deleteComment() {
        this.loadProxy();
        if (this._proxy != null) {
            this._proxy.deleteComment();
        }
    }

    public FormulaExpression getFormulaExpression() {
        this.loadProxy();
        if (this._proxy != null) {
            return this._proxy.getFormulaExpression();
        }
        return null;
    }

    public void setTextHeight(int height) {
        this.loadProxy();
        if (this._proxy != null) {
            this._proxy.setTextHeight(height);
        }
    }

    public int getTextHeight() {
        this.loadProxy();
        if (this._proxy != null) {
            return this._proxy.getTextHeight();
        }
        return this.getSheet().getDefaultRowHeight();
    }

    public boolean isCalcAutoHeight() {
        this.loadProxy();
        if (this._proxy != null) {
            return this._proxy.isCalcAutoHeight();
        }
        return false;
    }

    public void setCalcAutoHeight(boolean b) {
        this.loadProxy();
        if (this._proxy != null) {
            this._proxy.setCalcAutoHeight(b);
        }
    }

    public void setTextWidth(int width) {
        this.loadProxy();
        if (this._proxy != null) {
            this._proxy.setTextWidth(width);
        }
    }

    public int getTextWidth() {
        this.loadProxy();
        if (this._proxy != null) {
            return this._proxy.getTextWidth();
        }
        return -1;
    }
}

