/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.model.impl;

import java.io.Serializable;
import org.zkoss.poi.ss.formula.FormulaRenderer;
import org.zkoss.poi.ss.formula.FormulaRenderingWorkbook;
import org.zkoss.poi.ss.formula.ptg.Ptg;
import org.zkoss.zss.model.SCell;
import org.zkoss.zss.model.SCellStyle;
import org.zkoss.zss.model.SComment;
import org.zkoss.zss.model.SDataValidation;
import org.zkoss.zss.model.SHyperlink;
import org.zkoss.zss.model.impl.AbstractCellAdv;
import org.zkoss.zss.model.impl.AbstractCommentAdv;
import org.zkoss.zss.model.impl.AbstractHyperlinkAdv;
import org.zkoss.zss.model.impl.sys.formula.ParsingBook;
import org.zkoss.zss.range.impl.StyleUtil;

public class CellBuffer
implements Serializable {
    private static final long serialVersionUID = -364582164612926619L;
    private boolean _null = true;
    private SCell.CellType _type;
    private Object _value;
    private String _formula;
    private SCellStyle _style;
    private SComment _comment;
    private SDataValidation _validation;
    private SHyperlink _hyperlink;

    public boolean isNull() {
        return this._null;
    }

    public void setNull(boolean isNull) {
        this._null = isNull;
    }

    public SCell.CellType getType() {
        return this._type;
    }

    public void setType(SCell.CellType type) {
        this._type = type;
    }

    public Object getValue() {
        return this._value;
    }

    public void setValue(Object value) {
        this._value = value;
    }

    public String getFormula() {
        return this._formula;
    }

    public void setFormula(String formula) {
        this._formula = formula;
    }

    public SCellStyle getStyle() {
        return this._style;
    }

    public void setStyle(SCellStyle style) {
        this._style = style;
    }

    public SComment getComment() {
        return this._comment;
    }

    public void setComment(SComment comment) {
        this._comment = comment;
    }

    public SDataValidation getValidation() {
        return this._validation;
    }

    public void setValidation(SDataValidation validation) {
        this._validation = validation;
    }

    public SHyperlink getHyperlink() {
        return this._hyperlink;
    }

    public void setHyperlink(SHyperlink hyperlink) {
        this._hyperlink = hyperlink;
    }

    public static CellBuffer bufferAll(SCell cell) {
        CellBuffer buffer = new CellBuffer();
        if (!cell.isNull()) {
            buffer.setNull(false);
            buffer.setType(cell.getType());
            if (cell.getType() == SCell.CellType.FORMULA) {
                String formula = cell.getFormulaValue();
                ParsingBook parsingBook = new ParsingBook(cell.getSheet().getBook());
                Ptg[] tokens = ((AbstractCellAdv)cell).getFormulaExpression().getPtgs();
                String result = FormulaRenderer.toFormulaCopyText((FormulaRenderingWorkbook)parsingBook, (Ptg[])tokens, (String)formula);
                buffer.setFormula(result);
            } else {
                buffer.setValue(cell.getValue());
            }
            buffer.setStyle(StyleUtil.prepareStyle(cell));
            buffer.setHyperlink(cell.getHyperlink());
            buffer.setComment(cell.getComment());
            buffer.setValidation(cell.getSheet().getDataValidation(cell.getRowIndex(), cell.getColumnIndex()));
        }
        return buffer;
    }

    public void applyStyle(SCell destCell) {
        destCell.setCellStyle(this.getStyle());
    }

    public void applyValue(SCell destCell) {
        if (this.getType() == SCell.CellType.FORMULA) {
            destCell.setFormulaValue(this.getFormula());
        } else {
            destCell.setValue(this.getValue());
        }
    }

    public void applyComment(SCell destCell) {
        SComment comment = this.getComment();
        destCell.setComment(comment == null ? null : ((AbstractCommentAdv)comment).clone());
    }

    public void applyHyperlink(SCell destCell) {
        SHyperlink link = this.getHyperlink();
        destCell.setHyperlink(link == null ? null : ((AbstractHyperlinkAdv)link).clone());
    }
}

