/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.zkoss.lang.Objects;
import org.zkoss.poi.ss.SpreadsheetVersion;
import org.zkoss.util.logging.Log;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zss.model.EventQueueModelEventListener;
import org.zkoss.zss.model.InvalidModelOpException;
import org.zkoss.zss.model.ModelEvent;
import org.zkoss.zss.model.ModelEventListener;
import org.zkoss.zss.model.ModelEvents;
import org.zkoss.zss.model.SBookSeries;
import org.zkoss.zss.model.SCell;
import org.zkoss.zss.model.SCellStyle;
import org.zkoss.zss.model.SColor;
import org.zkoss.zss.model.SColumnArray;
import org.zkoss.zss.model.SExtraStyle;
import org.zkoss.zss.model.SFont;
import org.zkoss.zss.model.SName;
import org.zkoss.zss.model.SNamedStyle;
import org.zkoss.zss.model.SPicture;
import org.zkoss.zss.model.SPictureData;
import org.zkoss.zss.model.SRow;
import org.zkoss.zss.model.SSheet;
import org.zkoss.zss.model.STable;
import org.zkoss.zss.model.STableColumn;
import org.zkoss.zss.model.STableStyle;
import org.zkoss.zss.model.SheetRegion;
import org.zkoss.zss.model.impl.AbstractBookAdv;
import org.zkoss.zss.model.impl.AbstractBookSeriesAdv;
import org.zkoss.zss.model.impl.AbstractCellStyleAdv;
import org.zkoss.zss.model.impl.AbstractColorAdv;
import org.zkoss.zss.model.impl.AbstractFontAdv;
import org.zkoss.zss.model.impl.AbstractNameAdv;
import org.zkoss.zss.model.impl.AbstractSheetAdv;
import org.zkoss.zss.model.impl.AbstractTableAdv;
import org.zkoss.zss.model.impl.CellStyleImpl;
import org.zkoss.zss.model.impl.ColorImpl;
import org.zkoss.zss.model.impl.ColumnPrecedentRefImpl;
import org.zkoss.zss.model.impl.DirectEventListenerAdaptor;
import org.zkoss.zss.model.impl.EventListenerAdaptor;
import org.zkoss.zss.model.impl.EventQueueListenerAdaptor;
import org.zkoss.zss.model.impl.FontImpl;
import org.zkoss.zss.model.impl.FormulaTunerHelper;
import org.zkoss.zss.model.impl.ModelUpdateUtil;
import org.zkoss.zss.model.impl.NameImpl;
import org.zkoss.zss.model.impl.NameRefImpl;
import org.zkoss.zss.model.impl.PictureDataImpl;
import org.zkoss.zss.model.impl.RefImpl;
import org.zkoss.zss.model.impl.SheetImpl;
import org.zkoss.zss.model.impl.SimpleBookSeriesImpl;
import org.zkoss.zss.model.impl.TableNameImpl;
import org.zkoss.zss.model.impl.TablePrecedentRefImpl;
import org.zkoss.zss.model.impl.sys.DependencyTableAdv;
import org.zkoss.zss.model.impl.sys.formula.ParsingBook;
import org.zkoss.zss.model.sys.EngineFactory;
import org.zkoss.zss.model.sys.dependency.DependencyTable;
import org.zkoss.zss.model.sys.dependency.Ref;
import org.zkoss.zss.model.sys.formula.EvaluationContributor;
import org.zkoss.zss.model.sys.formula.FormulaClearContext;
import org.zkoss.zss.model.util.CellStyleMatcher;
import org.zkoss.zss.model.util.FontMatcher;
import org.zkoss.zss.model.util.Strings;
import org.zkoss.zss.model.util.Validations;
import org.zkoss.zss.range.impl.NotifyChangeHelper;
import org.zkoss.zss.range.impl.StyleUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BookImpl
extends AbstractBookAdv {
    private static final long serialVersionUID = 1L;
    private static final Log _logger = Log.lookup(BookImpl.class);
    private static final String SYNC_MERGE_FIRED = "_ZSS_MER";
    private final String _bookName;
    private String _shareScope;
    private SBookSeries _bookSeries;
    private final List<AbstractSheetAdv> _sheets = new ArrayList<AbstractSheetAdv>();
    private List<AbstractNameAdv> _names;
    private final List<SCellStyle> _cellStyles = new ArrayList<SCellStyle>();
    private final Map<String, SNamedStyle> _namedStyles = new HashMap<String, SNamedStyle>();
    private final List<SCellStyle> _defaultCellStyles = new ArrayList<SCellStyle>();
    private final List<AbstractFontAdv> _fonts = new ArrayList<AbstractFontAdv>();
    private AbstractFontAdv _defaultFont;
    private final HashMap<AbstractColorAdv, AbstractColorAdv> _colors = new LinkedHashMap<AbstractColorAdv, AbstractColorAdv>();
    private static final Random _random = new Random(System.currentTimeMillis());
    private static final AtomicInteger _bookCount = new AtomicInteger();
    private final String _bookId;
    private final HashMap<String, AtomicInteger> _objIdCounter = new HashMap();
    private final int _maxRowSize = SpreadsheetVersion.EXCEL2007.getMaxRows();
    private final int _maxColumnSize = SpreadsheetVersion.EXCEL2007.getMaxColumns();
    private EventListenerAdaptor _listeners;
    private EventListenerAdaptor _queueListeners;
    private HashMap<String, Object> _attributes;
    private EvaluationContributor _evalContributor;
    private ArrayList<SPictureData> _picDatas;
    private boolean _dirty = false;
    private HashMap<String, STable> _tables;
    private List<SExtraStyle> _extraStyles = new ArrayList<SExtraStyle>();
    private LinkedHashMap<String, STableStyle> _tableStyles = new LinkedHashMap();
    private String _defaultPivotStyle;
    private String _defaultTableStyle;
    static final ThreadLocal<SSheet> destroyingSheet = new ThreadLocal();

    public BookImpl(String bookName) {
        Validations.argNotNull(bookName);
        this._bookName = bookName;
        this._bookSeries = new SimpleBookSeriesImpl(this);
        this._defaultFont = new FontImpl();
        this._fonts.add(this._defaultFont);
        this.initDefaultCellStyles();
        this._colors.put(ColorImpl.WHITE, ColorImpl.WHITE);
        this._colors.put(ColorImpl.BLACK, ColorImpl.BLACK);
        this._colors.put(ColorImpl.RED, ColorImpl.RED);
        this._colors.put(ColorImpl.GREEN, ColorImpl.GREEN);
        this._colors.put(ColorImpl.BLUE, ColorImpl.BLUE);
        this._bookId = (char)(97 + _random.nextInt(26)) + Long.toString(_bookCount.getAndIncrement(), 36);
        this._tables = new HashMap(0);
    }

    @Override
    public void initDefaultCellStyles() {
        CellStyleImpl defaultCellStyle = new CellStyleImpl(this._defaultFont);
        this._cellStyles.add(defaultCellStyle);
        this._defaultCellStyles.add(defaultCellStyle);
    }

    @Override
    public SBookSeries getBookSeries() {
        return this._bookSeries;
    }

    @Override
    public String getBookName() {
        return this._bookName;
    }

    @Override
    public SSheet getSheet(int i) {
        return this._sheets.get(i);
    }

    @Override
    public int getNumOfSheet() {
        return this._sheets.size();
    }

    @Override
    public SSheet getSheetByName(String name) {
        for (SSheet sSheet : this._sheets) {
            if (!sSheet.getSheetName().equalsIgnoreCase(name)) continue;
            return sSheet;
        }
        return null;
    }

    @Override
    public SSheet getSheetById(String id) {
        for (SSheet sSheet : this._sheets) {
            if (!sSheet.getId().equals(id)) continue;
            return sSheet;
        }
        return null;
    }

    protected void checkOwnership(SSheet sheet) {
        if (!this._sheets.contains(sheet)) {
            throw new IllegalStateException("doesn't has ownership " + sheet);
        }
    }

    protected void checkOwnership(SName name) {
        if (this._names == null || !this._names.contains(name)) {
            throw new IllegalStateException("doesn't has ownership " + name);
        }
    }

    @Override
    public void sendModelEvent(ModelEvent event) {
        if (this._listeners != null) {
            this._listeners.sendModelEvent(event);
        }
        if (this._queueListeners != null) {
            AbstractSheetAdv sheet = (AbstractSheetAdv)event.getSheet();
            if (Executions.getCurrent() != null) {
                String eventName = event.getName();
                if (("onMergeAdd".equals(eventName) || "onMergeDelete".equals(eventName)) && sheet != null && sheet.getMergeOutOfSync() == 1) {
                    sheet.setMergeOutOfSync(0);
                } else if (!"onMergeSync".equals(eventName) && !"onSheetDelete".equals(eventName) && sheet != null && sheet.getMergeOutOfSync() == 2) {
                    sheet.setMergeOutOfSync(0);
                    Boolean syncMerged = (Boolean)Executions.getCurrent().getAttribute(SYNC_MERGE_FIRED, false);
                    if (syncMerged == null) {
                        Executions.getCurrent().setAttribute(SYNC_MERGE_FIRED, (Object)Boolean.TRUE, false);
                        new NotifyChangeHelper().notifyMergeSync(new SheetRegion(sheet, 1, 1));
                    }
                }
                this._queueListeners.sendModelEvent(event);
            } else if (sheet != null && sheet.getMergeOutOfSync() == 1) {
                sheet.setMergeOutOfSync(2);
            }
        }
        if (!ModelEvents.isCustomEvent(event) && !this._dirty) {
            this._dirty = true;
            this.sendModelEvent(ModelEvents.createModelEvent("onDirtyChange", event.getBook(), event.getSheet(), ModelEvents.createDataMap("customData", this._dirty)));
        }
    }

    @Override
    public SSheet createSheet(String name) {
        return this.createSheet(name, null);
    }

    @Override
    String nextObjId(String type) {
        StringBuilder sb = new StringBuilder(this._bookId);
        sb.append("_").append(type).append("_");
        AtomicInteger i = this._objIdCounter.get(type);
        if (i == null) {
            i = new AtomicInteger(0);
            this._objIdCounter.put(type, i);
        }
        sb.append(i.getAndIncrement());
        return sb.toString();
    }

    @Override
    public SSheet createSheet(String name, SSheet src) {
        this.checkLegalSheetName(name);
        if (src != null) {
            this.checkOwnership(src);
        }
        SheetImpl sheet = new SheetImpl(this, this.nextObjId("sheet"));
        ((AbstractSheetAdv)sheet).setSheetName(name);
        this._sheets.add(sheet);
        if (src instanceof AbstractSheetAdv) {
            ((AbstractSheetAdv)src).copyTo(sheet);
        }
        EngineFactory.getInstance().createFormulaEngine().clearCache(new FormulaClearContext(this));
        ModelUpdateUtil.handlePrecedentUpdate(this.getBookSeries(), new RefImpl(sheet, -1));
        return sheet;
    }

    protected Ref getRef() {
        return new RefImpl(this);
    }

    @Override
    public void setSheetName(SSheet sheet, String newname) {
        this.checkLegalSheetName(newname);
        this.checkOwnership(sheet);
        int index = this.getSheetIndex(sheet);
        String oldname = sheet.getSheetName();
        ((AbstractSheetAdv)sheet).setSheetName(newname);
        EngineFactory.getInstance().createFormulaEngine().clearCache(new FormulaClearContext(this));
        ModelUpdateUtil.handlePrecedentUpdate(this.getBookSeries(), new RefImpl(this.getBookName(), newname, index));
        ModelUpdateUtil.handlePrecedentUpdate(this.getBookSeries(), new RefImpl(this.getBookName(), oldname, index));
        this.renameSheetFormula(oldname, newname, index);
    }

    private void renameSheetFormula(String oldName, String newName, int index) {
        AbstractBookSeriesAdv bs = (AbstractBookSeriesAdv)this.getBookSeries();
        DependencyTable dt = bs.getDependencyTable();
        Set<Ref> dependents = dt.getDirectDependents(new RefImpl(this.getBookName(), oldName, index));
        if (dependents.size() > 0) {
            for (Ref dependent : dependents) {
                dt.clearDependents(dependent);
            }
            FormulaTunerHelper tuner = new FormulaTunerHelper(bs);
            tuner.renameSheet(this, oldName, newName, dependents);
        }
        for (SName name : this.getNames()) {
            if (!oldName.equalsIgnoreCase(name.getApplyToSheetName())) continue;
            name.setApplyToSheetName(newName);
        }
    }

    private void checkLegalSheetName(String name) {
        if (Strings.isBlank(name)) {
            throw new InvalidModelOpException("sheet name '" + name + "' is not legal");
        }
        if (this.getSheetByName(name) != null) {
            throw new InvalidModelOpException("sheet name '" + name + "' is duplicated");
        }
    }

    private void checkLegalNameName(String name, String sheetName) {
        int colIndex;
        if (Strings.isBlank(name)) {
            throw new InvalidModelOpException("name '" + name + "' is not legal");
        }
        if (this.getTable(name) != null) {
            throw new InvalidModelOpException("name '" + name + "' is duplicated with Table name");
        }
        if (this.getNameByName(name, sheetName) != null) {
            throw new InvalidModelOpException("name '" + name + "' " + (sheetName == null ? "" : " in '" + sheetName + "'") + " is duplicated");
        }
        if (sheetName != null && this.getSheetByName(sheetName) == null) {
            throw new InvalidModelOpException("no such sheet " + sheetName);
        }
        if (name.length() > 255) {
            throw new InvalidModelOpException("name '" + name + "' is not legal: cannot exceed 255 characters");
        }
        char c1 = name.charAt(0);
        if (!Character.isLetter(c1) && c1 != '_' && c1 != '\\') {
            throw new InvalidModelOpException("name '" + name + "' is not legal: first character must be a letter, an underscore, or a backslash");
        }
        boolean invalid = c1 == '_' || c1 == '\\' || c1 == '?' || c1 == '.';
        int n = colIndex = invalid ? -2 : Character.getNumericValue(c1) - 9;
        if (!invalid) {
            invalid = colIndex < 0;
        }
        int rowIndex = -1;
        int len = name.length();
        for (int j = 1; j < len; ++j) {
            char ch = name.charAt(j);
            if (Character.isLetter(ch)) {
                if (invalid) continue;
                if (rowIndex >= 0) {
                    invalid = true;
                    continue;
                }
                int c = Character.getNumericValue(ch) - 9;
                if (c < 0) {
                    invalid = true;
                    continue;
                }
                colIndex = colIndex * 26 + c;
                continue;
            }
            if (Character.isDigit(ch)) {
                if (invalid) continue;
                if (rowIndex < 0) {
                    rowIndex = Character.getNumericValue(ch);
                    continue;
                }
                rowIndex = rowIndex * 10 + Character.getNumericValue(ch);
                continue;
            }
            if (ch != '.' && ch != '_' && ch != '?' && ch != '\\') {
                throw new InvalidModelOpException("name '" + name + "' is not legal: the character '" + ch + "' at index " + j + " must be a letter, a digit, an underscore, a period, a question mark, or a backslash");
            }
            invalid = true;
        }
        if (!invalid && colIndex >= 0 && colIndex <= this.getMaxColumnSize() && rowIndex >= 0 && rowIndex < this.getMaxRowSize()) {
            throw new InvalidModelOpException("name '" + name + "' is not legal: cannot be a cell reference");
        }
        if (name.equalsIgnoreCase("C") || name.equalsIgnoreCase("R")) {
            throw new InvalidModelOpException("name '" + name + "' is not legal: cannot be 'C', 'c', 'R', or 'r'");
        }
    }

    @Override
    public void deleteSheet(SSheet sheet) {
        this.checkOwnership(sheet);
        String bookName = sheet.getBook().getBookName();
        destroyingSheet.set(sheet);
        try {
            ((AbstractSheetAdv)sheet).destroy();
        }
        finally {
            destroyingSheet.set(null);
        }
        String oldName = sheet.getSheetName();
        int index = this._sheets.indexOf(sheet);
        this._sheets.remove(index);
        EngineFactory.getInstance().createFormulaEngine().clearCache(new FormulaClearContext(this));
        ModelUpdateUtil.handlePrecedentUpdate(this.getBookSeries(), new RefImpl(this.getBookName(), sheet.getSheetName(), index));
        this.renameSheetFormula(oldName, null, index);
        this.adjustSheetIndex(bookName, index);
    }

    private void adjustSheetIndex(String bookName, int index) {
        AbstractBookSeriesAdv bs = (AbstractBookSeriesAdv)this.getBookSeries();
        DependencyTableAdv dt = (DependencyTableAdv)bs.getDependencyTable();
        dt.adjustSheetIndex(bookName, index, -1);
    }

    @Override
    public void moveSheetTo(SSheet sheet, int index) {
        this.checkOwnership(sheet);
        if (index < 0 || index >= this._sheets.size()) {
            throw new InvalidModelOpException("new position out of bound " + this._sheets.size() + "<>" + index);
        }
        int oldindex = this._sheets.indexOf(sheet);
        if (oldindex == index) {
            return;
        }
        this.reorderSheetFormula(this.getSheet(oldindex).getSheetName(), oldindex, index);
        this._sheets.remove(oldindex);
        this._sheets.add(index, (AbstractSheetAdv)sheet);
        EngineFactory.getInstance().createFormulaEngine().clearCache(new FormulaClearContext(this));
        ModelUpdateUtil.handlePrecedentUpdate(this.getBookSeries(), new RefImpl(this.getBookName(), sheet.getSheetName(), index));
        ModelUpdateUtil.handlePrecedentUpdate(this.getBookSeries(), new RefImpl(this.getBookName(), sheet.getSheetName(), oldindex));
        this.moveSheetIndex(this.getBookName(), oldindex, index);
    }

    private void moveSheetIndex(String bookName, int oldIndex, int newIndex) {
        AbstractBookSeriesAdv bs = (AbstractBookSeriesAdv)this.getBookSeries();
        DependencyTableAdv dt = (DependencyTableAdv)bs.getDependencyTable();
        dt.moveSheetIndex(bookName, oldIndex, newIndex);
    }

    public void dump(StringBuilder builder) {
        for (AbstractSheetAdv sheet : this._sheets) {
            if (sheet instanceof SheetImpl) {
                ((SheetImpl)sheet).dump(builder);
                continue;
            }
            builder.append("\n").append(sheet);
        }
    }

    @Override
    public SCellStyle getDefaultCellStyle() {
        return this.getDefaultCellStyle(0);
    }

    @Override
    public SCellStyle getDefaultCellStyle(int index) {
        return this._defaultCellStyles.get(index);
    }

    @Override
    public void setDefaultCellStyle(SCellStyle cellStyle) {
        if (cellStyle == null) {
            return;
        }
        AbstractCellStyleAdv defaultCellStyle = (AbstractCellStyleAdv)cellStyle;
        this._defaultCellStyles.set(0, defaultCellStyle);
        this._cellStyles.set(0, defaultCellStyle);
    }

    @Override
    public SCellStyle createCellStyle(boolean inStyleTable) {
        return this.createCellStyle(null, inStyleTable);
    }

    @Override
    public SCellStyle createCellStyle(SCellStyle src, boolean inStyleTable) {
        if (src != null) {
            Validations.argInstance(src, AbstractCellStyleAdv.class);
        }
        CellStyleImpl style = new CellStyleImpl(this._defaultFont);
        if (src != null) {
            style.copyFrom(src);
        }
        if (inStyleTable) {
            this._cellStyles.add(style);
        }
        return style;
    }

    @Override
    public SCellStyle searchCellStyle(CellStyleMatcher matcher) {
        for (SCellStyle style : this._cellStyles) {
            if (!matcher.match(style)) continue;
            return style;
        }
        return null;
    }

    @Override
    public SFont getDefaultFont() {
        return this._defaultFont;
    }

    @Override
    public SFont createFont(boolean inFontTable) {
        return this.createFont(null, inFontTable);
    }

    @Override
    public SFont createFont(SFont src, boolean inFontTable) {
        if (src != null) {
            Validations.argInstance(src, AbstractFontAdv.class);
        }
        FontImpl font = new FontImpl();
        if (src != null) {
            font.copyFrom(src);
        }
        if (inFontTable) {
            this._fonts.add(font);
        }
        return font;
    }

    @Override
    public SFont searchFont(FontMatcher matcher) {
        for (SFont sFont : this._fonts) {
            if (!matcher.match(sFont)) continue;
            return sFont;
        }
        return null;
    }

    @Override
    public int getMaxRowSize() {
        return this._maxRowSize;
    }

    @Override
    public int getMaxColumnSize() {
        return this._maxColumnSize;
    }

    @Override
    public void optimizeCellStyle() {
        LinkedHashMap<String, SCellStyle> stylePool = new LinkedHashMap<String, SCellStyle>();
        this._cellStyles.clear();
        this._fonts.clear();
        SCellStyle defaultStyle = this.getDefaultCellStyle();
        SFont defaultFont = this.getDefaultFont();
        stylePool.put(((AbstractCellStyleAdv)defaultStyle).getStyleKey(), defaultStyle);
        for (SSheet sSheet : this._sheets) {
            Iterator<SRow> rowIter = sSheet.getRowIterator();
            while (rowIter.hasNext()) {
                SRow row = rowIter.next();
                row.setCellStyle(this.hitStyle(defaultStyle, row.getCellStyle(), stylePool));
                Iterator<SCell> cellIter = sSheet.getCellIterator(row.getIndex());
                while (cellIter.hasNext()) {
                    SCell cell = cellIter.next();
                    cell.setCellStyle(this.hitStyle(defaultStyle, cell.getCellStyle(), stylePool));
                }
            }
            Iterator<SColumnArray> colIter = sSheet.getColumnArrayIterator();
            while (colIter.hasNext()) {
                SColumnArray colarr = colIter.next();
                colarr.setCellStyle(this.hitStyle(defaultStyle, colarr.getCellStyle(), stylePool));
            }
        }
        this._cellStyles.addAll(((HashMap)stylePool).values());
        LinkedHashMap<String, SFont> linkedHashMap = new LinkedHashMap<String, SFont>();
        linkedHashMap.put(((AbstractFontAdv)defaultFont).getStyleKey(), defaultFont);
        for (SCellStyle style : this._cellStyles) {
            SFont font = style.getFont();
            String key = ((AbstractFontAdv)font).getStyleKey();
            if (((HashMap)linkedHashMap).get(key) != null) continue;
            linkedHashMap.put(key, font);
        }
        this._fonts.addAll(((HashMap)linkedHashMap).values());
        this._colors.clear();
    }

    public List<SCellStyle> getCellStyleTable() {
        return Collections.unmodifiableList(this._cellStyles);
    }

    public List<SFont> getFontTable() {
        return Collections.unmodifiableList(this._fonts);
    }

    private SCellStyle hitStyle(SCellStyle defaultStyle, SCellStyle currSytle, HashMap<String, SCellStyle> stylePool) {
        if (currSytle == defaultStyle) {
            return defaultStyle;
        }
        String key = ((AbstractCellStyleAdv)currSytle).getStyleKey();
        SCellStyle hit = stylePool.get(key);
        if (hit == null) {
            hit = currSytle;
            stylePool.put(key, hit);
        }
        return hit;
    }

    @Override
    public void addEventListener(ModelEventListener listener) {
        if (listener instanceof EventQueueModelEventListener) {
            if (this._queueListeners == null) {
                String scope = this.getShareScope();
                if (scope == null) {
                    scope = "desktop";
                }
                this._queueListeners = new EventQueueListenerAdaptor(scope, this.getId());
            }
            this._queueListeners.addEventListener(listener);
        } else {
            if (this._listeners == null) {
                this._listeners = new DirectEventListenerAdaptor();
            }
            this._listeners.addEventListener(listener);
        }
    }

    @Override
    public void removeEventListener(ModelEventListener listener) {
        if (listener instanceof EventQueueModelEventListener && this._queueListeners != null) {
            this._queueListeners.removeEventListener(listener);
            if (this._queueListeners.size() == 0) {
                this._queueListeners = null;
            }
        } else if (this._listeners != null) {
            this._listeners.removeEventListener(listener);
        }
    }

    @Override
    public Object getAttribute(String name) {
        return this._attributes == null ? null : this._attributes.get(name);
    }

    @Override
    public Object setAttribute(String name, Object value) {
        if (this._attributes == null) {
            this._attributes = new HashMap();
        }
        return this._attributes.put(name, value);
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this._attributes == null ? Collections.EMPTY_MAP : Collections.unmodifiableMap(this._attributes);
    }

    @Override
    public SColor createColor(byte r, byte g, byte b) {
        ColorImpl newcolor = new ColorImpl(r, g, b);
        AbstractColorAdv color = this._colors.get(newcolor);
        if (color == null) {
            color = newcolor;
            this._colors.put(newcolor, color);
        }
        return color;
    }

    @Override
    public SColor createColor(String htmlColor) {
        ColorImpl newcolor = new ColorImpl(htmlColor);
        AbstractColorAdv color = this._colors.get(newcolor);
        if (color == null) {
            color = newcolor;
            this._colors.put(newcolor, color);
        }
        return color;
    }

    @Override
    public List<SSheet> getSheets() {
        return Collections.unmodifiableList(this._sheets);
    }

    @Override
    public SName createName(String namename) {
        return this.createName(namename, null);
    }

    @Override
    public SName createName(String namename, String sheetName) {
        this.checkLegalNameName(namename, sheetName);
        NameImpl name = new NameImpl(this, this.nextObjId("name"), namename, sheetName);
        if (this._names == null) {
            this._names = new ArrayList<AbstractNameAdv>();
        }
        this._names.add(name);
        return name;
    }

    @Override
    public void setNameName(SName name, String newname) {
        this.setNameName(name, newname, null);
    }

    @Override
    public void setNameName(SName name, String newname, String sheetName) {
        this.checkLegalNameName(newname, sheetName);
        this.checkOwnership(name);
        EngineFactory.getInstance().createFormulaEngine().clearCache(new FormulaClearContext(this));
        ModelUpdateUtil.handlePrecedentUpdate(this.getBookSeries(), new NameRefImpl((AbstractNameAdv)name));
        String oldName = name.getName();
        if (name instanceof TableNameImpl) {
            ModelUpdateUtil.handlePrecedentUpdate(this.getBookSeries(), new TablePrecedentRefImpl(this.getBookName(), oldName));
        }
        ((AbstractNameAdv)name).setName(newname, sheetName);
        this.renameNameFormula(name, oldName, newname, sheetName);
        if (name instanceof TableNameImpl) {
            STable tb = this.removeTable(oldName);
            if (tb != null) {
                this.addTable(tb);
            }
            this.renameTableNameFormula(name, oldName, newname);
        }
    }

    private void renameNameFormula(SName name, String oldName, String newName, String sheetName) {
        NameRefImpl ref;
        AbstractBookSeriesAdv bs = (AbstractBookSeriesAdv)this.getBookSeries();
        FormulaTunerHelper tuner = new FormulaTunerHelper(bs);
        DependencyTable dt = bs.getDependencyTable();
        Set<Ref> dependents = dt.getDirectDependents(ref = new NameRefImpl(name.getBook().getBookName(), name.getApplyToSheetName(), oldName));
        if (dependents.size() > 0) {
            for (Ref dependent : dependents) {
                dt.clearDependents(dependent);
            }
            int sheetIndex = sheetName == null ? -1 : this.getSheetIndex(sheetName);
            tuner.renameName(this, oldName, newName, dependents, sheetIndex);
        }
    }

    @Override
    public void deleteName(SName name) {
        this.checkOwnership(name);
        ((AbstractNameAdv)name).destroy();
        int index = this._names.indexOf(name);
        this._names.remove(index);
    }

    @Override
    public int getNumOfName() {
        return this._names == null ? 0 : this._names.size();
    }

    @Override
    public SName getName(int idx) {
        if (this._names == null) {
            throw new ArrayIndexOutOfBoundsException(idx);
        }
        return this._names.get(idx);
    }

    @Override
    public SName getNameByName(String namename) {
        return this.getNameByName(namename, null);
    }

    @Override
    public SName getNameByName(String namename, String sheetName) {
        if (this._names == null || sheetName != null && this.getSheetByName(sheetName) == null) {
            return null;
        }
        for (SName sName : this._names) {
            String scopeSheetName = sName.getApplyToSheetName();
            if (sheetName != scopeSheetName && (sheetName == null || !sheetName.equalsIgnoreCase(scopeSheetName)) || !sName.getName().equalsIgnoreCase(namename)) continue;
            return sName;
        }
        return null;
    }

    @Override
    public List<SName> getNames() {
        return this._names == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(this._names);
    }

    @Override
    public int getSheetIndex(SSheet sheet) {
        return this._sheets.indexOf(sheet);
    }

    @Override
    public int getSheetIndex(String sheetName) {
        int i = 0;
        for (SSheet sSheet : this._sheets) {
            if (sSheet.getSheetName().equals(sheetName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public void setShareScope(String scope) {
        if (!Objects.equals((Object)this._shareScope, (Object)scope)) {
            if ("disable".equals(scope)) {
                if (this._listeners != null) {
                    this._listeners.clear();
                }
                if (this._queueListeners != null) {
                    this._queueListeners.clear();
                }
                return;
            }
            if (this._queueListeners != null && this._queueListeners.size() > 0) {
                throw new IllegalStateException("can't change share scope after registed any queue model event listener");
            }
            this._shareScope = scope;
        }
    }

    @Override
    public String getShareScope() {
        return this._shareScope;
    }

    @Override
    void setBookSeries(SBookSeries bookSeries) {
        this._bookSeries = bookSeries;
    }

    @Override
    public EvaluationContributor getEvaluationContributor() {
        return this._evalContributor;
    }

    @Override
    public void setEvaluationContributor(EvaluationContributor contributor) {
        this._evalContributor = contributor;
    }

    @Override
    public int getMaxRowIndex() {
        return this.getMaxRowSize() - 1;
    }

    @Override
    public int getMaxColumnIndex() {
        return this.getMaxColumnSize() - 1;
    }

    @Override
    public String getId() {
        return this._bookId;
    }

    @Override
    public SPictureData addPictureData(SPicture.Format format, byte[] data) {
        if (this._picDatas == null) {
            this._picDatas = new ArrayList(4);
        }
        int index = this._picDatas.size();
        PictureDataImpl picData = new PictureDataImpl(index, format, data);
        this._picDatas.add(picData);
        return picData;
    }

    @Override
    public SPictureData getPictureData(int index) {
        if (index < 0 || this._picDatas == null || index >= this._picDatas.size()) {
            return null;
        }
        return this._picDatas.get(index);
    }

    @Override
    public Collection<SPictureData> getPicturesDatas() {
        if (this._picDatas == null) {
            return Collections.emptyList();
        }
        ArrayList<SPictureData> list = new ArrayList<SPictureData>(this._picDatas.size());
        for (SPictureData picData : this._picDatas) {
            if (picData == null) continue;
            list.add(picData);
        }
        return list;
    }

    private void reorderSheetFormula(String sheetName, int oldIndex, int newIndex) {
        AbstractBookSeriesAdv bs = (AbstractBookSeriesAdv)this.getBookSeries();
        DependencyTable dt = bs.getDependencyTable();
        Set<Ref> dependents = dt.getDirectDependents(new RefImpl(this.getBookName(), sheetName, oldIndex));
        if (dependents.size() > 0) {
            String bookName = this.getBookName();
            int low = oldIndex < newIndex ? oldIndex : newIndex;
            int high = oldIndex < newIndex ? newIndex : oldIndex;
            HashSet<String> bookNames = new HashSet<String>();
            Iterator<Ref> it = dependents.iterator();
            while (it.hasNext()) {
                Ref dependent = it.next();
                Set<Ref> precedents = ((DependencyTableAdv)dt).getDirectPrecedents(dependent);
                boolean candidate = false;
                for (Ref p : precedents) {
                    ParsingBook parsingBook;
                    if (p.getType() != Ref.RefType.AREA && p.getType() != Ref.RefType.CELL) continue;
                    String bookName0 = p.getBookName();
                    String sheet1 = p.getSheetName();
                    String sheet2 = p.getLastSheetName();
                    int low0 = this.getSheetIndex(sheet1);
                    int high0 = this.getSheetIndex(sheet2);
                    if (high0 < 0) {
                        high0 = low0;
                    }
                    if (low0 == high0 || high0 < low || low0 > high) continue;
                    if (low0 == oldIndex && low0 != high0 && newIndex >= high0) {
                        candidate = true;
                        if (bookNames.contains(bookName0)) break;
                        parsingBook = new ParsingBook(bs.getBook(bookName0));
                        parsingBook.reorderSheet(bookName, oldIndex, newIndex);
                        bookNames.add(bookName0);
                        break;
                    }
                    if (high0 != oldIndex || low0 == high0 || newIndex > low0) continue;
                    candidate = true;
                    if (bookNames.contains(bookName0)) break;
                    parsingBook = new ParsingBook(bs.getBook(bookName0));
                    parsingBook.reorderSheet(bookName, oldIndex, newIndex);
                    bookNames.add(bookName0);
                    break;
                }
                if (candidate) continue;
                it.remove();
            }
            if (!dependents.isEmpty()) {
                for (Ref dependent : dependents) {
                    dt.clearDependents(dependent);
                }
                FormulaTunerHelper tuner = new FormulaTunerHelper(bs);
                tuner.reorderSheet(this, oldIndex, newIndex, dependents);
            }
        }
    }

    @Override
    public SNamedStyle getNamedStyle(String name) {
        return this._namedStyles.get(name);
    }

    @Override
    public int addDefaultCellStyle(SCellStyle cellStyle) {
        this._defaultCellStyles.add((AbstractCellStyleAdv)cellStyle);
        return this._defaultCellStyles.size() - 1;
    }

    @Override
    public Collection<SCellStyle> getDefaultCellStyles() {
        return this._defaultCellStyles;
    }

    @Override
    public void addNamedCellstyle(SNamedStyle namedStyle) {
        this._namedStyles.put(namedStyle.getName(), namedStyle);
    }

    @Override
    public Collection<SNamedStyle> getNamedStyles() {
        return this._namedStyles.values();
    }

    @Override
    public void clearDefaultCellStyles() {
        this._cellStyles.clear();
        this._defaultCellStyles.clear();
    }

    @Override
    public void clearNamedStyles() {
        this._namedStyles.clear();
    }

    @Override
    public boolean isDirty() {
        return this._dirty;
    }

    @Override
    public void setDirty(boolean dirty) {
        this._dirty = dirty;
    }

    @Override
    public SName createTableName(STable table) {
        String namename = table.getName();
        this.checkLegalNameName(namename, null);
        TableNameImpl name = new TableNameImpl((AbstractBookAdv)this, table, this.nextObjId("name"), namename);
        if (this._names == null) {
            this._names = new ArrayList<AbstractNameAdv>();
        }
        this._names.add(name);
        return name;
    }

    @Override
    public void addTable(STable table) {
        this._tables.put(table.getName().toUpperCase(), table);
    }

    @Override
    public STable getTable(String name) {
        return this._tables.get(name.toUpperCase());
    }

    @Override
    public STable removeTable(String name) {
        STable tb = this._tables.remove(name.toUpperCase());
        if (tb != null) {
            ((AbstractTableAdv)tb).refreshFilter();
        }
        return tb;
    }

    private void renameTableNameFormula(SName name, String oldName, String newName) {
        TablePrecedentRefImpl ref;
        AbstractBookSeriesAdv bs = (AbstractBookSeriesAdv)this.getBookSeries();
        FormulaTunerHelper tuner = new FormulaTunerHelper(bs);
        DependencyTable dt = bs.getDependencyTable();
        Set<Ref> dependents = dt.getDirectDependents(ref = new TablePrecedentRefImpl(name.getBook().getBookName(), oldName));
        if (dependents.size() > 0) {
            for (Ref dependent : dependents) {
                dt.clearDependents(dependent);
            }
            tuner.renameTableName(this, oldName, newName, dependents);
        }
    }

    @Override
    public String setTableColumnName(STable table, String oldName, String newName) {
        String newNameUpper;
        if (Objects.equals((Object)oldName, (Object)newName)) {
            return newName;
        }
        List<STableColumn> tbCols = table.getColumns();
        STableColumn tbCol = null;
        STableColumn tbColDup = null;
        HashSet<String> set = new HashSet<String>(tbCols.size() * 4 / 3);
        for (STableColumn tbCol0 : tbCols) {
            String tbColName = tbCol0.getName().toUpperCase();
            if (tbColName.equalsIgnoreCase(oldName)) {
                tbCol = tbCol0;
                continue;
            }
            if (tbColName.equalsIgnoreCase(newName)) {
                tbColDup = tbCol0;
                continue;
            }
            set.add(tbColName);
        }
        if (tbCol == null) {
            return null;
        }
        String newName0 = null;
        if (newName == null) {
            newName0 = "Column";
            newNameUpper = newName0.toUpperCase();
            for (int j = tbCols.size(); j > 0; --j) {
                if (set.contains(newNameUpper + j)) continue;
                newName0 = newName0 + j;
                break;
            }
        } else if (tbColDup != null) {
            newName0 = newName;
            newNameUpper = newName0.toUpperCase();
            int len = tbCols.size() + 2;
            for (int j = 2; j < len; ++j) {
                if (set.contains(newNameUpper + j)) continue;
                newName0 = newName0 + j;
                break;
            }
        }
        String newName1 = newName0 != null ? newName0 : newName;
        tbCol.setName(newName1);
        this.renameColumnNameFormula(table, oldName, newName1);
        return newName0 != null ? newName0 : null;
    }

    private void renameColumnNameFormula(STable table, String oldName, String newName) {
        AbstractBookSeriesAdv bs = (AbstractBookSeriesAdv)this.getBookSeries();
        FormulaTunerHelper tuner = new FormulaTunerHelper(bs);
        DependencyTable dt = bs.getDependencyTable();
        String tableName = table.getName();
        ColumnPrecedentRefImpl ref = new ColumnPrecedentRefImpl(table.getBook().getBookName(), tableName, oldName);
        Set<Ref> dependents = dt.getDirectDependents(ref);
        if (dependents.size() > 0) {
            for (Ref dependent : dependents) {
                dt.clearDependents(dependent);
            }
            tuner.renameColumnName(table, oldName, newName, dependents);
        }
    }

    @Override
    public SCellStyle getOrCreateDefaultHyperlinkStyle() {
        SFont defaultFont = this.getDefaultFont();
        FontMatcher fontMatcher = new FontMatcher(defaultFont);
        fontMatcher.setColor("0000FF");
        fontMatcher.setUnderline(SFont.Underline.SINGLE);
        SFont linkFont = this.searchFont(fontMatcher);
        if (linkFont == null) {
            linkFont = this.createFont(defaultFont, true);
            linkFont.setColor(this.createColor("#0000FF"));
            linkFont.setUnderline(SFont.Underline.SINGLE);
        }
        SCellStyle defaultStyle = this.getDefaultCellStyle();
        CellStyleMatcher matcher = new CellStyleMatcher(defaultStyle);
        matcher.setFont(linkFont);
        SCellStyle linkStyle = this.searchCellStyle(matcher);
        if (linkStyle == null) {
            linkStyle = StyleUtil.cloneCellStyle(this, defaultStyle);
            linkStyle.setFont(linkFont);
        }
        return linkStyle;
    }

    @Override
    public void initDefaultFont() {
        this._defaultFont = (AbstractFontAdv)this._defaultCellStyles.get(0).getFont();
    }

    @Override
    public int getCharWidth() {
        if (this._defaultFont != null) {
            int pt = this._defaultFont.getHeightPoints();
            switch (pt) {
                case 12: {
                    return 8;
                }
            }
            return 7;
        }
        return 7;
    }

    @Override
    public SExtraStyle getExtraStyleAt(int idx) {
        return this._extraStyles.get(idx);
    }

    @Override
    public void addExtraStyle(SExtraStyle extraStyle) {
        this._extraStyles.add(extraStyle);
    }

    @Override
    public List<SExtraStyle> getExtraStyles() {
        return this._extraStyles;
    }

    @Override
    public void clearExtraStyles() {
        this._extraStyles.clear();
    }

    @Override
    public int indexOfExtraStyle(SExtraStyle style) {
        if (this._extraStyles == null) {
            return -1;
        }
        int j = 0;
        for (SExtraStyle s : this._extraStyles) {
            if (s == style) {
                return j;
            }
            ++j;
        }
        return -1;
    }

    @Override
    public STableStyle getTableStyle(String name) {
        return this._tableStyles.get(name);
    }

    @Override
    public void addTableStyle(STableStyle tableStyle) {
        this._tableStyles.put(tableStyle.getName(), tableStyle);
    }

    @Override
    public List<STableStyle> getTableStyles() {
        return new ArrayList<STableStyle>(this._tableStyles.values());
    }

    @Override
    public void clearTableStyles() {
        this._tableStyles.clear();
    }

    @Override
    public void setDefaultPivotStyleName(String name) {
        this._defaultPivotStyle = name;
    }

    @Override
    public String getDefaultPivotStyleName() {
        return this._defaultPivotStyle;
    }

    @Override
    public void setDefaultTableStyleName(String name) {
        this._defaultTableStyle = name;
    }

    @Override
    public String getDefaultTableStyleName() {
        return this._defaultTableStyle;
    }
}

