/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.model.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.TreeMap;
import org.zkoss.zss.model.CellRegion;
import org.zkoss.zss.model.SAutoFilter;
import org.zkoss.zss.model.SBook;
import org.zkoss.zss.model.impl.AbstractAutoFilterAdv;
import org.zkoss.zss.model.impl.AbstractBookSeriesAdv;
import org.zkoss.zss.model.impl.ObjectRefImpl;
import org.zkoss.zss.model.impl.RefImpl;
import org.zkoss.zss.model.sys.dependency.DependencyTable;
import org.zkoss.zss.model.sys.dependency.ObjectRef;
import org.zkoss.zss.model.util.Validations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoFilterImpl
extends AbstractAutoFilterAdv {
    private static final long serialVersionUID = 1L;
    private final CellRegion _region;
    private final TreeMap<Integer, SAutoFilter.NFilterColumn> _columns;

    public AutoFilterImpl(CellRegion region) {
        this._region = region;
        this._columns = new TreeMap();
    }

    @Override
    public CellRegion getRegion() {
        return this._region;
    }

    @Override
    public Collection<SAutoFilter.NFilterColumn> getFilterColumns() {
        return Collections.unmodifiableCollection(this._columns.values());
    }

    @Override
    public SAutoFilter.NFilterColumn getFilterColumn(int index, boolean create) {
        SAutoFilter.NFilterColumn col = this._columns.get(index);
        if (col == null && create) {
            int s = this._region.getLastColumn() - this._region.getColumn() + 1;
            if (index >= s) {
                throw new IllegalStateException("the column index " + index + " >= " + s);
            }
            col = new AbstractAutoFilterAdv.FilterColumnImpl(index);
            this._columns.put(index, col);
        }
        return col;
    }

    @Override
    public void clearFilterColumn(int index) {
        this._columns.remove(index);
    }

    @Override
    public void clearFilterColumns() {
        this._columns.clear();
    }

    @Override
    public void renameSheet(SBook book, String oldName, String newName) {
        Validations.argNotNull(oldName);
        Validations.argNotNull(newName);
        if (oldName.equals(newName)) {
            return;
        }
        String bookName = book.getBookName();
        ObjectRefImpl dependent = new ObjectRefImpl(bookName, oldName, "AUTO_FILTER", ObjectRef.ObjectType.AUTO_FILTER);
        DependencyTable dt = ((AbstractBookSeriesAdv)book.getBookSeries()).getDependencyTable();
        dt.clearDependents(dependent);
        dependent = new ObjectRefImpl(bookName, newName, "AUTO_FILTER", ObjectRef.ObjectType.AUTO_FILTER);
        if (this._region != null) {
            RefImpl dummy = new RefImpl(bookName, newName, this._region.row, this._region.column, this._region.lastRow, this._region.lastColumn);
            dt.add(dependent, dummy);
        }
    }

    AutoFilterImpl cloneAutoFilterImpl() {
        AutoFilterImpl tgt = new AutoFilterImpl(new CellRegion(this._region.row, this._region.column, this._region.lastRow, this._region.lastColumn));
        for (SAutoFilter.NFilterColumn value : this._columns.values()) {
            AbstractAutoFilterAdv.FilterColumnImpl srccol = (AbstractAutoFilterAdv.FilterColumnImpl)value;
            AbstractAutoFilterAdv.FilterColumnImpl tgtcol = srccol.cloneFilterColumnImpl();
            this._columns.put(tgtcol.getIndex(), tgtcol);
        }
        return tgt;
    }
}

