/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.model.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Locale;
import org.zkoss.poi.ss.formula.eval.ValueEval;
import org.zkoss.zss.model.ErrorValue;
import org.zkoss.zss.model.SCell;
import org.zkoss.zss.model.SComment;
import org.zkoss.zss.model.SHyperlink;
import org.zkoss.zss.model.SRichText;
import org.zkoss.zss.model.impl.AbstractRowAdv;
import org.zkoss.zss.model.impl.CommentImpl;
import org.zkoss.zss.model.impl.HyperlinkImpl;
import org.zkoss.zss.model.impl.LinkedModelObject;
import org.zkoss.zss.model.impl.ReadOnlyRichTextImpl;
import org.zkoss.zss.model.impl.RichTextImpl;
import org.zkoss.zss.model.sys.EngineFactory;
import org.zkoss.zss.model.sys.dependency.Ref;
import org.zkoss.zss.model.sys.formula.FormulaExpression;

public abstract class AbstractCellAdv
implements SCell,
LinkedModelObject,
Serializable {
    private static final long serialVersionUID = 1L;

    protected void checkType(SCell.CellType ... types) {
        SCell.CellType type = this.getType();
        for (SCell.CellType t : types) {
            if (!t.equals((Object)type)) continue;
            return;
        }
        throw new IllegalStateException("is " + (Object)((Object)this.getType()) + ", not the one of " + Arrays.asList(types));
    }

    protected void checkFormulaResultType(SCell.CellType ... types) {
        if (!this.getType().equals((Object)SCell.CellType.FORMULA)) {
            throw new IllegalStateException("is " + (Object)((Object)this.getType()) + ", not the one of " + types);
        }
        LinkedHashSet<SCell.CellType> set = new LinkedHashSet<SCell.CellType>();
        for (SCell.CellType t : types) {
            set.add(t);
        }
        if (!set.contains((Object)this.getFormulaResultType())) {
            throw new IllegalStateException("is " + (Object)((Object)this.getFormulaResultType()) + ", not the one of " + Arrays.asList(types));
        }
    }

    abstract void evalFormula();

    abstract Object getValue(boolean var1);

    public Object getValue() {
        return this.getValue(true);
    }

    public void setStringValue(String value) {
        this.setValue(value, true);
    }

    public String getStringValue() {
        if (this.getType() == SCell.CellType.FORMULA) {
            this.evalFormula();
            this.checkFormulaResultType(SCell.CellType.STRING, SCell.CellType.BLANK);
        } else {
            this.checkType(SCell.CellType.STRING, SCell.CellType.BLANK);
        }
        Object val = this.getValue();
        return val == null ? "" : (val instanceof SRichText ? ((SRichText)val).getText() : (String)val);
    }

    public void setNumberValue(Double number) {
        this.setValue(number);
    }

    public Double getNumberValue() {
        if (this.getType() == SCell.CellType.FORMULA) {
            this.evalFormula();
            this.checkFormulaResultType(SCell.CellType.NUMBER, SCell.CellType.BLANK);
        } else {
            this.checkType(SCell.CellType.NUMBER, SCell.CellType.BLANK);
        }
        Object val = this.getValue();
        if (val instanceof Double) {
            return (Double)val;
        }
        if (val instanceof Number) {
            return ((Number)val).doubleValue();
        }
        return 0.0;
    }

    public void setDateValue(Date date) {
        double num = EngineFactory.getInstance().getCalendarUtil().dateToDoubleValue(date);
        this.setNumberValue(num);
    }

    public Date getDateValue() {
        if (SCell.CellType.BLANK.equals((Object)this.getType())) {
            return null;
        }
        Double num = this.getNumberValue();
        return EngineFactory.getInstance().getCalendarUtil().doubleValueToDate(num);
    }

    public void setBooleanValue(Boolean date) {
        this.setValue(date);
    }

    public Boolean getBooleanValue() {
        SCell.CellType type = this.getType();
        if (this.getType() == SCell.CellType.FORMULA) {
            this.evalFormula();
            this.checkFormulaResultType(SCell.CellType.BOOLEAN, SCell.CellType.BLANK);
        } else {
            this.checkType(SCell.CellType.BOOLEAN, SCell.CellType.BLANK);
        }
        return Boolean.TRUE.equals(this.getValue());
    }

    public ErrorValue getErrorValue() {
        if (this.getType() == SCell.CellType.FORMULA) {
            this.evalFormula();
            this.checkFormulaResultType(SCell.CellType.ERROR);
        } else {
            this.checkType(SCell.CellType.ERROR);
        }
        return (ErrorValue)this.getValue();
    }

    public void setErrorValue(ErrorValue errorValue) {
        this.setValue(errorValue);
    }

    public String getFormulaValue() {
        this.checkType(SCell.CellType.FORMULA);
        FormulaExpression expr = (FormulaExpression)this.getValue(false);
        return expr.getFormulaString();
    }

    public SRichText setupRichTextValue() {
        Object val = this.getValue();
        if (val instanceof SRichText) {
            return (SRichText)val;
        }
        RichTextImpl text = new RichTextImpl();
        this.setValue(text);
        return text;
    }

    public SRichText getRichTextValue() {
        if (this.getType() == SCell.CellType.FORMULA) {
            this.evalFormula();
            this.checkFormulaResultType(SCell.CellType.STRING, SCell.CellType.BLANK);
        } else {
            this.checkType(SCell.CellType.STRING, SCell.CellType.BLANK);
        }
        Object val = this.getValue();
        if (val instanceof SRichText) {
            return (SRichText)val;
        }
        return new ReadOnlyRichTextImpl(val == null ? "" : (String)val, this.getCellStyle().getFont());
    }

    public boolean isRichTextValue() {
        Object val = this.getValue(false);
        return val instanceof SRichText;
    }

    public SHyperlink setupHyperlink(SHyperlink.HyperlinkType type, String address, String label) {
        SHyperlink hyperlink = this.getHyperlink();
        if (hyperlink != null) {
            hyperlink.setType(type);
            hyperlink.setAddress(address);
            hyperlink.setLabel(label);
            return hyperlink;
        }
        hyperlink = new HyperlinkImpl(type, address, label);
        this.setHyperlink(hyperlink);
        return hyperlink;
    }

    public SComment setupComment() {
        SComment comment = this.getComment();
        if (comment != null) {
            return comment;
        }
        comment = new CommentImpl();
        this.setComment(comment);
        return comment;
    }

    abstract void setIndex(int var1);

    abstract void setRow(int var1, AbstractRowAdv var2);

    abstract Ref getRef();

    public abstract void setFormulaValue(String var1, Locale var2);

    abstract AbstractCellAdv cloneCell(AbstractRowAdv var1);

    public abstract void setFormulaResultValue(ValueEval var1);

    protected abstract void setValue(Object var1, boolean var2);

    public abstract FormulaExpression getFormulaExpression();

    public abstract void setTextHeight(int var1);

    public abstract int getTextHeight();

    public abstract void setCalcAutoHeight(boolean var1);

    public abstract boolean isCalcAutoHeight();

    public abstract void setTextWidth(int var1);

    public abstract int getTextWidth();
}

