/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.model;

import java.util.HashMap;
import java.util.Map;
import org.zkoss.zss.model.CellRegion;
import org.zkoss.zss.model.ModelEvent;
import org.zkoss.zss.model.SBook;
import org.zkoss.zss.model.SSheet;

public class ModelEvents {
    public static final String ON_CELL_CONTENT_CHANGE = "onCellChange";
    public static final String ON_CHART_CONTENT_CHANGE = "onChartContentChange";
    public static final String ON_DATA_VALIDATION_CONTENT_CHANGE = "onDataValidationContentChange";
    public static final String ON_ROW_COLUMN_SIZE_CHANGE = "onRowColumnSizeChange";
    public static final String ON_AUTOFILTER_CHANGE = "onAutoFilterChange";
    public static final String ON_FREEZE_CHANGE = "onFreezeChange";
    public static final String ON_SHEET_CREATE = "onSheetCreate";
    public static final String ON_SHEET_NAME_CHANGE = "onSheetNameChange";
    public static final String ON_SHEET_ORDER_CHANGE = "onSheetOrderChange";
    public static final String ON_SHEET_DELETE = "onSheetDelete";
    public static final String ON_SHEET_VISIBLE_CHANGE = "onSheetVisibleChange";
    public static final String ON_PICTURE_ADD = "onPictureAdd";
    public static final String ON_PICTURE_UPDATE = "onPictureUpdate";
    public static final String ON_PICTURE_DELETE = "onPictureDelete";
    public static final String ON_CHART_ADD = "onChartAdd";
    public static final String ON_CHART_UPDATE = "onChartUpdate";
    public static final String ON_CHART_DELETE = "onChartDelete";
    public static final String ON_MERGE_ADD = "onMergeAdd";
    public static final String ON_MERGE_DELETE = "onMergeDelete";
    public static final String ON_MERGE_SYNC = "onMergeSync";
    public static final String ON_DISPLAY_GRIDLINES_CHANGE = "onDisplayGridlinesChange";
    public static final String ON_PROTECT_SHEET_CHANGE = "onProtectSheetChange";
    public static final String ON_ROW_INSERT = "onRowInsert";
    public static final String ON_ROW_DELETE = "onRowDelete";
    public static final String ON_COLUMN_INSERT = "onColumnInsert";
    public static final String ON_COLUMN_DELETE = "onColumnDelete";
    public static final String ON_NAME_NAME_CHANGE = "onNameNameChange";
    public static final String ON_MODEL_FRIEND_FOCUS_DELETE = "onFriendFocusDelete";
    public static final String ON_MODEL_FRIEND_FOCUS_MOVE = "onFriendFocusMove";
    public static final String ON_MODEL_DIRTY_CHANGE = "onDirtyChange";
    public static final String PARAM_BOOK = "book";
    public static final String PARAM_SHEET = "sheet";
    public static final String PARAM_REGION = "region";
    public static final String PARAM_OBJECT_ID = "objid";
    public static final String PARAM_CUSTOM_DATA = "customData";
    public static final String PARAM_INDEX = "index";
    public static final String PARAM_OLD_NAME = "oldName";
    public static final String PARAM_OLD_INDEX = "oldIndex";
    public static final String PARAM_ENABLED = "enabled";
    public static final String PARAM_NAME = "name";

    public static ModelEvent createModelEvent(String name, SBook book) {
        return ModelEvents.createModelEvent0(name, book, null, null, null);
    }

    public static ModelEvent createModelEvent(String name, SBook book, Map data) {
        return ModelEvents.createModelEvent0(name, book, null, null, data);
    }

    public static ModelEvent createModelEvent(String name, SSheet sheet) {
        return ModelEvents.createModelEvent0(name, sheet.getBook(), sheet, null, null);
    }

    public static ModelEvent createModelEvent(String name, SSheet sheet, Map data) {
        return ModelEvents.createModelEvent0(name, sheet.getBook(), sheet, null, data);
    }

    public static ModelEvent createModelEvent(String name, SSheet sheet, CellRegion region) {
        return ModelEvents.createModelEvent0(name, sheet.getBook(), sheet, region, null);
    }

    public static ModelEvent createModelEvent(String name, SBook book, SSheet sheet, Map data) {
        return ModelEvents.createModelEvent0(name, book, sheet, null, data);
    }

    public static ModelEvent createModelEvent(String name, SSheet sheet, CellRegion region, Map data) {
        return ModelEvents.createModelEvent0(name, sheet.getBook(), sheet, region, data);
    }

    public static Map createDataMap(Object ... data) {
        if (data != null) {
            if (data.length % 2 != 0) {
                throw new IllegalArgumentException("event data must be key,value pair");
            }
            HashMap<String, Object> datamap = new HashMap<String, Object>();
            for (int i = 0; i < data.length; i += 2) {
                if (!(data[i] instanceof String)) {
                    throw new IllegalArgumentException("event data key must be string");
                }
                datamap.put((String)data[i], data[i + 1]);
            }
            return datamap;
        }
        return null;
    }

    private static ModelEvent createModelEvent0(String name, SBook book, SSheet sheet, CellRegion region, Map data) {
        HashMap<String, Object> datamap = new HashMap<String, Object>();
        if (book != null) {
            datamap.put(PARAM_BOOK, book);
        }
        if (sheet != null) {
            datamap.put(PARAM_SHEET, sheet);
        }
        if (region != null) {
            datamap.put(PARAM_REGION, region);
        }
        if (data != null) {
            datamap.putAll(data);
        }
        ModelEvent event = new ModelEvent(name, datamap);
        return event;
    }

    public static boolean isCustomEvent(ModelEvent event) {
        String eventName = event.getName();
        return ON_MODEL_FRIEND_FOCUS_MOVE.equals(eventName) || ON_MODEL_FRIEND_FOCUS_DELETE.equals(eventName) || ON_MODEL_DIRTY_CHANGE.equals(eventName);
    }
}

