/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.zkoss.zss.model.CellRegion;
import org.zkoss.zss.model.SBook;
import org.zkoss.zss.model.SSheet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelEvent
implements Serializable {
    private static final long serialVersionUID = -3146584806063875161L;
    private String _name;
    private Map<String, Object> data;

    public ModelEvent(String name) {
        this._name = name;
    }

    public ModelEvent(String name, Map<String, Object> data) {
        this._name = name;
        this.data = new HashMap<String, Object>(data);
    }

    public Object getData(String key) {
        return this.data == null ? null : this.data.get(key);
    }

    public String getName() {
        return this._name;
    }

    public SBook getBook() {
        return (SBook)this.getData("book");
    }

    public SSheet getSheet() {
        return (SSheet)this.getData("sheet");
    }

    public CellRegion getRegion() {
        return (CellRegion)this.getData("region");
    }

    public Object getCustomData() {
        return this.getData("customData");
    }

    public boolean isWholeRow() {
        SBook book = this.getBook();
        if (book == null) {
            throw new IllegalStateException("can't find book");
        }
        CellRegion region = this.getRegion();
        if (region == null) {
            return false;
        }
        return region.column <= 0 && region.lastColumn >= book.getMaxColumnIndex();
    }

    public boolean isWholeColumn() {
        SBook book = this.getBook();
        if (book == null) {
            throw new IllegalStateException("can't find book");
        }
        CellRegion region = this.getRegion();
        if (region == null) {
            return false;
        }
        return region.row <= 0 && region.lastRow >= book.getMaxRowIndex();
    }

    public String getObjectId() {
        return (String)this.getData("objid");
    }
}

