/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.range.impl.imexp;

public class UnitUtil {
    private static final int DPI = 96;

    public static int pxToPoint(int px) {
        return px * 72 / 96;
    }

    public static int pointToPx(int point) {
        return point * 96 / 72;
    }

    public static int pxToEmu(int px) {
        return (int)Math.round((double)px * 72.0 * 20.0 * 635.0 / 96.0);
    }

    public static int emuToPx(int emu) {
        return (int)Math.round((double)emu * 96.0 / 72.0 / 20.0 / 635.0);
    }

    public static int twipToPx(int twip) {
        return twip * 96 / 72 / 20;
    }

    public static int pxToTwip(int px) {
        return px * 72 * 20 / 96;
    }

    public static int fileChar256ToPx(int char256, int charWidth) {
        double w = char256;
        return (int)Math.floor(w * (double)charWidth / 256.0 + 0.5);
    }

    public static int pxToFileChar256(int px, int charWidth) {
        double w = px;
        return (int)Math.floor(w * 256.0 / (double)charWidth + 0.5);
    }

    public static int defaultColumnWidthToPx(int columnWidth, int charWidth) {
        int w;
        int diff = (w = columnWidth * charWidth + 5) % 8;
        return w + (diff > 0 ? 8 - diff : 0);
    }

    public static int pxToDefaultColumnWidth(int px, int charWidth) {
        return (px - 5) / charWidth;
    }

    public static int incheToPx(double inches) {
        return (int)(inches * 96.0);
    }

    public static double pxToInche(int px) {
        return (double)px / 96.0;
    }

    public static double pxToCTChar(int px, int charWidth) {
        return (double)UnitUtil.pxToFileChar256(px, charWidth) / 256.0;
    }

    public static double cmToInche(double cm) {
        return cm / 2.54;
    }

    public static double incheToCm(double inches) {
        return inches * 2.54;
    }

    public static int cmToPx(double cm) {
        return UnitUtil.incheToPx(UnitUtil.cmToInche(cm));
    }

    public static double pxToCm(int px) {
        return UnitUtil.incheToCm(UnitUtil.pxToInche(px));
    }
}

