/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.range.impl.imexp;

import org.zkoss.poi.ss.usermodel.charts.ChartDirection;
import org.zkoss.poi.ss.usermodel.charts.ChartGrouping;
import org.zkoss.poi.ss.usermodel.charts.LegendPosition;
import org.zkoss.zss.model.ErrorValue;
import org.zkoss.zss.model.SAutoFilter;
import org.zkoss.zss.model.SCellStyle;
import org.zkoss.zss.model.SChart;
import org.zkoss.zss.model.SDataValidation;
import org.zkoss.zss.model.SFont;
import org.zkoss.zss.model.SHyperlink;
import org.zkoss.zss.model.SPicture;
import org.zkoss.zss.model.SPrintSetup;

public class PoiEnumConversion {
    public static int toPoiHyperlinkType(SHyperlink.HyperlinkType type) {
        switch (type) {
            case DOCUMENT: {
                return 2;
            }
            case EMAIL: {
                return 3;
            }
            case FILE: {
                return 4;
            }
        }
        return 1;
    }

    public static SHyperlink.HyperlinkType toHyperlinkType(int type) {
        switch (type) {
            case 2: {
                return SHyperlink.HyperlinkType.DOCUMENT;
            }
            case 3: {
                return SHyperlink.HyperlinkType.EMAIL;
            }
            case 4: {
                return SHyperlink.HyperlinkType.FILE;
            }
        }
        return SHyperlink.HyperlinkType.URL;
    }

    public static int toPoiFilterOperator(SAutoFilter.FilterOp operator) {
        switch (operator) {
            case AND: {
                return 1;
            }
            case BOTTOM10: {
                return 2;
            }
            case BOTOOM10_PERCENT: {
                return 3;
            }
            case OR: {
                return 4;
            }
            case TOP10: {
                return 5;
            }
            case TOP10_PERCENT: {
                return 6;
            }
        }
        return 7;
    }

    public static SAutoFilter.FilterOp toFilterOperator(int operator) {
        switch (operator) {
            case 1: {
                return SAutoFilter.FilterOp.AND;
            }
            case 2: {
                return SAutoFilter.FilterOp.BOTTOM10;
            }
            case 3: {
                return SAutoFilter.FilterOp.BOTOOM10_PERCENT;
            }
            case 4: {
                return SAutoFilter.FilterOp.OR;
            }
            case 5: {
                return SAutoFilter.FilterOp.TOP10;
            }
            case 6: {
                return SAutoFilter.FilterOp.TOP10_PERCENT;
            }
        }
        return SAutoFilter.FilterOp.VALUES;
    }

    public static short toPoiPaperSize(SPrintSetup.PaperSize paperSize) {
        switch (paperSize) {
            case A3: {
                return 8;
            }
            case A4_EXTRA: {
                return 53;
            }
            case A4_PLUS: {
                return 60;
            }
            case A4_ROTATED: {
                return 77;
            }
            case A4_SMALL: {
                return 10;
            }
            case A4: {
                return 9;
            }
            case A4_TRANSVERSE: {
                return 55;
            }
            case A5: {
                return 11;
            }
            case B4: {
                return 12;
            }
            case B5: {
                return 13;
            }
            case ELEVEN_BY_SEVENTEEN: {
                return 17;
            }
            case ENVELOPE_10: {
                return 20;
            }
            case ENVELOPE_9: {
                return 19;
            }
            case ENVELOPE_C3: {
                return 29;
            }
            case ENVELOPE_C4: {
                return 30;
            }
            case ENVELOPE_C5: {
                return 28;
            }
            case ENVELOPE_C6: {
                return 31;
            }
            case ENVELOPE_CS: {
                return 28;
            }
            case ENVELOPE_DL: {
                return 27;
            }
            case ENVELOPE_MONARCH: {
                return 37;
            }
            case EXECUTIVE: {
                return 7;
            }
            case FOLIO8: {
                return 14;
            }
            case LEDGER: {
                return 4;
            }
            case LEGAL: {
                return 5;
            }
            case LETTER: {
                return 1;
            }
            case LETTER_ROTATED: {
                return 75;
            }
            case LETTER_SMALL: {
                return 2;
            }
            case NOTE8: {
                return 18;
            }
            case QUARTO: {
                return 15;
            }
            case STATEMENT: {
                return 6;
            }
            case TABLOID: {
                return 3;
            }
            case TEN_BY_FOURTEEN: {
                return 16;
            }
        }
        return 9;
    }

    public static SPrintSetup.PaperSize toPaperSize(short paperSize) {
        switch (paperSize) {
            case 8: {
                return SPrintSetup.PaperSize.A3;
            }
            case 53: {
                return SPrintSetup.PaperSize.A4_EXTRA;
            }
            case 9: {
                return SPrintSetup.PaperSize.A4;
            }
            case 60: {
                return SPrintSetup.PaperSize.A4_PLUS;
            }
            case 77: {
                return SPrintSetup.PaperSize.A4_ROTATED;
            }
            case 10: {
                return SPrintSetup.PaperSize.A4_SMALL;
            }
            case 55: {
                return SPrintSetup.PaperSize.A4_TRANSVERSE;
            }
            case 11: {
                return SPrintSetup.PaperSize.A5;
            }
            case 12: {
                return SPrintSetup.PaperSize.B4;
            }
            case 13: {
                return SPrintSetup.PaperSize.B5;
            }
            case 17: {
                return SPrintSetup.PaperSize.ELEVEN_BY_SEVENTEEN;
            }
            case 20: {
                return SPrintSetup.PaperSize.ENVELOPE_10;
            }
            case 19: {
                return SPrintSetup.PaperSize.ENVELOPE_9;
            }
            case 29: {
                return SPrintSetup.PaperSize.ENVELOPE_C3;
            }
            case 30: {
                return SPrintSetup.PaperSize.ENVELOPE_C4;
            }
            case 28: {
                return SPrintSetup.PaperSize.ENVELOPE_C5;
            }
            case 31: {
                return SPrintSetup.PaperSize.ENVELOPE_C6;
            }
            case 27: {
                return SPrintSetup.PaperSize.ENVELOPE_DL;
            }
            case 37: {
                return SPrintSetup.PaperSize.ENVELOPE_MONARCH;
            }
            case 7: {
                return SPrintSetup.PaperSize.EXECUTIVE;
            }
            case 14: {
                return SPrintSetup.PaperSize.FOLIO8;
            }
            case 4: {
                return SPrintSetup.PaperSize.LEDGER;
            }
            case 1: {
                return SPrintSetup.PaperSize.LETTER;
            }
            case 75: {
                return SPrintSetup.PaperSize.LETTER_ROTATED;
            }
            case 2: {
                return SPrintSetup.PaperSize.LETTER_SMALL;
            }
            case 18: {
                return SPrintSetup.PaperSize.NOTE8;
            }
            case 15: {
                return SPrintSetup.PaperSize.QUARTO;
            }
            case 6: {
                return SPrintSetup.PaperSize.STATEMENT;
            }
            case 3: {
                return SPrintSetup.PaperSize.TABLOID;
            }
            case 16: {
                return SPrintSetup.PaperSize.TEN_BY_FOURTEEN;
            }
        }
        return SPrintSetup.PaperSize.A4;
    }

    public static short toPoiVerticalAlignment(SCellStyle.VerticalAlignment vAlignment) {
        switch (vAlignment) {
            case BOTTOM: {
                return 2;
            }
            case CENTER: {
                return 1;
            }
            case JUSTIFY: {
                return 3;
            }
        }
        return 0;
    }

    public static SCellStyle.VerticalAlignment toVerticalAlignment(short poiVerticalAlignment) {
        switch (poiVerticalAlignment) {
            case 0: {
                return SCellStyle.VerticalAlignment.TOP;
            }
            case 1: {
                return SCellStyle.VerticalAlignment.CENTER;
            }
            case 3: {
                return SCellStyle.VerticalAlignment.JUSTIFY;
            }
        }
        return SCellStyle.VerticalAlignment.BOTTOM;
    }

    public static short toPoiFillPattern(SCellStyle.FillPattern fillPattern) {
        switch (fillPattern) {
            case ALT_BARS: {
                return 3;
            }
            case BIG_SPOTS: {
                return 9;
            }
            case BRICKS: {
                return 10;
            }
            case DIAMONDS: {
                return 16;
            }
            case FINE_DOTS: {
                return 2;
            }
            case LEAST_DOTS: {
                return 18;
            }
            case LESS_DOTS: {
                return 17;
            }
            case SOLID_FOREGROUND: {
                return 1;
            }
            case SPARSE_DOTS: {
                return 4;
            }
            case SQUARES: {
                return 15;
            }
            case THICK_BACKWARD_DIAG: {
                return 7;
            }
            case THICK_FORWARD_DIAG: {
                return 8;
            }
            case THICK_HORZ_BANDS: {
                return 5;
            }
            case THICK_VERT_BANDS: {
                return 6;
            }
            case THIN_BACKWARD_DIAG: {
                return 13;
            }
            case THIN_FORWARD_DIAG: {
                return 14;
            }
            case THIN_HORZ_BANDS: {
                return 11;
            }
            case THIN_VERT_BANDS: {
                return 12;
            }
        }
        return 0;
    }

    public static SCellStyle.FillPattern toFillPattern(short poiFillPattern) {
        switch (poiFillPattern) {
            case 1: {
                return SCellStyle.FillPattern.SOLID_FOREGROUND;
            }
            case 2: {
                return SCellStyle.FillPattern.FINE_DOTS;
            }
            case 3: {
                return SCellStyle.FillPattern.ALT_BARS;
            }
            case 4: {
                return SCellStyle.FillPattern.SPARSE_DOTS;
            }
            case 5: {
                return SCellStyle.FillPattern.THICK_HORZ_BANDS;
            }
            case 6: {
                return SCellStyle.FillPattern.THICK_VERT_BANDS;
            }
            case 7: {
                return SCellStyle.FillPattern.THICK_BACKWARD_DIAG;
            }
            case 8: {
                return SCellStyle.FillPattern.THICK_FORWARD_DIAG;
            }
            case 9: {
                return SCellStyle.FillPattern.BIG_SPOTS;
            }
            case 10: {
                return SCellStyle.FillPattern.BRICKS;
            }
            case 11: {
                return SCellStyle.FillPattern.THIN_HORZ_BANDS;
            }
            case 12: {
                return SCellStyle.FillPattern.THIN_VERT_BANDS;
            }
            case 13: {
                return SCellStyle.FillPattern.THIN_BACKWARD_DIAG;
            }
            case 14: {
                return SCellStyle.FillPattern.THIN_FORWARD_DIAG;
            }
            case 15: {
                return SCellStyle.FillPattern.SQUARES;
            }
            case 16: {
                return SCellStyle.FillPattern.DIAMONDS;
            }
            case 17: {
                return SCellStyle.FillPattern.LESS_DOTS;
            }
            case 18: {
                return SCellStyle.FillPattern.LEAST_DOTS;
            }
        }
        return SCellStyle.FillPattern.NO_FILL;
    }

    public static short toPoiBorderType(SCellStyle.BorderType borderType) {
        switch (borderType) {
            case DASH_DOT: {
                return 9;
            }
            case DASHED: {
                return 3;
            }
            case DOTTED: {
                return 4;
            }
            case DOUBLE: {
                return 6;
            }
            case HAIR: {
                return 7;
            }
            case MEDIUM: {
                return 2;
            }
            case MEDIUM_DASH_DOT: {
                return 9;
            }
            case MEDIUM_DASH_DOT_DOT: {
                return 11;
            }
            case MEDIUM_DASHED: {
                return 8;
            }
            case SLANTED_DASH_DOT: {
                return 13;
            }
            case THICK: {
                return 5;
            }
            case THIN: {
                return 1;
            }
            case DASH_DOT_DOT: {
                return 11;
            }
        }
        return 0;
    }

    public static SCellStyle.BorderType toBorderType(short poiBorder) {
        switch (poiBorder) {
            case 1: {
                return SCellStyle.BorderType.THIN;
            }
            case 2: {
                return SCellStyle.BorderType.MEDIUM;
            }
            case 3: {
                return SCellStyle.BorderType.DASHED;
            }
            case 7: {
                return SCellStyle.BorderType.HAIR;
            }
            case 5: {
                return SCellStyle.BorderType.THICK;
            }
            case 6: {
                return SCellStyle.BorderType.DOUBLE;
            }
            case 4: {
                return SCellStyle.BorderType.DOTTED;
            }
            case 8: {
                return SCellStyle.BorderType.MEDIUM_DASHED;
            }
            case 9: {
                return SCellStyle.BorderType.DASH_DOT;
            }
            case 10: {
                return SCellStyle.BorderType.MEDIUM_DASH_DOT;
            }
            case 11: {
                return SCellStyle.BorderType.DASH_DOT_DOT;
            }
            case 12: {
                return SCellStyle.BorderType.MEDIUM_DASH_DOT_DOT;
            }
            case 13: {
                return SCellStyle.BorderType.SLANTED_DASH_DOT;
            }
        }
        return SCellStyle.BorderType.NONE;
    }

    public static short toPoiHorizontalAlignment(SCellStyle.Alignment alignment) {
        switch (alignment) {
            case CENTER: {
                return 2;
            }
            case FILL: {
                return 4;
            }
            case JUSTIFY: {
                return 5;
            }
            case RIGHT: {
                return 3;
            }
            case LEFT: {
                return 1;
            }
            case CENTER_SELECTION: {
                return 6;
            }
        }
        return 0;
    }

    public static SCellStyle.Alignment toHorizontalAlignment(short poiHorizontalAlignment) {
        switch (poiHorizontalAlignment) {
            case 1: {
                return SCellStyle.Alignment.LEFT;
            }
            case 3: {
                return SCellStyle.Alignment.RIGHT;
            }
            case 2: {
                return SCellStyle.Alignment.CENTER;
            }
            case 6: {
                return SCellStyle.Alignment.CENTER_SELECTION;
            }
            case 4: {
                return SCellStyle.Alignment.FILL;
            }
            case 5: {
                return SCellStyle.Alignment.JUSTIFY;
            }
        }
        return SCellStyle.Alignment.GENERAL;
    }

    public static short toPoiBoldweight(SFont.Boldweight bold) {
        switch (bold) {
            case BOLD: {
                return 700;
            }
        }
        return 400;
    }

    public static SFont.Boldweight toBoldweight(short bold) {
        switch (bold) {
            case 700: {
                return SFont.Boldweight.BOLD;
            }
        }
        return SFont.Boldweight.NORMAL;
    }

    public static short toPoiTypeOffset(SFont.TypeOffset typeOffset) {
        switch (typeOffset) {
            case SUPER: {
                return 1;
            }
            case SUB: {
                return 2;
            }
        }
        return 0;
    }

    public static SFont.TypeOffset toTypeOffset(short typeOffset) {
        switch (typeOffset) {
            case 2: {
                return SFont.TypeOffset.SUB;
            }
            case 1: {
                return SFont.TypeOffset.SUPER;
            }
        }
        return SFont.TypeOffset.NONE;
    }

    public static byte toPoiUnderline(SFont.Underline underline) {
        switch (underline) {
            case SINGLE: {
                return 1;
            }
            case DOUBLE: {
                return 2;
            }
            case DOUBLE_ACCOUNTING: {
                return 34;
            }
            case SINGLE_ACCOUNTING: {
                return 33;
            }
        }
        return 0;
    }

    public static SFont.Underline toUnderline(byte underline) {
        switch (underline) {
            case 1: {
                return SFont.Underline.SINGLE;
            }
            case 2: {
                return SFont.Underline.DOUBLE;
            }
            case 33: {
                return SFont.Underline.SINGLE_ACCOUNTING;
            }
            case 34: {
                return SFont.Underline.DOUBLE_ACCOUNTING;
            }
        }
        return SFont.Underline.NONE;
    }

    public static int toPoiPictureFormat(SPicture.Format format) {
        switch (format) {
            case GIF: {
                return 8;
            }
            case JPG: {
                return 5;
            }
        }
        return 6;
    }

    public static ChartGrouping toPoiGrouping(SChart.ChartGrouping grouping) {
        if (grouping == null) {
            return ChartGrouping.STANDARD;
        }
        switch (grouping) {
            case CLUSTERED: {
                return ChartGrouping.CLUSTERED;
            }
            case PERCENT_STACKED: {
                return ChartGrouping.PERCENT_STACKED;
            }
            case STACKED: {
                return ChartGrouping.STACKED;
            }
        }
        return ChartGrouping.STANDARD;
    }

    public static SChart.ChartGrouping toChartGrouping(ChartGrouping grouping) {
        switch (grouping) {
            case STACKED: {
                return SChart.ChartGrouping.STACKED;
            }
            case PERCENT_STACKED: {
                return SChart.ChartGrouping.PERCENT_STACKED;
            }
            case CLUSTERED: {
                return SChart.ChartGrouping.CLUSTERED;
            }
        }
        return SChart.ChartGrouping.STANDARD;
    }

    public static ChartDirection toPoiBarDirection(SChart.BarDirection direction) {
        switch (direction) {
            case VERTICAL: {
                return ChartDirection.VERTICAL;
            }
        }
        return ChartDirection.HORIZONTAL;
    }

    public static SChart.BarDirection toBarDirection(ChartDirection direction) {
        switch (direction) {
            case VERTICAL: {
                return SChart.BarDirection.VERTICAL;
            }
        }
        return SChart.BarDirection.HORIZONTAL;
    }

    public static LegendPosition toPoiLegendPosition(SChart.ChartLegendPosition position) {
        switch (position) {
            case BOTTOM: {
                return LegendPosition.BOTTOM;
            }
            case TOP: {
                return LegendPosition.TOP;
            }
            case TOP_RIGHT: {
                return LegendPosition.TOP_RIGHT;
            }
            case LEFT: {
                return LegendPosition.LEFT;
            }
        }
        return LegendPosition.RIGHT;
    }

    public static SChart.ChartLegendPosition toLengendPosition(LegendPosition position) {
        switch (position) {
            case BOTTOM: {
                return SChart.ChartLegendPosition.BOTTOM;
            }
            case LEFT: {
                return SChart.ChartLegendPosition.LEFT;
            }
            case TOP: {
                return SChart.ChartLegendPosition.TOP;
            }
            case TOP_RIGHT: {
                return SChart.ChartLegendPosition.TOP_RIGHT;
            }
        }
        return SChart.ChartLegendPosition.RIGHT;
    }

    public static int toPoiOperatorType(SDataValidation.OperatorType type) {
        switch (type) {
            case NOT_EQUAL: {
                return 3;
            }
            case NOT_BETWEEN: {
                return 1;
            }
            case LESS_THAN: {
                return 5;
            }
            case LESS_OR_EQUAL: {
                return 7;
            }
            case GREATER_THAN: {
                return 4;
            }
            case GREATER_OR_EQUAL: {
                return 6;
            }
            case EQUAL: {
                return 2;
            }
        }
        return 0;
    }

    public static SDataValidation.OperatorType toOperatorType(int poiOperator) {
        switch (poiOperator) {
            case 2: {
                return SDataValidation.OperatorType.EQUAL;
            }
            case 6: {
                return SDataValidation.OperatorType.GREATER_OR_EQUAL;
            }
            case 4: {
                return SDataValidation.OperatorType.GREATER_THAN;
            }
            case 7: {
                return SDataValidation.OperatorType.LESS_OR_EQUAL;
            }
            case 5: {
                return SDataValidation.OperatorType.LESS_THAN;
            }
            case 1: {
                return SDataValidation.OperatorType.NOT_BETWEEN;
            }
            case 3: {
                return SDataValidation.OperatorType.NOT_EQUAL;
            }
        }
        return SDataValidation.OperatorType.BETWEEN;
    }

    public static int toPoiErrorStyle(SDataValidation.AlertStyle style) {
        switch (style) {
            case INFO: {
                return 2;
            }
            case WARNING: {
                return 1;
            }
        }
        return 0;
    }

    public static SDataValidation.AlertStyle toErrorStyle(int errorStyle) {
        switch (errorStyle) {
            case 2: {
                return SDataValidation.AlertStyle.INFO;
            }
            case 1: {
                return SDataValidation.AlertStyle.WARNING;
            }
        }
        return SDataValidation.AlertStyle.STOP;
    }

    public static SDataValidation.ValidationType toValidationType(int validationType) {
        switch (validationType) {
            case 5: {
                return SDataValidation.ValidationType.TIME;
            }
            case 6: {
                return SDataValidation.ValidationType.TEXT_LENGTH;
            }
            case 3: {
                return SDataValidation.ValidationType.LIST;
            }
            case 1: {
                return SDataValidation.ValidationType.INTEGER;
            }
            case 7: {
                return SDataValidation.ValidationType.CUSTOM;
            }
            case 2: {
                return SDataValidation.ValidationType.DECIMAL;
            }
            case 4: {
                return SDataValidation.ValidationType.DATE;
            }
        }
        return SDataValidation.ValidationType.ANY;
    }

    public static ErrorValue toErrorCode(byte errorCellValue) {
        return ErrorValue.valueOf(errorCellValue);
    }
}

