/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.range.impl.imexp;

import org.zkoss.poi.ss.usermodel.Row;
import org.zkoss.poi.ss.usermodel.Sheet;
import org.zkoss.zss.range.impl.imexp.UnitUtil;

public class ImExpUtils {
    public static int getWidthAny(Sheet poiSheet, int col, int charWidth) {
        int w = poiSheet.getColumnWidth(col);
        if (w == poiSheet.getDefaultColumnWidth() * 256) {
            return UnitUtil.defaultColumnWidthToPx(w / 256, charWidth);
        }
        return UnitUtil.fileChar256ToPx(w, charWidth);
    }

    public static int getHeightAny(Sheet poiSheet, int row) {
        return ImExpUtils.getRowHeightInPx(poiSheet, poiSheet.getRow(row));
    }

    public static int getRowHeightInPx(Sheet poiSheet, Row row) {
        short h;
        short defaultHeight = poiSheet.getDefaultRowHeight();
        short s = h = row == null ? defaultHeight : row.getHeight();
        if (h == 255) {
            h = defaultHeight;
        }
        return UnitUtil.twipToPx(h);
    }
}

